% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecop-find-fixed-point-lambda-by-atm-skew-method.R
\name{ecop.find_fixed_point_lambda_by_atm_skew}
\alias{ecop.find_fixed_point_lambda_by_atm_skew}
\title{Utility to find the fixed point lambda that matches ATM skew}
\usage{
ecop.find_fixed_point_lambda_by_atm_skew(fn_get_ld1, lambda, step, atm_skew,
  k_atm, ttm, otype = "c", verbose = TRUE, msg_prefix = "",
  min_lambda = 1.1)
}
\arguments{
\item{fn_get_ld1}{function, takes stdev, lambda, beta as input, return ld1 object
via \code{ecop.get_ld_triple}. This closure function encapulates
mu_plus_ratio, epsilon_ratio, atm_imp_k.}

\item{lambda}{numeric, the lambda parameter.}

\item{step}{numeric, increment to decrease lambda.}

\item{atm_skew}{numeric, ATM skew from data.}

\item{k_atm}{a vector of numeric, range of log-strike to calculate ATM skew via lm.}

\item{ttm}{numeric, time to expiration, with 1 representing 1 year (365 days).}

\item{otype}{character, option type. Default: "c".}

\item{verbose}{boolean, print debug message. Default: \code{FALSE}.}

\item{msg_prefix}{character, command line message prefix. Default: "".}

\item{min_lambda}{numeric, do not try lambda lower than this and return it. Default is 1.1.}
}
\value{
numeric, representing lambda.
}
\description{
This utility finds the fixed point lambda from larger lambda to smaller lambda
until the calculated ATM skew is smaller than ATM skew from data.
It uses \code{ecop.find_fixed_point_sd_by_lambda} to locate stdev.
Other smile related parameters are abstracted away via the closure function \code{fn_get_ld1}.
This utility is used primarily to solve the fixed point ATM hypothesis (for VIX option smile).
Note that this utility alone is not the full solution. Another utility is needed to match
the two tails (via mu and epsilon). This utility doesn't handle beta either.
}
\author{
Stephen H-T. Lihn
}
\keyword{fixed-point}

