% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lamp-stable-cnt-distribution-method.R
\name{dstablecnt}
\alias{dstablecnt}
\alias{pstablecnt}
\alias{rstablecnt}
\alias{qstablecnt}
\alias{cfstablecnt}
\alias{kstablecnt}
\title{Stable Count distribution}
\usage{
dstablecnt(x, alpha = NULL, nu0 = 0, theta = 1, lambda = NULL)

pstablecnt(x, alpha = NULL, nu0 = 0, theta = 1, lambda = NULL)

rstablecnt(n, alpha = NULL, nu0 = 0, theta = 1, lambda = NULL)

qstablecnt(q, alpha = NULL, nu0 = 0, theta = 1, lambda = NULL)

cfstablecnt(s, alpha = NULL, nu0 = 0, theta = 1, lambda = NULL)

kstablecnt(alpha = NULL, nu0 = 0, theta = 1, lambda = NULL)
}
\arguments{
\item{x}{numeric, vector of responses.}

\item{alpha}{numeric, the shape parameter, default is NULL. User must provide
either alpha or lambda.}

\item{nu0}{numeric, the location parameter, default is 0.}

\item{theta}{numeric, the scale parameter, default is 1.}

\item{lambda}{numeric, alternative shape parameter, default is NULL.}

\item{n}{numeric, number of observations.}

\item{q}{numeric, vector of quantiles.}

\item{s}{numeric, vector of responses for characteristic function.}
}
\value{
numeric, standard convention is followed:
        d* returns the density,
        p* returns the distribution function,
        q* returns the quantile function, and
        r* generates random deviates.
        The following are our extensions:
        k* returns the first 4 cumulants, skewness, and kurtosis,
        cf* returns the characteristic function.
}
\description{
Implements some aspects of stable count distribution
(based on stabledist package) for stable random walk sinu0lation.
Quartic stable distribution is implemented through gamma distribution.
}
\author{
Stephen H-T. Lihn
}
\keyword{Stable}
