% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecd-integrate-method.R
\name{ecd.integrate}
\alias{ecd.integrate}
\title{Wrapper to integrate numeric and mpfr}
\usage{
ecd.integrate(
  object,
  f,
  lower,
  upper,
  ...,
  abs.tol = .Machine$double.eps^0.25,
  mpfr.qagi = TRUE,
  show.warning = TRUE
)
}
\arguments{
\item{object}{An object of ecd class. This object can be bare-boned.}

\item{f}{An R function taking a numeric first argument and
returning a numeric vector of the same length.
Returning a non-finite element will generate an error.}

\item{lower}{Numeric, the lower limit of integration. Can be infinite.}

\item{upper}{Numeric, the upper limit of integration. Can be infinite.}

\item{...}{Addtional arguments for \code{f}.}

\item{abs.tol}{numeric, the suggested absolute tolerance.}

\item{mpfr.qagi}{logical, to use quadpack qagi transformation for infinity.}

\item{show.warning}{logical, to suppress warnings or not.}
}
\value{
The \code{integrate} object
}
\description{
The wrapper handles chooses to to use \code{integrate} for numeric;
or to use \code{integrateR} for mpfr. Since the later doesn't allow
infinity, there is a special handling to replace infinity with a large
multiple of \code{sigma}.
}
\author{
Stephen H. Lihn
}
\keyword{utility}
