% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecdfHT.R
\name{pecdfHT}
\alias{decdfHT}
\alias{pecdfHT}
\alias{qecdfHT}
\alias{recdfHT}
\title{Compute cdf, pdf, quantiles, and simulate from a fitted distribution}
\usage{
pecdfHT(x, ecdfHT.fit)

decdfHT(x, ecdfHT.fit)

qecdfHT(p, ecdfHT.fit)

recdfHT(n, ecdfHT.fit)
}
\arguments{
\item{x}{A vector of numbers}

\item{ecdfHT.fit}{An object returned by \code{ecdfHT.fit} describing the interpolation.}

\item{p}{Vector of probabilites}

\item{n}{Number of values to simulate}
}
\value{
\code{pecdfHT} computes the cdf, \code{decdfHT} computes the pdf, \code{qecdfHT} computes the quantiles (inverse of the cdf), \code{recdfHT} simulates from the distribution.
}
\description{
Use the semi-parametric fit calculated by \code{ecdfHT.fit} to evaluate the cdf F(x), pdf f(x), quantiles and simulate.
}
\details{
\code{pecdfHT} computes the cdf of the semi-parametric fit to the data.
\code{decdfHT} computes the pdf of the semi-parametric fit to the data.  This is likely very irregular and not of much value except on the tails, where the pdf calculation is computed analytically.
\code{qecdfHT} computes quantiles.
\code{recdfHT} simulates from a semi-parameteric distribution.
}
\examples{
x <- rcauchy(1000)
a <- ecdfHT( x, show.plot=FALSE )
fit <- ecdfHT.fit( c(.1,.9), a, add.to.plot=FALSE )
pecdfHT( -3:3, fit )
decdfHT( -3:3, fit )
qecdfHT( seq(.1,.9,.1), fit )
recdfHT( 10, fit )

}

