% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/echarty.R
\name{ec.paxis}
\alias{ec.paxis}
\title{Parallel Axis}
\usage{
ec.paxis(df = NULL, minmax = TRUE, cols = NULL, ...)
}
\arguments{
\item{df}{A data.frame, regular or grouped}

\item{minmax}{Boolean to add max/min limits or not, default TRUE}

\item{cols}{A string vector with columns names in desired order}

\item{...}{Additional arguments for \href{https://echarts.apache.org/en/option.html#parallelAxis}{parallelAxis}.}
}
\value{
A list, see format in \href{https://echarts.apache.org/en/option.html#parallelAxis}{parallelAxis}.
}
\description{
Create 'parallelAxis' for a parallel chart
}
\examples{
iris |> dplyr::group_by(Species) |> ec.init(ctype='parallel')

ec.init(preset= FALSE,
        parallelAxis= ec.paxis(mtcars, 
                               cols= c('gear','cyl','hp','carb'), nameRotate= 45),
        series= list(list(type= 'parallel', smooth= TRUE, 
                          data= ec.data(mtcars, 'dataset') ))
)

}
