% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/echarty.R
\name{ec.upd}
\alias{ec.upd}
\title{Update option lists}
\usage{
ec.upd(wt, ...)
}
\arguments{
\item{wt}{An echarty widget}

\item{...}{R commands to update chart option lists}
}
\description{
And improve readability by chaining commands after ec.init
}
\details{
ec.upd makes changes to chart elements already set by ec.init.\cr
It should be always piped after ec.init.\cr
Numerical indexes for series,visualMap,etc. are JS-counted (0,1...)\cr
Replaces syntax\cr
\verb{   }p <- ec.init(...)\cr
\verb{   }p$x$opts$series <- ...\cr
with\cr
\verb{   }ec.init(...) |> \verb{   } # set or preset chart params\cr
\verb{   }ec.upd(\{series <- ...\}) # update params thru R commands
}
\examples{
Orange |> dplyr::group_by(Tree) |> ec.init() |>
ec.upd({ series <- lapply(series, function(x) {
    x$symbolSize= 15;
    x$markPoint= list(data= list(list(type='max')))
    x })
})
}
