#' Spider data
#'
#' Abundance of hunting spiders and associated environmental variables 
#'
#' The data frame \code{abund} has the following species abundances (column name abbreviation in brackets)
#' \itemize{
#'   \item Alopecosa accentuata (Alopacce)
#'   \item Alopecosa cuneata (Alopcune)
#'   \item Alopecosa fabrilis (Alopfabr)
#'   \item Arctosa lutetiana (Arctlute)
#'   \item Arctosa perita(Arctperi)
#'   \item Aulonia albimana (Auloalbi)
#'   \item Pardosa lugubris (Pardlugu)
#'   \item Pardosa monticola (Pardmont)
#'   \item Pardosa nigriceps (Pardnigr)
#'   \item Pardosa pullata (Pardpull)
#'   \item Trochosa terricola (Trocterr)
#'   \item Zora spinimana (Zoraspin)
#' }
#' The matrix \code{x} has the following log(x+1)-transformed environmantal variables 
#' \itemize{
#'   \item soil.dry - Soil dry mass
#'   \item bare.sand - Cover bare sand
#'   \item fallen.leaves - Cover fallen leaves / twigs
#'   \item moss - Cover moss
#'   \item herb.layer - Cover herb layer
#'   \item reflection - Reflection of the soil surface with a cloudless sky
#' }
#' 
#' @format A list containing the elements
#' \describe{
#'   \item{abund}{A data frame with 28 observations of abundance of 12 hunting spider species.}
#'   \item{x}{A matrix of six (transformed) environmental variables at each of the 28 sites.}
#' }
#' @source Data attributed to van der Aart & Smeenk-Enserink (1975), 
#' obtained from the spider2 directory, CANOCO FORTRAN package
#' exported from mvabund R package.
"spider"