\name{ecospat-package}
\alias{ecospat-package}
\alias{ecospat}

\docType{package}

\title{Miscellaneous methods and utilities for spatial ecology analysis.
}
\description{

Miscellaneous methods and utilities for spatial ecology analysis, written by current and former members and collaborators of the ecospat group of Antoine Guisan, Department of Ecology and Evolution (DEE) & Institute of Earth Surface Dynamics (IDYST), University of Lausanne, Switzerland.
 
\pkg{ecospat} offers the possibility to perform Pre-modelling Analysis, such as Spatial autocorrelation analysis, MESS (Multivariate Environmental Similarity Surfaces) analyses, Phylogenetic diversity Measures, Biotic Interactions. It also provides functions to complement \pkg{biomod2} in preparing the data, calibrating and evaluating (e.g. boyce index) and projecting the models. Complementary analysis based on model predictions (e.g. co-occurrences analyses) are also provided.

In addition, the \pkg{ecospat} package includes Niche Quantification and Overlap functions that were used in Broennimann et al. 2012 and Petitpierre et al. 2012 to quantify climatic niche shifts between the native and invaded ranges of invasive species.

\pkg{ecospat} can also be complemented with the \pkg{MigClim} package, developed by members of the same group.


}
\details{
\tabular{ll}{
Package: \tab ecospat\cr
Type: \tab Package\cr
Version: \tab 1.0\cr
Date: \tab 2014-07-23\cr
License: \tab GPL \cr
}

}
\author{Olivier Broenniman <olivier.broennimann@unil.ch> and
             Blaise Petitpierre <bpetitpierre@gmail.com> and
             Christophe Randin <christophe.randin@unibas.ch> and
             Robin Engler <robin.engler@gmail.com> and
             Frank Breiner <frank.breiner@unil.ch> and
             Manuela D`Amen<manuela.damen@unil.ch> and
             Loic Pellissier <loic.pellissier@unifr.ch> and
             Julien Pottier <julien.pottier@clermont.inra.fr> and
             Dorothea Pio <Dorothea.Pio@fauna-flora.org> and
             Ruben Garcia Mateo <rubeng.mateo@gmail.com> and
             Valeria Di Cola <valeria.dicola@unil.ch> and
             Wim Hordijk <wim@WorldWideWanderings.net> and 
             Anne Dubuis <anne.dubuis@gmail.com> and
             Daniel Scherrer <daniel.scherrer@unil.ch> and
             Nicolas Salamin <nicolas.salamin@unil.ch> and
             Antoine Guisan <antoine.guisan@unil.ch>}

\keyword{ package }
