% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/monitor.opt.path.logging.R
\name{setupOptPathLoggingMonitor}
\alias{setupOptPathLoggingMonitor}
\title{Logging monitor.}
\usage{
setupOptPathLoggingMonitor(step = 1L, log.extras.fun = NULL)
}
\arguments{
\item{step}{[\code{integer(1)}]\cr
After how many generations should the logger be active?
Default is 1, which means that logging takes place in each generation.}

\item{log.extras.fun}{[\code{function} | \code{NULL}]\cr
Function which expects the internal optimization state \code{opt.state} and
additional parameters \code{...} and returns a numeric vector of scalar
qualities computed based e.g. on the individual genomes or the fitness values.
The function is called every time the \code{logger} is called in each generation.
The results are then stored additionally in the \code{\link[ParamHelpers]{OptPath}}.
Default is \code{NULL}, which means no extra logging.}
}
\value{
[\code{ecr_monitor}]
}
\description{
This is the default logging function used by ecr. It makes use of the fantastic
\code{\link[ParamHelpers]{OptPath}} which allows optimizers to log evaluated
points.
The logger is registered to be called once the EA is initialized (after the
creation of the initial population), right after each survival selection and
once the EA finished. By default the logger stores the entire population, i.e.,
the individuals, the fitness values and moreover some additional statistics
of the fitness value distribution.

A word of causion: In case of a custom representation, which can not be
stored in the \code{\link[ParamHelpers]{OptPath}} by default since the
individuals are more complex than normal parameters, the serialized individuals
are stored in the \code{\link[ParamHelpers]{OptPath}}.
}

