% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/computeAverageHausdorffDistance.R
\name{normalizeFront}
\alias{normalizeFront}
\title{Normalize points of a set.}
\usage{
normalizeFront(A, min.value = NULL, max.value = NULL)
}
\arguments{
\item{A}{[\code{matrix}]\cr
Point set (each column corresponds to a point).}

\item{min.value}{[\code{numeric}]\cr
Vector of minimal values of length \code{nrow(A)}.
Default is the row-wise minimum of \code{A}.}

\item{max.value}{[\code{numeric}]\cr
Vector of maximal values of length \code{nrow(A)}.
Default is the row-wise maximum of \code{A}.}
}
\value{
[\code{matrix}] Normalized front.
}
\description{
Normalization is done by subtracting the \code{min.value} for each dimension
and dividing by the \code{max.value} for each dimension by default.
}
