% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/select.R
\name{select}
\alias{select}
\alias{selectForMating}
\alias{selectForSurvival}
\title{Select individuals.}
\usage{
selectForMating(control, fitness, n.select)

selectForSurvival(control, fitness, n.select)
}
\arguments{
\item{control}{[\code{ecr_control}]\cr
Control object.}

\item{fitness}{[\code{matrix}]\cr
Matrix of fitness values (each column contains the fitness value(s) of one
individual).}

\item{n.select}{[\code{integer(1)}]\cr
Number of individuals to select.}
}
\value{
[\code{integer}] Integer vector with the indizes of selected individuals.
}
\description{
This utility functions expect a control object, a matrix of
fitness values - each column containing the fitness value(s) of one individual -
and the number of individuals to select.
The corresponding selector, i.e., mating selector for \code{selectForMating}
or survival selector for \code{selectForSurvival} is than called internally
and a vector of indizes of selected individuals is returned.
}
\details{
Both functions check the optimization directions stored in the task
inside the control object, i.e., whether to minimize or maximize each objective,
and transparently prepare/transform the \code{fitness} matrix for the selector.
}
