% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gpx.r
\name{read_gpx}
\alias{read_gpx}
\title{Read a GPX file into a data frame containing dates and distances}
\usage{
read_gpx(file, units = c("miles", "kilometers"))
}
\arguments{
\item{file}{The input file to be parsed.}

\item{units}{The units desired for the distance metric.}
}
\value{
A data frame containing up to two columns:
\describe{
\item{date}{The date of the ride. See description and details.}
\item{distance}{The distance of the track segment in the requested units.}
}
}
\description{
Reads in a GPS Exchange Format XML document and outputs a \code{data.frame}
containing distances. The corresponding dates for each track segment
(\code{trkseg}) will be included if present in the source file, else the \code{date}
column will be populated with \code{NA}s.
}
\details{
Distances are computed using the Haversine formula and do not account for
elevation changes.

This function treats the first timestamp of each \code{trkseg} as the date of
record. Thus overnight track segments will all count toward the day in which
the journey began.
}
\examples{
\dontrun{
# Get a list of all GPX export files in a directory tree
gpx_export_files <- list.files(
  "/path/to/gpx/exports/",
  pattern = "\\\\.gpx$",
  full.names = TRUE,
  recursive = TRUE
)

# Read in all files and combine them into a single data frame
rides <- do.call(rbind, lapply(activity_files, read_gpx))
}
}
