% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_activity_instances.R
\name{filter_activity_instance}
\alias{filter_activity_instance}
\alias{filter_activity_instance.eventlog}
\alias{filter_activity_instance.grouped_eventlog}
\alias{ifilter_activity_instance}
\title{title Filter: Activity instance}
\usage{
filter_activity_instance(eventlog, activity_instances, reverse)

\method{filter_activity_instance}{eventlog}(eventlog, activity_instances = NULL, reverse = FALSE)

\method{filter_activity_instance}{grouped_eventlog}(eventlog, activity_instances = NULL, reverse = FALSE)

ifilter_activity_instance(eventlog)
}
\arguments{
\item{eventlog}{The dataset to be used. Should be a (grouped) eventlog object.}

\item{activity_instances}{A vector of activity instance identifiers}

\item{reverse}{Logical, indicating whether the selection should be reversed.}
}
\value{
When given an eventlog, it will return a filtered eventlog. When given a grouped eventlog, the filter will be applied
in a stratified way (i.e. each separately for each group). The returned eventlog will be grouped on the same variables as
the original event log.
}
\description{
Filters the log based on activity instance identifier
}
\details{
The method filter_activity_instance can be used to filter on activity instance identifiers. It has an activity_instances argument,
to which a vector of identifiers can be given. The selection can be negated with the reverse argument.
}
\section{Methods (by class)}{
\itemize{
\item \code{eventlog}: Filter for eventlogs

\item \code{grouped_eventlog}: Stratified filter for grouped eventlogs
}}

\seealso{
\code{vignette("filters", "edeaR")}
}
