structure(list(url = "https://www.sec.gov/Archives/edgar/data/1424844/000092290708000774/form10k_122308.htm", 
    status_code = 200L, headers = structure(list(`accept-ranges` = "bytes", 
        `content-encoding` = "gzip", `content-type` = "text/html", 
        etag = "\"aa0cf9a5e404bd21f55d44f8d6940c8a\"", `last-modified` = "Sat, 30 Sep 2017 11:01:47 GMT", 
        server = "AmazonS3", `x-amz-id-2` = "+zd5mF9UQYb9KQU/iIvWQ1hPtv79EYp5LL8mmEdb5YKnZrX+SIRpCWXgHLV1tc35lmb1kR6ncVo=", 
        `x-amz-meta-mode` = "33188", `x-amz-replication-status` = "REPLICA", 
        `x-amz-request-id` = "2D6E7F10AABDE7CB", `x-amz-version-id` = "WQ.TcNWfTpQfsu7Mpq2Ob9rN1havdbZg", 
        `x-content-type-options` = "nosniff", `x-frame-options` = "SAMEORIGIN", 
        `x-xss-protection` = "1; mode=block", `content-length` = "93997", 
        date = "Thu, 21 Dec 2017 22:48:44 GMT", connection = "keep-alive", 
        vary = "Accept-Encoding", `strict-transport-security` = "max-age=31556952"), .Names = c("accept-ranges", 
    "content-encoding", "content-type", "etag", "last-modified", 
    "server", "x-amz-id-2", "x-amz-meta-mode", "x-amz-replication-status", 
    "x-amz-request-id", "x-amz-version-id", "x-content-type-options", 
    "x-frame-options", "x-xss-protection", "content-length", 
    "date", "connection", "vary", "strict-transport-security"
    ), class = c("insensitive", "list")), all_headers = list(
        structure(list(status = 200L, version = "HTTP/1.1", headers = structure(list(
            `accept-ranges` = "bytes", `content-encoding` = "gzip", 
            `content-type` = "text/html", etag = "\"aa0cf9a5e404bd21f55d44f8d6940c8a\"", 
            `last-modified` = "Sat, 30 Sep 2017 11:01:47 GMT", 
            server = "AmazonS3", `x-amz-id-2` = "+zd5mF9UQYb9KQU/iIvWQ1hPtv79EYp5LL8mmEdb5YKnZrX+SIRpCWXgHLV1tc35lmb1kR6ncVo=", 
            `x-amz-meta-mode` = "33188", `x-amz-replication-status` = "REPLICA", 
            `x-amz-request-id` = "2D6E7F10AABDE7CB", `x-amz-version-id` = "WQ.TcNWfTpQfsu7Mpq2Ob9rN1havdbZg", 
            `x-content-type-options` = "nosniff", `x-frame-options` = "SAMEORIGIN", 
            `x-xss-protection` = "1; mode=block", `content-length` = "93997", 
            date = "Thu, 21 Dec 2017 22:48:44 GMT", connection = "keep-alive", 
            vary = "Accept-Encoding", `strict-transport-security` = "max-age=31556952"), .Names = c("accept-ranges", 
        "content-encoding", "content-type", "etag", "last-modified", 
        "server", "x-amz-id-2", "x-amz-meta-mode", "x-amz-replication-status", 
        "x-amz-request-id", "x-amz-version-id", "x-content-type-options", 
        "x-frame-options", "x-xss-protection", "content-length", 
        "date", "connection", "vary", "strict-transport-security"
        ), class = c("insensitive", "list"))), .Names = c("status", 
        "version", "headers"))), cookies = structure(list(domain = logical(0), 
        flag = logical(0), path = logical(0), secure = logical(0), 
        expiration = structure(numeric(0), class = c("POSIXct", 
        "POSIXt")), name = logical(0), value = logical(0)), .Names = c("domain", 
    "flag", "path", "secure", "expiration", "name", "value"), row.names = integer(0), class = "data.frame"), 
    content = charToRaw("<DOCUMENT>\n<TYPE>10-K\n<SEQUENCE>1\n<FILENAME>form10k_122308.htm\n<TEXT>\n<HTML>\n<HEAD>\n<TITLE>FORM 10-K</TITLE>\n</HEAD>\n<BODY>\n<PRE>\n\n                                  <b>UNITED STATES\n                       SECURITIES AND EXCHANGE COMMISSION\n                             Washington, D.C. 20549\n\n                                    Form 10-K</b>\n(Mark one)\n |X|  ANNUAL REPORT UNDER SECTION 13 OR 15(d) OF THE SECURITIES EXCHANGE ACT\n      OF 1934\n\n                    For the fiscal year ended September 30, 2008\n\n[ ]   TRANSITION  REPORT  UNDER  SECTION  13 OR 15(d)  OF THE  SECURITIES\n      EXCHANGE ACT OF 1934\n\n                    For the  transition  period  from  _________  to  __________\n                    Commission file number 000-53041\n\n                      <u>SOUTHWEST IOWA RENEWABLE ENERGY, LLC</u>\n             (Exact name of registrant as specified in its charter)\n\n          <u>Iowa</u>                                         <u>20-2735046</u>\n(State or other jurisdiction of           (I.R.S. Employer Identification No.)\nincorporation or organization)\n\n  10868 189th Street, Council Bluffs, Iowa                51503\n  ----------------------------------------                -----\n  (Address of principal executive offices)              (Zip Code)\n\nIssuer's telephone number (712) 366-0392\n\nSecurities registered under Section 12(b) of the Exchange Act:      None.\n\n     Title of each class               Name of each exchange on which registered\n\nSecurities registered under Section 12(g) of the Exchange Act:\n\n                            <u>Series A Membership Units</u>\n                                (Title of class)\n\nIndicate by check mark if the  registrant is a well-known  seasoned  issuer,  as\ndefined in Rule 405 of the Securities Act. Yes [ ] No |X|\n\nIndicate  by  check  mark if the  registrant  is not  required  to file  reports\npursuant to Section 13 or 15(d) of the Exchange Act. Yes [ ] No |X|\n\nCheck  whether the issuer (1) filed all reports  required to be filed by Section\n13 or 15(d) of the Exchange Act during the 12 months (or for such shorter period\nthat the registrant was required to file such reports), and (2) has been subject\nto such filing requirements for the past 90 days. Yes |X| No [ ]\n\nCheck if there is no disclosure of delinquent  filers in response to Item 405 of\nRegulation  S-K  contained  herein,  and will not be  contained,  to the best of\nregistrant's   knowledge,   in  definitive   proxy  or  information   statements\nincorporated by reference in Part III of this Form 10-K or any amendment to this\nForm 10-K. [ ]\n\nIndicate by check mark whether the registrant is a large  accelerated  filer, an\naccelerated filer, a non-accelerated  filer, or a smaller reporting company. See\nthe definitions of \"large accelerated  filer,\"  \"accelerated filer\" and \"smaller\nreporting company\" in Rule 12b-2 of the Exchange Act.\n\n  Large  accelerated  filer    [ ] Accelerated filer    [ ] Non-accelerated filer\n  [ ] Smaller  reporting  company  |X|\n\nIndicate by check mark whether the  registrant is a shell company (as defined in\nRule 12b-2 of the Exchange Act). Yes [ ] No |X|\n\nAs of December 15, 2008, the aggregate market value of the Membership Units held\nby  non-affiliates  (computed by reference to the most recent  offering price of\nsuch Membership Units) was $52,134,000.\n\nAs of  September  30,  2008,  the Company had 8,805 Series A, 3,334 Series B and\n1,000 Series C Membership Units outstanding.\n\n                   DOCUMENTS INCORPORATED BY REFERENCE--None\n\n                                       1\n\n</pre>\n<hr>\n<pre>\n\n                                <b>TABLE OF CONTENTS\n\n                                     PART I\n\nItem Number    Item Matter                                           Page Number\n\nItem 1.        Business.                                                       1\n\nItem 1A.       Risk Factors.                                                  15\n\nItem 2.        Properties.                                                    30\n\nItem 3.        Legal Proceedings.                                             30\n\nItem 4.        Submission of Matters to a Vote of Security Holders.           31\n\n                                     PART II\n\nItem 5.        Market for Registrant's Common Equity, Related Member          31\n               Matters, and Issuer Purchases of Equity Securities.\n\nItem 6.        Selected Financial Data.                                       32\n\nItem 7.        Management's Discussion and Analysis of Financial Condition    32\n               and Results of Operation.\n\nItem 7A.       Quantitative and Qualitative Disclosures About Market Risk.    40\n\nItem 8.        Financial Statements and Supplementary Data.                   40\n\nItem 9.        Changes in and Disagreements With Accountants on Accounting    54\n               and Financial Disclosure.\n\nItem 9A(T).    Controls and Procedures.                                       54\n\nItem 9B.       Other Information.                                             55\n\n                                    PART III\n\nItem 10.       Directors, Executive Officers and Corporate Governance.        55\n\nItem 11.       Executive Compensation.                                        57\n\nItem 12.       Security Ownership of Certain Beneficial Owners and            59\n               Management and Related Member Matters.\n\nItem 13.       Certain Relationships and Related Transactions, and Director   60\n               Independence.\n\nItem 14.       Principal Accountant Fees and Services.                        63\n\n\n                                     PART IV\n\nItem 15.       Exhibits and Financial Statement Schedules.                    64\n\nSignatures</b>\n\n</pre>\n<hr>\n<pre>\n\n<b>Item 1. Business.</b>\n\n     Southwest Iowa Renewable  Energy,  LLC (the  \"<u>Company</u>,\"  \"<u>we</u>\" or \"<u>us</u>\") is a\ndevelopment  stage Iowa limited  liability company which was formed on March 28,\n2005 to  develop,  construct,  own and  operate a 110  million  gallon  dry mill\ncorn-based ethanol plant near Council Bluffs, Iowa (the \"<u>Facility</u>\").  Based upon\nengineering  specifications from ICM, Inc. (\"<u>ICM</u>\"), our primary constructor,  we\nexpect the Facility to process  approximately  39.3 million  bushels of corn per\nyear into 110 million  gallons of denatured fuel grade ethanol,  300,000 tons of\ndistillers' dry grains with solubles (\"<u>DDGS</u>\") and 50,000 tons of wet distillers'\ngrains with soluble (\"<u>WDGS</u>,\" together with DDGS,  \"<u>Distillers Grains</u>\"). The fuel\ngrade ethanol will be sold in limited  markets  throughout the United States and\nDistillers  Grains sold in  surrounding  communities  in  southwestern  Iowa and\nsoutheastern Nebraska.\n\n     Our Facility is located in Pottawattamie County in southwestern Iowa. It is\nnear two major interstate  highways,  within a half a mile of the Missouri River\nand will have  access to five major rail  carriers.  This  location  is in close\nproximity to raw materials and product market access.  The Facility will receive\ncorn and chemical deliveries primarily by truck but will be able to utilize rail\ndelivery if  necessary.  The site has access to water from ground wells and from\nthe Missouri  river.  In addition to close  proximity to the Facility's  primary\nenergy source,  steam, there are two natural gas providers available,  both with\ninfrastructure immediately accessible.\n\n     To execute our business plan, we raised capital  through two  offerings--an\ninitial  seed round in the fourth  quarter of 2005 and a secondary  round in the\nfirst quarter of 2006--and on May 2, 2007, we entered into a $126,000,000 credit\nfacility (as amended,  the \"<u>Credit  Agreement</u>\") with AgStar Financial  Services,\nPCA  (\"<u>Agent</u>\"),  as agent  for a  syndicate  group of  lenders  (\"<u>Lenders</u>\").  As\ndiscussed  in more  detail  below  under Item 7 -  Management's  Discussion  and\nAnalysis of Financial Condition and Results of Operation - Overview,  Status and\nRecent  Developments,  effective  March 7,  2008,  we  amended  the terms of our\nprimary  lending  agreements,  obtained a bridge loan in the  maximum  principal\namount of $36,000,000  (the \"<u>Bridge Loan</u>\") from Commerce Bank, N.A. (the \"<u>Bridge</u>\n<u>Lender</u>\") and entered into arrangements with the Bridge Lender and our key equity\nholders and operational  partners,  ICM and Bunge North America,  Inc. (a wholly\nowned  subsidiary  of Bunge  Limited,  a  publicly-traded,  global  agribusiness\ncompany)  (\"<u>Bunge</u>\"),  in order to resolve a  construction  budget  shortfall  of\n$34,000,000.\n\n     Information  respecting our losses, assets, and other financial information\nis contained below under Item 8 - Financial Statements and Supplementary Data.\n\n<b><I>Primary Contractors</i></b>\n\n     We have entered into  contracts  with various  contractors to construct the\nFacility,  though our primary contractors are ICM, Todd &amp; Sargent, Inc. (\"<u>T&amp;S</u>\"),\nand HGM Associates,  Inc. (\"<u>HGM</u>\").  Below are summaries of the contracts we have\nwith these three parties.\n\n     On September  25, 2006,  we entered  into an  Agreement  Between  Owner and\nDesign/Builder  on the Basis of Stipulated  Price with ICM (the \"<u>ICM Contract</u>\"),\nwhich provides that ICM will design and construct a dry mill fuel-grade  ethanol\nplant,  capable of producing 110 million gallons of denatured fuel-grade ethanol\nper  year  and  338,000  tons  of  DDGS.  For  such  services  we  will  pay ICM\napproximately  $118,000,000,  but the total cost of work may increase based upon\nchanges in the work to be performed.  On January 11, 2008,  ICM notified us that\ndue to our funding issues, additional time will be required to complete the work\nunder the ICM  Contract.  We  expect  the  construction  of the  Facility  to be\nsubstantially  completed in December 2008. In addition to designing and building\nthe Facility, ICM will provide training to our employees to operate the Facility\nthrough a six week training course.\n\n     Under the ICM  Contract,  ICM has the right to stop  work,  upon seven days\nwritten  notice  to us,  if we do not pay ICM  amounts  coming  due that we have\ncertified for payment;  provided,  however,  ICM may not stop work if there is a\ngood faith  dispute  regarding  the amount of payment  due. ICM has the right to\nterminate  the ICM  Contract  on seven  days  written  notice if (i) the work is\nsuspended,  without  fault on the part of ICM, by us or by order of the court or\nother public authority for a period of more than 90 days, or (ii) we fail to pay\nICM undisputed  amounts within 30 days of receiving an application  for payment.\nWe may suspend ICM's performance at any time and without cause for up to 90 days\nby  providing  written  notice  to ICM and the date on which  performance  is to\nresume. In addition,  we may terminate the ICM Contract for cause for any of the\nfollowing  reasons:  (w) ICM fails to perform  its work in  accordance  with the\nagreement,  (x) ICM intentionally or willfully disregards any law or regulation,\n(y)\n\n                                       1\n\n</pre>\n<hr>\n<pre>\n\nICM  materially  breaches  any  provision of the  agreement,  or (z) ICM becomes\nfinancially  insolvent,  files for a  voluntary  petition of  bankruptcy,  or an\ninvoluntary petition of bankruptcy is filed and not dismissed within 180 days of\nsuch filing.\n\n     On December  18,  2006,  we entered  into a Standard  Form of  Design-Build\nAgreement and General Conditions Between Owner and Contractor with T&amp;S (the \"<u>T&amp;S</u>\n<u>Contract</u>\"),   under  which  T&amp;S  agreed  to  provide  us  with  the  design  and\nconstruction  of a 1,000,000  bushel grain  receiving  and storage  facility and\nDistillers Grain storage facility.  The work provided for under the T&amp;S Contract\nwas completed by September 2008. We agreed to pay T&amp;S $9,661,000, subject to any\nchange orders,  and as of September 30, 2008, we have paid T&amp;S $9,562,000  under\nthe T&amp;S Contract.  The T&amp;S Contract can be terminated by T&amp;S if (i) the work has\nstopped for 90 day period due to a court  order,  a national  emergency or other\ngovernment  act  which  results  in a lack of  available  materials,  (ii)  work\nstopping  for at  least  90 days as a result  of us  suspending  the work or our\nfailure to pay (work can be stopped 30 days after our failure to pay), (iii) our\nmaterial  delay  of  T&amp;S's  performance,  (iv) our  material  breach  of the T&amp;S\nContract, or (v) our failure to furnish reasonable evidence that we will be able\nto pay the  costs of the  project  as they come due.  We can  terminate  the T&amp;S\nContract if T&amp;S breaches the  agreement in specified  ways.  If we terminate the\nT&amp;S Contract after commencement of construction,  we agreed to pay an additional\n5% of the remaining balance of the contract price.\n\n     On November 27, 2006,  we entered into an  Engineering  Services  Agreement\nwith HGM (the \"<u>HGM Contract</u>\").  Under the HGM Contract, HGM agreed to provide us\nwith professional design services for the development,  design, and construction\nof our Facility. Such services include geotechnical coordination,  site grading,\nutilities (including wells and water mains, natural gas, sanitary sewer, process\nsewer  outfall,  and fire loop),  substation  coordination,  a  landscape  plan,\nconstruction   staking,   construction   administration,   a  resident   project\nrepresentative,  compaction and material testing coordination,  record drawings,\nand site coordination.\n\n     We agreed to pay HGM either hourly rates or fixed prices,  depending on the\nservices.  The fixed prices total $93,200 for plant site grading revisions,  the\nplant road design,  the water well and raw water main,  the outfall  sewer,  the\nsanitary  sewer/collection/lift station, the potable water system the fire main,\nthe landscape plan, and natural gas.  Hourly fees will be paid for  geotechnical\ncoordination, construction staking and construction administration; in addition,\nhourly fees will be paid for (i) any  additional  services added at a later date\nand  (ii)  any  revisions  made  by us  requiring  HGM to  change  any  plan  or\nspecifications.  The hourly  fees  range from $35 to $280 per hour.  There is no\nestimated  total cost for any hourly  services.  In addition  to these fees,  we\nagreed  to  reimburse  HGM  for  direct  non-salary  expenses  including  travel\nexpenses,  reproduction costs and computer plots, postage, express mail, courier\nservices and handling of drawings, renderings, artwork, models, photography, and\nother deliverables.  The estimated cost of such reimbursable  expense is $1,300,\nbut the actual amount may exceed such estimate.\n\n     Either party may terminate the HGM Contract for cause upon at least 14 days\nnotice.  Termination for cause includes  violation of the covenants,  agreements\nand  stipulations  of the  HGM  Contract  and  nonpayment  by  us.  In  lieu  of\ntermination due to our nonpayment, HGM may elect to suspend its services. If HGM\nelects to suspend its services due to  nonpayment,  HGM has no liability for any\ndelay or damage caused.  In addition to termination  for cause, we may terminate\nthe HGM Contract for any reason with at least 30 days notice to HGM.\n\n<b><I>Status of Plant Construction</i></b>\n\n     With the proceeds of our two equity offerings, we began construction of our\nFacility  in  February  of 2007.  Construction  is  nearing  completion  and our\nFacility is anticipated to be operational  early in the second quarter of fiscal\n2009.  Further  detail  is  provided  in Item 7 --  Management's  Discussion  of\nFinancial Condition and Results of Operation -- Construction Status.\n\n<b><I>Plan of Operation for Fiscal Year 2009</i></b>\n\n     <b><u>Generally</u></b>\n\n     During the second  quarter of our fiscal 2009, we plan to continue  working\ntoward achieving nameplate production for the Facility,  and to raise additional\ncapital through one or more equity financings, as further\n\n                                       2\n\n</pre>\n<hr>\n<pre>\n\n\ndiscussed  elsewhere in this report.  We do not presently,  nor intend to in the\nfuture, conduct any research or development activities.\n\n     <b><u>Employees</u></b>\n\n     The Company had 14 full time employees as of September 30, 2008. In October\n2008 we were fully staffed with 52 employees in anticipation of the commencement\nof our operations.  We are not subject to any collective  bargaining  agreements\nand we have not  experienced any work  stoppages.  Our management  considers the\nCompany's employee relationships to be favorable.\n\n<b><I>Rail Access</i></b>\n\n     A six mile loop railroad  track for rail service to our Facility  comes off\nthe Council Bluffs Energy Center line where interstate I-29 crosses and proceeds\nsouth along the east side of Pony Creek.  We have  obtained  easements  with the\nproperty  owners  along  this  route to permit our  intended  access.  The track\nterminates in a loop-track south of the Facility, which will accommodate 100 car\nunit trains.  On June 18, 2008, we executed an Industrial  Track  Agreement with\nCBEC Railway,  Inc. (the \"<u>Track  Agreement</u>\"),  which governs our use of the loop\nrailroad and requires, among other things, that we maintain the loop track.\n\n     On June 25, 2007, we entered into a Railcar  Sublease  Agreement  (\"<u>Railcar</u>\n<u>Agreement</u>\")  with Bunge for the  sub-lease of 320 ethanol cars and 300 DDGS cars\nwhich will be used in the delivery and marketing of ethanol and DDGS. We will be\nresponsible for all maintenance and mileage charges as well as the monthly lease\nexpense and certain railcar modification expenses.  Under the Railcar Agreement,\nwe will  lease  railcars  for terms  lasting  120  months  and  continuing  on a\nmonth-to-month  basis thereafter.  The Railcar Agreement will terminate upon the\nexpiration of all railcar leases.\n\n<b><I>Principal Products</i></b>\n\n     <b><u>Ethanol</u></b>\n\n     Ethanol is a  chemical  produced  by the  fermentation  of sugars  found in\ngrains and other  biomass.  Ethanol can be produced  from a number of  different\ntypes of grains,  such as wheat and sorghum,  as well as from agricultural waste\nproducts  such as sugar,  rice hulls,  cheese whey,  potato  waste,  brewery and\nbeverage  wastes  and  forestry  and paper  wastes.  However,  according  to the\nRenewable Fuels Association (\"<u>RFA</u>\") website  (www.Ethanolrfa.org)  approximately\n90% of ethanol in the United  States  today is produced  from corn  because corn\nproduces  large  quantities  of  carbohydrates,  which convert into glucose more\neasily than other kinds of biomass.\n\n     Ethanol  has been used in motor  fuels in the  United  States  for the last\ncentury,  but for all practical  purposes had not been used  commercially  until\n1978. At that time a deliberate  public policy  objective to create a fuel-grade\nethanol  industry  was  established  by  Congress  when it created an excise tax\nexemption  in order to  encourage  the  production  of  ethanol  from  renewable\nresources. According to the RFA website (www. ethanolrfa.org),  the industry has\ngrown from virtually zero production at that time to a current annual production\nlevel of approximately  10.7 billion  gallons,  with  approximately  another 2.9\nbillion gallons currently expected to come on line by 2009.\n\n     We entered into an Ethanol  Merchandising  Agreement (\"<U>Lansing  Agreement</U>\")\nwith Lansing Ethanol Services, LLC (\"<U>Lansing</U>\"),  under which we agree to sell to\nand Lansing agrees to buy all ethanol produced at our Facility for the first six\nmonths  of our  operations.  Contract  terms  for the  sale of  ethanol  will be\nspecified  in sale  contracts.  Pricing for the ethanol  will be set by our Risk\nManagement Committee.  Under the Lansing Agreement, we assume all responsibility\nfor market price  fluctuations of ethanol,  but once a price is fixed in a sales\ncontract,  that  price  controls.  If we are made an offer to sell  ethanol at a\nprice greater than Lansing pays, Lansing has the option of paying that amount or\nallowing us to sell to the other  offeror.  For its  services,  we agreed to pay\nLansing a per-gallon fee for ethanol delivered under the Lansing  Agreement.  We\nalso agreed to allow  Lansing to store up to 2.8  million  gallons of ethanol at\nthe  Facility  at any time at no cost to  Lansing.  We  intend to  exercise  our\ncontractual  right under our agreement  with Lansing to terminate this agreement\nsix months after our ethanol  production  begins.  After the first six months of\nour operations, Bunge will be the exclusive purchaser of our ethanol pursuant to\nan Ethanol Purchase Agreement dated December 15, 2008 (the \"<U>Ethanol Agreement</U>\").\nBunge will market our ethanol\n\n                                       3\n\n</pre>\n<hr>\n<pre>\n\nin  national,  regional  and local  markets.  Under the Ethanol  Agreement,  the\nCompany  has agreed to sell Bunge all of the ethanol  produced at the  Facility,\nand Bunge has  agreed to  purchase  the  same,  up to the  Facility's  nameplate\ncapacity of  110,000,000  gallons a year. We will pay Bunge a per-gallon fee for\nethanol sold by Bunge under the Ethanol  Agreement,  subject to a minimum annual\nfee of $750,000  and  adjustments  according to  specified  indexes  after three\nyears. The initial term of the Ethanol  Agreement,  which will commence upon the\ntermination of the Lansing  Agreement,  is three years and it will automatically\nrenew for successive three-year terms unless one party provides the other notice\nof their election to terminate 180 days prior to the end of the term.\n\n     <b><u>Distillers Grains</u></b>\n\n     The chief  co-product  of the  ethanol  production  process  is  Distillers\nGrains, which are the residues that remain after high quality cereal grains have\nbeen fermented by yeast. In the fermentation  process,  the remaining  nutrients\nundergo a three-fold  concentration  to yield wet distillers  grains to which is\nadded evaporator syrup to create wet distillers  grains with solubles,  or WDGS.\nWDGS is a highly  digestible  feed ingredient  marketed  primarily to the dairy,\nbeef,  sheep,  swine and  poultry  industries.  Once  operational,  we intend to\nannually  dry 300,000  tons of our WDGS to become  distillers  dried grains with\nsolubles, or DDGS, which has a longer shelf life (three summer days, five winter\ndays) than WDGS and can better withstand  transportation over greater distances.\nWe plan to annually market 50,000 tons of our Distillers Grains as WDGS.\n\n     We entered into a Distiller's  Grain Purchase  Agreement  dated October 13,\n2006 (\"<u>DG  Agreement</u>\")  with Bunge,  under which Bunge is  obligated to purchase\nfrom us and we are obligated to sell to Bunge all Distillers  Grains produced at\nour Facility.  If we find another  purchaser for  Distillers  Grains  offering a\nbetter price for the same grade, quality,  quantity, and delivery period, we can\nask Bunge to either market  directly to the other purchaser or market to another\npurchaser on the same terms and pricing.\n\n      The initial  term of the DG  Agreement  began July 15, 2008 or a different\ndate if agreed upon in writing by both parties,  and lasts for ten years. The DG\nAgreement will  automatically  renew for additional  three year terms unless one\nparty  provides the other party with notice of election to not renew 180 days or\nmore prior to expiration.  Under the DG Agreement,  Bunge will pay us a Purchase\nPrice equal to the Sales Price minus the Marketing Fee and Transportation Costs.\nThe Sales Price is the price received by Bunge in a contract consistent with the\nDGS  Marketing  Policy or the spot price  agreed to between  Bunge and us. Bunge\nreceives a Marketing  Fee  consisting  of a  percentage  of the Net Sales Price,\nsubject to a minimum  yearly  payment of $150,000.  Net Sales Price is the Sales\nPrice less the Transportation  Costs and Rail Lease Charges.  The Transportation\nCosts are all freight charges,  fuel surcharges,  and other accessorial  charges\napplicable to delivery of Distillers Grains.  Rail Lease Charges are the monthly\nlease  payment for rail cars along with all  administrative  and tax filing fees\nfor such leased rail cars.\n\n<b><I>Description of Dry Mill Process</i></b>\n\n     Our Facility  will produce  ethanol by  processing  corn.  The corn will be\nreceived by  semitrailer  truck (or railcar if needed),  and will be weighed and\nstored in a  receiving  building.  It will then be  transported  to a scalper to\nremove rocks and debris before it is conveyed to storage bins.  Thereafter,  the\ncorn will be  transported  to a hammer mill or grinder where it is ground into a\nmash and  conveyed  into a tank for  processing.  We will  add  water,  heat and\nenzymes to break the ground  corn into a fine  liquid.  This liquid will be heat\nsterilized  and pumped to a tank where  other  enzymes  are added to convert the\nstarches into glucose sugars. Next, the liquid is pumped into fermenters,  where\nyeast  is  added,  to  begin  a 48 to 50  hour  batch  fermentation  process.  A\ndistillation  process  will divide the alcohol  from the corn mash.  The alcohol\nwhich exits the distillation  process is then partially dried. The resulting 200\nproof  alcohol is pumped into  storage  tanks.  Corn mash from the  distillation\nprocess  is  then  pumped  into  one of  several  centrifuges.  Water  from  the\ncentrifuges is dried into a thick syrup.  The solids that exit the centrifuge or\nevaporators  are called wet cake and are conveyed to dryers.  Corn mash is added\nto the wet cake as it enters the dryer, where moisture is removed.  This process\nproduces Distillers Grains.\n\n                                       4\n\n</pre>\n<hr>\n<pre>\n\n<b><I>Raw Materials</i></b>\n\n     <b><u>Corn Requirements</u></b>\n\n     Ethanol  can be  produced  from a number of  different  types of grains and\nwaste products. However, approximately 90% of ethanol in the United States today\nis  produced  from corn.  The cost of corn is affected  primarily  by supply and\ndemand factors such as crop production,  carryout,  exports, government policies\nand programs,  risk management and weather.  Despite strong corn production over\nthe last three growing seasons, corn prices rose dramatically in our 2008 fiscal\nyear due in part to  additional  corn  demand  from  the  ethanol  industry  and\nflooding in the Midwest.  With the volatility of the commodity markets we cannot\npredict the future price of corn with any certainty.\n\n     We  anticipate  that our  Facility  will need  approximately  39.3  million\nbushels of corn per year,  or  approximately  108,000  bushels  per day,  as the\nfeedstock  for its dry milling  process.  The grain supply for our plant will be\nobtained  primarily from local markets.  To assist in our securing the necessary\nquantities  of grain for our plant,  we entered  into a Grain  Feedstock  Supply\nAgreement dated December 15, 2008 (the \"<u>Supply Agreement</u>\") with AGRI-Bunge,  LLC\n(\"<u>AB</u>\"),  an entity  affiliated with Bunge.  Under the Supply  Agreement,  AB has\nagreed to provide us with all of the corn we need to operate our ethanol  plant,\nand we have  agreed  to only  purchase  corn  from  AB.  AB will  provide  grain\noriginators  who will  work at the  Facility  for  purposes  of  fulfilling  its\nobligations under the Supply Agreement. The Company will pay AB a per-bushel fee\nfor corn procured by AB for the Company under the Supply Agreement, subject to a\nminimum annual fee of $675,000 and  adjustments  according to specified  indexes\nafter three years.  The term of the Supply  Agreement  is ten years,  subject to\nearlier  termination upon specified  events.  The Supply Agreement  suspends the\noperation of the Agency Agreement  entered into by the Company and AB on October\n13,  2006,  as amended  December 15, 2008 (the  \"<u>Agency  Agreement</u>\").  Under the\nAgency  Agreement,  we  agreed to pay an  agency  fee to AB for corn  delivered,\nsubject to an annual minimum fee of $225,000,  for AB's service of procuring all\ngrain  requirements  for our  plant.  In the  event we  obtain a grain  dealer's\nlicense,  then the  operation of the Supply  Agreement  will  terminate  and the\nAgency Agreement will be reinstated.\n\n     The price and availability of corn are subject to significant  fluctuations\ndepending  upon a number of factors  which affect  commodity  prices in general,\nincluding crop conditions, weather, governmental programs and foreign purchases.\nIn the ordinary course of business, once we are operational,  we anticipate that\nwe will enter into forward purchase contracts for our commodity purchases.\n\n     <b><u>Energy Requirements</u></b>\n\n     The  production  of ethanol is a very energy  intensive  process which uses\nsignificant amounts of electricity and a supply of a heat source.  Presently, we\nanticipate  that about 34,000 BTUs of energy are required to produce a gallon of\nethanol. Additionally, water supply and quality are important considerations.\n\n     <I>Steam</i>\n\n     Unlike  most  ethanol  producers  in the  United  States  which use coal or\nnatural gas as their primary  energy  source,  our primary energy source will be\nsteam.  We  believe  that  utilizing  steam  will  make us more  competitive  by\nproviding us with critical support and services in the areas of risk management,\nquality   control,   experienced   commodity   trading  and  experience  in  the\nimplementation  of the latest  technologies.  We have  entered  into an Executed\nSteam Service  Contract  (\"<u>Steam  Contract</u>\")  with  MidAmerican  Energy  Company\n(\"<u>MidAm</u>\")  dated  January 22, 2007,  as amended on October 3, 2008,  under which\nMidAm agreed to provide the steam required by us, up to 475,000 pounds per hour.\nWe agree to pay a Net Energy Rate for all steam service provided under the Steam\nContract and a Monthly Demand charge for Condensate Not Returned. Condensate Not\nReturned is the steam delivered to us less the  condensation we return to MidAm.\nThe Net Energy Rate is set for first three years then adjusted each year started\non the third  anniversary  date.  The Steam  Contract  remains in effect for ten\nyears from the  earlier of the date we commence a  continuous  grind of corn for\nethanol production, or February 1, 2009.\n\n                                       5\n\n</pre>\n<hr>\n<pre>\n\n     <I>Natural Gas</i>\n\n     Although  steam will be our  primary  energy  source and will  account  for\naround 85% of our energy usage,  we will install natural gas back-up boilers for\nuse when our steam service is temporarily unavailable.  Natural gas will also be\nneeded for  incidental  purposes.  Natural gas prices  fluctuate with the energy\ncomplex in general.  Recently, natural gas prices have trended lower as a result\nof the drop in crude oil prices.  We do not expect  natural gas prices to remain\nsteady in the near future and will trend even  higher into the winter  months of\n2008-2009 as seasonal  demand for natural gas  increases due to heating needs in\nthe colder  weather.  We have entered into a natural gas supply  agreement  with\nConstellation Energy for our long term natural gas needs.\n\n     <I>Electricity</i>\n\n     Our plant will require a large continuous  supply of electrical  energy. We\nplan on purchasing  electricity  from MidAm under an Electric  Service  Contract\n(\"<u>Electric  Contract</u>\") dated December 15, 2006. Under the Electric Contract,  we\nare allowed to install a standby  generator,  which  would  operate in the event\nMidAm is unable to provide us with  electricity.  In the Electric  Contract,  we\nagreed to own and operate a 13 kV switchgear with metering bay, all distribution\ntransformers, and all 13 kV and low voltage cable on our side of the switchgear.\nWe agreed to pay (i) a service charge of $200 per meter, (ii) a demand charge of\n$3.38 in the Summer and $2.89 in the Winter  (iii) a reactive  demand  charge of\n$0.49/kVAR of reactive demand in excess of 50% of billing demand, (iv) an energy\ncharge  ranging from  $0.03647 to $0.01837 per kilowatt  hour,  depending on the\namount of usage and season, (v) tax adjustments,  (vi) AEP and energy efficiency\ncost recovery  adjustments,  and (vii) a CNS capital  additions  tracker.  These\nrates only apply to the primary  voltage  electric  service  provided  under the\nElectric Contract.  The electric service will continue at these prices for up to\n60 months,  but in any event will  terminate on June 30, 2012. The pricing under\nthe Electric  Contract is based on the assumptions  that we will have an average\nbilling demand of 7,300 kilowatts per month and that we will average an 85% load\nfactor over a 12 month period.  If these  assumptions  are not met, then we will\npay the most applicable tariff rate. Additionally,  at any time, we may elect to\nbe charged under one of MidAm's electric tariffs.\n\n     <I>Water</i>\n\n     We will require a significant supply of water. Much of the water used in an\nethanol plant is recycled  back into the process.  There are,  however,  certain\nareas of  production  where fresh water is needed.  Those areas  include  boiler\nmakeup water and cooling tower water.  Boiler makeup water is treated on-site to\nminimize  all elements  that will harm the boiler and  recycled  water cannot be\nused for this process.  Cooling tower water is deemed non-contact water (it does\nnot come in contact with the mash) and, therefore,  can be regenerated back into\nthe cooling tower process.  The makeup water  requirements for the cooling tower\nare  primarily a result of  evaporation.  Much of the water can be recycled back\ninto the process,  which will minimize the effluent.  Our Facility's engineering\nspecifications  provide  that our fresh  water  requirements  are  approximately\n1,000,000  gallons per day. We anticipate  that our water  requirements  will be\nsupplied  through  three  ground  wells  which are  permitted  to  produce up to\n2,000,000 gallons of water per day. We could also access water from the Missouri\nRiver.\n\n<b><I>Principal Supply &amp; Demand Factors</i></b>\n\n     <b><u>Ethanol</u></b>\n\n     <I>Generally</i>\n\n     Ethanol prices have come down  dramatically  during the three months ending\nSeptember  30, 2008 as a direct  response  to falling  corn  prices.  Management\ncurrently  expects  ethanol  prices will continue to be directly  related to the\nprice of corn.  Management  believes the industry will need to grow both product\ndelivery  infrastructure  and demand for ethanol in order to support  production\nmargins in the near and long term. According to the Renewable Fuels Association,\nas of October,  2008, there were 176 ethanol plants in operation nationwide with\nthe capacity to produce  nearly 10.7  billion  gallons of ethanol  annually.  An\nadditional  27 new  plants  and five  company  expansions  are  currently  under\nconstruction,  which will add an  additional  estimated  2.9 billion  gallons of\nannual production capacity. Unless the new supply of ethanol is equally met with\nethanol demand, downward pressure on ethanol prices could continue.\n\n                                       6\n\n</pre>\n<hr>\n<pre>\n\n      According  to the RFA,  ethanol  demand  has  been  relatively  stable  at\napproximately  7  billion  gallons  per year  throughout  2008.  Ethanol  demand\nexpanded  significantly  in 2006 due to  replacement of MTBE with ethanol as the\noxygenate in reformulated fuel required for carbon monoxide non-attainment areas\nin the winter months.  This could mean that there may be some slight seasonality\nto the demand for ethanol,  with increases in demand occurring during the winter\nmonths.  However,  we believe that most of the increase in ethanol demand due to\nMTBE replacement has already occurred.  Management believes that it is important\nthat ethanol  blending  capabilities of the gasoline market be expanded in order\nto increase demand for ethanol.  Recently, there has been increased awareness of\nthe need to expand ethanol distribution and blending infrastructure, which would\nallow the  ethanol  industry to supply  ethanol to markets in the United  States\nthat are not currently blending ethanol.\n\n     <I>VEETC</i>\n\n     The  profitability  of the ethanol  industry is impacted by federal ethanol\nsupports and tax  incentives,  such as the Volumetric  Ethanol Excise Tax Credit\n(\"<u>VEETC</u>\")  blending  credit.  The passage of the VEETC has helped to provide the\nflexibility  necessary to expand ethanol blending into higher blends of ethanol,\nsuch as E85. The VEETC went into effect on January 1, 2005.  Prior to VEETC, the\nfederal  excise tax on 10%  ethanol-blended  gasoline was 13.2 cents per gallon,\ncompared to 18.4 cents per gallon on regular  gasoline.  Under VEETC,  the lower\nfederal excise tax on ethanol-blended  gasoline was eliminated.  In place of the\nlower excise tax, the VEETC created a new  volumetric  ethanol excise tax credit\nof $0.51 per gallon of ethanol.  Gasoline  distributors  apply for this  credit.\nBased on volume, the VEETC is expected to allow greater refinery  flexibility in\nblending  ethanol since it makes the tax credit available on all ethanol blended\nwith gasoline, diesel and ethyl tertiary butyl ether, including ethanol in E-85.\nUnder  provisions of the 2008 Farm Bill, the tax exemption will drop to 45 cents\nper gallon in 2009.  The VEETC is  scheduled  to expire on December  31, 2010. A\nnumber of bills have been  introduced  in the  Congress  to extend  ethanol  tax\ncredits, including some bills that would make the ethanol tax credits permanent.\nThere can be no assurance, however, that such legislation will be enacted.\n\n     <I>RFS</i>\n\n     The  federal  legislation  which  impacts  ethanol  demand the most are the\nEnergy  Policy Act of 2005 (the  \"<u>2005  Act</u>\") and the  Energy  Independence  and\nSecurity  Act of 2007  (\"<u>2007  Act</u>\").  Most  notably,  the 2005 Act  created the\nRenewable  Fuels Standard  (\"<u>RFS</u>\"),  which was designed to favorably  impact the\nethanol industry by enhancing both the production and use of ethanol. The RFS is\na national program that does not require that any renewable fuels be used in any\nparticular  area or state,  allowing  refiners to use  renewable  fuel blends in\nthose areas where it is most cost-effective.\n\n     The 2007 Act amended  several  components  of the RFS. The RFS now requires\n(i) the fuel  refining  industry as a whole  (including  refiners,  blenders and\nimporters) to use 4.5 billion gallons of renewable fuels in 2007,  increasing to\n15.2  billion  gallons by 2012 and 36 billion  gallons  by 2022;  (ii)  advanced\nbiofuel  (renewable  fuel  derived  from corn  starch  other  than  ethanol  and\nencompassing  cellulosic biofuel and biomass-based  diesel),  cellulosic biofuel\nand  biomass-based  diesel  to be  used  in  addition  to  conventional  biofuel\n(ethanol);  (iii) for 2008,  the use of  approximately  nine billion  gallons of\nrenewable fuels (only ethanol); (iv) in 2012, the use of 13.2 billion gallons of\nethanol,  two  billion  gallons  of  advanced  biofuel,  .5  billion  gallons of\ncellulosic biofuel, and one billion gallons of biomass-based diesel, for a total\nof 15.2 billion gallons of renewable fuel; and (v) by 2036,  usage of 15 billion\ngallons of ethanol, excluding advanced biofuel.\n\n     The  2007  Act also  requires  facilities  beginning  operation  after  its\nenactment to operate with at least a 20% reduction in lifecycle  greenhouse  gas\nemissions  compared to gasoline.  In the event the EPA  determines  this size of\nreduction is not feasible, it may reduce the required reduction, but in no event\nwill a new plant be allowed to operate at less than a 10% reduction in lifecycle\ngreenhouse gas emissions. Presently, we are assessing our options to comply with\nthis requirement.  We believe that our use of steam as our primary energy source\nwill reduce our  emissions,  as compared to other  ethanol  plants which utilize\nnatural gas or coal as their primary heat source.\n\n     The  ethanol  industry  has  expanded  production  and is  projected  to be\nsignificantly  higher than the 2007 RFS amount.  This means the ethanol industry\nmust continue to generate demand for ethanol beyond the minimum floor\n\n                                       7\n\n</pre>\n<hr>\n<pre>\n\nset by the RFS in order to support current ethanol prices.  We will be dependent\non Lansing's and then Bunge's ability to market the ethanol in this  competitive\nenvironment.\n\n     <I>State Initiatives</i>\n\n     In 2006,  Iowa passed  legislation  promoting the use of renewable fuels in\nIowa.  One of the  most  significant  provisions  of the  Iowa  renewable  fuels\nlegislation is a renewable  fuels standard  encouraging 10% of the gasoline sold\nin Iowa to consist of renewable  fuels by 2009.  This  renewable  fuels standard\nincreases   incrementally  to  25%  of  the  gasoline  sold  in  Iowa  by  2019.\nAdditionally, certain plants located in Nebraska that were in production on June\n30,  2004 are  eligible  for state  incentives,  which  authorize  a producer to\nreceive up to $2.8 million of tax credits per year for up to eight years.  While\nwe cannot qualify for these incentives, they do provide an economic advantage to\nsome of our competitors.\n\n     <I>E85</i>\n\n     Demand for ethanol has been  affected by the increased  consumption  of E85\nfuel.  E85 fuel is a blend of 85% ethanol  and 15%  gasoline.  According  to the\nEnergy Information Administration, E85 consumption is projected to increase from\na national  total of 11 million  gallons in 2003 to 47 million  gallons in 2025.\nE85 can be used as an aviation  fuel,  as reported by the National  Corn Growers\nAssociation, and as a hydrogen source for fuel cells. According to the Renewable\nFuels  Association,  there are  currently  more than five million  flexible fuel\nvehicles capable of operating on E85 in the United States and automakers such as\nFord and General Motors have  indicated  plans to produce  several  million more\nflexible fuel vehicles per year. The National Ethanol Vehicle  Coalition reports\nthat there are currently  approximately 1,150 retail gasoline stations supplying\nE85.  While the number of retail E85  suppliers has  increased  each year,  this\nremains  a  relatively  small  percentage  of the total  number  of U.S.  retail\ngasoline  stations,  which is  approximately  170,000.  In order for E85 fuel to\nincrease demand for ethanol,  it must be available for consumers to purchase it.\nAs public  awareness  of ethanol and E85  increases  along with E85's  increased\navailability,   management   anticipates  some  growth  in  demand  for  ethanol\nassociated with increased E85 consumption.\n\n     <I>Cellulosic Ethanol</i>\n\n     Due to the current high corn prices,  discussion of cellulose-based ethanol\nhas recently increased.  Cellulose is the main component of plant cell walls and\nis the most common organic compound on earth.  Cellulose is found in wood chips,\ncorn stalks and rice straw,  among other common  plants.  Cellulosic  ethanol is\nethanol produced from cellulose, and currently, production of cellulosic ethanol\nis in its  infancy.  It is  technology  that is as yet  unproven on a commercial\nscale. However,  several companies and researchers have commenced pilot projects\nto study the feasibility of commercially  producing  cellulosic ethanol. If this\ntechnology  can  be  profitably   employed  on  a  commercial  scale,  it  could\npotentially  lead to ethanol that is less  expensive to produce than  corn-based\nethanol,  especially  if corn prices  remain high.  Cellulosic  ethanol may also\ncapture more government  subsidies and assistance than corn-based ethanol.  This\ncould decrease demand for our product or result in competitive disadvantages for\nour ethanol production process.\n\n     <I>Local Production</i>\n\n     Because  we are  located on the border of Iowa and  Nebraska,  and  because\nethanol producers generally compete primarily with local and regional producers,\nthe ethanol  producers  located in Iowa and Nebraska  presently  constitute  our\nprimary competition. According to the Iowa Renewable Fuels Association, in 2008,\nIowa had 31 ethanol  refineries in production,  producing 2.4 billion gallons of\nethanol from 890 million  bushels of corn.  There are an  additional  13 ethanol\nrefineries under  construction or expansion in Iowa as of October,  2008. If all\nthese plants are completed,  it is anticipated it will add 1.34 billion  gallons\nof new ethanol production  capacity annually in Iowa. We expect more plants will\nbegin construction,  but at a slower pace than previous years.  According to the\nNebraska  Ethanol  Board,  there are  currently  24 existing  ethanol  plants in\nNebraska,  and three plants under  construction.  Additionally,  certain  plants\nlocated in Nebraska  that were in  production  on June 30, 2004 are eligible for\nstate  incentives,  which  authorize a producer to receive up to $2.8 million of\ntax credits per year for up to eight years. Those producers  qualifying for this\nincentive will have a competitive advantage over us.\n\n                                       8\n\n</pre>\n<hr>\n<pre>\n\n     <b><u>Distillers Grains</u></b>\n\n     Management  expects that Distillers Grains prices will continue to decrease\nslightly  in the  foreseeable  future as the  supply  increases  (the  result of\nincreased  ethanol  production) and with the poor state of the economy and lower\ncorn  prices.  Management  believes  DDG's will trade with a 75% to 80% value to\ncorn.\n\n<b><I>Regulatory Environment</i></b>\n\n     <b><u>Governmental Approvals</u></b>\n\n     Ethanol  production  involves the emission of various airborne  pollutants,\nincluding  particulate matters,  carbon monoxide,  oxides of nitrogen,  volatile\norganic compounds and sulfur dioxide.  Ethanol  production also requires the use\nof  significant  volumes of water,  a portion of which is treated and discharged\ninto  the  environment.   We  are  required  to  obtain  various  environmental,\nconstruction and operating permits,  as discussed below. Under the HGM Contract,\nHGM has  agreed  to take  primary  responsibility  for  obtaining  some of those\npermits.  In addition,  ICM is responsible  for obtaining  various  construction\npermits and registrations. Even though we have successfully acquired the permits\nnecessary at our stage of construction,  any retroactive change in environmental\nregulations,  either at the federal or state level,  could  require us to obtain\nadditional or new permits or spend considerable resources on complying with such\nregulations.  In addition,  although we do not presently  intend to do so, if we\nsought to expand the  Facility's  capacity  in the  future,  we would  likely be\nrequired to acquire additional  regulatory permits and could also be required to\ninstall additional pollution control equipment.\n\n     Our failure to obtain and  maintain  the permits  discussed  below or other\nsimilar  permits  which may be  required  in the future  could  force us to make\nmaterial changes to our Facility or to shut down  altogether.  The following are\nsummaries  of the various  governmental  approvals  needed to obtain in order to\nbecome operational.\n\n     <b><u>Environmental Regulations and Permits</u></b>\n\n     We will be subject to regulations on emissions from the U.S.  Environmental\nProtection  Agency  (\"<u>EPA</u>\")  through the Iowa  Department  of Natural  Resources\n(\"<u>IDNR</u>\").  The EPA's and IDNR's environmental  regulations are subject to change\nand often such changes are not favorable to industry.  Consequently,  even if we\nhave the proper permits now, we may be required to invest or spend  considerable\nresources to comply with future environmental regulations.  The capital expenses\nrequired  for us to comply  with the  following  environmental  regulations  are\nincluded in the price we agreed to pay ICM under the ICM Contract.\n\n     <I>Air Pollution Construction and Operation Permits</i>\n\n     Based on reportable emissions, our Facility is considered a minor source of\nregulated  air  pollutants,  but due to our steam system with MidAm,  we will be\nsubject to Title V of the Clean Air Act (\"<u>Title  V</u>\") and the Maximum  Achievable\nControl Technology  Standards  promulgated by the EPA. We were required to apply\nfor an Air Construction  Permit with the IDNR and the EPA as a major emitter due\nour proximity to MidAm's  adjacent plant and a soybean crush plant.  We received\nan Air Permit for  construction  from IDNR and the EPA,  respecting  our ethanol\nprocess equipment,  storage tanks, scrubbers, and bag houses' emissions sources,\nand we were  required to modify our Air Permit for our  auxiliary  boilers.  Air\nPermits are required for our auxiliary boilers.  Such a permit is required prior\nto construction of or modification to an air pollution  emission source. The Air\nPermit for  construction  allows us to build,  initially  operate and test a new\nsource of air  pollution,  but does not cover  any of our  activities  after the\nFacility is operational.  Therefore, we are required to obtain an Air Permit for\nour operations  from both the EPA and IDNR before we can commence  operations at\nthe  Facility.  The Air Permit  for  operations  will  allow us to  operate  our\nFacility within certain  requirements  detailed in that permit.  Our revised air\npermit is  expected  to be  awarded  in  mid-December  allowing  us to  complete\nconstruction  of our permanent  backup  boiler  system.  This back-up  system is\nexpected to be  operational  by February 1, 2009,  and will have the capacity to\nsupply  100% of our  Facility's  steam  needs in the event of a MidAm  shutdown.\nThere is an annual fee associated with holding an Air Permit for operations, and\nthat annual fee is based on the prior year's  actual  emission  levels.  The Air\nPermit for operations is required to be renewed every five years.\n\n                                       9\n\n</pre>\n<hr>\n<pre>\n\n     We are  required  to  collect  and keep  information  outlining  our annual\npollution  emissions.  Every year we must  provide an  accounting  of the actual\npollution generated by the Facility to the EPA and IDNR in order to maintain our\nstatus as a Conditionally Exempt Small Quantity Generator and our Air Permit for\noperating.  This  accounting  is the basis for the Air  Permit  fees,  discussed\nabove.\n\n     Because  we are  installing  auxiliary  boilers  at our  Facility,  the EPA\nrequires us to install  Continuous  Emissions  Monitoring  or Partial  Emissions\nMonitoring.  In addition, the EPA requires us to have and maintain an Operations\nMonitoring Plan, which will be outlined in our Air Permit for operations.\n\n     There  is a  risk  that  regulatory  changes  might  impose  additional  or\ndifferent  requirements.   To  date,  we  have  not  been  determined  to  be  a\nnon-attainment  area for any pollutant.  Being designated a non-attainment  area\nmeans  the EPA has  determined  that  more of a  particular  pollutant  is being\nemitted  in  one  area  than  the  EPA  allows.   If  our  Facility   becomes  a\nnon-attainment  area, then the State of Iowa could impose a State Implementation\nPlan  which  would  require  the   imposition   of  Prevention  of   Significant\nDeterioration  requirements  and  the  installation  of Best  Available  Control\nTechnologies  for any future  modifications  or expansions of the Facility.  Any\nsuch event would  significantly  increase the operating  costs and capital costs\nassociated with any future expansion or modification of the Facility.\n\n     <I>Prevention of Significant Deterioration</i>\n\n     Our  Facility  is adjacent to the MidAm  coal-fired  electrical  generating\nfacilities.  These facilities  produce steam as a byproduct that will be used by\nour Facility for production purposes, as discussed elsewhere in this 10-K. It is\npossible  that the IDNR or the EPA could  determine  that the use of steam  from\nMidAm's facilities as the power source for our Facility renders MidAm's plant to\nbe a  \"support  facility\"  of our  Facility.  The  EPA's  interpretation  of its\nPrevention of Significant  Deterioration  regulations (\"<u>PSD</u>\") generally provides\nthat if two  facilities are adjacent to each other but have different SIC codes,\none of the facilities  can still be determined to be a support  facility for the\nother.  The result is that our Facility is subject to PSD  regulations,  meaning\nthat both the MidAm plant and our Facility will be  considered  one major source\nof air pollutants  for the  applicability  of both Title V and PSD.  Because our\nFacility and the MidAm plant are considered one major source of air  pollutants,\nthen we may have difficulty maintaining our Air Permits, discussed above, due to\nthe higher  level of  emissions  coming from the  combined  source.  Because our\nFacility must comply with PSD, it will also be subject to Best Available Control\nTechnology (\"<u>BACT</u>\") requirements. Compliance with BACT requirements will require\nadditional  compliance  and testing from our  engineers  to  establish  that the\ndesign of the Facility uses BACT,  which have  materially  increased our capital\ncosts by  $150,000.  If we are  unable  to  achieve  BACT  compliance,  then our\nFacility's  ability to obtain  permits  and  operate  will be  jeopardized.  PSD\ncompliance  also  requires (i) the  coordination  of additional  air  dispersion\nmodeling  by both  MidAm and our  Facility  in order to obtain an air  discharge\npermit  from IDNR,  and (ii) our  Facility  to meet both  National  Ambient  Air\nQuality  Standards  and not  exceed  ambient  air  increment  limits  for  major\nmodifications.  If the air  dispersion  modeling  indicates that the Facility is\nunable to meet  either of these PSD  requirements,  then the  Facility  would be\nunable to obtain the necessary operating permits,  unless the design or capacity\nof our plant were  reduced or  modified.  Any  reduction  in the capacity of the\nplant or  modification  to the  design in order to meet  these PSD  requirements\nwould  significantly  increase  operating costs and capital costs, and otherwise\nnegatively impact our ability to operate the Facility profitably.\n\n     <I>New Source Performance Standards</i>\n\n     The  Facility  is  subject to the EPA's New  Source  Performance  Standards\n(\"<u>NSPS</u>\") for both its distillation processes and the storage of volatile organic\ncompounds  used in the  denaturing  process.  Duties imposed by the NSPS include\ninitial notification,  emission limits,  compliance and monitoring  requirements\nand  recordkeeping  requirements.  These  standards  will require  equipment and\nprocedures which will increase our operating and capital costs.\n\n     We are required to provide the EPA with various NSPS  Notifications.  These\nnotifications  are required before and after the start of construction  and also\nbefore and after  beginning  operation of several key  processes  and  equipment\ncomponents. We have currently submitted all required notifications. We intend to\ncontinue  to  submit  the  appropriate  forms as the  identified  processes  are\ncompleted or equipment components are installed.\n\n                                       10\n\n</pre>\n<hr>\n<pre>\n\n     <I>Wetlands and Navigable Waters</i>\n\n     The  construction  of the  railroad  line to the  Facility or the  Facility\nitself,  including roads,  bridges,  and discharge pipes, may impact wetlands or\nnavigable  waterways  under the  jurisdiction  of Army Corps of  Engineers  (the\n\"<u>Corps</u>\").  We obtained a 404(b)(1) permit from the Corps for the construction of\nour rail line.  We are required to obtain a 404(b)(1)  permit from the Corps for\nthe  construction  of our steam line and force  main.  An  application  for this\npermit has been submitted to the Corps. We have also completed a  Corps-required\nEnvironmental  Assessment,  and it is  possible  that we will need to  undertake\ncertain  mitigation  efforts in order to  eliminate  any net loss of wetlands or\nother  damage  to  streams  and  rivers.  The Corps or other  agencies  have not\nrequired an Environmental Impact Study be completed.  If an Environmental Impact\nStudy is required at some point in the future,  the construction of the Facility\ncould be  significantly  delayed.  A  significant  delay in  construction  could\nsignificantly increase operating and capital costs.\n\n     <I>Endangered Species</i>\n\n     Prior  to  Construction,   we  performed  endangered  species  research  to\ndetermine if any species listed on the Iowa or Federal  endangered or threatened\nspecies list lived in the construction area. The Least Tern (<I>Sterna  antillarum,</i>\non both  Iowa and  federal  endangered  species  lists)  and the  Piping  Plover\n(<I>Charadrius melodus</i>, also on both Iowa and federal endangered species lists) use\nthe fly ash piles and pond of the  adjacent  MidAm  power  facility  as seasonal\nhabitat.  The construction of the rail line which will service our Facility will\nrun along and adjacent to the fly ash piles and pond. We have received direction\nfrom the United  States Fish and Wildlife  Service  (\"<u>USFWS</u>\") and IDNR to reduce\nany potential impact on these endangered species,  and will accordingly restrict\nrail line  construction  activities to non-nesting  seasons and strictly  follow\nconstruction  erosion control procedures pursuant to our Construction Site Storm\nWater  Pollution  Prevention  Plan,  which was  created  as part of an  National\nPollution  Discharge  Elimination System (\"<u>NPDES</u>\")  Stormwater  Discharge Permit\nrequired  for  construction  activities.   The  Construction  Site  Storm  Water\nPollution  Prevention  Plan  details  how storm  waters will be  protected  from\nexposure  to  plant  pollutants,  and also how we will  prevent  excessive  soil\nerosion on the  construction  site  prior to  vegetation  growing in  sufficient\nquantities to prevent such erosion. As part of the Construction Site Storm Water\nPollution  Prevention  Plan we are  required  to examine  our silt  fencing  for\nintegrity  degradation  each week and after each rain.  It is possible  that the\nUSFWS or IDNR could impose  additional  restrictions  on us at a future date and\nthis  would  significantly  delay  construction  of the rail line,  which  could\nsignificantly  increase our operating or capital  costs or otherwise  negatively\nimpact our ability to operate the Facility as profitably.\n\n     <I>Rail Line Matters</i>\n\n     We plan for our  railroad  line to only  serve  the  Facility.  While it is\npossible that we could agree with other  industries to share our railroad  line,\nno such  industry  is known at this  time.  We believe  that the line  should be\nconsidered an exempt \"industry lead track\" or \"spur track\" under applicable rail\ntransportation  regulations.  The  United  State  Surface  Transportation  Board\n(\"<u>STB</u>\"),  which  regulates  the  construction  of new  railroad  lines,  has not\nrequired any  Environmental  Assessment of the site. If in the future additional\nindustries request access to our railroad line and the railroad line were deemed\nby the STB to be a major  project,  then the STB could require an  Environmental\nAssessment or an Environmental  Impact Study. If an  Environmental  Impact Study\nwere  required  by the STB,  then the use of the rail line  could be  negatively\nimpacted.  Any  negative  impact  on the  rail  line  or a  required  change  in\noperations  could  significantly  increase  our  operating  or capital  costs or\notherwise negatively impact our ability to operate the Facility profitably.\n\n     <I>Waste Water Discharge Permit</i>\n\n     We will use water to cool our closed circuit systems in the Facility and we\nwill  generate  Reverse  Osmosis.  blowdown  water.  In order to maintain a high\nquality of water for the cooling system, the water will be continuously replaced\nwith make-up water. As a result, our Facility will discharge non-contact cooling\nwater from the cooling towers.  We received a Wastewater  Discharge  Permit from\nIDNR  to  discharge  non-contact  water  into  the  Missouri  River.  Under  the\nWastewater Discharge Permit, we are required to periodically test and report our\ndischarge activity to IDNR.\n\n                                       11\n\n</pre>\n<hr>\n<pre>\n\n     <I>Storm Water Discharge Permit and Other Water Permits</i>\n\n     We have received a Hydrostatic  Testing Water Discharge Permit from IDNR to\nallow the temporary discharge of water used for testing the integrity of vessels\nand equipment as part of our construction  activities.  The Hydrostatic  Testing\nWater Discharge Permit allows each vessel or piece of equipment to be filled and\ndischarged one time. In addition,  the water used in the testing process must be\ntested prior to discharge.\n\n     We have received our  Construction  Storm Water  Discharge  Permit from the\nIDNR.  This  general  permit  was  issued  after  two  public  notices  and  the\npreparation of a Storm Water  Pollution  Prevention  Plan that outlines  various\nmeasures we plan to implement to prevent storm water pollution.  Under our Storm\nWater Pollution Prevention Plan, we must assess the effectiveness of our run off\nprevention each week and after each storm. We received a Construction Site Storm\nWater Discharge Permit  (\"<u>CSSWDP</u>\") from IDNR. As part of the application for the\nCSSWDP,  we prepared a Construction  Site Storm Water Pollution  Prevention Plan\ncovering  how we will  control  construction  site  erosion.  We are  subject to\ncertain  ongoing  reporting and  monitoring  requirements  to retain the CSSWDP.\nDuring  construction,  if we fail to maintain  all  conditions  specified in the\nCSSWDP, the Construction Site Storm Water Pollution  Prevention Plan may need to\nbe revised or  changed.  This could  change or delay  construction,  which could\nsignificantly  increase our operating or capital  costs or otherwise  negatively\nimpact our ability to operate the Facility profitably.\n\n     We have obtained the required Storm Water  Discharge  Permit  (\"<U>SWDP</U>\") from\nthe IDNR.  This permit  requires two public  notices and  preparation of a Storm\nWater Pollution  Prevention Plan (\"<U>SWPPP</U>\").  The SWPPP outlines various measures\nwe plan to implement to prevent storm water pollution  during plant  operations.\n\n     <I>High Capacity Well Permit</i>\n\n     The Facility will not use municipal water,  gray sewage treatment water, or\nMissouri river water. We received a High Capacity Well Permit from Pottawattamie\nCounty,  Iowa  authorizing us to drill three new high capacity wells to meet our\nwater needs and which are now  complete.  These wells have been  completed as of\nSeptember 30, 2008. This permit allows us to draw to 2,000,000  gallons of water\na day through these wells, though the Facility is currently estimated to require\nonly  1,000,000  gallons  of  water  daily.  The  wells  have  been  tested  and\ncommissioned.  If the wells are not able to produce at the levels required, then\nalternatives  such as piping Missouri River water may be investigated.  The cost\nof alternative water supply sources could prohibit their use. If we are not able\nto obtain  the water in the  condition  and  amounts  needed  for the  Facility,\nadditional resources would need to be located.  This could delay the start up of\nthe Facility and significantly increase our operating or capital costs.\n\n     In addition to the High  Capacity  Well Permit,  we have received a Potable\nWater Permit from IDNR.  The Potable  Water  Permit  allows us to use one of our\nwells for potable water.  This potable water will be used for drinking,  toilets\nand safety showers.\n\n     <I>Alcohol and Tobacco Tax and Trade Bureau Requirements</i>\n\n     We have  complied  with the  applicable  Alcohol  and Tobacco Tax and Trade\nBureau  (formerly  the  Bureau  of  Alcohol,  Tobacco  and  Firearms)  (\"<u>ATTTB</u>\")\nregulations.  These  regulations  require that we first make application for and\nobtain an alcohol fuel producer's  permit,  which we have received.  The term of\nthe permit is indefinite until terminated, revoked or suspended. The permit also\nrequires  that we  maintain  certain  security  measures.  We have  secured  the\nrequired operations bond pursuant to 27 CFR sec. 19.957.\n\n     <I>Risk Management Plan</i>\n\n     Pursuant to the federal Clean Air Act,  stationary  sources with  processes\nthat  contain  more than a  threshold  quantity  of a  regulated  substance  are\nrequired to prepare and implement a Risk Management  Plan.  Since we plan to use\nanhydrous  ammonia,  we must  establish a plan to prevent spills or leaks of the\nammonia  and an  emergency  response  program  in the  event of  spills,  leaks,\nexplosions  or other events that may lead to the release of the ammonia into the\nsurrounding  area. The same  requirement may also be true for  denaturant.  This\ndetermination  will  be  made  as  soon  as the  exact  chemical  makeup  of the\ndenaturant is obtained.  We are required to conduct a hazardous\n\n                                       12\n\n</pre>\n<hr>\n<pre>\n\nassessment  and  prepare  models  to assess  the  impact  of an  ammonia  and/or\ndenaturant  release into the surrounding  area. The program will be presented at\none or more public meetings.  We have successfully  obtained our EPA air permit.\nIn  addition,  it is  likely  that we will have to  comply  with the  prevention\nrequirements under the Occupational Safety and Health  Administration's  Process\nSafety  Management  Standard,  which  are  similar  to the  Clean  Air Act  Risk\nManagement Plan requirements.  Once completed,  we will file our Risk Management\nPlan with the EPA. If any of the applicable  laws or  regulations  governing our\nRisk  Management  Plan  change,  it could delay the start up of our Facility and\nsignificantly increase our operating or capital costs.\n\n     <I>Above Ground Storage Tank Requirements</i>\n\n     We are  required  to obtain a permit from the State of Iowa in order to use\nour above ground  storage tank for storing  ethanol.  The state of Iowa may test\nour above ground  storage  tank prior to issuing the permit.  In addition to the\npermit, our above ground storage tank requires a Spill, Prevention,  Control and\nCountermeasure  Plan  (\"<u>SPCCP</u>\")  in  order  to  comply  with  the  EPA's  Spill,\nPrevention,  Control and Countermeasure Rule, which we have submitted. Our SPCCP\naddresses the likelihood and prevention of petroleum based substance  spills and\ndetail the  actions we will take in the event of any spill.  Within the  storage\ntank area,  we have a  containment  field  designed to retain any spillage for a\nminimum of 72 hours.\n\n     <I>Hazardous Waste Characterization Tool</i>\n\n     Under the Resource Conservation and Recovery Act, we may create and provide\nto the EPA a Hazardous  Waste  Characterization  Tool  (\"<u>HWCT</u>\").  The  Resources\nConservation  and Recovery Act covers the disposal of solid and hazardous waste.\nTypically,  ethanol plants generate such a small quantity of hazardous and solid\nwaste  that  they  are  classified  as a  Conditionally  Exempt  Small  Quantity\nGenerator.  This  classification  is entirely  dependent  on the amount of waste\ngenerated  and can change over time.  Although  not  required  by law,  the HWCT\nallows  us  to  document,  on a  monthly  basis,  that  we  still  qualify  as a\nConditionally  Exempt Small Quantity  Generator and therefore are not subject to\nhazardous  waste  regulations.  We have  purchased  a HWCT tool from ICM and are\nimplementing the required tracking and reporting procedures.\n\n     <I>Top Screen Analysis</i>\n\n     The  Department  of Homeland  Security  (\"<u>DHS</u>\")  requires any facility that\npossesses  certain  chemicals above a threshold to submit a Top Screen Analysis.\nWe will possess chemical subject to the Top Screen Analysis requirement and will\nbe required to complete the Top Screen  Analysis on an on-going  basis.  The Top\nScreen  Analysis  requires us to provide  information  such as the  chemicals we\nstore on site,  where the chemicals are stored,  and the risks  associated  with\nsuch  chemicals.  DHS requires us to complete the Top Screen  Analysis within 60\ndays of receiving any listed chemicals.\n\n     <I>Waste Reduction Plan</i>\n\n     We are  required  to submit  to IDNR and the Iowa  Department  of  Economic\nDevelopment (\"<u>IDED</u>\") a Waste Reduction Plan. The Waste Reduction Plan will focus\non the  identification  of waste  streams and how waste streams may be recycled.\nAll  companies  receiving  state funding must prepare and submit such a plan. We\nmust  submit a Waste  Reduction  Plan or we will be forced  to return  the state\nfunds we have received from the IDED, as discussed below.\n\n     <I>Historical Site Examination</i>\n\n     Prior to beginning construction, we conducted a complete review of the site\nfor the existence of historical sites,  including Indian burial grounds.  We did\nnot locate any such historical sites.\n\n                                       13\n\n</pre>\n<hr>\n<pre>\n\n     <I>Site Security Plan</i>\n\n     We are in the process of developing a Site Security Plan. The Site Security\nPlan  is  designed  to  enhance  the  security  of  hazardous   materials  being\ntransported to and from the Facility.  We have purchased a template for our Site\nSecurity Plan from ICM and we intend to complete the Site Security Plan prior to\nbeginning operations and shipping of ethanol.\n\n     <I>On-Going Activities and Reporting</i>\n\n     We are  required  to  provide  the  EPA  with  Tier II  Initial  Reporting,\ncontaining a report of the hazardous chemicals stored on-site, within 90 days of\ncommencing  operations.  The Tier II  Initial  Report is used to  provide  local\nemergency  response and fire  department  officials with a list of the hazardous\nmaterials we store on site. Thereafter, we will provide the EPA with annual Tier\nII reports of the hazardous  materials we store on site, which will similarly be\nused to inform local emergency  response and fire  department  officials of such\nhazardous substances. We have purchased a reporting package from ICM to complete\nthe required reporting.\n\n     We are also required to submit Form R, a Toxic Release Inventory report, to\nthe EPA. Form R is required for  facilities  processing or using certain  listed\nchemicals  above  a  regulated   quantity.   Our  annual  form  R  will  include\ndocumentation  of our release of those certain  chemicals  into the  environment\nwithin the previous year.\n\n     Every five years we will be  required  to submit a Form U Report  under the\nToxic Substances Control Act (\"<u>TSCA</u>\") to the EPA. In the Form U, we are required\nto  report  on  manufacturing  thresholds  that  were  exceeded  for  any of the\nchemicals listed in the TSCA during the reporting period.\n\n     Under the  Emergency  Planning  and Right to Know Act,  we are  required to\nreport  our  receipt of  certain  regulated  chemicals  to  community  and state\nofficials within 60 days. This act requires local emergency planning communities\nto prepare a comprehensive emergency response plan. The local emergency planning\nagencies  have  been  notified  and  are  collaborating  with us to  complete  a\ncomprehensive ERS plan.\n\n     As a  producer  of over  10,000  gallons of  ethanol  per year,  we will be\nrequired to comply with the RFS.  Under the RFS, we must  register with the EPA.\nIn  addition,   we  are  required  provide  the  EPA  with  our  Renewable  Fuel\nIdentification  Numbers,  product transfer documents and quarterly reports.  The\nRFS  requires  us to keep these  records for five years.  We have  obtained  our\nrenewable  identification  number  (\"RIN\")  registration  membership,   and  are\nprepared to comply with the RFS.\n\n     <I>Other Local Permits</i>\n\n     We have obtained the required  Septic System Permit from the  Pottawattamie\nCounty Health  Department,  a Zoning Permit from  Pottawattamie  County,  and an\nEntrance Permit from the Mills County Road Department.\n\n     <I>Nuisance</i>\n\n     Ethanol  production has been known to produce an odor to which  surrounding\nresidents  could object.  Ethanol  production may also increase dust in the area\ndue to operations  and the  transportation  of grain to the Facility and ethanol\nand  Distillers  Grains from the  Facility.  Such  activities  may subject us to\nnuisance,  trespass,  or  similar  claims by  employees  or  property  owners or\nresidents in the vicinity of the Facility. To help minimize the risk of nuisance\nclaims based on odors related to the production of ethanol and its  co-products,\nwe have  installed  a  reverse  thermal  oxidizer  and flare  technology  in the\nFacility.  Nonetheless, any such claims or increased costs to address complaints\nmay have a  material  adverse  effect on us, our  operations,  cash  flows,  and\nfinancial  performance.  It is  estimated  that this  equipment  will  involve a\nsignificant capital expenditure, which is included in the price we agreed to pay\nunder  the  ICM  Contract.  We are  not  currently  involved  in any  litigation\ninvolving  nuisance  claims.  If the  Facility  is  subject  to  any  litigation\nregarding odor or any other factors in the operations or the  transportation  of\nproducts,  this could  significantly  increase our operating or capital costs or\notherwise negatively impact our ability to operate the Facility profitably.\n\n                                       14\n\n</pre>\n<hr>\n<pre>\n\n     <I>Operational Safety Regulations</i>\n\n     We also will be  subject to federal  and state laws  regarding  operational\nsafety. Risks of substantial  compliance costs and liabilities are inherent in a\nlarge-scale  construction  project,  and in ethanol  production after a plant is\nconstructed.  Costs and  liabilities  related to worker  safety may be incurred.\nPossible  future  developments,  including  stricter  safety laws for workers or\nothers, regulations and enforcement policies and claims for personal or property\ndamages   resulting  from  our  construction  or  operation,   could  result  in\nsubstantial costs and liabilities.\n\n<b>Item 1A. Risk Factors.</b>\n\n<I>The  following  risks,  together with  additional  risks and  uncertainties  not\ncurrently  known to us or that we  currently  deem  immaterial  could impair our\nfinancial condition and results of operation.</i>\n\n<b><I>Risks Associated With Our Financing Plan</i></b>\n\n     <b><u>Our Units  have no public  trading  market and are  subject to  significant</u></b>\n     <b><u>transfer restrictions which could make it difficult to sell Units and could</u></b>\n     <b><u>reduce the value of the Units.</u></b>\n\n     We do not expect an active trading market for our limited liability company\ninterests,  or \"Units,\" to develop.  To maintain our partnership tax status, our\nUnits may not be publicly traded.  Within applicable tax regulations,  we intend\nto utilize a Qualified  Matching Service (\"<U>QMS</U>\") to provide limited liquidity to\nour  Members,  but we will not  apply  for  listing  of the  Units on any  stock\nexchange.  Finally,  applicable securities laws may restrict the transfer of our\nUnits. As a result, while a limited market for our Units may develop through the\nQMS,  Members  may not sell  Units  readily,  and use of the QMS is subject to a\nvariety  of  conditions  and  limitations.  The  transfer  of our  Units is also\nrestricted by our Second Amended and Restated Operating Agreement dated March 7,\n2008 (the \"<u>Operating Agreement</u>\"). Transfers without the approval of our Board of\nDirectors  (\"<u>Board</u>\") are not permitted and are invalid.  Furthermore,  the Board\nwill  not  approve  transfer  requests  which  would  cause  the  Company  to be\ncharacterized  as a publicly traded  partnership  under the regulations  adopted\nunder the Internal  Revenue Code of 1986, as amended (the \"<u>Code</u>\").  The value of\nour Units  will  likely  be lower  because  they are  illiquid.  Members  may be\nrequired to bear the economic risks  associated  with an investment in us for an\nindefinite period of time.\n\n     <b><u>Members  may not  receive  cash  distributions  which  could  result  in an</u></b>\n     <b><u>investor receiving little or no return on his or her investment.</u></b>\n\n     Distributions  are payable at the sole discretion of our Board,  subject to\nthe  provisions  of the Iowa  Limited  Liability  Company Act (the  \"<u>Act</u>\"),  our\nOperating  Agreement and the  requirements of our creditors.  We do not know the\namount of cash that we will generate,  if any, if and once we begin  operations.\nCash  distributions  are not assured,  and we may never be in a position to make\ndistributions.  Our  Board  may  elect  to  retain  future  profits  to  provide\noperational  financing  for the Facility,  debt  retirement  and possible  plant\nexpansion.  In  addition,  our loan  agreements  restrict  our  ability  to make\ndistributions.  This means that Members may receive little or no return on their\ninvestment  and may be unable to  liquidate  their  investment  due to  transfer\nrestrictions and lack of a public trading market.  This could result in the loss\nof a Member's entire investment.\n\n                                       15\n\n</pre>\n<hr>\n<pre>\n\n     <b><u>Our Units will be subordinate to our debts and other liabilities, resulting</u></b>\n     <b><u>in a greater risk of loss for investors.</u></b>\n\n     The Units are unsecured  equity  interests and are  subordinate in right of\npayment  to all our  current  and future  debt as  discussed  elsewhere  in this\nreport. In the event of our insolvency, liquidation dissolution or other winding\nup of our affairs, all of our debts, including winding-up expenses, must be paid\nin full before any payment is made to the holders of the Units.  In the event of\nour bankruptcy,  liquidation, or reorganization,  all Units will be paid ratably\nwith all of our other equity holders as provided under the Operating  Agreement,\nand there is no  assurance  that there  would be any  remaining  funds after the\npayment of all our debts for any  distribution  to Members.  In addition,  it is\npossible  that in order to replace the Bridge Loan  discussed  elsewhere in this\nreport,  we may have to issue additional  equity interests in the Company having\npreferential treatment in the event we liquidated or reorganized.\n\n     <U><b>Our failure to comply with our loan  covenants or raise  additional  equity</b></U>\n     <b><U>could require us to abandon our business</U>.</b>\n\n     In May 2007, we entered into the Credit  Agreement  with Lenders  providing\nfor a credit facility of up to $126,000,000  for the  construction and permanent\ndebt financing for our Facility.  As discussed in more detail below under Item 7\n-  Management's  Discussion  and Analysis of Financial  Condition and Results of\nOperation - Overview, Status and Recent Developments, in March, 2008, we amended\nthe terms of the Credit  Agreement and obtained the Bridge Loan  (together,  the\n\"<u>Current  Loans</u>\") from the Bridge Lender.  While we intend to obtain  additional\ndebt or issue additional  equity in order to replace the Bridge Loan, the Bridge\nLoan is due on March 1, 2009 and we may be unable to raise  additional  funds to\nretire the Bridge Loan. Any issuances of new equity to third parties will dilute\nthe interests of Unit holders, as will the issuance of additional units to Bunge\nand ICM, which will occur  automatically if we do not repay the Bridge Loan from\nother sources prior to March 1, 2009.\n\n     We believe  the  Current  Loans  should  provide  substantially  all of the\ncapital we will require to complete  construction  of our Facility , but we will\nlikely be required to issue additional equity (to replace the Bridge Loan or for\nworking capital if it were needed due to long-term negative  margins).  If we do\nutilize a debt instrument to retire the Bridge Loan or provide working  capital,\nadditional debt financing increases the risk that we will not be able to operate\nprofitably  because we will need to make principal and interest  payments on the\nindebtedness.  Debt  financing  also  exposes our Members to the risk that their\nentire  investment  could be lost in the event of a default on the  indebtedness\nand a foreclosure  and sale of the Facility and its assets for an amount that is\nless than the outstanding debt. Our ability to obtain additional debt financing,\nif required,  will be subject to approval of our lending group, which may not be\ngranted,  the  interest  rates and the  credit  environment  as well as  general\neconomic factors and other factors over which we have no control.\n\n     <b><u>Our Members will  experience  dilution of their equity and voting rights if</u></b>\n     <b><u>Bunge and ICM repay our Bridge Loan.</u></b>\n\n     As  discussed  in more detail under Item 7 -  Management's  Discussion  and\nAnalysis of Financial Condition and Results of Operation - Overview,  Status and\nRecent  Developments,  to the extent Bunge and/or ICM repay our Bridge Loan, the\nUnit Issuance Agreements provide that we must repay Bunge and/or ICM in the form\nof equity.  To the extent we issue additional units to Bunge and/or ICM in order\nto satisfy our reimbursement obligations under the Unit Issuance Agreements, the\nownership  interests  of the  Company's  Members  would be  diluted.  If (i) the\nmaximum principal amount of the Bridge Loan were drawn ($36,000,000), (ii) Bunge\nand ICM each made their respective  maximum Bridge Loan Payments,  and (iii) the\nCompany  did not  issue  any  equity to any other  party  (thereby  setting  the\nissuance price under the Unit Issuance  Agreements at $3,000 per Unit), then the\nCompany  would be  required  to issue  9,120  Series E Units to Bunge  and 2,880\nSeries C Units  to ICM.  Such  issuances  would  increase  the  Company's  total\noutstanding  Units from 13,139 to 25,139.  The dilutive effect of such issuances\non a Member  holding  100 Units  would be to  reduce  such  Member's  percentage\ninterest in the Company from 0.761% to 0.398%.  Furthermore,  as discussed under\nItem  13--Certain   Relationships   and  Related   Transactions,   and  Director\nIndependence, if we issue 9,120 Series E Units to Bunge, Bunge would be entitled\nto appoint an additional  two directors,  meaning Bunge would be able then to\nappoint a total of four directors and effectively control the Company's Board of\nDirectors,  in  addition  to certain  other  rights  granted  under the Series E\nIssuance Agreement.\n\n                                       16\n\n</pre>\n<hr>\n<pre>\n\n     <b><u>Our debt service  requirements  and  restrictive  loan covenants  limit our</u></b>\n     <b><u>ability to borrow more money,  make cash  distributions  to our Members and</u></b>\n     <b><u>engage in other activities.</u></b>\n\n     Under the Credit Agreement, the Bridge Loan and other debt instruments,  we\nhave made  certain  customary  representations  and we are subject to  customary\naffirmative  and negative  covenants,  including  restrictions on our ability to\nincur  additional  debt  that  is not  subordinated,  create  additional  liens,\ntransfer or dispose of assets, make  distributions,  make capital expenditure in\nexcess of  $1,000,000  (other than on the  Facility),  consolidate,  dissolve or\nmerge, and customary events of default  (including  payment  defaults,  covenant\ndefaults,   cross  defaults,   construction   related  defaults  and  bankruptcy\ndefaults).  The Current Loans also contain  financial  covenants  effective upon\ncompletion of the plant  including a minimum  working  capital  amount,  minimum\nreserves,  minimum current assets to current liabilities ratio, minimum tangible\nnet worth,  minimum tangible owner's equity, and a minimum fixed charge coverage\nratio. Our obligations to repay principal and interest on the Current Loans make\nus vulnerable to economic or market  downturns.  If we are unable to service our\ndebt, we may be forced to reduce or delay  planned  capital  expenditures,  sell\nassets,  restructure our indebtedness or seek additional  equity capital,  which\nwould dilute our Members' interests.  If we default on any covenant,  either the\nLenders or the Bridge  Lender (or any  subsequent  lender) could make the entire\ndebt, once incurred,  immediately due and payable.  If this occurs, we might not\nbe able to repay our debt or borrow  sufficient  funds to refinance  it. Even if\nnew  financing is available,  it may not be on terms that are  acceptable to us.\nThese  events  could  cause  us to cease  construction,  or if the  Facility  is\nconstructed and operating, to cease operations.\n\n<b><b>Risks Associated With Construction and Development</b></b>\n\n     <b><u>We depend on ICM and Bunge for  expertise  in beginning  operations  in the</u></b>\n     <b><u>ethanol industry and any loss of these  relationships  could cause us delay</u></b>\n     <b><u>and added expense, placing us at a competitive disadvantage.</u></b>\n\n     We will be  dependent  on our  relationships  with ICM and  Bunge and their\nemployees. As discussed elsewhere in this report, Bunge has agreed to provide us\nwith a wide  variety  of  critical  services.  Any loss of these  relationships,\nparticularly  during the construction and start-up period for the Facility,  may\nprevent us from commencing operations and result in the failure of our business.\nThe time and  expense of  locating  new  consultants,  contractors  or equity or\noperational partners would result in unforeseen expenses and delays.  Unforeseen\nexpenses and delays may reduce our ability to generate revenue and profitability\nand  significantly  damage  the  competitive  position  we expect to have in the\nethanol  industry such that Members could lose some or all of their  investment.\nWe have already  experienced delays in our construction  schedule because of our\nbudget shortfall.\n\n     We will also be  dependent  upon  ICM's  experience  and  ability  to train\npersonnel  in  operating  the  Facility.  If the  Facility is built and does not\noperate to the level anticipated by us in our business plan, we will rely on ICM\nto adequately  address such  deficiency.  There is no assurance that ICM will be\nable to address  such  deficiency  in an  acceptable  manner.  Their  failure to\naddress  deficiencies  could  cause  us to halt  or  discontinue  production  of\nethanol,  which could  damage our ability to  generate  revenues  and reduce the\nvalue of Units.\n\n     <b><u>We are dependent upon ICM to build the Facility.</u></b>\n\n     ICM will perform various services and provide certain  equipment  necessary\nfor the construction and operation of our ethanol production  Facility under the\nterms of the ICM Contract.  Upon seven days written notice, ICM has the right to\nstop work if we do not pay ICM  amounts  coming due that we have  certified  for\npayment.  Further,  ICM can  terminate  the ICM Contract upon seven days written\nnotice for any of the following reasons: (i) suspension of work for more than 90\ndays by us or by order of a court or other public authority, through no fault to\nICM or  (ii)  our  failure  to pay  ICM  undisputed  amounts  within  30 days of\nreceiving an application for payment.\n\n     Due to the  competitive  nature  of the  ethanol  industry  and the lack of\nqualified design and construction  firms available to build plants such as ours,\nICM's  refusal or  inability  to  perform  under the ICM  Contract  could have a\nmaterial adverse effect on our ability to complete  construction of our Facility\nand achieve profitability in the future.\n\n                                       17\n\n</pre>\n<hr>\n<pre>\n\n     <b><u>We may encounter  problems with the steam energy plant design,  which could</u></b>\n     <b><u>delay or prevent start-up of Facility operations or decrease our ability to</u></b>\n     <b><u>generate  profits  causing a  decrease  in the value of Units and  Members'</u></b>\n     <b><u>investment returns.</u></b>\n\n     The use of steam  directly  from a  coal-fired  public  utility  as a power\nsource for an  ethanol  plant is  largely  untested.  We are aware of only a few\nother ethanol  plants  currently  operating  with steam as their major source of\nenergy.  Because  our  plant is next to a  coal-fired  plant  and will use steam\ndirectly, we may be required to meet the same air quality standards as a utility\nplant  when  applying  for our air  permit.  Further,  it is  possible  that our\nemissions   will  exceed   expectations   and  that  the  Facility   will  incur\nsignificantly higher regulatory, permit, and compliance costs. Because this is a\nnew and largely  untested  energy  source,  it is possible that during the final\ndesign, construction, and initial start up phases of the project that additional\nand costly  engineering  and design  changes  may be  necessary  to meet  energy\nproduction, ethanol processing, and environmental requirements. This may lead to\na decrease in the value of our Units and Member investment returns.\n\n     <b><u>We are  dependent on Mid American  Energy  Company for our steam supply and</u></b>\n     <b><u>any  failure  by them  may  result  in a  decrease  in our  profits  or our</u></b>\n     <b><u>inability  to operate,  which may  decrease  the value of Units or Members'</u></b>\n     <b><u>investment return.</u></b>\n\n     Under the Steam  Contract,  MidAm will provide us with steam to operate our\nethanol  plant for ten years from the  earlier of our first grind or February 1,\n2009.  We expect to face  periodic  interruptions  in our steam supply under the\nSteam  Contract.  For this reason,  we have  executed a change order with ICM to\ninstall  boilers at the Facility to provide a backup  natural gas energy source.\nThe backup boiler system is anticipated to be operational by February,  2009. We\nalso have entered into a natural gas supply agreement with Constellation  Energy\nfor our long term natural gas needs,  but this does not assure  availability  at\nall times. As with natural gas and other energy sources, our steam supply can be\nsubject to  immediate  interruption  by weather,  strikes,  transportation,  and\nproduction problems that can cause supply  interruptions or shortages.  While we\nanticipate  utilizing  natural gas as a temporary heat source when MidAm's plant\nis down,  an extended  interruption  in the supply of both steam and natural gas\nbackup could cause us to halt or discontinue  our  production of ethanol,  which\nwould  damage our ability to generate  revenues.  A decrease in our revenues may\nlead to a decrease in the value of Units or Members' investment return.\n\n     <b><u>We may not be able to protect  ourselves  from an  increase in the price of</u></b>\n     <b><u>steam which may result in a decrease in profits,  causing a decrease in the</u></b>\n     <b><u>value of our Units and Members' investment return.</u></b>\n\n     We will be  significantly  dependent  on the  price  of  steam.  The  Steam\ncontract  will  last for ten  years as long as our  first  grind  occurs  before\nFebruary 1, 2009. The Steam Contract will fix the price of steam for three years\nand provide for price  increases  annually  thereafter.  The price increases are\nbased upon market forces over which we have no control.  We anticipate  that the\nSteam  Contract  will protect us from extreme  price changes for the term of the\nagreement. Upon the expiration of the Steam Contract, there is no assurance that\nwe will be able to enter into a similar  agreement  following the  expiration of\nthe Steam  Contract.  Although coal prices and supplies have  historically  been\nmore  stable  than  many  other  forms of  energy,  this  may not be taken  into\nconsideration  when we are  negotiating  a new steam  contract.  If higher steam\nprices are  sustained for some time,  such pricing may reduce our  profitability\ndue to higher  operating  costs.  This may cause a decrease  in the value of our\nUnits and Members' investment returns.\n\n     <b><u>We may  encounter  hazardous or unexpected  conditions at the  construction</u></b>\n     <b><u>site  that  could  increase  our  costs or delay  the  construction  of the</u></b>\n     <b><u>Facility,  which would delay our ability to generate  revenues and decrease</u></b>\n     <b><u>the value of Units or Members' investment return.</u></b>\n\n     Compliance  issues with applicable  environmental  standards could arise at\nany time during the  construction  and  operation of our  Facility.  We may have\ndifficulty obtaining the necessary  environmental permits required in connection\nwith the  operation  of the  Facility.  As a  condition  of  granting  necessary\npermits, regulators could make demands that result in additional costs to us and\ndelay our ability to generate revenues.\n\n                                       18\n\n</pre>\n<hr>\n<pre>\n\n     <b><u>The project could suffer  additional  delays or construction cost increases</u></b>\n     <b><u>that could  postpone  our  ability to  generate  revenues  and make it more</u></b>\n     <b><u>difficult  for us to pay our debts,  which could  decrease the value of our</u></b>\n     <b><u>Units or Members' investment return.</u></b>\n\n     We began  construction  in February  2007 and have  projected  that we will\nbegin  operation of the proposed  ethanol plant in the second  quarter of fiscal\n2009. We have already experienced  construction delays,  primarily the result of\ncost increases that caused us to have a budget  shortfall prior to obtaining the\nBridge  Loan.  As  of  September  30,  2008,  we  have  expended   approximately\n$161,000,000 on the project. Our anticipated total project cost has never been a\nfirm estimate and we expect that it will continue to change from time to time as\nconstruction  of the project  progresses.  The costs under the ICM  Contract are\nsubject to change.  The total amount we have to pay under the ICM Contract,  the\nT&amp;S Contract and HGM Contract may be further  increased due to design changes or\ncost  overruns,  which we have  already  experienced.  Any  further  significant\nincrease in the construction cost of the Facility or significant expense related\nto the  design  and  construction  of the steam  line may delay our  ability  to\ngenerate  revenues  and hence  reduce  the  value of our Units and the  Members'\ninvestment return.\n\n     Additionally,  construction  projects often experience  delays in obtaining\nconstruction  permits,  construction delays due to weather conditions,  or other\nevents. If it takes longer to obtain necessary permits or construct the Facility\nthan we currently  anticipate,  it would  further  delay our ability to generate\nrevenues and make it difficult for us to meet our debt service  obligations.  If\nwe encounter delays in obtaining the required permits, our expected construction\nschedule will also be delayed.  Delays and weather  conditions could result in a\ndelay of the date we become operational and begin to generate revenue.\n\n     <b><u>Defects in plant  construction  could result in devaluation of our Units if</u></b>\n     <b><u>our Facility does not produce ethanol and its co-products as anticipated.</u></b>\n\n     There is no assurance that defects in, materials and/or  workmanship in the\nFacility will not occur. Under the terms of the ICM Contract,  ICM warrants that\nthe plant will meet specified  performance criteria upon start-up,  and that the\nplant will be free from defects in workmanship and materials  respecting certain\nFacility  components.  Though the ICM Contract  requires ICM to correct  certain\ndefects in material or workmanship  during the time period  specified in the ICM\nContract,  material defects in material or workmanship may still occur which ICM\nis not obligated to remedy. Such defects could further delay the commencement of\noperations of the Facility,  or, if such defects are discovered after operations\nhave commenced, could cause us to halt or discontinue the Facility's operations.\nHalting or  discontinuing  the Facility's  operations could delay our ability to\ngenerate revenues and reduce the value of Units.\n\n     <b><u>ICM will continue to employ subcontractors for key parts of the Facility.</u></b>\n\n     The  failure  on  the  part  of  major   subcontractors  to  perform  in  a\nsatisfactory  manner can present risk that the Facility will not be  constructed\nas planned.  Failure on the part of ICM to  compensate  subcontractors  can also\npresent risk of claims or liens on plant assets.  These claims could result in a\nloss of the value of Units.\n\n     <b><u>The ICM Contract  does not protect us from  changing  prices for  concrete,</u></b>\n     <b><u>labor or other inputs.</u></b>\n\n     Material  ongoing price increases in key inputs used in the construction of\nour Facility could result in more capital  expenditures than have been forecast.\nIf this occurs, the return on Members' investment will be reduced,  resulting in\na decline in the value of Units.\n\n     <b><u>ICM does not provide formal guarantees or assurances  respecting our use of</u></b>\n     <b><u>steam heat technology at the Facility.</u></b>\n\n     Our use of  steam  at the  Facility  is a  unique  feature  which  is being\nconstructed on a design and build basis by ICM under the ICM Contract.  Although\nthe ICM  Contract  provides  that our plant  specifications  be met,  ICM cannot\nguarantee use of our steam source.\n\n                                       19\n\n</pre>\n<hr>\n<pre>\n\n     <b><u>Any site near a major waterway system presents potential for flooding risk.</u></b>\n\n     While our site is located in an area designated as above the 100-year flood\nplain,  our site exists  within an area at risk of a 500-year  flood.  While our\nsite is  protected by levee  systems,  its  existence  next to a major river and\nmajor  creeks  presents a risk that  flooding  could  occur at some point in the\nfuture. We have procured flood insurance as a means of risk mitigation; however,\nthere is a chance that such  insurance will not cover certain costs in excess of\nour  insurance  associated  with flood damage or loss of income,  during a flood\nperiod. Our current insurance may not be adequate to cover the losses that could\nbe incurred in a flood of a 500-year magnitude. Accordingly, floods could have a\nmaterial adverse impact upon Unit value.\n\n     <b><u>We may  experience  delays or  disruption in the operation of our rail line</u></b>\n     <b><u>and loop track, which may lead to decreased revenues.</u></b>\n\n     We have entered  into an agreement  with a third party to service our track\nand railroad cars, which we will be highly dependent on. There may be times when\nwe have to slow production at our ethanol plant due to our inability to ship all\nof the ethanol and Distillers Grains we expect to produce.  If we cannot operate\nour plant at full  capacity,  we may  experience  decreased  revenues  which may\naffect the profitability of the Facility.\n\n<b><I>Risks Associated With Our Formation and Operation</i></b>\n\n     <b><u>We have no operational  history and limited  working  capital,  which could</u></b>\n     <b><u>result in losses that will affect the value of Units or Members' investment</u></b>\n     <b><u>return.</u></b>\n\n     We were organized on March 28, 2005 and other than progressing  through the\ninitial stages of plant construction,  we have no operating history. Our Company\nis  currently  promotional  and remains in its  development  stages and plans to\nbecome  operational  in the  second  quarter  of fiscal  2009.  We  cannot  make\nrepresentations  about our future  profitable  operation or our future income or\nlosses.  If our  plans  prove to be  unsuccessful,  Members  will  lose all or a\nsubstantial part of their  investment.  There can be no assurance that the funds\nwe received in our prior equity offerings,  combined with debt we have obtained,\nmost of which will be spent on plant  construction,  will be sufficient to allow\nus to operate our plant  until  profits are  attained.  Furthermore,  we need to\nraise  additional  equity to replace the Bridge  Loan,  and we may need to raise\nequity to complete construction or commence operations if our costs increase.\n\n     <b><u>We have no  experience  in the  construction  and  operation  of an ethanol</u></b>\n     <b><u>plant,  our  Facility  was more  expensive  to build than  anticipated  and</u></b>\n     <b><u>operating  costs may be higher  than we expect,  which could  decrease  the</u></b>\n     <b><u>value of Units or Members' investment return.</u></b>\n\n     The Company has and the members of its Board of Directors have little to no\nexperience in the organization,  construction and operation of an ethanol plant,\nthe ethanol industry,  or in governance or operation of a public company. Due to\nthis lack of  experience,  and even  though we have  hired  management  which we\nbelieve is  qualified,  our Facility may cost more to construct and operate than\nwe currently  anticipate.  Further increased costs may decrease the value of our\nUnits and the opportunity for Members to receive a return on their investments.\n\n     <b><u>Our operation  costs could be higher than  anticipated,  which could reduce</u></b>\n     <b><u>our profits or create  losses,  which could  decrease the value of Units or</u></b>\n     <b><u>Members' investment return.</u></b>\n\n     We could experience cost increases  associated with the on-going  operation\nof the  Facility  caused by a variety of  factors,  many of which are beyond our\ncontrol.  Corn prices may  increase  and labor costs could  increase  over time,\nparticularly  if there is a shortage  of persons  with the skills  necessary  to\noperate the Facility.  The adequacy and cost of electric,  steam and natural gas\nutilities could also affect our operating costs. Changes in price, operation and\navailability of truck and rail  transportation may affect our profitability with\nrespect to the transportation of ethanol and Distillers Grains to our customers.\nIn addition, the operation of the Facility will be subject to ongoing compliance\nwith all applicable governmental regulations,  such as those governing pollution\ncontrol, ethanol production, grain purchasing and other matters. If any of these\nregulations were to change,  it could cost us\n\n                                       20\n\n</pre>\n<hr>\n<pre>\n\nsignificantly  more to comply  with  them.  We will be  subject  to all of these\nregulations whether or not the operation of the ethanol plant is profitable.\n\n     <b><u>If we cannot  retain  competent  personnel,  we may not be able to  operate</u></b>\n     <b><u>profitably,  which could decrease the value of Units or Members' investment</u></b>\n     <b><u>return.</u></b>\n\n     Though we believe we have employed  capable  management to date, we provide\nno  assurance  that we can manage the  start-up  of the project  effectively  or\nproperly staff our  operations.  Any failure to manage our start-up  effectively\ncould delay the commencement of Facility operations, and such delay is likely to\nfurther delay our ability to generate revenue and satisfy our debt  obligations,\nwhich may decrease the value of Units or negatively  affect Members'  investment\nreturn.\n\n     <b><u>Our lack of business diversification could result in the devaluation of our</u></b>\n     <b><u>Units if our revenues from our primary products decrease.</u></b>\n\n     Our  business  will  solely  consist  of  ethanol  and  Distillers   Grains\nproduction  and sales.  We will not have any other  lines of  business  or other\nsources of revenue if we are unable to complete the  construction  and operation\nof the  Facility.  Our lack of business  diversification  could cause Members to\nlose all or some of their  investment  if we are unable to generate  revenues by\nthe production and sales of ethanol and Distillers Grains since we do not expect\nto have any other lines of business or alternative revenue sources.\n\n     <b><u>We have a history of losses and may not ever operate profitably.</u></b>\n\n     From our  inception  on March 28,  2005  through  September  30,  2008,  we\nincurred an accumulated net loss of approximately  $3,417,000.  We will continue\nto  incur  significant  losses  until  we  complete  construction  and  commence\noperations of the Facility.  There is no assurance that we will be successful in\ncompleting  our  efforts to build and  operate  the  Facility.  Even if we begin\noperations at the ethanol  plant,  there is no assurance that we will be able to\noperate profitably.\n\n     <b><u>An  investment  in our Units may decline in value due to decisions  made by</u></b>\n     <b><u>our Board and Members'  only  recourse is to replace our  Directors,  which</u></b>\n     <b><u>could take several years.</u></b>\n\n     Our Board of Directors  may make poor  decisions  regarding  actions of the\nCompany,  which  may cause a  decrease  in the  value of  Units.  Our  Operating\nAgreement  provides that each member of the Board of Directors  will serve for a\nfour year term,  and in all cases  until a successor  is elected and  qualified.\nHolders of Series A Units (the  \"<u>Series A Members</u>\")  have the right to elect the\nbalance of the  Directors  not  elected  by the  holders of Series B or Series C\nMembers,  or Series E Members,  if we issue such Units  (presently  the Series A\nMembers  may elect  four  Directors);  however,  the terms of the  Directorships\nelected  by the  Series A Members  are  staggered  such  that only one  Series A\nDirector  may be  elected  each  year.  Staggering  the  terms  of the  Series A\nDirectors,  in addition to the rights of Bunge (the  \"<u>Series B Member</u>\")  and ICM\n(the \"<u>Series C Member</u>\") to elect certain Directorships, including Bunge's rights\nto elect  directorships in the event it is issued additional  Units,  means that\nSeries A Members could only change the control of the Company  through  electing\nall four Series A Directors, which would take four years. If our project suffers\nfurther delays due to financing or  construction or the Board of Directors makes\npoor  decisions,  the Series A Members' only recourse is to replace the Series A\ndirectors  through  elections at four successive annual meetings or an amendment\nto our Operating Agreement, which may be difficult to accomplish.\n\n     <b><u>Our  Operating  Agreement  contains  restrictions  on  Members'  rights  to</u></b>\n     <b><u>participate  in corporate  governance  of our  affairs,  which limits their</u></b>\n     <b><u>ability to influence management decisions.</u></b>\n\n     Our Operating  Agreement  provides that a Member or Members owning at least\n30 percent of the  outstanding  Units may call a special meeting of the Members.\nThis may make it  difficult  for  Members  to propose  changes to our  Operating\nAgreement without support from our Board of Directors. Our Directors are elected\nby the three  Series of Units  that have  been  issued to date:  presently,  the\nSeries A Members elect four Directors  (the \"<u>Series A Directors</u>\"),\n\n                                       21\n\n</pre>\n<hr>\n<pre>\n\nour Series B Member  elects two  Directors,  and our Series C Member  elects one\nDirector. The Series A Directors' terms of office are divided into four classes,\nwith each Director  serving a staggered  four-year term. In addition to Series A\nMembers only being able to elect four of our seven Directors, the classification\nof the Series A Directors  will make it more difficult for Members to change the\ncomposition of the Board because only one of the Directors can be elected at one\ntime. If a vacancy  develops in our Board of Directors for any reason other than\nremoval or  expiration  of a term,  the  remaining  Directors of the same Series\nwould fill it.\n\n     <b><u>Our Directors have other business and management responsibilities which may</u></b>\n     <b><u>cause conflicts of interest in the allocation of their time and services to</u></b>\n     <b><u>the Company.</u></b>\n\n     Since our project is  currently  managed  both by our  officers and to some\nextent by the Board of  Directors  (rather  than  completely  by a  professional\nmanagement  group),  the  devotion  of the  Directors'  time to the  project  is\ncritical.  However,  the Directors have other  management  responsibilities  and\nbusiness interests apart from our project. Most particularly,  our Directors who\nwere  nominated  by Bunge  and ICM have  duties  and  responsibilities  to those\ncompanies which may conflict with our interests.  As a result, our Directors may\nexperience  conflicts of interest in allocating  their time and services between\nus and their other business  responsibilities.  No formal  procedures  have been\nestablished to address or resolve these conflicts of interest.\n\n     <b><u>We may have conflicting  financial interests with Bunge and ICM which could</u></b>\n     <b><u>cause them to put their financial interests ahead of ours.</u></b>\n\n     ICM and Bunge advise our Directors  and have been,  and are expected to be,\ninvolved in  substantially  all material aspects of our financing and operations\nto date. We have entered into a number of material commercial  arrangements with\nBunge,  as  described  elsewhere  in this  report.  Consequently,  the terms and\nconditions  of our  agreements  with ICM and Bunge have not been  negotiated  at\narm's length.  Therefore,  these  arrangements  may not be as favorable to us as\ncould have been if obtained from unaffiliated third parties. Most of the cost of\nour project will be paid to ICM for the design and  construction  of our ethanol\nplant.  ICM may  experience  conflicts  of  interest  that  cause  it to put its\nfinancial interest in the design and construction of our plant ahead of our best\ninterests.  In addition,  because of the extensive roles that ICM and Bunge have\nin the  development,  construction  and  operation  of the  Facility,  it may be\ndifficult or impossible for us to enforce claims that we may have against ICM or\nBunge.  Such conflicts of interest may reduce our profitability and the value of\nthe Units and could result in reduced distributions to investors.\n\n     Bunge has  purchased  Series B Units and is  currently  the only  holder of\nSeries B Units. Under our Operating Agreement,  the Series B Member is currently\nentitled  to elect two  directors  without  any other  votes.  Additionally,  as\ndiscussed  in more  detail  below  under Item 7 -  Management's  Discussion  and\nAnalysis of Financial Condition and Results of Operation - Overview,  Status and\nRecent  Developments,  under the terms of the Series E Unit  Issuance  Agreement\nbetween the Company and Bunge,  Bunge may receive Series E Units. If such Series\nE Units are issued to Bunge, our Operating  Agreement  provides that Bunge, as a\nSeries E  Member,  would be  entitled,  without  any other  votes,  to elect one\nadditional  director  (to the extent that Bunge owns  between 21% and 29% of the\ntotal Units issued and outstanding; two additional directors (to the extent that\nBunge owns  between 30% and 39% of the total Units  issued and  outstanding)  or\nthree  additional  directors  (to the extent  that Bunge owns 40% or more of the\ntotal Units issued and  outstanding).  This may create conflicts of interest due\nto any such  Directors'  affiliation  with Bunge,  especially for Company action\ndirectly or indirectly affecting Bunge.\n\n     ICM has purchased Series C Units and is currently the only holder of Series\nC Units.  Additionally,  under the terms of the Series C Unit Issuance Agreement\nbetween the Company  and ICM,  ICM may  similarly  receive  additional  Series C\nUnits. Under our Operating  Agreement,  the Series C Member is entitled to elect\none  director  without any other votes.  Accordingly,  there may be conflicts of\ninterest resulting from any such director's affiliation with ICM, especially for\nCompany action directly or indirectly affecting ICM.\n\n     ICM,  Bunge and their  respective  affiliates  may also have  conflicts  of\ninterest  because  ICM,  Bunge  and their  respective  employees  or agents  are\ninvolved as owners,  creditors and in other capacities with other ethanol plants\nin the United  States.  We cannot require ICM or Bunge to devote their full time\nor attention to our  activities.  As a result,  ICM and / or Bunge may have,  or\ncome to have,  a conflict of interest in  allocating  personnel,  materials  and\nother resources to our Facility.\n\n                                       22\n\n</pre>\n<hr>\n<pre>\n\n     <b><u>From time to time, our Directors may serve in director or leadership  roles</u></b>\n     <b><u>with trade associations which could raise a conflict of interest.</u></b>\n\n     A number of our  Directors  have or continue to serve as directors of local\nand  state  agricultural  trade  organizations.  These  organizations  may adopt\npolicies,  or engage in political lobbying activities that are in opposition to,\nor that  conflict  with the  Company's  business  needs.  This may  require  the\nDirector to abstain from votes or discussion on certain Company-related business\nmatters.\n\n     <b><u>An elected official serves as a Director.</u></b>\n\n     State  Senator  Hubert  Houser  is  an  elected   official  who  represents\nconstituents  in  southwest  Iowa  and  he  currently  serves  on the  Board  of\nDirectors.  As an elected official,  he is obligated to serve the needs of those\nwhom he  represents,  and in so doing,  from time to time,  he may need to place\nthese needs ahead of our needs.  In  addition,  from time to time he may have to\nabstain from voting on Company  business issues that conflict with state policy,\nor formal positions that the Senator is taking that may be inconsistent with our\nbusiness  needs.  Conversely,  he may be precluded  from  assisting us in public\npolicy debate, lobbying efforts or in the interface of the Company with state or\nlocal government  agencies.  Senator Houser's brother is also currently a member\nof the Pottawattamie County Board of Supervisors.\n\n<b><I>Risks Associated With the Ethanol Industry</i></b>\n\n     <b><U>There  have been  increasing  questions  about  the  viability  of  ethanol</U>\n     <U>producers</U>.</b>\n\n     The recent  bankruptcy  filing of one of the industry's major producers has\nresulted in great  economic  uncertainty  about the  viability  of ethanol.  The\nethanol  boom of  recent  years  spurred  overcapacity  in the  industry  and is\ncurrently  nearing the RFS mandates.  The average  national  ethanol spot market\nprice has plunged  over 30% since May 2008.  The drop in crude oil prices from a\nrecord $150 a barrel to its recent  price of less than $40 a barrel has resulted\nin the price of  reformulated  gasoline blendstock for oxygen blending  (\"<U>RBOB</U>\")\ndropping  below $1 per  gallon  in  December  2008.  With  ethanol  spot  prices\nexceeding  RBOB prices,  the economic  incentives for blenders to continue using\nethanol  has  become  less  advantageous.  This  could  result in a  significant\nreduction in the demand for ethanol.\n\n     The recent bankruptcy filings of several biofuel producers have resulted in\na  significant  reduction in the market  price per share of the  publicly-traded\ncompanies.  This has created opportunities for investors to buy operating plants\nfor a significantly reduced price per share. These recent filings and the recent\npublicity of the food versus fuel  controversy have given the ethanol industry a\nnegative image as a viable alternative to foreign oil in many Americans' eyes.\n\n     <b><u>Once operational,  we will compete with larger,  better financed  entities,</u></b>\n     <b><u>which could negatively impact our ability to operate profitably.</u></b>\n\n     There is  significant  competition  among ethanol  producers  with numerous\nproducers and privately  owned ethanol plants  planned and operating  throughout\nthe Midwest and elsewhere in the United States. Our business faces a competitive\nchallenge  from  larger  plants,  from  plants that can produce a wider range of\nproducts  than we can,  and from other  plants  similar to ours.  Large  ethanol\nproducers such as Abengoa  Bioenergy  Corp.,  Archer Daniels  Midland,  Aventine\nRenewable Energy,  Inc.,  Cargill,  Inc. and New Energy Corp., among others, are\ncapable of producing a significantly greater amount of ethanol than we expect to\nproduce. In addition,  there are several Nebraska,  Iowa, Minnesota,  Wisconsin,\nSouth Dakota and other Midwest  regional  ethanol  producers which have recently\nformed, are in the process of forming, or are under consideration,  which are or\nwould be of a similar  size and have similar  resources to us.  According to the\nRenewable Fuels Association,  there are currently 55 operational  ethanol plants\nin Iowa and  Nebraska  with  several  new  plants  in the  process  of  forming.\nFurthermore,  ethanol from certain  Central  American or Caribbean  countries is\neligible for tariff  reduction or  elimination  upon  importation  to the United\nStates.  Ethanol  imported from these  Caribbean  Basin  countries may be a less\nexpensive alternative to domestically produced ethanol.\n\n                                       23\n\n</pre>\n<hr>\n<pre>\n\n     This  competition  also  means  that the  supply of  domestically  produced\nethanol is at an  all-time  high.  As of October  2008,  there were 176  ethanol\nplants in operation  nationwide  with a capacity to produce  nearly 10.7 billion\ngallons of ethanol  annually.  Another  27 new  plants and five  expansions  are\ncurrently under construction nationally,  which will add an additional estimated\n2.9 billion gallons of annual  production  capacity.  Iowa alone is estimated to\nproduce  approximately  2.76 billion gallons of ethanol in 2008. Excess capacity\nin the ethanol  industry  will have an adverse  impact on our  operations,  cash\nflows and general financial conditions.  If the demand for ethanol does not grow\nat the same pace as  increases  in  supply,  the price of  ethanol  will  likely\ndecline. If excess capacity in the ethanol industry continues,  the market price\nof ethanol may  continue to decline to levels  that are  inadequate  to generate\nsufficient cash flow to cover our costs. This could negatively impact our future\nprofitability  and  decrease  the  value of our Units  and  Members'  investment\nreturn.\n\n     <b><u>Changes in the supply,  demand,  production and price of corn could make it</u></b>\n     <b><u>more expensive to produce ethanol, which could decrease our profits.</u></b>\n\n     Our  ethanol  production  will  require  substantial  amounts  of  corn.  A\nsignificant  reduction in the quantity of corn harvested due to adverse  weather\nconditions,  farmer  planting  decisions,  domestic and foreign  government farm\nprograms and policies, global demand and supply or other factors could result in\nincreased  corn costs which would increase our cost to produce  ethanol.  Events\nthat tend to negatively  impact the supply of corn are likely to increase prices\nand affect our  operating  results.  The record  high of corn  prices  this past\nspring has resulted in lower profit margins for the  production of ethanol,  and\nmarket  conditions  generally do not allow us to pass along increased corn costs\nto our  customers.  If the demand for corn returned to the levels of spring 2008\nand drove corn  prices  significantly  higher we may not be able to acquire  the\ncorn needed to continue operations.\n\n     We entered into the Supply  Agreement  with AB, an entity  affiliated  with\nBunge.  Under the Supply Agreement,  AB has agreed to provide us with all of the\ncorn we need to operate our ethanol  plant,  and we have agreed to only purchase\ncorn from AB. AB will provide  grain  originators  who will work at the Facility\nfor purposes of fulfilling its obligations under the Supply Agreement.  The term\nof the Supply  Agreement  is ten years,  subject  to  earlier  termination  upon\nspecified  events.  The Supply  Agreement  suspends the  operation of the Agency\nAgreement  between us and AB. In the event we obtain a grain  dealer's  license,\nsubject to  certain  procedures  specified  in the  Supply  Agreement,  then the\noperation of the Supply  Agreement will terminate and the Agency  Agreement will\nbe reinstated.  In the ordinary  course of business,  we anticipate that once we\nare operational, we will enter into forward purchase contracts for our commodity\npurchases.\n\n     The  price  of  corn  has  fluctuated  significantly  in the  past  and may\nfluctuate significantly in the future. We cannot provide assurances that we will\nbe able to offset any increase in the price of corn by  increasing  the price of\nour  products.  Any  reduction  in the spread  between  ethanol and corn prices,\nwhether as a result of further increase in corn price or an additional  decrease\nin ethanol prices,  may adversely affect our results of operations and financial\nconditions,  leading to a decrease in the value of Units and Members' investment\nreturn.\n\n     <b><u>We have executed output contracts for the purchase of all of the ethanol we</u></b>\n     <b><u>produce once  operational,  which may result in lower  revenues  because of</u></b>\n     <b><u>decreased marketing flexibility and inability to capitalize on temporary or</u></b>\n     <b><u>regional price disparities, and could reduce the value of Units or Members'</u></b>\n     <b><u>investment return.</u></b>\n\n     We  executed  the Lansing  Agreement,  which  provides  that  Lansing  will\npurchase  the  entire  output of our  ethanol  for the  first six  months of our\noperations.  We also agreed to allow Lansing to store up to 2.8 million  gallons\nof ethanol at the Facility at any time at no cost to Lansing.  Thereafter, Bunge\nwill be the exclusive purchaser of our ethanol pursuant to the Ethanol Agreement\nwith  them.  Bunge will  market our  ethanol  in  national,  regional  and local\nmarkets.  We do not plan to build our own sales force or sales  organization  to\nsupport the sale of ethanol.  As a result,  we will be  dependent on Lansing and\nthen Bunge to sell our principal  product.  When there are temporary or regional\ndisparities in ethanol market prices, it could be more financially  advantageous\nto have the flexibility to sell ethanol  ourselves  through our own sales force.\nWe have  decided not to pursue this route.  Our  strategy  could result in lower\nrevenues  and reduce the value of Units if Lansing or Bunge do not perform as we\nplan.\n\n                                       24\n\n</pre>\n<hr>\n<pre>\n\n     <b><u>Low ethanol prices and low gasoline prices could reduce our profitability.</u></b>\n\n     Prices for ethanol products can vary  significantly over time and decreases\nin price levels could  adversely  affect our  profitability  and viability.  The\nprice for ethanol has some  relation to the price for oil and  gasoline  but has\nnot  increased as much as the 2008  increases in oil and  gasoline  prices.  The\nprice of ethanol tends to increase as the price of gasoline  increases,  and the\nprice of ethanol tends to decrease as the price of gasoline decreases,  although\nthis may not always be the case.  Any  lowering of  gasoline  prices will likely\nalso lead to lower  prices  for  ethanol  and  adversely  affect  our  operating\nresults. The total production of ethanol is at an all-time high and continues to\nexpand at this time.  Further increased  production of ethanol may lead to lower\nprices.  Any downward  change in the price of ethanol may decrease our prospects\nfor  profitability  and thus the  value of our  Units  and  Members'  investment\nreturn.\n\n     <b><u>Increases  in the  production  of ethanol  could result in lower prices for</u></b>\n     <b><u>ethanol  and  have  other   adverse   effects   which   could   reduce  our</u></b>\n     <b><u>profitability.</u></b>\n\n     We expect that new fuel grade ethanol plants will be  constructed,  because\nof the increase in ethanol demand  resulting from the 2005 Act and the 2007 Act,\nwhich  mandate  an  increase  in the  use of  renewable  fuels  in the  U.S.  to\napproximately   15,200,000,000  gallons  per  year  by  2012  and  approximately\n36,000,000,000  gallons per year by 2022. Because increased  production capacity\nis usually  less costly to achieve  through  expansion  of existing  plants,  we\nexpect expansion will also occur.  The increased  production of ethanol may lead\nto lower prices for ethanol.  The  increased  production  of ethanol  could have\nother adverse effects as well. For example,  the increased  production will also\nlead to increased  supplies of co-products from the production of ethanol,  such\nas Distillers  Grains.  Those increased  supplies could lead to lower prices for\nthis co-product.\n\n     <b><u>There is scientific  disagreement about the wisdom of policies  encouraging</u></b>\n     <b><u>ethanol production,  which could result in changes in governmental policies</u></b>\n     <b><u>concerning ethanol and reduce our profitability.</u></b>\n\n     Some studies have challenged  whether  ethanol is an appropriate  source of\nfuel and fuel additives, because of concerns about energy efficiency,  potential\nhealth effects,  cost and impact on air quality.  Federal energy policy,  as set\nforth in the  2005  Act and the 2007  Act,  supports  ethanol  production.  If a\nscientific  consensus  develops  that  ethanol  production  does not enhance our\noverall  energy  policy,  our  ability to produce  and market  ethanol  could be\nmaterially and adversely affected.\n\n     <b><u>Hedging  transactions,  which, if used,  would be intended to stabilize our</u></b>\n     <b><u>corn  costs,   also   involve   risks  and  costs  that  could  reduce  our</u></b>\n     <b><u>profitability.</u></b>\n\n     In an attempt to minimize  the effects of the  volatility  of corn costs on\noperating  profits,  we may take hedging  positions in corn futures markets once\noperational,   provided  we  have  sufficient  working  capital.  Hedging  means\nprotecting  the  price at which we buy corn and the  price at which we will sell\nour products in the future.  It is a way to attempt to reduce the risk caused by\nprice  fluctuation.  The effectiveness of hedging  activities is dependent upon,\namong other things,  the cost of corn and our ability to sell sufficient amounts\nof  ethanol  and  Distillers  Grains to utilize  all of the corn  subject to the\nfutures  contracts.   Hedging  activities  result  in  costs  such  as  brokers'\ncommissions and other transaction costs. If there are significant swings in corn\nprices,  or if we purchase more corn for future delivery than we can use, we may\nhave to pay to terminate a futures  contract,  or resell unneeded corn inventory\nat a loss.\n\n     <b><u>Ethanol  production is energy intensive and  interruptions in our supply of</u></b>\n     <b><u>energy,  or  volatility  in energy  prices,  could have a material  adverse</u></b>\n     <b><u>impact on our business.</u></b>\n\n     Ethanol production  requires a constant and consistent supply of energy. If\nour  production  is  halted  for any  extended  period  of time,  it will have a\nmaterial adverse effect on our business.  If we were to suffer  interruptions in\nour energy supply,  either during  construction  or after we begin operating the\nethanol  plant,  our  business  would be harmed.  We have entered into the Steam\nContract for our primary energy source. In addition, natural gas and electricity\nprices have  historically  fluctuated  significantly.  Increases in the price of\nsteam,  natural gas or  electricity\n\n                                       25\n\n</pre>\n<hr>\n<pre>\n\nwould harm our business by increasing our energy costs. The prices which we will\nbe required to pay for these  energy  sources  will have a direct  impact on our\ncosts of producing ethanol and our financial results.\n\n     <b><u>Our ability to successfully operate depends on the availability of water at</u></b>\n     <b><u>anticipated prices.</u></b>\n\n     To produce ethanol,  we will need a significant  supply of water, and water\nsupply and quality are important  requirements  to operate an ethanol plant.  We\nanticipate  that our water  requirements  for the plant will be  supplied by our\nwells. However, there are no assurances that we will have a sufficient supply of\nwater to sustain the Facility in the future, or that we can obtain the necessary\npermits to obtain water  directly from the Missouri  River as an  alternative to\nour wells. As a result, our ability to make a profit may decline.\n\n     <b><u>We have no current  plan to sell the raw carbon  dioxide we  anticipate  we</u></b>\n     <b><u>will  produce  to a  third  party  processor  resulting  in the  loss  of a</u></b>\n     <b><u>potential source of revenue.</u></b>\n\n     At this  time,  we have no  agreement  to sell the raw  carbon  dioxide  we\nanticipate we will produce.  We cannot provide any assurances  that we will sell\nour raw  carbon  dioxide at any time in the  future.  If we do not enter into an\nagreement to sell our raw carbon dioxide,  we will have to emit it into the air.\nThis will result in the loss of a potential source of revenue.\n\n     <b><u>Changes and advances in ethanol  production  technology could require us to</u></b>\n     <b><u>incur costs to update our Facility or could otherwise hinder our ability to</u></b>\n     <b><u>complete in the ethanol industry or operate profitably.</u></b>\n\n     Advances and changes in the  technology of ethanol  production are expected\nto occur. Such advances and changes may make the ethanol  production  technology\ninstalled in our plant less  desirable or obsolete.  These  advances  could also\nallow our  competitors  to  produce  ethanol  at a lower cost than us. If we are\nunable to adopt or incorporate  technological  advances,  our ethanol production\nmethods and processes could be less efficient than our competitors,  which could\ncause  our  plant  to  become  uncompetitive  or  completely  obsolete.  If  our\ncompetitors  develop,  obtain or license  technology that is superior to ours or\nthat makes our  technology  obsolete,  we may be required  to incur  significant\ncosts to  enhance or  acquire  new  technology  so that our  ethanol  production\nremains  competitive.  Alternatively,  we may be  required  to seek  third-party\nlicenses,  which  could  also  result  in  significant  expenditures.  We cannot\nguarantee  or assure  that  third-party  licenses  will be  available  or,  once\nobtained,  will continue to be available on commercially reasonable terms, if at\nall. These costs could negatively impact our financial performance by increasing\nour operating  costs and reducing our net income,  all of which could reduce the\nvalue of Members' investment.\n\n     <b><u>Competition from the advancement of alternative fuels may lessen the demand</u></b>\n     <b><u>for ethanol and negatively impact our profitability, which could reduce the</u></b>\n     <b><u>value of Members' investment.</u></b>\n\n     Alternative fuels,  gasoline  oxygenates and ethanol production methods are\ncontinually  under  development.  A number of  automotive,  industrial and power\ngeneration  manufacturers  are developing  alternative clean power systems using\nfuel cells or clean burning gaseous fuels. Like ethanol,  the emerging fuel cell\nindustry offers a technological  option to address  increasing  worldwide energy\ncosts,  the  long-term  availability  of petroleum  reserves  and  environmental\nconcerns. Fuel cells have emerged as a potential alternative to certain existing\npower  sources  because  of their  higher  efficiency,  reduced  noise and lower\nemissions.   Fuel  cell  industry   participants  are  currently  targeting  the\ntransportation, stationary power and portable power markets in order to decrease\nfuel costs, lessen dependence on crude oil and reduce harmful emissions.  If the\nfuel cell and hydrogen  industries continue to expand and gain broad acceptance,\nand hydrogen  becomes  readily  available to consumers for motor vehicle use, we\nmay not be able to compete effectively. This additional competition could reduce\nthe demand for ethanol, which would negatively impact our profitability, causing\na reduction in the value of Members' investment.\n\n                                       26\n\n</pre>\n<hr>\n<pre>\n\n     <b><u>Corn-based ethanol may compete with cellulose-based  ethanol in the future,</u></b>\n     <b><u>which  could  make  it  more  difficult  for  us to  produce  ethanol  on a</u></b>\n     <b><u>cost-effective basis and could reduce the value of Members' investment.</u></b>\n\n\n     Most ethanol is currently produced from corn and other raw grains,  such as\nmilo or  sorghum -  especially  in the  Midwest.  The  current  trend in ethanol\nproduction  research is to develop an efficient method of producing ethanol from\ncellulose-based  biomass, such as agricultural waste, forest residue,  municipal\nsolid  waste,  and  energy  crops.  This  trend  is  driven  by  the  fact  that\ncellulose-based  biomass is generally  cheaper than corn, and producing  ethanol\nfrom  cellulose-based  biomass would create  opportunities to produce ethanol in\nareas  which  are  unable  to grow  corn.  Although  current  technology  is not\nsufficiently efficient to be competitive,  a report dated August 25, 2000 by the\nU.S.  Department of Energy entitled \"Outlook for Biomass Ethanol  Production and\nDemand\"  indicated  that new  conversion  technologies  may be  developed in the\nfuture. If an efficient method of producing ethanol from cellulose-based biomass\nis developed,  we may not be able to compete  effectively.  We do not believe it\nwill be  cost-effective  to convert  our  Facility  into a plant  which will use\ncellulose-based  biomass to produce ethanol. If we are unable to produce ethanol\nas  cost-effectively  as  cellulose-based  producers,  our  ability to  generate\nrevenue will be negatively impacted and Members' investment could lose value.\n\n     <b><u>Competition  from ethanol  imported from Caribbean basin countries may be a</u></b>\n     <b><u>less  expensive  alternative  to our ethanol,  which would cause us to lose</u></b>\n     <b><u>market share and reduce the value of Members' investment.</u></b>\n\n     Ethanol  produced or processed in certain  countries in Central America and\nthe  Caribbean  region is eligible  for tariff  reduction  or  elimination  upon\nimportation  to the United States under a program  known as the Caribbean  Basin\nInitiative. Large ethanol producers, such as Cargill, have expressed interest in\nbuilding dehydration plants in participating Caribbean Basin countries,  such as\nEl Salvador, which would convert ethanol into fuel-grade ethanol for shipment to\nthe United States. Ethanol imported from Caribbean Basin countries may be a less\nexpensive alternative to domestically produced ethanol. Competition from ethanol\nimported  from  Caribbean  Basin  countries  may affect our  ability to sell our\nethanol profitably, which would reduce the value of Members' investment.\n\n     <b><u>Competition  from  ethanol  imported  from  Brazil may be a less  expensive</u></b>\n     <b><u>alternative  to our ethanol,  which would cause us to lose market share and</u></b>\n     <b><u>reduce the value of Members' investment.</u></b>\n\n     Brazil is currently the world's  largest  producer and exporter of ethanol.\nIn Brazil,  ethanol is produced primarily from sugarcane,  which is also used to\nproduce  food-grade sugar.  Ethanol imported from Brazil may be a less expensive\nalternative to domestically produced ethanol, which is primarily made from corn.\nTariffs   presently   protecting  U.S.  ethanol  producers  may  be  reduced  or\neliminated. Competition from ethanol imported from Brazil may affect our ability\nto sell our  ethanol  profitably,  which  would  reduce  the  value of  Members'\ninvestment.\n\n<b><I>Risks Associated With Government Regulation and Subsidization</i></b>\n\n     <b><u>Federal regulations  concerning tax incentives could expire or change which</u></b>\n     <b><u>could reduce our revenues.</u></b>\n\n     The federal government presently encourages ethanol production by taxing it\nat a lower rate which will indirectly benefit us. The VEETC currently equates to\na $.51 per gallon  subsidy of ethanol which is available to  distributors.  Some\nstates and cities provide additional  incentives.  The 2005 Act and the 2007 Act\neffectively mandate increases in the amount of annual ethanol consumption in the\nUnited States. The result is that the ethanol  industry's  economic structure is\nhighly  dependent  on  governmental  policies.  Although  current  policies  are\nfavorable factors,  any major change in federal policy,  including a decrease in\nethanol  production  incentives,  would have significant  adverse effects on our\nproposed plan of operations  and might make it impossible  for us to continue in\nthe ethanol business. Under provisions of the 2008 Farm Bill, the exemption will\ndrop to $.45 per gallon in 2009.\n\n     <b><u>Nebraska state producer  incentives are  unavailable to us, which places us</u></b>\n     <b><u>at a competitive disadvantage.</u></b>\n\n     Neighboring states such as Nebraska have historically  provided  incentives\nto ethanol producers, and may do so in the future.  Presently, we do not qualify\nfor any state-granted  incentives. To the extent that neighboring states\n\n                                       27\n\n</pre>\n<hr>\n<pre>\n\nprovide  economic  incentives  to our  competitors,  our ability to  effectively\ncompete with such recipients will be reduced.\n\n     <b><u>We are subject to extensive environmental regulation and operational safety</u></b>\n     <b><u>regulations that impact our expenses and could reduce our profitability.</u></b>\n\n     Ethanol  production  involves the emission of various airborne  pollutants,\nincluding  particulate matters,  carbon monoxide,  oxides of nitrogen,  volatile\norganic  compounds  and sulfur  dioxide.  We will be subject to  regulations  on\nemissions  from  the  EPA and the  IDNR.  The  EPA's  and  IDNR's  environmental\nregulations  are subject to change and often such  changes are not  favorable to\nindustry.  Consequently,  even if we have  the  proper  permits  now,  we may be\nrequired  to invest  or spend  considerable  resources  to  comply  with  future\nenvironmental regulations.\n\n     Our  failure  to  comply  or the  need to  respond  to  threatened  actions\ninvolving  environmental laws and regulations may adversely affect our business,\noperating  results  or  financial  condition.  Once our  ethanol  plant  becomes\noperational  and as our  business  grows,  we will have to  develop  and  follow\nprocedures for the proper  handling,  storage,  and  transportation  of finished\nproducts and materials  used in the  production  process and for the disposal of\nwaste products.  In addition,  state or local requirements may also restrict our\nproduction and  distribution  operations.  We could incur  significant  costs to\ncomply with  applicable  laws and  regulations  as production  and  distribution\nactivity  increases.  Protection  of the  environment  will  require us to incur\nexpenditures for equipment or processes.\n\n     We  could be  subject  to  environmental  nuisance  or  related  claims  by\nemployees,  property  owners or residents near the Facility  arising from air or\nwater discharges.  Ethanol production has been known to produce an odor to which\nsurrounding  residents could object. We believe our plant design should mitigate\nmost odor objections.  However,  if odors become a problem, we may be subject to\nfines  and  could be  forced to take  costly  curative  measures.  Environmental\nlitigation  or  increased  environmental  compliance  costs could  significantly\nincrease our operating costs.\n\n     We will be subject to federal and state laws regarding  operational safety.\nRisks  of  substantial  compliance  costs  and  liabilities  are  inherent  in a\nlarge-scale  construction  project,  and in ethanol  production after a plant is\nconstructed.  Costs and  liabilities  related to worker  safety may be incurred.\nPossible  future  developments-including  stricter  safety  laws for  workers or\nothers, regulations and enforcement policies and claims for personal or property\ndamages resulting from our construction or operation could result in substantial\ncosts  and  liabilities  that  could  reduce  the  amount  of cash that we would\notherwise have to distribute to Members or use to further enhance our business.\n\n     <b><u>Carbon  dioxide  may be  regulated  by the  EPA  in  the  future  as an air</u></b>\n     <b><u>pollutant, requiring us to obtain additional permits and install additional</u></b>\n     <b><u>environmental   mitigation  equipment,   which  may  adversely  affect  our</u></b>\n     <b><u>financial performance.</u></b>\n\n     Our  Facility  will emit  carbon  dioxide as a  by-product  of the  ethanol\nproduction  process.  The United  States  Supreme  Court has  classified  carbon\ndioxide as an air pollutant under the Clean Air Act in a case seeking to require\nthe EPA to regulate carbon dioxide in vehicle  emissions.  Similar lawsuits have\nbeen filed seeking to require the EPA to regulate carbon dioxide  emissions from\nstationary  sources  such as our  ethanol  plant  under the Clean Air Act.  Once\noperational,  our Facility will produce a significant  amount of carbon  dioxide\nthat  will  be  vented  into  the  atmosphere.  While  there  are  currently  no\nregulations  applicable to us concerning carbon dioxide,  if Iowa or the federal\ngovernment,  or any  appropriate  agency,  decides to  regulate  carbon  dioxide\nemissions by plants such as ours, we may have to apply for additional permits or\nwe may be required to install carbon dioxide mitigation  equipment or take other\nsteps unknown to us at this time in order to comply with such law or regulation.\nCompliance  with future  regulation of carbon  dioxide,  if it occurs,  could be\ncostly and may prevent us from  operating  the  Facility  profitably,  which may\ndecrease the value of our Units and Members' investment return.\n\n                                       28\n\n</pre>\n<hr>\n<pre>\n\n     <b><u>Our site borders nesting areas used by endangered bird species, which could</u></b>\n     <b><u>impact our ability to successfully  acquire operating permits. The presence</u></b>\n     <b><u>of these species,  or future shifts in its nesting areas,  could  adversely</u></b>\n     <b><u>impact construction activities or future operating performance.</u></b>\n\n     The Piping Plover (Charadrius  melodus) and Least Term (Sterna  antillarum)\nuse the fly ash ponds of the  existing  MidAm  power  plant  for  their  nesting\ngrounds. The birds are listed on the state and federal threatened and endangered\nspecies  lists.  Representatives  of the  IDNR  have  determined  that  our rail\nconstruction  will not interfere with the birds' nesting patterns and behaviors,\nbased upon current  observations made during the construction of the neighboring\nCB4 power plant.  However,  it was necessary  for us to modify our  construction\nschedules and plant site design to accommodate  the birds'  patterns.  We cannot\nforesee or predict the birds' future behaviors or status. As such, we cannot say\nwith  certainty  that  endangered  species  related issues will not arise in the\nfuture that could negatively effect the plant's operations,  or the valuation of\nUnits.\n\n     <b><u>We may encounter or discover unforeseen  environmental  contaminants at our</u></b>\n     <b><u>site.</u></b>\n\n     We completed a Phase One environmental  survey to determine the presence of\nhazardous waste on the Facility site. While we believe the historical use of our\nsite has primarily been bare farmland,  a Phase Two environmental study (to test\nfor the presence of any contaminants that may have permeated the ground water or\nleached into the soil as a consequence of any prior disposal or improper storage\nby prior  occupants or  neighboring  businesses)  was  performed  and updated in\nconnection with the closing of our 2006 equity offering.  In the future,  should\nsuch  contaminants  or hazards be  discovered,  we may be unable to utilize  the\nFacility  site as we  intend  or we may incur  costs  for  cleanup  that are not\nreflected in our  forecasted  sources and uses of funds  discussed  elsewhere in\nthis report.\n\n     <b><u>We may encounter  unforeseen  negative public sentiment of nearby residents</u></b>\n     <b><u>who are opposed to the prospects of additional  manufacturing businesses in</u></b>\n     <b><u>the area.</u></b>\n\n     While we do not expect that the ethanol plant will produce air emissions or\nwaste water that would  negatively  impact the nearby  residential  communities,\noccupants of those  communities may choose to express negative  sentiment toward\nthe  addition  of another  major  manufacturing  plant in the  community  due to\nmisperceptions about the plant's expected  environmental  impact. Such reactions\ncould influence local zoning rules, impede construction, or result in unforeseen\ncosts related to education,  legal defense,  permitting, and other factors which\ncould adversely impact our anticipated expenses and reduce the value of Units.\n\n     <b><u>In the  future,  environmental  regulations  and  public  policy  regarding</u></b>\n     <b><u>compliance  may  change,   adversely   affecting  the  Facility's  economic</u></b>\n     <b><u>performance.</u></b>\n\n     Any future adverse changes in governmental  regulations  regarding emission\nof carbon dioxide, water disposal, co-existence with endangered species or other\nwildlife, or other factors, could result in unforeseen material costs or capital\nexpenditures  that  could  cause the  Company to fail to  generate  satisfactory\neconomic  results,  causing  devaluation of Units.  In addition,  any changes in\nenvironmental  laws and regulations,  both at the federal and state level, could\nrequire us to spend  considerable  resources in order to comply with such law or\nregulation.  The expense of compliance may be  significant  enough to reduce our\nprofitability and negatively affect our financial condition.\n\n<b><I>Risks Related to Tax Issues in a Limited Liability Company</i></b>\n\n<b>MEMBERS  SHOULD  CONSULT THEIR OWN TAX ADVISOR  CONCERNING THE IMPACT THAT THEIR\nOWNERSHIP  IN US MAY  HAVE  ON  THEIR  FEDERAL  INCOME  TAX  LIABILITY  AND  THE\nAPPLICATION OF STATE AND LOCAL INCOME AND OTHER TAX LAWS TO OWNERSHIP OF UNITS.</b>\n\n     <b><u>IRS  classification  of us as a  corporation  rather than as a  partnership</u></b>\n     <b><u>would result in higher taxation and reduced profits, which could reduce the</u></b>\n     <b><u>value of an investment in us.</u></b>\n\n     We are an Iowa limited  liability company that has elected to be taxed as a\npartnership for federal and state income tax purposes,  with income, gain, loss,\ndeduction and credit passed through to our Members.  However,  if for\n\n                                       29\n\n</pre>\n<hr>\n<pre>\n\nany reason the Internal  Revenue  Service (\"IRS\") would  successfully  determine\nthat we should be taxed as a corporation rather than as a partnership,  we would\nbe taxed on our net income at rates of up to 35 percent for  federal  income tax\npurposes, and all items of our income, gain, loss, deduction and credit would be\nreflected  only on our tax  returns  and  would  not be  passed  through  to our\nMembers.  If we were to be taxed as a corporation for any reason,  distributions\nwe make to our Members will be created as ordinary dividend income to the extent\nof our  earnings  and  profits,  and  the  payment  of  dividends  would  not be\ndeductible by us, thus resulting in double taxation of our earnings and profits.\nIf we pay taxes as a  corporation,  we will have less cash to  distribute to our\nMembers.\n\n     <b><u>The IRS may  classify  an  investment  in us as  passive  activity  income,</u></b>\n     <b><u>resulting  in a Member's  inability  to deduct  losses  associated  with an</u></b>\n     <b><u>investment in us.</u></b>\n\n     It is likely  that the IRS will  classify  an  interest  in us as a passive\nactivity. If a Member is either an individual or a closely held corporation, and\nif a Member's  interest is deemed to be \"passive  activity,\"  then such Member's\nallocated  share of any loss we incur will be deductible  only against income or\ngains such Member has earned from other  passive  activities.  Passive  activity\nlosses that are  disallowed in any taxable year are suspended and may be carried\nforward and used as an offset against  passive  activity income in future years.\nThese rules could  restrict a Member's  ability to  currently  deduct any of our\nlosses that are passed through.\n\n     <b><u>Income allocations assigned to Units may result in taxable income in excess</u></b>\n     <b><u>of cash  distributions,  which means a Member may have to pay income tax on</u></b>\n     <b><u>our Units with personal funds.</u></b>\n\n     Members  will pay tax on their  allocated  shares  of our  taxable  income.\nMembers may receive allocations of taxable income that result in a tax liability\nthat is in excess of any cash  distributions  we may make to the Members.  Among\nother  things,  this result might occur due to accounting  methodology,  lending\ncovenants  imposed by our current  loans that  restrict  our ability to pay cash\ndistributions,  or our decision to retain the cash  generated by the business to\nfund our  operating  activities  and  obligations.  Accordingly,  Members may be\nrequired to pay some or all of the income tax on their  allocated  shares of our\ntaxable income with personal funds.\n\n     <b><u>An IRS audit could  result in  adjustments  to our  allocations  of income,</u></b>\n     <b><u>gain, loss and deduction causing additional tax liability to our Members.</u></b>\n\n     The IRS may audit our income tax returns and may challenge  positions taken\nfor tax purposes and allocations of income, gain, loss and deduction to Members.\nIf the IRS were  successful  in  challenging  our  allocations  in a manner that\nreduces  loss or  increases  income  allocable  to  Members,  Members  may  have\nadditional tax  liabilities.  In addition,  such an audit could lead to separate\naudits of Members' tax returns,  especially if adjustments  are required,  which\ncould result in adjustments  on Members' tax returns.  Any of these events could\nresult in additional tax liabilities, penalties and interest to Members, and the\ncost of filing amended tax returns.\n\n<b>Item 2.           Properties.</b>\n\n     We have  purchased  the Facility  site located near Council  Bluffs,  Iowa,\nwhich consists of three parcels totaling 200 acres.  This property is encumbered\nunder the Mortgage  Agreement with Lenders.  We lease a building on the Facility\nsite to an unrelated third party, and lease 55.202 acres on the south end of the\nproperty to an unrelated third party for farming.\n\n     In December  2008,  we entered  into a lease  agreement  with Bunge for the\nlease of property in Council Bluffs,  Iowa. The property  contains a storage bin\nthat we expect to use for storing grain to be used at the Facility.  The initial\nterm of the lease is one year and it may be  extended  for  additional  one-year\nterms upon mutual agreement.\n\n<b>Item 3.           Legal Proceedings.</b>\n\n     There are no items to report.\n\n                                       30\n\n</pre>\n<hr>\n<pre>\n\n<b>Item 4.  Submission of Matters to a Vote of Security Holders</b>.\n\n     None.\n<b>\n                                     PART II\n\nItem 5. Market for  Registrant's  Common  Equity,  Related Member  Matters,  and\n        Issuer Purchases of Equity Securities.</b>\n\n     In March 2008,  we amended the terms of the Credit  Agreement  and obtained\nthe Bridge Loan for a maximum  principal amount of $36,000,000.  The Bridge Loan\nis secured by two letters of credit,  as  described  below.  As of November  30,\n2008,  we  have  drawn   $34,900,000  under  the  Bridge  Loan  for  payment  of\nconstruction in progress, and interest on the Bridge Loan.\n\n     Bunge  caused its bank to issue a letter of credit in the  amount  equal to\n76% of the  maximum  principal  amount of the Bridge Loan in favor of the Bridge\nLender (the \"<U>Bunge LC</U>\"),  and ICM caused its lender to similarly  issue a letter\nof credit in the  amount  equal to 24% of the  maximum  principal  amount of the\nBridge Loan in favor of the Bridge  Lender (the \"<U>ICM LC</U>\" and,  together with the\nBunge LC, the \"<U>LCs</U>\").  Both LCs expire on March 16, 2009,  and the Bridge Lender\nwill only draw  against the LCs to the extent  that we default  under the Bridge\nLoan or if we have not repaid the Bridge  Loan in full by March 1, 2009.  In the\nevent the Bridge  Lender  draws  against the LCs,  the amounts  drawn will be in\nproportion  to Bunge's and ICM's  respective  ownership of the  Company's  Units\nwhich are not Series A--76% and 24%, respectively.  As we repay the principal of\nthe Bridge Loan,  the LCs' stated amounts will  automatically  be reduced in the\nsame proportion.\n\n     We entered into a Series C Unit Issuance  Agreement with ICM (the \"<U>Series C</U>\n<U>Agreement</U>\")  and a Series E Unit  Issuance  Agreement  with Bunge (the \"Series E\n<U>Agreement</U>\",   together  with  the  Series  C  Agreement,   the  \"<U>Unit   Issuance</U>\n<U>Agreements</U>\") in connection with their respective issuances of the LCs. Under the\nUnit  Issuance  Agreements,  we  agreed  to pay Bunge and ICM each a fee for the\nissuances  of their  respective  LCs equal to 6% per annum of the  undrawn  face\namount of their  respective LCs. As of September 2008, we have accrued  expenses\nof approximately $300,000 and $950,000 to ICM and Bunge, respectively.  The Unit\nIssuance  Agreements  provide  that we will use our best  efforts to raise funds\nthrough  a  subsequent   private  placement  offering  of  Units  (the  \"<U>Private</U>\n<U>Placement</U>\"),  or such  other  form of equity or debt  financing  as our Board of\nDirectors may deem necessary, in an amount sufficient to pay off the Bridge Loan\nin full  prior to  maturity.  However,  the recent  tightening  of credit in the\nmarket has significantly  reduced the availability of investors that are willing\nto invest in new ethanol  production.  The recent bankruptcy  filings of several\nethanol  plants  have  resulted  in  an  opportunity  to  purchase  plants  at a\nsignificantly  reduced market price. In the event that the LCs are drawn upon as\ndiscussed  above or if Bunge or ICM make any  payment to the Bridge  Lender that\nreduces  amounts  owed by us  under  the  Bridge  Loan  (each,  a  \"<U>Bridge  Loan</U>\n<U>Payment</U>\"),  the  Unit  Issuance  Agreements  provide  that we  will  immediately\nreimburse  Bunge and/or ICM, as  applicable,  for the amount of such Bridge Loan\nPayment by issuing Units to Bunge and ICM, as further described below.\n\n     Under the Series C Agreement,  if ICM makes a Bridge Loan Payment,  we will\nimmediately  issue  Series C Units to ICM based on a Unit price that is equal to\nthe lesser of $3,000 or one half (1/2) of the lowest  purchase price paid by any\nparty for a Unit who acquired (or who has entered into any agreement, instrument\nor document to acquire)  such Unit after the date of the Series C Agreement  but\nprior to the date of any Bridge Loan Payment made by ICM. The Series C Agreement\nfurther  provides that ICM will have the right to purchase its pro rata share of\nany Units issued by us at any time after the date of the Series C Agreement.\n\n     Under the Series E Agreement, if Bunge makes a Bridge Loan Payment, we will\nimmediately issue Series E Units to Bunge based on a Unit price that is equal to\nthe lesser of $3,000 or one half (1/2) of the lowest  purchase price paid by any\nparty for a Unit who acquired (or who has entered into any agreement, instrument\nor document to acquire)  such Unit after the date of the Series E Agreement  but\nprior to the  date of any  Bridge  Loan  Payment  made by  Bunge.  The  Series E\nAgreement  further  provides  that Bunge will have the right to purchase its pro\nrata share of any Units  issued by us at any time after the date of the Series E\nAgreement.\n\n\n                                       31\n</pre>\n<hr>\n<pre>\n\n     As of September  30, 2008,  the Company had (i) 8,805 Series A Units issued\nand  outstanding  held by 774  persons,  (ii)  3,334  Series B Units  issued and\noutstanding held by Bunge, and (iii) 1,000 Series C Units issued and outstanding\nheld by ICM. The Company does not have any  established  trading  market for its\nUnits, nor is one contemplated. To date, the Company has made no distribution to\nits  Members,   and  it  cannot  be  certain  when  it  will  be  able  to  make\ndistributions.  Further,  our ability to make  distributions  will be restricted\nunder the terms of the Credit Agreement.\n\n     If the LCs are drawn upon to repay the Bridge Loan,  we will be required to\nimmediately issue Series C Units to ICM and Series E Units to Bunge based on the\namounts of the LCs paid by Bunge and ICM.  The Unit  issuance  price will be the\nlesser of $3,000 or  one-half  (1/2) of the  lowest  purchase  price paid by any\nparty for a Unit who acquired (or who has entered into any agreement, instrument\nor  document  to  acquire)  such Unit after the date of the Series C or Series E\nAgreements but prior to the date of any Bridge Loan Payment made by Bunge.\n<b>\nItem 6. Selected Financial Data.</b>\n\n        Not applicable.\n<b>\nItem 7. Management's  Discussion and Analysis of Financial Condition and Results\n        of Operation.</b>\n<b><i>\nForward Looking Statements</i></b>\n\n     This report on Form 10-K by Southwest Iowa Renewable  Energy,  LLC contains\nforward-looking  statements that involve future events,  our future  performance\nand our expected future  operations and actions.  In some cases you can identify\nforward-looking  statements  by the  use  of  words  such  as  \"may,\"  \"should,\"\n\"anticipate,\"   \"believe,\"   \"expect,\"  \"plan,\"  \"future,\"   \"intend,\"  \"could,\"\n\"estimate,\" \"predict,\" \"hope,\" \"potential,\" \"continue,\" or the negative of these\nterms or other similar expressions.  These  forward-looking  statements are only\nour predictions and involve numerous assumptions,  risks and uncertainties.  Our\nactual  results or  actions  may differ  materially  from these  forward-looking\nstatements for many reasons, including the following factors:\n\n     &#149;    Overcapacity in the ethanol industry;\n     &#149;    Our ability to obtain any  additional  equity  financing  which may be\n          required to complete plant  construction and commence  operations,  or\n          our inability to fulfill our debt financing covenants;\n     &#149;    Changes in our business strategy,  capital improvements or development\n          plans;\n     &#149;    Construction  delays and technical  difficulties in  constructing  the\n          plant;\n     &#149;    Changes in the environmental  regulations that apply to our plant site\n          and operations;\n     &#149;    Our ability to hire and retain key  employees for the operation of the\n          plant;\n     &#149;    Changes in general  economic  conditions or the  occurrence of certain\n          events  causing  an  economic  impact  in  the  agricultural,  oil  or\n          automobile industries;\n     &#149;    Changes  in the  availability  and  price of  electricity,  steam  and\n          natural gas;\n     &#149;    Changes in federal and/or state laws (including the elimination of any\n          federal and/or state ethanol tax incentives);\n     &#149;    Changes and advances in ethanol production technology; and competition\n          from alternative fuel additives.\n\n     Our actual results or actions could and likely will differ  materially from\nthose anticipated in the forward-looking  statements for many reasons, including\nthe reasons  described in this  report.  We are not under any duty to update the\nforward-looking  statements contained in this report. We cannot guarantee future\nresults, levels of activity,  performance or achievements. We caution you not to\nput undue reliance on any forward-looking statements, which speak only as of the\ndate of this  report.  You  should  read  this  report  completely  and with the\nunderstanding  that our actual future  results may be materially  different from\nwhat we currently  expect. We qualify all of our  forward-looking  statements by\nthese cautionary statements.\n<b><i>\nOverview, Status and Recent Developments</i></b>\n\n     We are a development  stage Iowa limited liability company which was formed\non March 28, 2005 to develop,  construct,  own and operate the  Facility.  Based\nupon engineering specifications from ICM, our primary constructor, we expect the\nFacility to process approximately 39.3 million bushels of corn per year into 110\nmillion gallons of\n\n\n                                       32\n\n</pre>\n<hr>\n<pre>\n\ndenatured fuel grade ethanol,  300,000 tons of DDGS and 50,000 tons of WDGS. The\nfuel grade  ethanol  will be sold in markets  throughout  the United  States and\nDistillers   Grains   sold  in  markets   throughout   the  United   States  and\ninternationally.  To execute our business  plan, we raised  capital  through two\nofferings--an  initial seed round in the fourth  quarter of 2005 and a secondary\nround  in the  first  quarter  of  2006.  With the  proceeds  of our two  equity\nofferings,  we began construction of our Facility in February of 2007. We expect\nto become operational the second quarter of fiscal 2009.\n\n     On May 2, 2007, we entered into a $126,000,000  credit facility pursuant to\nthe Credit Agreement with AgStar Financial  Services,  PCA (\"<U>AgStar</U>\"),  as agent\nfor the Lenders.  Effective  March 7, 2008,  we amended the terms of our primary\nlending agreements,  obtained the Bridge Loan in the maximum principal amount of\n$36,000,000 from the Bridge Lender and entered into arrangements with the Bridge\nLender and our key equity holders and  operational  partners,  ICM and Bunge. On\nMarch 7, 2008, we made the following arrangements:\n\n     &#149;  We  obtained  the  Bridge  Loan  in  the  maximum  principal  amount  of\n     $36,000,000, which is secured by two letters of credit, as described below.\n     As of  November  30th  2008,  we have  drawn  $34,900,000  for  payment  of\n     construction in progress and interest on the Bridge Loan.\n\n     &#149; Bunge  caused  its bank to issue  the Bunge LC, a letter of credit in the\n     amount equal to 76% of the maximum  principal amount of the Bridge Loan, in\n     favor of the Bridge  Lender,  and ICM caused its lender to similarly  issue\n     the ICM LC, a letter of credit in the  amount  equal to 24% of the  maximum\n     principal  amount of the Bridge Loan, in favor of the Bridge  Lender.  Both\n     LCs expire on March 16, 2009,  and the Bridge Lender will only draw against\n     the LCs to the extent  that we default  under the Bridge Loan or if we have\n     not  repaid  the  Bridge  Loan in full by March 1,  2009.  In the event the\n     Bridge  Lender  draws  against  the  LCs,  the  amounts  drawn  will  be in\n     proportion to Bunge's and ICM's respective ownership of the Company's Units\n     which  are not  Series  A--76%  and  24%,  respectively.  As we  repay  the\n     principal of the Bridge Loan, the LCs' stated amounts will automatically be\n     reduced in the same proportion.\n\n     &#149; We entered into the Unit Issuance  Agreements  in  connection  with their\n     respective  issuances of the LCs.  Under the Unit Issuance  Agreements,  we\n     agreed  to pay  Bunge  and  ICM  each a fee  for  the  issuances  of  their\n     respective  LCs equal to 6% per annum of the  undrawn  face amount of their\n     respective LCs. The Unit Issuance  Agreements  provide that we will use our\n     best efforts to raise funds  through the Private  Placement,  or such other\n     form of  equity  or debt  financing  as our  Board  of  Directors  may deem\n     necessary, in an amount sufficient to pay off the Bridge Loan in full prior\n     to maturity.  Although we anticipate  that funds  obtained from the Private\n     Placement or such other equity or debt  financing will enable us to pay off\n     the Bridge  Loan in full prior to  maturity,  in the event that the LCs are\n     drawn  upon as  discussed  above or if Bunge  or ICM make any  Bridge  Loan\n     Payment,  the Unit  Issuance  Agreements  provide that we will  immediately\n     reimburse  Bunge and/or ICM, as  applicable,  for the amount of such Bridge\n     Loan Payment by issuing Units to Bunge and ICM, as further described below.\n\n     &#149; Under the Series C Agreement, if ICM makes a Bridge Loan Payment, we\n     will immediately  issue Series C Units to ICM based on a Unit price that is\n     equal to the  lesser  of $3,000 or one half  (1/2) of the  lowest  purchase\n     price paid by any party for a Unit who  acquired  (or who has entered  into\n     any agreement,  instrument or document to acquire) such Unit after the date\n     of the Series C Agreement  but prior to the date of any Bridge Loan Payment\n     made by ICM. The Series C Agreement further provides that ICM will have the\n     right to purchase  its pro rata share of any Units issued by us at any time\n     after the date of the Series C Agreement.\n\n     &#149; Under the Series E Agreement,  if Bunge makes a Bridge Loan Payment,\n     we will  immediately  issue  Series E Units to Bunge  based on a Unit price\n     that is equal to the  lesser  of  $3,000  or one half  (1/2) of the  lowest\n     purchase  price  paid by any  party  for a Unit  who  acquired  (or who has\n     entered into any  agreement,  instrument  or document to acquire) such Unit\n     after  the date of the  Series  E  Agreement  but  prior to the date of any\n     Bridge Loan Payment made by Bunge. The Series E Agreement  further provides\n     that Bunge will have the right to purchase  its pro rata share of any Units\n     issued by us at any time after the date of the Series E Agreement.\n\n     We have retained an  investment  banking firm to assist us in obtaining the\nadditional  institutional equity to replace the Bridge Loan. However, the Bridge\nLoan is due March 1, 2009, and we may be unable to find a source of\n\n\n                                       33\n\n</pre>\n<hr>\n<pre>\n\nfinancing to retire the Bridge Loan at that time.  The Board may also  determine\nto make an offering to existing  Members and other  investors to compliment  the\nadditional institutional equity, if any.\n\n<b><i>\nConstruction Status</i></b>\n\n     We have entered into  contracts  with various  contractors to construct the\nFacility, though our primary contractors are ICM, T&amp;S and HGM. With the proceeds\nof our two equity offerings,  we began  construction of our Facility in February\nof 2007 with grading and GeoPier  installation.  TT&amp;S began work on the grain and\nDDGS silos in  February of 2007,  with the silos  poured the end of July and the\nDDG building set and sided in October, 2008. As of December, 2008, the status of\nthe various components of the Facility was as follows:\n\n&#149;    Construction  workers are beginning to complete  their jobs and  demobilize\n     from our site.\n&#149;    Grain  handling:  The  handling  system is complete  and we have brought in\n     960,000 bushels of corn.\n&#149;    Storage tanks: Hydro testing is completed.\n&#149;    Process building: The roof work is completed and electrical/instrumentation\n     terminations are ongoing.\n&#149;    North and  South  Rail  line:  The rail  tracks  are  complete  and we have\n     received our locomotive and railcars.\n&#149;    Water: The reverse osmosis system is complete.\n&#149;    Steam Pipeline: The construction of the steam line is complete.\n&#149;    Back-up  boilers:  Our revised air permit was issued mid-December  allowing\n     us to complete  construction  of our permanent  backup boiler system.  This\n     back-up  system is expected to be  operational by Feb 1st and will have the\n     capacity to supply 100% of our plant's  steam needs in the event of a MidAm\n     shutdown.\n&#149;    Energy  center  and wet cake  pads:  The  final  electrical/instrumentation\n     terminations remain ongoing.\n&#149;    Distillers  Grains:  The  conveyor  work is complete  inside of the storage\n     building  and  conveyors  between the  storage and energy  center are being\n     installed.\n&#149;    Cooling Towers: Complete.\n&#149;    Natural  gas:  The  pipeline  that  connects  our  facility to the Northern\n     Natural Gas pipeline has been completed.\n&#149;    Scale/Probe  buildings:  The scale building complete and the probe building\n     is operational.\n&#149;    Site paving: Nearly complete.\n<b><i>\nResults of Operations\n</i></b>\n     During  Fiscal  Year  2008,  we  incurred  a  net  loss  of   approximately\n($3,718,000).  We  have  incurred  an  accumulated  net  loss  of  approximately\n($3,417,000) for the period March 28, 2005 (date of inception) through September\n30, 2008.  These losses were  incurred for general and  administrative  expenses\nrelating to organization  and development as we continue to construct our plant.\nNet income  resulted from interest  income on the equity  financing  before full\nconstruction of the plant was underway.\n<b><i>\nLiquidity and Capital Resources</i></b>\n\n     We  intend  to  rely  on our  current  equity  and  available  debt to fund\ncompletion of the project,  cover start-up costs and purchase inventory prior to\nour  operational  date. We will seek to issue equity to replace the Bridge Loan,\nas described above.  However, if we are not successful in raising equity or debt\nfrom  third  parties  to  replace  the  Bridge  Loan,  it will be  converted  to\nadditional  Series C and Series E Units.  Under the terms of the amended  Credit\nAgreement,  as of  September  30, 2008 we have drawn  approximately  $64,162,000\nunder the Credit  Agreement  and have also drawn  approximately  $34,762,000  of\nprincipal and interest  under the Bridge Loan. As we complete  construction,  we\nwill also be able to  access  our  revolving  line of  credit  under our  Credit\nAgreement.  We anticipate  that our working capital will be tight because of the\namendment  to  our  Credit   Facility  on  December   19,  2008  and   immediate\nimplementation of a 75% borrowing base on accounts receivable and inventory that\ncould significantly  reduce our cash flow. Once operational,  we anticipate that\ncash  flow  from  operations  will  allow  us to  operate  at a  breakeven  or a\nprofitable  basis and will provide the necessary cash to make our principal debt\nand  interest  payments.  However,  our  business  has been  subject  to extreme\nvolatility in recent months and market trends and  governmental  regulations and\nsupport  for our  industry  could have a  significant  impact on our  ability to\nremain  profitable  and provide  enough cash flow to make our debt and  interest\npayments.\n\n\n                                       34\n\n</pre>\n<hr>\n<pre>\n\n     We executed a second  amendment  to our Credit  Agreement  on December  19,\n2008, that granted us early access to our seasonal revolving Line of Credit. The\namendment  grants  access to the funds prior to the plant being  operational.  A\nborrowing  base  limitation  is  included  in  the  agreement  that  limits  the\navailability  of funds to the lesser of  $15,000,000  or 75 percent of  eligible\naccounts  receivable and eligible  inventory.  We can use this line of credit to\nhedge corn,  natural gas and ethanol futures.  The volatility in the commodities\nmarkets  this  year  have  resulted  in  wide  swings  in  margins  for  ethanol\nproduction.  We feel that this volatility  will continue  through 2009 and could\npossibly limit the working capital needed to have an effective hedging strategy.\n\n     Our operations are highly dependent on commodity prices,  especially prices\nfor corn,  ethanol,  distillers  grains and  natural  gas.  As a result of price\nvolatility  for  these   commodities,   our  operating   results  may  fluctuate\nsubstantially.  The price and  availability  of corn are subject to  significant\nfluctuations  depending upon a number of factors that affect commodity prices in\ngeneral, including crop conditions,  weather,  governmental programs and foreign\npurchases.  We may  experience  increasing  costs for corn and  natural  gas and\ndecreasing  prices for ethanol and distillers  grains which could  significantly\nimpact  our  operating  results.  Because  the  market  price of  ethanol is not\ndirectly  related to corn prices,  ethanol  producers  are generally not able to\ncompensate  for increases in the cost of corn feedstock  through  adjustments in\nprices charged for ethanol.  Based on recent forward prices of corn and ethanol,\nit is possible  that in the future we may be  operating  the  Facility at low to\nnegative  operating  margins.  Increases  in corn prices or decreases in ethanol\nprices may result in it being unprofitable to operate our Facility.\n\n     The  price of corn has been very  volatile  during  2008.  Since the end of\nfiscal 2007, the Chicago  Mercantile  Exchange (\"<U>CME</U>\") near-month corn price had\nrisen to above $7.00 per bushel.  The CME  near-month  corn price for March 2009\nwas $3.97 per bushel.  We believe the increase in corn prices was  primarily due\nto export demand,  speculation,  ethanol demand and current production concerns.\nHigher corn prices will negatively affect our costs of production.  However,  we\nalso believe that higher corn prices may, depending on the prices of alternative\ncrops,  encourage  farmers to plant  more acres of corn in the coming  years and\npossibly divert land in the Conservation Reserve Program to corn production.  We\nbelieve an increase in land devoted to corn production could reduce the price of\ncorn to some extent in the future.  The United States  Department of Agriculture\n(\"<U>USDA</U>\") is projecting a higher  carryout for corn this year due to smaller than\nexpected   usage  for  ethanol  and  exports.   The  USDA  has   projected   the\nseason-average farm price of corn at $3.65 to $4.35 per bushel for 2008. We feel\nthat there will  continue to be  volatility  in the corn  market.  With the USDA\nprojecting a 300 million bushel  reduction of corn usage for ethanol  production\nin December 2008 and a reduction of corn exports,  corn prices could continue to\ndecline.\n\n     Historically,  ethanol  prices have tended to track the wholesale  price of\ngasoline. Ethanol prices can vary from state to state at any given time. For the\npast  two  years,  the  average  U.S.  ethanol  price,  based  on the Oil  Price\nInformation Service (\"<U>Opis</U>\") Spot Ethanol Assessment,  was $2.27 per gallon. For\nthe same  time  period,  the  average  U.S.  gasoline  price,  based on New York\nMercantile  Exchange  (\"<U>NYMEX</U>\")  reformulated  blendstock  for  oxygen  blending\n(\"<U>RBOB</U>\")  contracts was $2.04 per gallon.  During the first six months of fiscal\n2008,  the average U.S.  ethanol  price was $2.37 per gallon.  For the same time\nperiod,  U.S.  gasoline prices have averaged $2.66 per gallon,  or approximately\n$0.29 per gallon above ethanol prices.  We believe this is due to constraints in\nthe ethanol  blending and  distribution  infrastructure  that has resulted  from\nsignificant  increases in ethanol  supply in recent years.  In December 2008, JP\nMorgan  cut its 2009  price  target  for oil to $43 a barrel  from  $69,  citing\n\"deterioration  in  the  world  economic   environment  and  the  ensuing  sharp\ncontraction  in global oil demand in both 2008 and 2009.  Once  operational,  we\nfeel that with an average netback for ethanol of $1.50 per gallon and an average\nof $3.60 per bushel of corn we will  generate free cash flow that will cover our\ninterest and principal debt  payments.  If corn were to average $4.40 per bushel\nwe would need to generate  an average  netback of $1.75 per gallon to be able to\nservice our interest and  principal  payments.  Netback is the sales price minus\nall freight charges, storage charges or marketing fees.\n\n     Federal policy has a significant  impact on ethanol market demand.  Ethanol\nblenders  benefit from  incentives that encourage usage and a tariff on imported\nethanol supports the domestic industry. Additionally, the RFS mandates increased\nlevel of usage of both corn-based and cellulosic ethanol.  The RFS policies were\nchallenged in a proceeding at the EPA by the State of Texas.  The State of Texas\nsought a waiver of 50% of the RFS mandate because of the economic impact of high\ncorn prices.  The EPA denied this  request in early  August,  2008.  Any adverse\nruling in the  future on any other RFS  waiver  request  could  have an  adverse\nimpact on short-term ethanol prices.\n\n     We  believe  the  ethanol  industry  will  continue  to expand due to these\nfederal mandates and policies. However, we expect the rate of industry expansion\nto slow  significantly  because of the amount of ethanol\n\n                                       35\n\n</pre>\n<hr>\n<pre>\n\nproduction  added  during the past two years or to be added by plants  currently\nunder construction.  This additional supply,  coupled with significantly  higher\ncorn  costs  and  relatively  low  ethanol  prices,   has  resulted  in  reduced\navailability of capital for ethanol plant construction or expansion.\n\n        We believe  that any  reversal in federal  policy  could have a profound\nimpact on the  ethanol  industry.  In recent  months,  a  political  debate  has\ndeveloped   related  to  the  alleged  adverse  impact  that  increased  ethanol\nproduction  has  had  on  food  prices.  The  high-profile   debate  focuses  on\nconflicting economic theories explaining increased commodity prices and consumer\ncosts.  Political candidates and elected officials have responded with proposals\nto reduce,  limit or eliminate the RFS mandate,  blender's  credit and tariff on\nimported ethanol. While at present no policy change appears imminent, we believe\nthat the debates have created  uncertainty and increased the ethanol  industry's\nexposure to political risk.\n\n        We expect federal policy changes to have a significant impact on ethanol\nmarket demand. Additionally,  we expect a significant increase in supply because\nof the amount of  ethanol  production  added  during the past two years or to be\nadded by plants currently under  construction.  This additional supply,  coupled\nwith  significantly  higher corn costs and  relatively low ethanol  prices,  has\nresulted in reduced  availability  of capital for ethanol plant  construction or\nexpansion.\n\n        Cash (used in) / provided by  operations  for Fiscal  Year 2008,  Fiscal\nYear 2007,  and from March 28, 2005 (date of  inception)  through  September 30,\n2008, was ($2,436,118),  $768,320 and ($2,118,600),  respectively. Cash has been\nused primarily for pre-operational and administrative  expenses. For Fiscal Year\n2008,  Fiscal  Year 2007,  and from March 28, 2005 (date of  inception)  through\nSeptember 30, 2008, net cash (used in) investing  activities was  ($88,922,249),\n($68,094,996)  and  ($162,641,675)   respectively,   primarily  related  to  the\nconstruction of our plant.\n\n\n     For Fiscal Year 2008,  Fiscal  Year 2007,  and from March 28, 2005 (date of\ninception)  through September 30, 2008, cash provided from financing  activities\nwas  $96,172,821,  $68,248,873  and  $171,317,669,  respectively.  This cash was\ngenerated through our equity financing of approximately $75,654,000,  the Bridge\nLoan of $34,100,000, and $64,162,000 from our construction loan.\n\n     <b><u>Sources of Funds</u></b>\n\n     The total project cost to construct our Facility and commence operations is\ncurrently  estimated  to be  approximately  $225,000,000,  assuming  no  unknown\nmaterial  changes  are  required.  To  date,  we have  planned  to  finance  the\nconstruction  of the Facility with a combination of equity and debt capital.  We\ninitially  raised  equity  from our  seed  capital  investors  and  completed  a\nsecondary  private  offering  in  March  2006.  We  intend  to draw on our  debt\nfinancing under the terms of the Credit  Agreement,  as amended,  and the Bridge\nLoan.  We have also received  grant income from the United States  Department of\nAgriculture (\"<U>USDA</U>\") and a loan from the IDED. The following schedule sets forth\nthe sources of funds from our equity  offering  proceeds and our debt  financing\nproceeds and grants:\n<b>\nSource of Funds                                                                   Amount            Percent of Total</b>\n     <i>Equity:</i>\n         Member Equity (Seed Capital Offerings)                               $      1,650,000            0.74 %\n         Member Equity (Secondary Offering)                                   $     74,004,000           32.94 %\n     <i>Other:</i>\n         Interest, Grant and Other Income                                     $      3,881,400            1.72 %\n     <b>Total Equity and Other                                                   $     79,535,400           35.40 %</b>\n     <i>Debt:</i>\n         Credit Facility                                                      $    111,000,000           49.40 %\n         Bridge Loan                                                          $     34,100,000           15.20 %\n     <b>Total Debt                                                               $    145,100,000           64.60 %\n----------------------------------------------------------------------------------------------------------------------\nTotal                                                                         $    224,635,000             100 %</b>\n\n\n                                       36\n\n\n</pre>\n<hr>\n<pre>\n\n     <b><u>Other Income</u></b>\n\n     In addition to our equity  financing,  the Credit  Agreement and the Bridge\nLoan, we have earned approximately $3,385,000 of interest income, and rental and\ngrant income of approximately $384,000, through September 30, 2008.\n\n     <b><u>Debt Financing</u></b>\n\n     In May 2007, we closed on our debt  financing  with AgStar as agent for the\nLenders. Our debt financing is principally governed by the Credit Agreement with\nthe Lenders,  along with other  agreements,  which were amended March 7, 2008 in\nconnection  with  the  Bridge  Loan.  The  Credit   Agreement   provides  for  a\n$111,000,000  construction  loan  which is  convertible  into a term  loan  (the\n\"<U>Construction Loan</U>\"), at a variable interest rate of LIBOR (the London Interbank\nOffered  Rate) plus 3.65%.  The Credit  Agreement  requires that we make monthly\nprincipal  payments  commencing seven months following the date the Construction\nLoan converts to a term loan (60 days after  completion of  construction  of the\nFacility) (the \"<U>Conversion  Date</U>\"). On the Conversion Date, the Credit Agreement\nprovides that the Construction  Loan will be converted into a term loan of up to\n$101,000,000  (the \"<U>Term Loan</U>\") and a term  revolving  loan of up to $10,000,000\n(the \"<U>Term Revolver</U>\"); and up to 50% of the outstanding Construction Loan can be\nconverted to a fixed rate term loan (\"<U>Fixed Rate Loan</U>\"). In addition, the Credit\nAgreement  provides for a revolving line of credit of approximately  $15,000,000\n(the \"<U>Revolving Line of Credit</U>\").  The Revolver provides for a variable interest\nrate of LIBOR plus 3.45%. Finally, the Credit Facility provides for a loan up to\n$1,000,000 on a revolving basis (the \"<U>Swingline  Revolver</U>\").  Under the terms of\nthe First Amendment to the Credit  Agreement,  the Company's  lenders waived any\nand all covenant violations or events of default as of March 7, 2008 arising out\nof or related to increased project costs.\n\n     In addition to all other payments due under the Credit  Agreement,  we also\nagreed  to pay,  beginning  at the end of the  third  fiscal  quarter  after the\nConversion  Date, the amount equal to 65% of our Excess Cash Flow (as defined in\nthe Credit  Agreement),  up to a total of $4,000,000 per year,  and  $16,000,000\nover the term of the  Credit  Agreement.  Such  payment  will be  applied to the\noutstanding principal of the Term Loan (once funded), and will not be subject to\nthe prepayment fee. The prepayment fee is due if the  Construction  Loan or Term\nLoan is paid in full within 24 months after the Conversion  Date. We also agreed\nto pay to each  Lender,  annually,  a letter  of  credit  fee equal to 150 basis\npoints of each  Lender's  maximum  amount  available  to us under its  letter of\ncredit.  We will pay a commitment  fee of 35 basis points per year of the unused\nportion  of  each  Lender's  Revolving  Commitment,  as  defined  in the  Credit\nAgreement,  and payable in arrears in quarterly  installments.  The repayment of\nany  loan  will  be  made  to the  Lenders  pro  rata  based  on  each  Lender's\ncontribution to the total outstanding principal of that loan.\n\n     <b><u>Governmental Programs</u></b>\n\n     &#149; <U>IDED</U>: We entered into a Master  Contract (the \"<u>IDED  Contract</u>\")  with the\nIDED,  effective  November 21, 2006 and amended June 5, 2008, which provides for\nfinancial  assistance  from IDED. The awards granted under the IDED Contract can\nbe reduced or terminated if there is a change in the IDED revenues  appropriated\nto us under the Master  Contract or for any other reason beyond IDED's  control.\nAll amounts of financing received from IDED will be spent on the construction of\nour  Facility.  As part of the  Master  Contract,  we  granted  to IDED a second\nposition security  interest in all of our assets,  and a first position security\ninterest in our rolling  stock valued at  $200,000.  We covenant to (i) maintain\nour business and Facility in Iowa, (ii) create certain numbers of jobs, based on\nthe job category (the \"<U>Job Requirement</U>\"),  (iii) provide certain benefits,  (iv)\ncomplete the Facility and comply with  performance  requirements  regarding  its\ncompletion,  (v) maintain our properties in a condition of good repair, (vi) pay\nall  taxes,  assessments  and fees,  and (vii)  insure  our risks as any  person\nsimilarly  situated  would.  We agree to provide  reports  including  a mid-year\nstatus report, an end-of-year  status report,  an end of project report,  and an\nend of job maintenance period report. Additionally,  we agreed to not be a party\nto any merger or  consolidation,  we agree to not sell,  transfer,  or lease any\nproperty  covered by a security  interest,  and we agreed to not form or acquire\nany  subsidiaries  or transfer any assets pledged as security to any subsidiary.\nThe  Master  Contract  contains  standard  events of  default,  and in  addition\ndeclares an event of default  when we are  subject to any  judgment in excess of\n$100,000, in the aggregate.\n\n     The IDED  Contract  contains  a  VAAPFAP  Funding  Agreement  (\"<U>VA  Funding</U>\n<U>Agreement</U>\"),  which provides us with an interest-free loan of $100,000,  payable\nover 60 months,  and a $100,000  forgivable  loan,  payable over 36\n\n\n                                       37\n\n</pre>\n<hr>\n<pre>\n\n\nmonths.  The forgivable  loan is only due if IDED  determines  that we failed to\ncomply  with the terms of the VA Funding  Agreement  and the IDED  Contract.  In\naddition to the requirements  for funding under the IDED Contract,  we must also\nprovide  evidence that we have access to steam energy from  MidAmerica  Energy's\nplant to replace  natural gas before we will receive  funds under the VA Funding\nAgreement.  In the event we fail to meet our Job  Requirement,  IDED can  either\nrequire full repayment of the loan or repayment on a pro rata basis.  If we fail\nto meet our Job Requirement,  the forgivable loan will be forgiven on a pro rata\nbasis,  with the remaining  balance being  amortized  over a two year period and\ncarrying  a 6%  interest  rate,  due from the first day of  disbursement  of the\nshortfall  amount.  We have  signed two  promissory  notes,  each for  $100,000,\ncovering the loans provided for under the VA Funding  Agreement.  The VA Funding\nAgreement  terminates  upon (i) IDED  determining  we have  fully met all of the\nrequirements of the VA Funding Agreement,  including repayment, (ii) an event of\ndefault, (iii) lack of any distribution under the VA Funding Agreement within 24\nmonths of the award date, or (iv) mutual agreement.\n\n     The IDED Contract also contains a High Quality Job Creation Program Funding\nAgreement (\"<U>HQJCP Funding Agreement</U>\"). Under the HQJCP Funding Agreement, we are\nallowed to claim an  investment  tax credit  (\"<U>Tax  Credit</U>\") of up to 5% (with a\nmaximum of $6,922,308) of our qualifying  expenses  directly related to new jobs\ncreated by the start-up, location,  expansion, or modernization of our Facility,\nwe are  eligible  for a  refund  of  sales,  service,  and use  taxes  we pay to\ncontractors  or  subcontractors,  and  we are  eligible  for a  value-added  tax\nexemption. Under the HQJCP Funding Agreement, we must create 45 new high quality\njobs.  These new jobs must be created  within five years of Facility  completion\nand must be maintained for at least two years thereafter.  We also agree to make\na qualifying  investment of $141,331,160 toward the purchase and construction of\nour  Facility.  Additionally,  we must (i) offer our new  employees a pension or\nprofit  sharing  plan,  (ii)  create  a high  value-added  good  or  service  in\n\"Value-Added  Agriculture\"  (one of Iowa's  target  industries),  (iii)  provide\nemployees 90% of the cost of medical and dental insurance,  and (iv) have active\nproductivity  and safety  programs.  If we fail to create the number of required\njobs,  then we will be  required  to repay  these tax  benefits  pro rata to the\npercent of jobs we failed to create  over the number of jobs we are  required to\ncreate. If we fail to meet the four  requirements  above for two years in a row,\nthen we forfeit all tax benefits we receive under the HQJCP  Funding  Agreement.\nIf we sell or dispose of any building,  land, or structure that has received tax\nincentives  under this  program,  then our tax  liability  will be  increased as\noutlined in the HQJCP  Funding  Agreement.  In the event we layoff  employees or\nclose our Facility  prior to  receiving  any tax  benefits,  the benefits may be\nreduced or terminated by IDED. The HQJCP Funding  Agreement  terminates upon (i)\nIDED  determining we have fully met all of the requirements of the HQJCP Funding\nAgreement,  including  repayment,  (ii) an event of  default,  (iii) lack of any\ndistribution  under the HQJCP  Funding  Agreement  within 24 months of the award\ndate, or (iv) mutual agreement.\n\n     &#149; <U>USDA</U>:  We have entered into a  Value-Added  Agricultural  Product  Market\nDevelopment (VAPG) Grant Agreement (\"<U>Grant Agreement</U>\") with the United States of\nAmerica,  dated  November  3,  2006,  under  which we  receive  a grant of up to\n$300,000 for payment of (i)  administrative  staff salaries during  construction\nand start-up,  (ii) the rental of temporary  office space,  and (iii)  permanent\nstaff  salaries for three  months.  As a condition to  receiving  the grant,  we\nagreed to contribute at least  $300,000 of our own money to be spent at an equal\nor greater  rate than the Grant  Agreement  funds.  We also agree to  maintain a\nfinancial  management  system and receive  payment in  accordance  with  federal\nregulations.  Additionally,  we agreed to comply with certain bonding  coverage,\naudit and  reporting  obligations.  Finally,  we agreed to comply  with  federal\nregulations concerning property, procurement and records access.\n\n     <b><u>Uses of Funds</u></b>\n\n     The  following  table  describes the estimated use of our offering and debt\nfinancing  proceeds.  The figures  are  estimates  only,  and the actual uses of\nproceeds may vary significantly from the descriptions given below.\n\n<b>\nEstimated Uses of Funds                                                           Amount            Percent of Total</b>\nPlant Construction                                                            $    118,325,000              52.7  %\nOther Construction                                                            $     66,487,000              29.6  %\nLand and Site Development                                                     $     10,779,000               4.8  %\nSite Utilities, Fire Protection and Water Supply                              $      3,893,000               1.7  %\n\n\n                                       38\n\n</pre>\n<hr>\n<pre>\n\n\nRolling Stock                                                                 $      2,000,000               0.9  %\nAdministration Building, Computer Systems and Furnishings                     $      1,040,000               0.5  %\nRail line                                                                     $     13,030,000               5.8  %\nConstruction Insurance                                                        $        443,000               0.2  %\nEquity and Debt Financing Expenses+                                           $      1,414,000               0.6  %\nOrganizational                                                                $      5,424,000               2.4  %\nStart-Up                                                                      $      1,800,000               0.8  %<b>\n\n----------------------------------------------------------------------------------------------------------------------\nTotal                                                                         $    224,635,000               100  %</b>\n\n+    Does not  include  additional  expenses  we may  incur to raise  additional\n     equity as discussed elsewhere in this report.\n\nThe ICM Contract  provides for a fixed fee of  $118,000,000 to build the primary\nportions of our Facility. In 2008, we executed seven change orders under the ICM\nContract  in the  amount of  $29,247,000.  These  change  orders  were for items\noutside of the scope of the ICM  Contract and  therefore  were time and material\nbased items  instead of fixed price.  Through  November  2008,  we have paid ICM\n$120,453,000  for  construction   services  under  the  ICM  Contract,   leaving\n$26,794,000 of future  commitment,  which we expect to pay in 2008 and 2009. The\nTT&amp;S Contract  provides for a fee,  subject to change  orders,  of  approximately\n$9,661,000  to design and  construct  a 1,000,000  bushel  grain  receiving  and\nstorage facility and Distillers Grain storage facility, which work is completed.\nThrough November 2008, we have paid TT&amp;S $9,641,000, leaving a balance of $20,000\nin  future  commitments.  Additionally,  we have  agreed to pay  $6,371,000  for\nexcavation services.\n<b><i>\n     Application of Critical Accounting Estimates</i></b>\n\n     Management  uses  estimates  and  assumptions  in preparing  our  financial\nstatements in accordance with accounting  principles  generally  accepted in the\nUnited States.  These estimates and assumptions  affect the reported  amounts of\nassets and liabilities, the disclosure of contingent assets and liabilities, and\nthe  reported  revenues  and  expenses.  We do  not  believe  that  any  of  the\nsignificant  accounting  policies  described  in  the  notes  to  the  financial\nstatements is critical at this time; however we expect to continue to review our\naccounting  policies as we commence  operation of our ethanol  plant in order to\ndetermine if any of these accounting policies are critical.\n<b><i>\nOff-Balance Sheet Arrangements</i></b>\n\n     We do  not  have  any  off-balance  sheet  arrangements  that  have  or are\nreasonably   likely  to  have  a  current  or  future  material  effect  on  our\nconsolidated financial condition, results of operations or liquidity.\n<b><i>\nRecent Accounting Pronouncements</i></b>\n\n     In March 2008,  the Financial  Accounting  Standards  Board issued SFAS No.\n161, \"Disclosures about Derivative  Instruments and Hedging Activities.\" The new\nstandard is intended to improve financial reporting about derivative instruments\nand hedging activities by requiring enhanced  disclosures to enable investors to\nbetter  understand their effects on an entity's  financial  position,  financial\nperformance,  and cash  flows.  SFAS No.  161  achieves  these  improvements  by\nrequiring  disclosure  of the fair values of  derivative  instruments  and their\ngains and losses in a tabular format. It also provides more information about an\nentity's  liquidity by requiring  disclosure  of  derivative  features  that are\ncredit risk related. Finally, it requires  cross-referencing within footnotes to\nenable  financial   statement  users  to  locate  important   information  about\nderivative  instruments.  SFAS No. 161 is  effective  for  financial  statements\nissued for fiscal years and interim  periods  beginning after November 15, 2008,\nwith early application  encouraged.  We are currently evaluating the impact that\nthis statement will have on our financial statements.\n\n     In September 2006, the FASB issued Statement No.157, Fair Value Measurement\n(\"<U>FAS 157</U>\"). While this statement does not require new fair value  measurements,\nit provides  guidance on applying fair value and expands  required  disclosures.\nFAS 157 is effective  for the Company  beginning in the first  quarter of fiscal\n2009.  The  Company is  currently  assessing  the impact FAS 157 may have on the\nCompany's financial statements.\n\n     In February 2007, the FASB issued statement  No.159,  The Fair Value Option\nfor Financial  Assets and Financial  Liabilities  (\"<U>FAS 159</U>\").  This  statement,\nwhich is expected to expand fair value  measurement,  permits entities to\n\n                                       39\n\n\n</pre>\n<hr>\n<pre>\n\nchoose to measure many  financial  instruments  and certain  other items at fair\nvalue.  FAS 159 is  effective  for the  Company  beginning  in the first  fiscal\nquarter of 2009. We are  currently  assessing the impact FAS 159 may have on our\nfinancial statements.\n<b>\nItem 7A. Quantitative and Qualitative Disclosures About Market Risk</b>\n\n     Not applicable.\n\n<b>Item 8.  Financial Statements and Supplementary Data.</b>\n\n\n<img src=\"mcgladrey.jpg\">\n\n\n<b>\nReport of Independent Registered Public Accounting Firm</b>\n\nTo the Board of Directors\nSouthwest Iowa Renewable Energy, LLC (A development stage company)\n\nWe have audited the  accompanying  balance  sheets of Southwest  Iowa  Renewable\nEnergy, LLC (a development stage company) as of September 30, 2008 and 2007, and\nthe related statements of operations,  members' equity, and cash flows for years\nended  September  30,  2008 and 2007 and the period from March 28, 2005 (date of\ninception)  to  September  30,  2008.   These   financial   statements  are  the\nresponsibility of the Company's management.  Our responsibility is to express an\nopinion on these financial statements based on our audits.\n\nWe conducted our audits in accordance  with the standards of the Public  Company\nAccounting Oversight Board (United States). Those standards require that we plan\nand perform the audit to obtain reasonable assurance about whether the financial\nstatements are free of material misstatement.  An audit includes examining, on a\ntest basis,  evidence  supporting  the amounts and  disclosures in the financial\nstatements.  An audit also includes assessing the accounting principles used and\nsignificant  estimates  made by  management,  as well as evaluating  the overall\nfinancial  statement  presentation.   We  believe  that  our  audits  provide  a\nreasonable basis for our opinion.\n\nIn our opinion,  the financial  statements  referred to above present fairly, in\nall  material  respects,  the  financial  position of Southwest  Iowa  Renewable\nEnergy, LLC as of September 30, 2008 and 2007, and the results of its operations\nand its cash flows for years  ended  September  30, 2008 and 2007 and the period\nfrom March 28, 2005 (date of  inception)  to September  30, 2008,  in conformity\nwith U.S. generally accepted accounting principles.\n\n\n/s/ McGladrey &amp; Pullen, LLP\n\nMcGladrey &amp; Pullen, LLP\n\nDes Moines, Iowa\nDecember 29, 2008\n\n\n                                       40\n\n\n</pre>\n<hr>\n<pre>\n\n<b>\nSouthwest Iowa Renewable Energy, LLC\n\n(A Development Stage Company)\n\nBalance Sheets\nSeptember 30, 2008 and 2007</b>\n-------------------------------------------------------------------------------------------------------------------\n\n                                                                           2008                         2007\n                                                                   -----------------------------------------------\nASSETS\n\nCURRENT ASSETS\n     Cash and cash equivalents                                     $        6,557,394          $         1,742,940\n     Restricted cash                                                        3,289,949                           --\n     Prepaid expenses and other                                                43,261                      124,952\n                                                                   -------------------        ---------------------\n         Total current assets                                               9,890,604                    1,867,892\n                                                                   -------------------        ---------------------\n\nPROPERTY AND EQUIPMENT\n     Land                                                                   2,064,090                    2,064,090\n     Construction in progress                                             172,745,278                   59,504,547\n     Office and other equipment                                               389,823                       79,090\n                                                                   -------------------        ---------------------\n                                                                          175,199,191                   61,647,727\n     Accumulated depreciation                                                (37,249)                      (7,233)\n                                                                   -------------------        ---------------------\n                                                                          175,161,942                   61,640,494\n                                                                   -------------------        ---------------------\n\nOTHER ASSETS\n     Financing costs, net of amortization 2008;\n        $497,672 and 2007; none                                             3,088,821                    2,800,846\n     Cash held for plant construction                                              --                   15,638,542\n                                                                   -------------------        ---------------------\n                                                                            3,088,821                   18,439,388\n                                                                   -------------------        ---------------------\n                                                                   $      188,141,367          $        81,947,774\n                                                                   ===================        === =================\nLIABILITIES AND MEMBERS' EQUITY\n\nCURRENT LIABILITIES\n     Accounts  payable                                             $        6,260,253                    1,315,278\n     Retainage Payable                                                      7,158,896                    2,342,222\n     Accrued expenses                                                       1,672,950                       43,730\n     Current maturities of long-term debt                                  35,198,440                    1,303,250\n                                                                   -------------------        ---------------------\n         Total current liabilities                                         50,290,539                    5,004,480\n                                                                   -------------------        ---------------------\n\nLONG-TERM DEBT, less current maturities                                    63,893,467                      168,333\nOther                                                                         900,000                           --\n                                                                   -------------------        ---------------------\n\n                                                                           64,793,467                      168,333\n                                                                   ===================        =====================\nCOMMITMENTS\n\nMEMBERS' EQUITY\n     Members' capital                                                      76,474,111                   76,474,111\n     Earnings (deficit) accumulated during the development stage          (3,416,750)                      300,850\n                                                                   -------------------        ---------------------\n                                                                           73,057,361                   76,774,961\n                                                                   -------------------        ---------------------\n\n                                                                   $      188,141,367          $        81,947,774\n                                                                   ===================        =====================\n\nSee Notes to Financial Statements.\n\n\n\n                                       41\n\n</pre>\n<hr>\n<pre>\n\n<b>Southwest Iowa Renewable Energy, LLC\n\n(A Development Stage Company)\n\nStatements of Operations</b>\n---------------------------------------------------------------------------------------------------------------------\n\n                                                                                                     March 28, 2005\n                                                                                                        (Date of\n                                                       Year Ended               Year Ended           Inception) to\n                                                      September 30,           September 30,          September 30,\n                                                          2008                     2007                   2008\n                                                  -------------------------------------------------------------------\n\n\nRevenues                                          $              ---        $            ---      $              ---\n                                                  -------------------       -----------------     -------------------\n\nGeneral and administrative expenses                        4,008,188               2,222,327               7,151,298\n                                                  -------------------       -----------------     -------------------\n     (Loss) before other income                          (4,008,188)             (2,222,327)             (7,151,298)\n                                                  -------------------       -----------------     -------------------\n\nOther income and (expense):\n     Grant                                                   136,513                 114,235                 305,994\n     Interest income                                         136,850               3,187,653               3,384,892\n     Miscellaneous income                                     17,225                  37,238                  77,746\n     Loss on disposal of property                                ---                (34,084)                (34,084)\n                                                  -------------------       -----------------     -------------------\n                                                             290,588               3,305,042               3,734,548\n                                                  -------------------       -----------------     -------------------\n\n         Net income (loss)                        $      (3,717,600)        $      1,082,715      $      (3,416,750)\n                                                  ===================       =================     ===================\n\nWeighted average units outstanding                            13,139                  11,999                   7,323\n                                                  ===================       =================     ===================\n\nNet income (loss) per unit - basic and diluted             ($282.94)                  $90.23               ($466.58)\n                                                  ===================       =================     ===================\n\n\nSee Notes to Financial Statements.\n\n\n\n                                       42\n\n\n</pre>\n<hr>\n<pre>\n\n<b>Southwest Iowa Renewable Energy, LLC\n\n(A Development Stage Company)\n\nStatements of Members' Equity</b>\n-----------------------------------------------------------------------------------------------------------------------\n                                                                                    Earnings\n                                                                                    (Deficit)\n                                                                                   Accumulated\n                                                                                   During the\n                                                                                   Development\n                                                          Members' Capital            Stage                 Total\n                                                          -------------------------------------------------------------\n\nBalance, March 28, 2005 (date of inception)               $            ---       $           ---                   ---                                                                                          $\n     Issuance of 285 Series A membership units                     570,000                   ---               570,000\n     Subscription receivable for 257 Series A\n     membership units                                            (514,000)                   ---             (514,000)\n     Net (loss)                                                        ---              (29,634)              (29,634)\n                                                          -----------------      ----------------      ----------------\n\nBalance, September 30, 2005                                         56,000              (29,634)                26,366\n     Receipt of membership units subscribed                        514,000                   ---               514,000\n     Issuance of 1,047 Series A membership units                 5,202,000                   ---             5,202,000\n     Issuance of 1 Series B membership unit                          6,000                   ---                 6,000\n     Net (loss)                                                                        (752,231)             (752,231)\n                                                          -----------------      ----------------      ----------------\n\nBalance, September 30, 2006                                      5,778,000             (781,865)             4,996,135\n     Issuance of 7,473 Series A membership units                44,838,000                   ---            44,838,000\n     Issuance of 3,333 Series B membership units                19,998,000                   ---            19,998,000\n     Issuance of 1,000 Series C membership units                 6,000,000                   ---             6,000,000\n     Offering costs                                              (139,889)                   ---             (139,889)\n     Net income                                                        ---             1,082,715             1,082,715\n                                                          -----------------      ----------------      ----------------\n\nBalance, September 30, 2007                                     76,474,111               300,850            76,774,961\n     Net (loss)                                                        ---           (3,717,600)           (3,717,600)\n                                                          -----------------      ----------------      ----------------\n\nBalance, September 30, 2008                               $     76,474,111       $   (3,416,750)            73,057,361                                                                                          $\n                                                          =================      ================      ================\n\nSee Notes to Financial Statements.\n\n\n\n                                       43\n</pre>\n<hr>\n<pre>\n\n\n\n<b>\nSouthwest Iowa Renewable Energy, LLC\n\n(A Development Stage Company)\n\nStatements of Cash Flows</b>\n---------------------------------------------------------------------------------------------------------------------\n                                                                                                         March 28,\n                                                                                                        2005 (Date\n                                                                                                            of\n                                                            Year Ended            Year Ended            Inception)\n                                                             September             September           to September\n                                                             30, 2008              30, 2007              30, 2008\n                                                        -- -------------- --- -- -------------- --- -- --------------\n\nCASH FLOWS FROM OPERATING ACTIVITIES\nNet income (loss)                                       $    (3,717,600)      $      1,082,715      $    (3,416,750)\nAdjustments to reconcile net income (loss) to net\ncash provided by (used in) operating activities:\n     Depreciation                                                 30,016                 7,071                37,249\n     Loss on disposal of property                                    ---                34,084                34,084\nChanges in working capital components:\n     (Increase) decrease in prepaid expenses and other            81,691             (104,575)              (43,261)\n     Increase in other non-current liabilities                   900,000                   ---               900,000\n     Increase (decrease) in accounts payable                     105,515             (188,669)               162,088\n     Increase (decrease) in accrued expenses                     164,260              (62,306)               207,990\n                                                        -----------------     -----------------     -----------------\nNet cash provided by (used in) operating activities          (2,436,118)               768,320           (2,118,600)\n                                                        -----------------     -----------------     -----------------\n\nCASH FLOWS FROM INVESTING ACTIVITIES\n     Purchase of property and equipment                    (101,270,842)          (53,871,995)         (160,767,267)\n     (Increase) decrease in cash-held for plant\n     construction                                             15,638,542          (15,638,542)                   ---\nIncrease in restricted cash                                  (3,289,949)                   ---           (3,289,949)\nProceeds from sale of property and equipment                         ---             1,415,541             1,415,541\n                                                        -----------------     -----------------     -----------------\n         Net cash (used in) investing activities           (88,922,249)           (68,094,996)         (162,641,675)\n                                                        -----------------     -----------------     -----------------\n\nCASH FLOWS FROM FINANCING ACTIVITIES\n     Proceeds from issuance of membership units                      ---            69,876,000            75,654,000\n     Payments for financing costs                              (785,647)           (1,815,460)           (2,626,493)\n     Payments for offering costs                                     ---                   ---             (139,889)\n     Proceeds from long-term borrowings                       64,161,718               200,000            65,644,968\n     Proceeds from bridge loan                                34,100,000                   ---            34,100,000\n     Payments on long-term borrowings                        (1,303,250)              (11,667)           (1,314,917)\n                                                        -----------------     -----------------     -----------------\n         Net cash provided by financing activities            96,172,821            68,248,873           171,317,669\n                                                        -----------------     -----------------     -----------------\n         Net increase (decrease) in cash and cash              4,814,454               922,197             6,557,394\n         equivalents\n\nCASH AND CASH EQUIVALENTS\n     Beginning                                                 1,742,940               820,743                   ---\n                                                        -----------------     -----------------     -----------------\n     Ending                                             $      6,557,394      $      1,742,940      $      6,557,394\n                                                        =================     =================     =================\n\nSUPPLEMENTAL DISCLOSURES OF NONCASH OPERATING,\nINVESTING AND FINANCING ACTIVITIES\n     Construction in progress included in accounts\n       payable                                          $     13,257,061      $      3,600,927      $     13,257,061\n     Membership units issued for financing costs                     ---               960,000               960,000\n     Interest capitalized and included in long-term\n       debt and accruals                                       2,624,488                   ---             2,624,488\n\nSee Notes to Financial Statements.\n\n\n                                       44\n\n\n</pre>\n<hr>\n<pre>\n<b>\nSouthwest Iowa Renewable Energy, LLC\n\n(A Development Stage Company)\n\nNotes to Financial Statements</b>\n--------------------------------------------------------------------------------\n<b>\nNote 1. Nature of Business and Significant Accounting Policies</b>\n\n<U>Principal  business   activity</U>:   Southwest  Iowa  Renewable  Energy,  LLC  (the\n\"<U>Company</U>\"),  located in Council  Bluffs,  Iowa, was formed in March 2005 to pool\ninvestors to build a 110 million gallon annual  production  dry mill  corn-based\nethanol plant. As of September 30, 2008, the Company is in the development stage\nwith  its  efforts  being  principally   devoted  to   organizational   matters,\nequity-raising activities and construction of the ethanol plant.\n\nA summary of significant accounting policies follows:\n\n   <U>Use of estimates</U>:  The preparation of financial statements in conformity with\n   accounting  principles  generally  accepted  in the United  States of America\n   requires  management  to make  estimates  and  assumptions  that  affect  the\n   reported  amounts of assets and  liabilities  and  disclosure  of  contingent\n   assets  and  liabilities  at the  date of the  financial  statements  and the\n   reported amounts of revenues and expenses during the reporting period. Actual\n   results could differ from those estimates.\n\n   <U>Concentration  of credit risk</U>:  The Company's cash balances are maintained in\n   bank deposit accounts which at times may exceed federally insured limits. The\n   Company has not experienced any losses in such accounts.\n\n   <U>Risks and uncertainties</U>:  The current U.S. recession with its massive layoffs\n   has reduced the nation's demand for energy.  The recent  bankruptcy filing of\n   one  of the  industry's  major  producers  has  resulted  in  great  economic\n   uncertainty about the viability of ethanol.  The ethanol boom of recent years\n   spurred  overcapacity  in the industry and capacity  is currently nearing the\n   Renewable Fuels  Standard  (\"<U>RFS</U>\")  mandates.  The  average  national ethanol\n   spot market  price  has  plunged  over 30% since May 2008.  The drop in crude\n   oil prices from a  record $150 a  barrel to its recent price of less than $40\n   a barrel has  resulted in the price  of reformulated  gasoline blendstock for\n   oxygen  blending  (\"<U>RBOB</U>\")  dropping   below  $1 per gallon in December 2008.\n   With ethanol spot prices exceeding  RBOB  prices the economic  incentives for\n   blenders to continue using  ethanol has  become less advantageous. This could\n   result in a significant reduction in the demand for ethanol.\n\n   As such,  the Company  may need to evaluate  whether  crush  margins  will be\n   sufficient  to operate the plant and  generate  enough debt  service.  In the\n   event crust  margins  become  negative  for an extended  period of time,  the\n   Company may be required to reduce capacity or shut down the plant.\n\n   <U>Cash and cash  equivalents</U>:  The  Company  considers  all highly  liquid debt\n   instruments  purchased with a maturity of three months or less when purchased\n   to be cash equivalents.\n\n   <U>Restricted cash</U>: Restricted cash includes minimum balance required per AgStar\n   Financial  Services,  PCA credit  agreement  contingent  project cost reserve\n   through March 2009.\n\n   <U>Financing  costs</U>:  Financing  costs  associated  with  the  construction  and\n   revolving  loans  discussed  in  Note 3 are  recorded  at  cost  and  include\n   expenditures  directly related to securing debt financing.  The Company began\n   amortizing these costs using the effective  interest method over the terms of\n   the  agreements  in  March,  2008.  The  interest  expense   amortization  is\n   capitalized during the development stage as construction in progress.\n\n   <U>Property  and   equipment</U>:   Property  and   equipment  is  stated  at  cost.\n   Construction in progress is comprised of costs related to the construction of\n   the ethanol plant,  depreciation of such amounts will commence when the plant\n   begins  operations over estimated useful lives ranging from 5 to 40 years. As\n   of  September  30,  2008,  approximately  $4,279,000  of  interest  has  been\n   capitalized. Depreciation is computed using the straight-line method over the\n   following estimated useful lives:\n\n\n\n                                       45\n\n</pre>\n<hr>\n<pre>\n<b>\n\nSouthwest Iowa Renewable Energy, LLC\n\n(A Development Stage Company)\n\nNotes to Financial Statements</b>\n--------------------------------------------------------------------------------\n<b>\nNote 1. Nature of Business and Significant Accounting Policies (Continued)\n\n                                                                Years</b>\n                                                          ------------------\n\n       Office and other equipment                               3 - 7\n\n   Maintenance  and repairs are expenses as  incurred;  major  improvements  and\nbetterments are capitalized.\n\n   <U>Income  taxes</U>:  The Company has  elected to be treated as a  partnership  for\n   federal and state  income tax purposes  and  generally  does not incur income\n   taxes.  Instead, the Company's earnings and losses are included in the income\n   tax returns of the members.  Therefore, no provision or liability for federal\n   or state income taxes has been included in these financial statements.\n\n   <U>Net income  (loss) per unit</U>:  Earnings  (loss) per unit have been computed on\n   the basis of the weighted  average  number of units  outstanding  during each\n   period presented.\n\n   <U>Grant  income</U>:  The  Company  recognizes  grant  income as other  income  for\n   reimbursement of expenses  incurred upon complying with the conditions of the\n   grant.\n\n   <U>Organizational   costs  and  startup   costs</U>:   The  Company   expenses   all\n   organizational and startup costs as incurred.\n\n   <U>Fair value of financial  instruments</U>:  The carrying  amounts of cash and cash\n   equivalents,  accounts payable and accrued  expenses  approximate fair value.\n   The carrying  amount of long-term  debt  approximates  fair value because the\n   interest rates fluctuate with market rates.\n\nNew accounting pronouncements:\n\nIn September  2006, the Financial  Accounting  Standards  Board (\"<U>FASB</U>\")  issued\nStatement No.157,  Fair Value Measurement (\"FAS 157\"). While this statement does\nnot require new fair value  measurements,  it provides guidance on applying fair\nvalue and expands  required  disclosures.  FAS 157 is effective  for the Company\nbeginning  in the first  quarter  of  fiscal  2009.  The  Company  is  currently\nassessing the impact FAS 157 may have on the Company's financial statements.\n\nIn February  2007, the Financial  Accounting  Standards  Board  (\"<U>FASB</U>\")  issued\nstatement  No.159,  The Fair Value  Option for  Financial  Assets and  Financial\nLiabilities (\"<U>FAS 159</U>\"). This statement,  which is expected to expand fair value\nmeasurement,  permits  entities to choose to measure many financial  instruments\nand  certain  other items at fair value.  FAS 159 is  effective  for the Company\nbeginning in the first fiscal  quarter of 2009. We are  currently  assessing the\nimpact FAS 159 may have on our financial statements.\n\nIn March  2008,  the FASB issued SFAS No.  161,  \"Disclosures  about  Derivative\nInstruments  and Hedging  Activities.\"  The new  standard is intended to improve\nfinancial  reporting  about  derivative  instruments  and hedging  activities by\nrequiring  enhanced  disclosures to enable investors to better  understand their\neffects on an  entity's  financial  position,  financial  performance,  and cash\nflows.  It is effective  for  financial  statements  issued for fiscal years and\ninterim  periods  beginning  after  November  15, 2008,  with early  application\nencouraged. We do not expect the adoption SFAS No. 161 to have a material impact\non our financial statements.\n<b>\nNote 2. Members' Equity</b>\n\nThe Company was formed on March 28, 2005 to have a perpetual  life with no limit\non the number of authorized  units. The Company was initially  capitalized by 19\nmanagement  committee  members  who  contributed  an  aggregate  of  $570,000 in\nexchange for 285 Series A membership units. In December 2005, the Company issued\nan additional 360 Series A membership units in exchange for $1,080,000. In March\n2006, the Company completed a private\n\n\n                                       46\n\n</pre>\n<hr>\n<pre>\n<b>\nSouthwest Iowa Renewable Energy, LLC\n\n(A Development Stage Company)\n\nNotes to Financial Statements</b>\n--------------------------------------------------------------------------------\n<b>\nNote 2. Members' Equity (Continued)\n</b>\nplacement  offering  with one  membership  unit at $6,000  being at risk and the\nremaining  investment held in escrow until closing of the offering.  The Company\napproved  and  issued 687  Series A and 1 Series B at risk  membership  units at\n$6,000 per unit for a total of  $4,128,000.  The offering was closed in November\n2006 with the  issuance  of 7,313  Series A  membership  units,  3,333  Series B\nmembership units and 1,000 Series C membership units for a total of $69,876,000.\n\nIn May 2007, 25 Series A membership units were issued to a development group for\nits  efforts in the  development  and  advancement  of the ethanol  project.  In\naddition, in May 2007, pursuant to terms of a management agreement, 135 Series A\nmembership  units  were  issued to a  related  party,  as part of a  contractual\nsuccess fee  arrangement  which  provided that upon actual  closing of specified\nfinancial  transactions,  the party would  receive a success fee for its efforts\nrelating to securing  the  Company's  financing.  The success fee was to be paid\none-half in cash and one-half in membership units.\n\nAt September 30, 2008 and 2007 outstanding membership units were:\n\n------------------------------------------------------------------\nSeries A Units                                      8,805\nSeries B Units                                      3,334\nSeries C Units                                      1,000\n\nThe  Series A, B and C unit  holders  all vote on  certain  matters  with  equal\nrights.  The Member  holding Series B units has the right to elect the number of\nDirectors out of those seven  directorships  equal to the proportion of Series B\nunits held as compared to the number of all  outstanding  units (this  provision\npresently entitles the Series B Member to elect two Directors), and the Series B\nMember  retains  the right to always  elect at least one  Director.  The  Member\nholding  Series C units has the right to elect one  Director.  If Series E Units\nare issued as described  below, the Series E Member has the right to elect up to\nthree of the seven Directors.  The Members holding Series A units have the right\nto elect the balance of the  Directors not elected by the Series B, Series C and\nSeries E Members (presently the Series A Members may elect four Directors).\n\nEffective  March 7, 2008,  the  Company  entered  into a Series C Unit  Issuance\nAgreement (the \"<U>Series C Agreemen</U>t\")  with ICM, Inc. (\"<U>ICM</U>\") and a Series E Unit\nIssuance  Agreement  (the  \"Series  E  Agreement\",  together  with the  Series C\nAgreement,  the \"<U>Unit  Issuance  Agreements</U>\")  with Bunge  North  America,  Inc.\n(\"<U>Bunge</U>\")  in  connection  with the LCs (see Note 3).  Under  the Unit  Issuance\nAgreements,  the  Company  has  agreed  to pay  Bunge and ICM each a fee for the\nissuances  of their  respective  LCs equal to 6% per annum of the  undrawn  face\namount of their  respective LCs. The Unit Issuance  Agreements  provide that the\nCompany is to use its best efforts to raise funds  through a subsequent  private\nplacement  offering of Units (the  \"<U>Private  Placemen</U>t\"),  or such other form of\nequity or debt financing as the Company's Board of Directors may deem necessary,\nin an amount sufficient to pay off the Bridge Loan (see Note 3) in full prior to\nmaturity. If ICM and Bunge do not extend the maturity of the LCs the LCs will be\ndrawn upon as  discussed  below or if Bunge or ICM make any  payment to Commerce\nBank,  N.A. (the Bridge  Lender) that reduces  amounts owed by the Company under\nthe Bridge Loan (each, a \"<U>Bridge Loan  Payment</U>\"),  the Unit Issuance  Agreements\nprovide  that the  Company  will  immediately  reimburse  Bunge  and/or  ICM, as\napplicable, for the amount of such Bridge Loan Payment by issuing Units to Bunge\nand ICM, as further described below. Any extension of the maturity of the LCs by\nICM or Bunge would require approval by the Company's lenders.\n\nUnder the Series C Agreement,  if ICM makes a Bridge Loan  Payment,  the Company\nwill immediately issue Series C Units to ICM based on a Unit price that is equal\nto the lesser of $3,000 or one half (1/2) of the lowest  purchase  price paid by\nany  party  for a Unit who  acquired  (or who has  entered  into any  agreement,\ninstrument or document to\n\n                                       47\n\n</pre>\n<hr>\n<pre>\n\n<b>\nSouthwest Iowa Renewable Energy, LLC\n\n(A Development Stage Company)\n\nNotes to Financial Statements</b>\n--------------------------------------------------------------------------------\n<b>\nNote 2. Members' Equity (Continued)</b>\n\nacquire)  such Unit  after the date of the Series C  Agreement  but prior to the\ndate of any Bridge Loan  Payment  made by ICM.  The Series C  Agreement  further\nprovides  that ICM has the right to  purchase  its  pro-rata  share of any Units\nissued by the Company at any time after the date of the Series C Agreement.\n\nUnder the Series E Agreement,  if Bunge makes a Bridge Loan Payment, the Company\nwill  immediately  issue  Series E Units to Bunge  based on a Unit price that is\nequal to the  lesser of $3,000 or one half (1/2) of the  lowest  purchase  price\npaid  by any  party  for a Unit  who  acquired  (or  who has  entered  into  any\nagreement,  instrument  or document to acquire)  such Unit after the date of the\nSeries E  Agreement  but prior to the date of any Bridge  Loan  Payment  made by\nBunge.  The  Series E  Agreement  further  provides  that Bunge has the right to\npurchase its pro-rata share of any Units issued by the Company at any time after\nthe date of the Series E Agreement.\n<b>\nNote 3. Construction and Revolving Loan/Credit Agreements</b>\n\nIn May  2007 and  amended  as  noted  below,  the  Company  entered  into a loan\ncommitment with a lender for $126,000,000  senior secured debt,  consisting of a\n$111,000,000  construction loan and a $15,000,000  revolving line of credit. The\nCredit  Facility  provides for a loan up to $1,000,000 on a revolving basis (the\n\"Swingline  Revolver\").  Subsequent to year-end,  in December 2008 we executed a\nsecond  amendment  to our Credit  Agreement  that granted us early access to our\nseasonal  Revolving  Line of Credit.  The  amendment  grants access to the funds\nprior to the plant being operational. A borrowing base limitation is included in\nthe agreement that limits the availability of funds to the lesser of $15,000,000\nor 75 percent of eligible accounts receivable and eligible inventory. Letters of\ncredit  pertaining to the construction may be drawn on the construction loan not\nto exceed  $5,000,000 in aggregate.  Borrowings  under the  construction  credit\nfacility  agreement  include a variable  interest rate based on LIBOR plus 3.65%\nfor each advance  under the  agreement.  Upon  completion of  construction,  the\nconstruction  loan may be segmented  into two credit  facilities,  an amortizing\nterm facility of $101,000,000 and a revolving term facility of $10,000,000. Upon\nconversion,  the Company has the option of converting  50% of the term note into\nfixed rate loans at the lender's bonds rate plus 3.25%.  The portion of the term\nloan not fixed and the term revolving line of credit will accrue  interest equal\nto LIBOR plus 3.45%.  LIBOR at September 30, 2008 was 2.49%. The credit facility\nand revolving credit agreement  require the maintenance of certain financial and\nnonfinancial  covenants.  Borrowings under this agreement are  collateralized by\nsubstantially  all of the  Company's  assets.  The  construction/revolving  term\ncredit facility require monthly  principal  payments  starting the seventh month\nfollowing  conversion of the  construction  loan to a term loan.  The conversion\nwill  occur 60 days  after  completion  of the  construction.  The loan  will be\namortized over 114 months and will mature five years after the conversion  date.\nThe revolving term credit  agreement  expires in five years after the conversion\nof the loan at which  time the  principal  outstanding  is due.  Borrowings  are\nsubject  to  borrowing  base  restrictions  as  defined  in the  agreement.  The\nagreements also include certain prepayment  penalties.  As of September 30, 2008\nthe   outstanding   balance  under  the  Credit   Agreement  was   approximately\n$64,162,000.  In addition to all other payments due under the Credit  Agreement,\nthe Company also agreed to pay, beginning at the end of the third fiscal quarter\nafter the  Conversion  Date, the amount equal to 65% of our Excess Cash Flow (as\ndefined in the Credit  Agreement),  up to a total of  $4,000,000  per year,  and\n$16,000,000 over the term of the Credit Agreement.\n\nOn March 7, 2008, the Company amended the terms of the Credit Agreement obtained\na bridge  loan  from the  Bridge  Lender  in the  maximum  principal  amount  of\n$36,000,000 (the \"<U>Bridge Loan</U>\").  The Bridge Loan debt is secured by two letters\nof credit, described below.\n\nBunge  caused its bank to issue a letter of credit in the amount equal to 76% of\nthe maximum  principal  amount of the Bridge Loan in favor of the Bridge  Lender\n(the  \"<U>Bunge  LC</U>\"),  and ICM caused its  lender to  similarly  issue a letter of\ncredit in the amount equal to 24% of the maximum  principal amount of the Bridge\nLoan in favor of the Bridge  Lender (the \"<U>ICM LC</U>\" and,  together  with the Bunge\nLC, the \"<U>LCs</U>\").  Both LCs expire on March 16, 2009,  and the Bridge  Lender will\nonly draw  against  the LCs to the extent that the  Company  defaults  under the\nBridge Loan or if the Company has not repaid the Bridge Loan in full by March 1,\n2009.  In the event the Bridge  Lender draws  against the LCs, the amounts drawn\nwill be in proportion to Bunge's and ICM's respective ownership of the Company's\n\n                                       48\n\n</pre>\n<hr>\n<pre>\n\n\n<b>Southwest Iowa Renewable Energy, LLC\n\n(A Development Stage Company)\n\nNotes to Financial Statements\n--------------------------------------------------------------------------------</b>\n\n<b>\nNote 3. Construction and Revolving Loan/Credit Agreements (Continued)</b>\n\nUnits which are not Series A--76% and 24%,  respectively.  As the Company repays\nthe principal of the Bridge Loan, the LCs' stated amounts will  automatically be\nreduced  in  the  same  proportion.  As of  September  30,  2008,  there  was an\noutstanding  principal and interest balance of approximately  $34,762,000  under\nthe Bridge Loan.\n\nIn connection  with the Bridge Loan, the Company  entered into the Unit Issuance\nAgreements  with Bunge and ICM,  which govern the  Company's  repayment of Bunge\nand/or  ICM,  as the case may be, in the event the LCs are drawn  upon (see Note\n2).\n<b>\nNote 4. Long-Term Debt and Subsequent Event</b>\n\nLong-term debt consists of the following as of September 30, 2008 and 2007:\n\n                                                                              2008                      2007\n                                                                      --------------------- --- ----------------------\n\nNote payable to Pottawattamie  County, Iowa,  non-interest bearing,\ndue 180 days after ethanol production begins or January 31, 2008,\nwhichever comes first, secured by land                                 $               ---       $          1,283,250\n\nBridge Loan  payable to Commerce  Bank,  N.A.,  bearing  interest at\nLIBOR plus .80% (3.29% at September  30, 2008)  through  maturity on\nMarch 1, 2009,  secured by two  letters  of credit as  described  in\nNote 3.                                                                         34,761,857                        ---\n                                                                      ---------------------     ----------------------\n\n$200,000  Note  payable  to  Iowa  Department  Economic  Development\n(\"<U>IDED</U>\")   non-interest  bearing  monthly  payments  of  $1,667  due\nthrough maturity date of March 2012 on non-forgivable portion. (A)                 168,333                    188,333\n\nConstruction loan payable to AgStar Financial  Services (PCA),\nbearing interest at LIBOR plus 3.65% (6.14% at September 30,\n2008).  See maturity and collateral discussed in Note 3. (B)          $         64,161,717       $                ---\n                                                                      ---------------------     ----------------------\n                                                                      $         99,091,907      $           1,471,583\n\nLess current maturities                                                       (35,198,440)                (1,303,250)\n                                                                      ---------------------     ----------------------\n                                                                      $         63,893,467      $             168,333\n                                                                      =====================     ======================\n\n\n(A)  This debt is comprised of two  components  under the Master  Contract  (the\n     \"<U>Master Contract</U>\") dated November 21, 2006 and amended June 5, 2008 between\n     the Company and the IDED. A $100,000 loan is non  interest-bearing  and due\n     in monthly payments of $1,667 beginning April 2007, with a final payment of\n     $1,667 due March 2012; and a $100,000 forgivable loan. Both notes under the\n     Master Contract are  collateralized  by substantially  all of the Company's\n     assets and subordinate to the above $126,000,000 financial institution debt\n     and construction and revolving loan/credit  agreements discussed in Note 3.\n     The $100,000  forgivable  loan may be forgiven upon IDED's  confirmation of\n     the creation and  retention  of  qualifying  jobs as provided in the Master\n     Contract.  If the  Company  does not meet the  requirements  of the  Master\n     Contract, the note is due on an agreed upon payment schedule.\n\n\n\n                                       49\n\n</pre>\n<hr>\n<pre>\n<b>\nSouthwest Iowa Renewable Energy, LLC\n\n(A Development Stage Company)\n\nNotes to Financial Statements</b>\n--------------------------------------------------------------------------------\n\n<b>\nNote 4. Long-Term Debt and Subsequent Event (Continued)</b>\n\n(B)  Subsequent to year-end,  the Company drew on the AgStar Financial  Services\n     (PCA)  revolving  line  of  credit  discussed  in Note 3 in the  amount  of\n     $6,000,000. This amount matures five years after conversion and is included\n     in maturities below.\n\nMaturities  of long-term  debt as of September 30, 2008 are as follows below and\nassume conversion of the construction/revolving term credit facility in February\n2009 with  principal  payments  beginning  September 2009 as discussed in Note 3\namortized over 114 months.\n\n     Years ending September 30:\n\n         2009                                    $       35,198,440\n         2010                                             5,187,577\n         2011                                             5,512,309\n         2012                                             5,845,781\n         2013                                             6,204,276\n              Thereafter                                 47,143,524\n                                                 -------------------\n                                                       $105,091,907\n                                                 ===================\n<b>\nNote 5.  Lease Commitments and Subsequent Event</b>\n\nIn June 2007, the Company  entered an operating  lease  agreement with a related\nparty and  member  for the lease of 320  ethanol  tank cars and 300  distillers'\ngrain  cars.  The  lease  begins  two  months  prior to  start-up  of the  plant\noperation,  continues  for  a  term  of  ten  years,  and  terminates  upon  the\ntermination  of the final car lease.  The lease  calls for  monthly  payments of\napproximately  $450,000.  There  was no  rental  expense  for  the  years  ended\nSeptember  30,  2008 and 2007,  and the  period  from  March 28,  2005  (date of\ninception) to September 30, 2008.\n\nThe Company leases vehicles and equipment under long-term  operating leases from\nunrelated third parties.  The original terms of the leases are 36 months to five\nyears beginning March 2007 and through various dates ending May 2013. The leases\ncall for monthly  payments  ranging from $152 to $1,136.  Rental expense for the\nyears ending  September 30, 2008,  2007 and the period from March 28, 2005 (date\nof inception)  to September  30, 2008 was  approximately  $20,000,  $7,000,  and\n$27,000, respectively.\n\nSubsequent  to year-end,  the Company  entered into an agreement  with a related\nparty and member for the lease of a grain  elevator  located in Council  Bluffs,\nIowa, for  approximately  $67,000 per month.  The lease has an initial  one-year\nterm,  which may be renewed  for  successive  one-year  terms upon the  parties'\nagreement.\n\nAlso subsequent to year-end,  the Company entered into a lease agreement with an\nunrelated  party for the lease of a  locomotive  for  approximately  $11,000 per\nmonth. The lease has a five-year term.\n\nApproximate  future minimum  operating lease payments  including  leases entered\ninto subsequent to year-end are as follows:\n\n     Years ending September 30:\n\n         2009                       $           5,235,000\n         2010                                   5,684,000\n         2011                                   6,512,000\n         2012                                   6,494,000\n         2013                                   6,493,000\n              Thereafter                       26,705,000\n                                        ------------------\n                                              $55,123,000\n                                        ==================\n\n\n\n                                      50\n</pre>\n<hr>\n<pre>\n<b>\nSouthwest Iowa Renewable Energy, LLC\n\n(A Development Stage Company)\n\nNotes to Financial Statements</b>\n--------------------------------------------------------------------------------\n<b>\nNote 6. Related-Party Transactions and Subsequent Events</b>\n\nIn September  2005, the Company  entered into an agreement that expired May 2007\n(and was not  renewed)  with a  management  company  that  included a member and\ndirector on the board of  directors,  for  project  development  services  for a\nmonthly  fee of  $10,000  per  month,  plus  actual  travel  and other  approved\nexpenses.  The agreement  also  included a fee of up to $1,600,000  for securing\nfinancing  for the  construction  of a 110  gallon  per year  ethanol  facility.\nFinancial close of the project occurred during the year ended September 30, 2007\nand 135 Series A membership units were issued directly to the party's principals\nfor  $810,000  of the  $1,600,000  fee.  The  total fee of  $1,600,000  has been\ncapitalized as financing costs.\n\nIn September  2006,  the Company  entered into a  design-build  agreement with a\nrelated  party,  a member  of the  Company,  for a  lump-sum  contract  price of\n$118,000,000 (the \"<U>Construction Contract</U>\"). Under the Construction Contract, the\nCompany was  required  to make a down  payment of 10% of the  original  contract\nprice which  $2,000,000  was paid at the  delivery  of the letter of intent,  an\nadditional  $2,000,000  was paid in November  2006 when the Company broke escrow\nand the  remaining  $7,800,000  of the 10% was  paid in  January  2007.  Monthly\napplications  are submitted  for work  performed,  subject to  retainage.  As of\nSeptember 30, 2008 and 2007, the Company incurred approximately $134,025,000 and\n$33,051,000 of construction  in progress,  respectively  under the  Construction\nContract.\n\nThe Company  entered into an agreement in October 2006 with a related  party,  a\nmember of the Company,  to purchase all of the  distiller's  grains with soluble\n(\"<U>DG</U>S\")  produced  by the plant.  The  Company  agreed to pay a  purchase  price\nsubject to the sales price,  transportation costs, rail lease charge and a fixed\nrate  marketing  fee for the DGS  produced.  The  agreement  commences  when the\nCompany  begins  producing  DGS  and  continues  for  ten  years  when  it  will\nautomatically  renew for successive  three-year  terms unless a 180-day  written\nnotice is given of either party's election not to renew before the expiration of\nthe initial term or the then current  renewal term. In addition,  the Company is\nrequired to deliver written estimates of its anticipated production annually and\nmonthly.  The  Company is  required  to pay a minimum  annual  marketing  fee of\n$150,000.  Beginning  on the  third  anniversary  of the  effective  date of the\nagreement and  thereafter,  the annual minimum amount and the purchase price may\nbe adjusted  based on terms within the contract.  Either party may terminate the\nagreement based on specific guidelines in the agreement.\n\nIn October 2006,  the Company  entered into an agreement with a company in which\nBunge  holds a  membership  interest,  AGRI-Bunge,  LLC,  to  procure  all grain\nrequired for the Company's  ethanol  plant.  The Company agreed to pay an agency\nfee mutually agreed to by both parties for corn delivered by truck or rail, with\na minimum  annual fee. On December  15,  2008,  this agreement  was  temporarily\nsuspended and replaced with a grain supply  agreement  between the parties.  The\nrevised  agreement  has a  term  of  ten  years  and  automatically  renews  for\nsuccessive  three-year  terms unless a 180-day written notice is given by either\nparty.  The Company  agreed to pay an annual  minimum fee of $675,000  under the\nrevised agreement.\n\nAlso subsequent to year-end,  the Company and Bunge, a related party and member,\nentered  into various  agreements.  Under the lease  agreement,  the Company has\nleased  from  Bunge a grain  elevator  located  in  Council  Bluffs,  Iowa,  for\napproximately  $67,000  per  month.  See Note 5. In  connection  with the  lease\nagreement, the Company entered into a grain purchase agreement,  under which the\nCompany  agreed to purchase the grain  inventory  at the grain  elevator and the\ngrain inventory located in the Company's  on-site storage facility.  The Company\npurchased  approximately  1,900,000 bushels of at an approximate market value of\n$6,000,000.\n\n\n                                      51\n</pre>\n<hr>\n<pre>\n\n<b>\nSouthwest Iowa Renewable Energy, LLC\n\n(A Development Stage Company)\n\nNotes to Financial Statements</b>\n--------------------------------------------------------------------------------\n<b>\nNote 6. Related-Party Transactions and Subsequent Events (Continued)</b>\n\nUnder the ethanol purchase  agreement,  the Company has agreed to sell Bunge all\nof the ethanol  produced at the ethanol plant,  and Bunge has agreed to purchase\nthe same, up to the ethanol plant's nameplate capacity of 110,000,000  gallons a\nyear.  The Company will pay Bunge a per-gallon fee for ethanol sold by Bunge for\nthe Company under this  agreement,  subject to a minimum  annual fee of $750,000\nand adjustments  according to specified  indexes after three years.  The initial\nterm of the agreement,  which will commence upon the termination of that Ethanol\nMerchandising  Agreement between the Company and Lansing Ethanol Services,  LLC,\nis three years and it will automatically  renew for successive  three-year terms\nunless one party  provides the other notice of their  election to terminate  180\ndays prior to the end of the term.\n\nUnder the risk management  services  agreement,  Bunge has agreed to provide the\nCompany with  assistance in managing its  commodity  price risks for a quarterly\nfee of  $75,000.  The  agreement  has an  initial  term of three  years and will\nautomatically  renew for successive three year terms,  unless one party provides\nthe other notice of their election to terminate 180 days prior to the end of the\nterm.\n\nOn January 30, 2008, the Company and Bunge entered into an agreement under which\nBunge agreed to provide engineering  support to the project,  provide reports to\nthe Company's lender and assist the Company with requests by the lender's agent.\nThe Company will pay, in addition to Bunge's out of pocket  expenses,  an hourly\nfee of $95 for such  services.  The  agreement  terminates  upon the  earlier of\ncompletion  of the ethanol  plant or December 31, 2008.  Bunge may terminate the\nagreement  at  any  time,  and  the  Company  may  terminate   under   specified\ncircumstances. Expenses of $101,000 and none have been paid under this agreement\nfor the years ended September 30, 2008 and 2007, respectively,  and $101,000 for\nthe period from March 28, 2005 (date of inception) to September 30, 2008.\n\nIn connection  with obtaining the Bridge Loan, the Company entered into the Unit\nIssuance Agreements, as described above in Note 2.\n<b>\nNote 7. Commitments</b>\n\nThe total cost of the project,  including the  construction of the ethanol plant\nand start-up expenses, is expected to be approximately $225,000,000. The Company\nis funding the development of the ethanol plant by using the total equity raised\nof  $75,654,000,  long term financing of  approximately  $126,000,000  under the\nCredit  Agreement and bridge financing of  approximately  $36,000,000  under the\nBridge Loan.\n\nIn September 2006, the Company entered into the Construction  Contract (See Note\n6). In 2008,  seven change orders in the amount of $29,247,000 were issued under\nthe  Construction  Contract.  As of  September  30, 2008,  the Company  incurred\napproximately   $134,025,000   of   construction   in  progress.   Approximately\n$13,222,000  future  commitment  remains  as of  September  30,  2008,  which is\nexpected to be paid in calendar  2008.  There are  approximately  $11,999,000 in\naccounts and retainage  payable under the Construction  Contract as of September\n30, 2008.\n\nThe Company entered into a contract with and unrelated party the construction of\na grain and DGS storage  facility in June of 2007 for  $9,745,426.  Between June\n2007 and  December  2008,  five  change  orders were  issued  which  reduced the\ncontract  amount to  $9,661,438.  As of September 30, 2008,  $9,561,438 has been\npaid  with   approximately   $100,000   remaining  in  the   contracted   price.\nApproximately  $100,000  was  included  in  accounts  and  retainage  payable at\nSeptember 30, 2008.\n\n\n\n                                      52\n\n\n</pre>\n<hr>\n<pre>\n\n<b>\nSouthwest Iowa Renewable Energy, LLC\n\n(A Development Stage Company)\n\nNotes to Financial Statements</b>\n--------------------------------------------------------------------------------\n<b>\nNote 7. Commitments (Continued)</b>\n\n\nThe Company entered into a contract with an unrelated party for  construction of\na rail line in November 2007. The original  contract amount was for $971,565 and\na change order was issued July 2008 in the amount of  $227,671.  As of September\n30, 2008,  $821,198  has been paid with  $378,038  remaining  in the  contracted\nprice.  Approximately  $66,000 was included in accounts and retainage payable at\nSeptember 30, 2008.\n\nThe Company entered into a contract with an unrelated party in July 2008 for the\nconstruction  of parking lots and roads.  The contract amount was for $1,273,944\nand as of September  2008 $291,393 has been paid with $982,551  remaining in the\ncontracted price.  Approximately $414,000 was included in accounts and retainage\npayable at September 30, 2008.\n\nThe Company  entered into a contract in March 2008 with an  unrelated  party for\ninstallation of the electrical system for the plant's grain storage and handling\nsystem  The  contract  amount  was  for $  1,107,566  and as of  September  2008\n$1,003,762 has been paid with $103,804  remaining in the contracted price. There\nwere no amounts included in accounts payable at September 30, 2008.\n\nThe Company also entered into various other  contracts  during 2007 and 2008 for\nthe  construction  of  the  ethanol  plant,  office  building,  rail  track  and\nacquisition  of  equipment  totaling  approximately  $2,564,000  with  a  future\ncommitment  of  approximately  $1,624,000  as of September  30,  2008,  which is\nexpected to be paid in calendar 2008. Of this total,  approximately  $354,000 is\nincluded in accounts and retainage payable as of September 30, 2008.\n\nIn November 2006, the Company entered into an agreement with an unrelated entity\nfor  marketing,  selling and  distributing  all of the  ethanol  produced by the\nCompany.  The Company agreed to pay a fee mutually agreed to by both parties for\neach gallon of ethanol sold. The Company notified the entity that this agreement\nwill be terminated six months after the plant starts production. As of September\n30, 2008, the ethanol plant is not operational and no amounts are due under this\nagreement.  The  Company is  obligated  to honor the  agreement  for a six-month\nperiod without any penalties or termination fees.\n\nThe Company has entered  into a steam  contract  with an  unrelated  party dated\nJanuary  22,  2007.  The  agreement  was  amended  October  2008 to  modify  the\ncircumstances  under  which the steam  service  can be  interrupted.  The vendor\nagreed to provide the steam  required by the Company,  up to 475,000  pounds per\nhour. The Company agreed to pay a net energy rate for all steam service provided\nunder the steam contract and a monthly demand charge for condensate not returned\n(steam delivered less the condensation returned). The net energy rate is set for\nthe first three years then adjusted each year beginning on the third anniversary\ndate. The steam contract will remain in effect for ten years from the earlier of\nthe  date  the  Company  commences  a  continuous  grind  of  corn  for  ethanol\nproduction,  or February 1, 2009.  No expenses  have been incurred to date under\nthis agreement.\n\nIn January 2007, the Company  entered into an agreement with an unrelated  party\nto provide the transportation of the Company's  commodities from Council Bluffs,\nIowa to an agreed upon customer  location.  The agreement  commences on the date\nthat the  contract  is approved by the  Surface  Transportation  Board,  then it\ncontinues for five years and will  automatically  renew for  additional one year\nperiods unless  cancelled by either party by giving a minimum of 90 days written\nnotice prior to the expiration date. The Company agreed to pay a mutually agreed\nupon rate per car. No expenses have been incurred to date under this agreement.\n\n\n\n                                      53\n</pre>\n<hr>\n<pre>\n\n<b>\nSouthwest Iowa Renewable Energy, LLC\n\n(A Development Stage Company)\n\nNotes to Financial Statements</b>\n\n--------------------------------------------------------------------------------\n<b>\nNote 7. Commitments (Continued)</b>\n\nIn October  2007,  the Company  entered  into an  agreement  with an  investment\nbanking firm, an unrelated party, to assist in obtaining  additional equity. The\nCompany's goal is to raise  sufficient  equity to replace the Bridge Loan, which\nis due March 1, 2009, as soon as possible. Initially, the Company is seeking one\nor more  institutional  investors to provide the additional  equity. The Company\nagreed  to pay a monthly  fee of  $10,000  for the  services  of the  investment\nbanking firm until the  agreement is terminated by both parties or the equity is\nraised.  The Company  recorded expense of none,  $135,000,  and $135,000 for the\nyears ended September 30, 2007, 2008 and the period from March 28, 2005 (date of\ninception) to September 30, 2008, respectively under this agreement.\n\nIn April 2008 the Company entered into a firm throughput  service agreement with\na natural gas  supplier,  an unrelated  party,  under which the vendor agreed to\nprovide the natural gas  required  by the  Company,  up to 900 Dth per day.  The\nCompany agreed to pay the maximum  reservation  and commodity  rates as provided\nunder the  vendor's  FERC gas  tariff as revised  from time to time,  as well as\nother additional charges.  The agreement specifies an in-service date of October\n1, 2008,  and the term of the  agreement is seven years.  No payments  have been\nincurred to date under this agreement.\n\nIn March 2008, the Company entered into the Unit Issuance  Agreements,  pursuant\nto  which  the  Company  has  agreed  to pay  Bunge  and ICM  each a fee for the\nissuances  of their  respective  LCs equal to 6% per annum of the  undrawn  face\namount  of their  respective  LCs for a total  annual  amount  of  approximately\n$2,160,000.  For the 12 months ended September 30, 2008, the Company capitalized\n$1,248,000 of interest related to the Unit Issuance Agreements. No payments have\nbeen made as of September 30, 2008 under the Unit Issuance Agreements.\n\nIn July 2008, the Company  entered into a services  agreement with and unrelated\nparty.  Under the terms of the agreement,  the vendor will provide operation and\nmaintenance  services of the Company's natural gas border station. The agreement\nbecame  effective in November  2008 and has a term of one year.  The Company has\nincurred no expense on this contract.\n\nIn August 2008, the Company  entered into an agreement  with an unrelated  party\nwhich  establishes  terms  governing the Company's  purchase of natural gas. The\nagreement  commenced in August 2008 and has a term of two years. The Company has\nincurred no expense on this contract.\n<b>\nItem  9.  Changes  in and  Disagreements  With  Accountants  on  Accounting  and\n          Financial Disclosure.</b>\n\n     There are no items to report.\n<b>\nItem 9A(T). Controls and Procedures.\n</b>\n\n     Our management,  including our President and Chief  Executive  Officer (our\nprincipal executive officer), Mark Drake, along with our Chief Financial Officer\n(our principal financial officer), Cindy Patterson,  have reviewed and evaluated\nthe effectiveness of our disclosure  controls and procedures (as defined in Rule\n13a-15 under the under the Securities  Exchange Act of 1934, as amended),  as of\nSeptember  30,  2008.  Based upon this  review and  evaluation,  these  officers\nbelieve that our disclosure  controls and procedures are presently  effective in\nensuring  that  material  information  related  to  us is  recorded,  processed,\nsummarized and reported within the time periods  required by the forms and rules\nof the Securities and Exchange Commission.\n\n\n                                      54\n</pre>\n<hr>\n<pre>\n\n\n      Our  management,   including  our  principal  executive  officer  and  our\nprincipal  financial  officer,  have  reviewed and  evaluated any changes in our\ninternal control over financial reporting that occurred as of September 30, 2008\nand there has been no  change  that has  materially  affected  or is  reasonably\nlikely to materially affect our internal control over financial reporting.\n\n     This annual  report does not  include a report of  management's  assessment\nregarding internal control over financial  reporting or an attestation report of\nthe  company's  registered  public  accounting  firm due to a transition  period\nestablished by rules of the  Securities  and Exchange  Commission for new public\ncompanies.\n<b>\nItem 9B. Other Information.</b>\n\n     None.\n\n<b>\n                                    PART III</b>\n<b>\nItem 10. Directors, Executive Officers and Corporate Governance.</b>\n\n     The Directors and / or officers listed below under \"Independent Directors T&amp;\nOfficers\"  meet the  \"independent  director\"  standards  applicable to companies\nlisted on the Nasdaq Capital  Market (though the Company's  Units are not listed\non any exchange or quotation system). Contrariwise, those Directors listed below\nunder \"Interested  Directors\" do not meet the \"independent  director\"  standards\napplicable to companies listed on the Nasdaq Capital Market.  With the exception\nof Mr. Scharf, who serves on the Board of Directors of Patriot Coal Corporation,\nnone of the Directors  listed below have served on the board of directors of any\nother company  having a class of securities  registered  under Section 12 of the\nExchange  Act or subject to the  requirements  of Section  15(d) of the Exchange\nAct, nor have any of our Directors served as directors of an investment  company\nregistered  under  the  Investment  Company  Act of 1940.  Under  the  Company's\nOperating  Agreement,  the independent  Directors' terms are staggered such that\none Director will be up for election every year.\n\n     Mr. King purchased nine (9) additional Units on August 1, 2008. This latter\npurchase was not  reflected in a timely Form 3 filing.  However,  on November 4,\n2008, the latter purchase was reflected in a Form 5 filing.\n\n\n<b><i>Independent Directors T&amp; Officers </i>\n\n                    Position(s)      Term of Office\n      Name         Held with the     and Length of                         Principal Occupation(s)\n    and Age           Company         Time Served                            During Past 5 Years</b>\n----------------- ---------------- ------------------- -----------------------------------------------------------------\n\nKarol King, 61    Series A         Term expires        Corn,  popcorn and soybean  farmer near  Mondamin,  Iowa,  since\n                  Director and     2009, Director      1967;  President,  King Agri Sales, Inc. (marketer of chemicals,\n                  Chairman         since November,     fertilizer  and  equipment)  since 1995;  President,  Kelly Lane\n                                   2006                Trucking,   LLC,  since  2007.  Mr.  King  attended  Iowa  State\n                                                       University  and has served on the  Harrison  County  Farm Bureau\n                                                       Board,  the Iowa Corn  Growers  Board,  the Iowa Corn  Promotion\n                                                       Board,  the US Feed Grains Council Board,  the National  Gasohol\n                                                       Commission, and the National Corn Growers Association Board.\n\nTed Bauer,  56    Series A         Term expires        Director,  Secretary  and  Treasurer  of the Company  from March\n                  Director,        2012, Director      2005;  Owner and  operator  of a farming  operation  and hunting\n                  Secretary and    since March         preserve near Audubon,  Iowa, since 1977;  Co-Founder,  and from\n                  Treasurer        2005; Officer       2005 to 2007,  Director,  Templeton  Rye  Spirits LLC; Director,\n                                   Since November,     Iowa  Quality  Producers  Alliance,  since 2003; Vice President,\n                                   2006                West Central Iowa Rural Water, from 2002 to 2007. Mr. Bauer  has\n                                                       an Ag Business degree from Iowa State\n\n\n\n                                                          55\n\n\n\n</pre>\n<hr>\n<pre>\n<b>\n\n                    Position(s)      Term of Office\n      Name         Held with the     and Length of                         Principal Occupation(s)\n    and Age           Company         Time Served                            During Past 5 Years</b>\n----------------- ---------------- ------------------- -----------------------------------------------------------------\n\n                                                       University  and  is a  graduate  of  the  Texas  A&amp;M  TEPAP\n                                                       program.\n\nHubert Houser,    Series A         Term expires        Lifetime  owner  of farm and  cow-calf  operation  located  near\n66                Director         2010, Director      Carson,  Iowa.  Mr.  Houser has  served in the Iowa  Legislature\n                                   since 2005          since 1993, first in the House of Representatives  and currently\n                                                       in the  Senate.  Mr.  Houser  also  served on the  Pottawattamie\n                                                       County Board of Supervisors  from 1979 to 1992,  director of the\n                                                       Riverbend  Industrial  Park,  and  was a  founder  of  the  Iowa\n                                                       Western Development Association and Golden Hills RC&amp;D.\n\nMichael Guttau,   Series A         Term expires        Chairman, Council of Federal Home Loan Banks, Washington,  D.C.;\n62                Director         2011, Director      Chairman  (2008-present), Vice Chairman (2004-2007) and Chairman\n                                   since 2007          of Audit  Committee  (2004-2006) and Chairman of Risk Management\n                                                       Committee  (2007),  Federal Home Loan Bank of Des Monies;  since\n                                                       1972,  various positions with Treynor State Bank,  currently CEO\n                                                       and  Chairman  of the Board;  Superintendent  of  Banking,  Iowa\n                                                       Division  of  Banking,   1995-1999;   Director,   Iowa   Bankers\n                                                       Association,  Iowa Bankers  Mortgage  Corporation,  Iowa Student\n                                                       Loan Liquidity Corp.,  Iowa Business  Development  Finance Corp.\n                                                       and Iowa See Capital  Liquidation  Corp.;  President,  Southwest\n                                                       Iowa Bank  Administration  Institute.  Mr.  Guttau  received his\n                                                       B.S.,  Farm  Operation,  from Iowa State  University in 1969 and\n                                                       completed  numerous  U.S. Army  education  programs from 1969 to\n                                                       1978.\n<b>\n\n<i>Interested Directors</i>\n\n                    Position(s)     Term of Office+\n      Name         Held with the     and Length of                         Principal Occupation(s)\n    and Age           Company         Time Served                            During Past 5 Years\n----------------- ---------------- ------------------- -----------------------------------------------------------------</b>\n\nBailey Ragan,     Series B         Since November 1,   Various  positions with Bunge North America,  Inc. for more than\n52++               Director and     2006               25 years,  currently Vice President and General  Manager,  Bunge\n                  Vice Chairman                        Grain.\n\nMichael Scharf,   Series B         Since November 1,   Senior Vice President and CFO, Bunge North America,  Inc., since\n61++               Director         2006               1989.\n\nGreg Krissek,     Series C         Since November 1,   Director of Government Affairs,  ICM, Inc., since 2006; Director\n45++               Director         2006               of Marketing and Governmental  Affairs,  United Bio Energy, from\n                                                       2003 to 2006;  Chairman,  National  Ethanol  Vehicle  Coalition,\n                                                       2007;  Secretary-Treasurer  of the Board,  Ethanol Promotion and\n                                                       Information  Council  since  2004 -  President  since June 2008;\n                                                       director,  Kansas  Association of Ethanol Processors since 2004;\n                                                       Kansas Energy Council,  since 2004 prior Director of Operations,\n                                                       Kansas Corn Commission;  Assistant Secretary,  Kansas Department\n                                                       of Agriculture,  1997 to 2000. Mr. Krissek represents ICM on the\n                                                       boards of six additional private ethanol companies.  Mr. Krissek\n                                                       received  his B.A. in Economics  from  Rockhurst  University  in\n                                                       Kansas City and his Juris Doctor and MBA from the  University of\n                                                       Denver.\n\n                                                          56\n\n</pre>\n<hr>\n<pre>\n\n+ The Interested  Directors'  terms do not have a specified  number of years, as\nthese Directors are nominated by the Series B Member and the Series C Member, as\ndiscussed further below under Items 11 and 13.\n\n     ++ The information provided below under Item 13, \"Certain Relationships and\nRelated  Transactions,  and Director  Independence,\"  respecting the election of\nMessrs.  Ragan, Scharf and Krissek as Directors,  is incorporated into this Item\n10 by reference.\n<b><i>\nExecutive Officers</i></b>\n<b>\n      Name        Position(s) Held     Length of                          Principal Occupation(s)\n    and Age       with the Company    Time Served                           During Past 5 Years\n</b>\nMark Drake, 50    President and    Since January,      Global  Sales and  Marketing  Manager - Ethanol,  Phibro  Animal\n                  Chief            2007                Health Corporation (global  manufacturer of antimicrobials) from\n                  Executive                            2004 - 2006; Corporate Account Manager,  Novozymes North America\n                  Officer                              (global  biotech  manufacturer  of food and industrial  enzymes)\n                                                       from 2002 -2004;  Marketing  Manager,  Chief Ethanol Fuels, Inc.\n                                                       (fuel grade ethanol  manufacturer)  from 2001 - 2002.  Mr. Drake\n                                                       received  his  Associate of Science,  Chemistry  degree from the\n                                                       College of Lake County.\n\nCindy             Chief            Since August, 2007  Controller,  Golden Triangle Energy,  L.L.C.  (ethanol producer)\nPatterson, 48     Financial                            from 2000 - 2007; auditor, Profit Management Consultants, 1995 -\n                  Officer                              1999;  staff  accountant,  Mitchell  Williams,  1994 - 1995. Ms.\n                                                       Patterson  received  her  BBA  degree  from  the  University  of\n                                                       Georgia,  a  Post  Baccalaureate  in  Accounting  from  Southern\n                                                       Indiana  University  and an MBA in  Management  from Golden Gate\n                                                       University.\n\nThe  Company  has not  adopted a code of ethics  that  applies to its  executive\nofficers, but expects to do so at its next annual Board of Directors meeting.\n<b>\nItem 11. Executive Compensation.\n\n<i>Corporate Governance / Compensation Committee</i></b>\n\n     The  Corporate   Governance  /  Compensation   Committee  (the  \"<U>Governance</U>\n<U>Committee</U>\")  operates under a written  charter,  which the Governance  Committee\napproved on February 15,  2007,  and which was adopted by the Board of Directors\non February 16, 2007 (the \"<U>Governance  Charter</U>\").  The Governance Charter is not\navailable on the Company's  website.  The Governance  Charter  provides that the\nGovernance Committee will annually review and approve the Company's compensation\nprogram for its Directors,  officers and managers.  The Governance  Charter does\nnot exclude from the Governance  Committee's membership Directors who also serve\nas officers of the Board or  Interested  Directors.  Presently,  the  Governance\nCommittee's  membership  consists of Messrs.  Scharf (Chair),  Bauer,  and King.\nAccordingly, Messrs. Bauer and King did participate in recommending to the Board\nthe Compensation Policy. The Governance Charter does provide that the Governance\nCommittee may form and delegate its  responsibilities to subcommittees,  and the\nGovernance  Charter  does not  contemplate  (nor  does it  prohibit)  the use of\ncompensation consultants to assist the Governance Committee in its determination\nof Director, officer and managers' compensation.\n<i>\n     Compensation of Executive Officers</i>\n\n     The Company does not currently provide any Unit options,  Unit appreciation\nrights,  non-equity  incentive  plans,  non-qualified  deferred  compensation or\npension  benefits  to  its  executive  officers.  The  Governance  Committee  is\nresponsible for designing,  reviewing and overseeing the  administration  of the\nCompany's  executive  compensation  program.  As a  development  stage  company,\ncertain  elements  of our  executive  compensation  system  have  not  yet  been\nestablished.  Pursuant  to the  Governance  Charter,  the  Governance  Committee\napproved the  compensation  terms for Mr. Drake and Ms. Patterson when they were\nhired in 2007.\n\n                                       57\n\n</pre>\n<hr>\n<pre>\n\n<b>\n                           Summary Compensation Table</b>\n\n     The  following  table  provides  all  compensation  paid  to our  executive\nofficers in fiscal years 2007 and 2008. None of our officers received any bonus,\nstock or option awards, non-equity incentive plan compensation,  or nonqualified\ndeferred compensation in fiscal years 2007 and 2008.\n<b>\n                                                                   Non-Equity\n                                                                   Incentive     Nonqualified\nName and                                        Stock   Option        Plan         Deferred      All Other\nPrincipal        Fiscal                Bonus    Awards  Awards    Compensation   Compensation   Compensation  Total\nPosition          Year    Salary ($)     ($)     ($)      ($)         ($)        Earnings ($)       ($)        ($)</b>\n\nMark Drake,\nPresident and\nCEO               2008     $150,000      $0       $0      $0           $0             $0        $19,905(1)   $169,905\n\n                  2007     $150,000      $0       $0      $0           $0             $0        $37,080(2)   $187,080\n\n\nCindy\nPatterson, CFO    2008     $100,000      $0       $0      $0           $0             $0            $0       $100,000\n\n                  2007      $90,000      $0       $0      $0           $0             $0        $25,000(3)   $115,000\n\n\n(1) This amount reflects the Company's cost to provide a vehicle for Mr. Drake's\nuse.\n(2) This amount constitutes reimbursements for the officer's relocation expenses\nin the amount of $30,000 and the cost of providing the officer with a vehicle in\nthe  approximate  amount of $7,080 for fiscal year.\n(3) This amount is a signing bonus for the officer.\n<b><i>\nCompensation of Directors</i></b>\n\n     The Company does not provide its Directors with any equity or equity option\nawards,  nor  any  non-equity  incentive  payments  or  deferred   compensation.\nSimilarly,   the  Company  does  not  provide  its  Directors   with  any  other\nperquisites,  \"gross-ups,\"  defined  contribution  plans,  consulting fees, life\ninsurance  premium  payments  or  otherwise.  Following  recommendation  by  the\nCompany's Corporate Governance / Compensation  Committee and subsequent approval\nby the Board on March 16, 2007,  the Company pays its  Directors  the  following\namounts (collectively, the \"<U>Compensation Policy</U>\"): (i) each Director receives an\nannual retainer of $12,000, (ii) each Director receives $1,000 per Board meeting\nattended  (whether  in  person  or  telephonic),  and  (iii)  once our  plant is\noperational,  each  Director  will  receive  $3,000 per Board  meeting  attended\n(whether in person or telephonic),  <i>provided that</i> the foregoing amounts in (i) -\n(iii) shall not exceed $24,000 per Director in any calendar year.  Additionally,\nthe  following  amounts are paid to Directors for  specified  services:  (i) the\nChairman  of the Board is paid $7,500 per year,  (ii) the  Chairman of the Audit\nCommittee and Audit Committee  Financial  Expert is paid $5,000 per year,  (iii)\nthe  Chairmen of all other  Committees  are paid  $2,500 per year,  and (iv) the\nSecretary of the Board is paid $2,500 per year.\n\n     <b><u>Independent Directors</u></b>\n\n     The following table lists the  compensation the Company paid in Fiscal Year\n2008  to  its  Directors  who  are  considered   \"independent\"  under  standards\napplicable  to  companies  listed  on the  Nasdaq  Capital  Market  (though  the\nCompany's  Units are not  listed  on any  exchange  or  quotation  system)  (the\n\"<U>Independent Directors</U>\").\n<b>\n                           Fees Earned or Paid                           Equity or Non-Equity\n          Name                   in Cash         All Other Compensation       incentives                Total\n------------------------- ---------------------- ----------------------- ---------------------- ----------------------</b>\n\nTed Bauer                        $25,500                   $0                     $0                   $25,500\nHubert Houser                    $24,500                   $0                     $0                   $24,500\nKarol King                       $30,500                   $0                     $0                   $30,500\nMichael Guttau                   $28,000                   $0                     $0                   $28,000\n\n                                       58\n\n</pre>\n<hr>\n<pre>\n\n     <b><u>Interested Directors</u></b>\n\n     The following table lists the  compensation the Company paid in Fiscal Year\n2008 to its  Directors  who are not  considered  \"independent\"  under  standards\napplicable  to  companies  listed  on the  Nasdaq  Capital  Market  (though  the\nCompany's  Units are not  listed  on any  exchange  or  quotation  system)  (the\n\"<U>Interested Directors</U>\").\n<b>\n                           Fees Earned or Paid                           Equity or Non-Equity\n          Name                   in Cash         All Other Compensation       incentives                Total\n------------------------- ---------------------- ----------------------- ---------------------- ----------------------</b>\n\nBailey Ragan+                    $24,500                   $0                     $0                   $24,500\nMichael M. Scharf+               $24,500                   $0                     $0                   $24,500\nGreg Krissek                     $23,000                   $0                     $0                   $23,000\n\n+ The Directors  fees payable to the  Interested  Directors are paid directly to\ntheir  corporate  employers  at such  Directors'  request,  and  the  Interested\nDirectors do not receive any compensation  from the Company for their service as\nDirectors.\n\nSelection of the  Company's  directors is governed by the  Nominating  Committee\nCharter, which was adopted by the Board of Directors on February 16, 2007. These\ngoverning  procedures have not been modified or amended. The Company also has an\naudit committee,  which consists of Mick Guttau (Chairman),  Ted Bauer and Karol\nKing.  Mr. Guttau is the financial  expert who is required to serve on the audit\ncommittee  under SEC  rules.  Mr.  Guttau  is not  considered  an  \"independent\"\nfinancial expert under listing standards applicable to the Company.\n<b>\nItem 12.  Security  Ownership of Certain  Beneficial  Owners and  Management and\n          Related Member Matters.</b>\n\n     As of September 30, 2008,  there were 8,805 Series A Units,  3,334 Series B\nUnits, and 1,000 Series C Units issued and outstanding. The following table sets\nforth certain  information  as of September  30, 2008,  with respect to the Unit\nownership  of:  (i) those  persons  or groups  (as that term is used in  Section\n13(d)(3) of the  Securities  Exchange  Act of 1934,  as amended  (the  \"<U>Exchange</U>\n<U>Act</U>\"))  who  beneficially  own more than 5% of any  Series  of Units,  (ii) each\nDirector of the Company,  and (iii) all  Officers and  Directors of the Company,\nnine in number, as a group. The address of those in the following table is 10868\n189th Street,  Council Bluffs, Iowa 51503.  Messrs.  King, Drake,  Patterson and\nBauer serve in the capacity of executive  officers.  Except as noted below,  the\npersons  listed  below  possess  sole  voting  and  investment  power over their\nrespective  Units.  The following does not reflect any Units which may be issued\nto Bunge and ICM, respectively, under the terms of the Unit Issuance Agreements.\n\n<b>\n                                                              Amount and Nature of Beneficial\n Title of Class            Name of Beneficial Owner                      Ownership                 Percent of Class\n------------------ ----------------------------------------- ----------------------------------- ---------------------</b>\n\n    Series A                      Ted Bauer                             36 Units(1)                     0.41%\n    Series A                    Hubert Houser                           39 Units(2)                     0.44%\n    Series A                      Karol King                            29 Units(3)                     0.33%\n    Series A                    Michael Guttau                          12 Units(4)                     0.14%\n       --                         Mark Drake                                -0-                           --\n       --                      Cindy Patterson                              -0-                           --\n       --                        Bailey Ragan                               -0-                           --\n       --                       Michael Scharf                              -0-                           --\n       --                        Greg Krissek                               -0-                           --\n    Series B              Bunge North America, Inc.                      3334 Units                      100%\n    Series C                      ICM, Inc.                              1000 Units                      100%\n\n    Series A        All Officers and Directors as a Group                116 Units                      1.92%\n\n------------------------------------\n\n(1)  These  Series A Units are owned  jointly by Mr.  Bauer and his wife,  Donna\n     Bauer.\n(2)  These Series A Units are owned  jointly by Mr.  Houser and his wife,  Paula\n     Houser.\n\n                                       59\n\n</pre>\n<hr>\n<pre>\n\n\n(3)  These  Series A Units are owned  jointly by Mr. King and his wife,  Rozanne\n     King.\n\n(4)  These Series A Units are owned jointly by Mr.  Guttau and his wife,  Judith\n     Guttau.\n\n<b>\nItem  13.  Certain   Relationships  and  Related   Transactions,   and  Director\n           Independence.\n\n     <U>Relationships and Related Party Transactions</U></b>\n\n     On  November  1,  2006,  in   consideration  of  its  agreement  to  invest\n$20,004,000  in the  Company,  Bunge  purchased  the only  Series B Units of the\nCompany  under an  arrangement  whereby the Company would (i) enter into various\nagreements  with  Bunge  or  its  affiliates  discussed  below  for  management,\nmarketing and other services to the Company,  and (ii) have the right to elect a\nnumber of Series B Directors which are  proportionate  to the number of Series B\nUnits owned by Bunge,  as compared to all Units.  Bunge elected Bailey Ragan and\nMichael  Scharf  as the  Series B  Directors  on  November  1,  2006.  Under the\nCompany's Operating Agreement, the Company may not, without Bunge's approval (i)\nissue additional Series B Units, (ii) create any additional Series of Units with\nrights  which are  superior to the Series B Units,  (iii)  modify the  Operating\nAgreement to adversely  impact the rights of Series B Unit holders,  (iv) change\nthe  Company's  status from one which is managed by managers,  or change back to\nmanager management in the event the status is changed to member management,  (v)\nrepurchase  or redeem  any Series B Units,  (vi)  cause the  Company to take any\naction  which would  cause a  bankruptcy,  or (vii)  approve a transfer of Units\nallowing the  transferee  to hold more than 17% of the  Company's  Units or to a\ntransferee which is a direct competitor of Bunge.\n\n     Additionally,  Bunge has  caused its bank to issue a letter of credit in an\namount equal to 76% of the maximum  principal amount of the Bridge Loan in favor\nof the Bridge  Lender as security for the Bridge Loan.  The Bunge LC will expire\non March 16, 2009,  and the Bridge Lender will only draw against the Bunge LC to\nthe extent  that we default  under the Bridge Loan or have not repaid the Bridge\nLoan in full by March 1, 2009.  In the event the Bridge Lender draws against the\nBunge LC, the amounts drawn will be in  proportion  to Bunge's  ownership of the\nCompany's Units which are not Series  A--currently 76%. As part of the foregoing\narrangement with Bunge, the Company entered into the Series E Agreement on March\n7, 2008, pursuant to which the Company has agreed (i) to pay Bunge a fee for the\nissuance of the Bunge LC equal to 6% per annum of the undrawn face amount of the\nBunge LC and (ii) to reimburse  Bunge with Series E Units to the extent that the\nBunge makes a Bridge Loan Payment, as further described below.\n\n     Under the Series E  Agreement,  if Bunge makes a Bridge Loan  Payment,  the\nCompany  will  immediately  issue  Series E Units to Bunge based on a Unit price\nthat is equal to the lesser of $3,000 or one half  (1/2) of the lowest  purchase\nprice paid by any party for a Unit who  acquired  (or who has  entered  into any\nagreement,  instrument or document to acquire) such Unit as part of any offering\nof Units after the date of the Series E  Agreement  but prior to the date of any\nBridge Loan Payment made by Bunge. The Series E Agreement  further provides that\nBunge will have the right to purchase  its pro rata share of any Units issued by\nthe  Company  at any time after the date of the  Series E  Agreement.  Bunge has\nindicated it plans to purchase  units  sufficient  to maintain  ownership at its\ncurrent percentage of outstanding units.\n\n     To the extent that the Company  issues Series E Units to Bunge  pursuant to\nthe Series E Agreement,  the  Company's  Operating  Agreement  provides (i) that\nBunge,  as a Series E Member,  is entitled to elect one additional  director (to\nthe extent that Bunge owns  between  21% and 29% of the total  Units  issued and\noutstanding) two additional directors (to the extent that Bunge owns between 30%\nand 39% of the total Units issued and outstanding) or three additional directors\n(to the  extent  that  Bunge  owns 40% or more of the  total  Units  issued  and\noutstanding);  and (ii) that the Company may not,  without Bunge's  approval (a)\nissue additional  Series E Units, (b) create any additional Series of Units with\nrights  which are  superior  to the Series E Units,  (c)  modify  the  Operating\nAgreement to adversely  impact the rights of Series E Unit  holders,  (d) change\nthe Company's  status from one which is managed by managers,  or vice versa, (e)\nrepurchase  or redeem  any  Series E Units,  (f) cause the  Company  to take any\naction  which  would  cause a  bankruptcy,  or (g)  approve a transfer  of Units\nallowing the  transferee  to hold more than 15% of the  Company's  Units or to a\ntransferee which is a direct competitor of Bunge.\n\n     The Company and Bunge  entered  into the DG  Agreement on October 13, 2006.\nThe DG Agreement  provides that Bunge will purchase all of the Distillers Grains\nproduced by us over a term of 10 years, beginning when we commence production of\nDistillers  Grains,  with automatic renewals for three-year terms unless a party\nprovides six\n\n                                       60\n\n</pre>\n<hr>\n<pre>\n\nmonths' notice.  Bunge will pay us for the Distillers Grains, but retain amounts\nfor transportation  costs, rail lease charges and marketing fees. We have agreed\nto pay a minimum annual marketing fee to Bunge in the amount of $150,000.  After\nthe third year of the DG  Agreement,  the  parties may make  adjustments  to the\nprices.\n\n     The  Company  and Bunge  entered  into an  Agreement  on October  13,  2006\nrespecting  the use of  Bunge's  grain  elevator  in Council  Bluffs,  Iowa (the\n\"<U>Elevator  Agreement</U>\").  The Elevator  Agreement does not require the payment by\nthe  Company of any moneys and  otherwise  did not  involve  the  payment of any\nconsideration by either party;  rather,  it imposes  restrictions on the use and\npossible  disposition by Bunge of its grain elevator  located in Council Bluffs,\nIowa,  including a right of first  refusal in favor of the Company.  The parties\nentered into the Elevator  Agreement as part of their overall  arrangement under\nwhich Bunge initially agreed to invest in the Company.\n\n     On December 15, 2008, the Company and Bunge entered into a Lease  Agreement\n(the \"Lease\") respecting  Bunge's grain elevator in Council  Bluffs.  Under  the\nLease, the Company has leased from Bunge the grain elevator, for  approximately  $800,000\nper year. The Lease provides  customary terms and has an initial  one-year term,\nwhich will be renewed for successive  one-year terms upon the parties' agreement\nto so extend the term.\n\n     The  Company  and a company in which  Bunge  holds a  membership  interest,\nAGRI-Bunge,  LLC,  entered into the Agency  Agreement  on October 13,  2006,  as\namended  December  15,  2008.  Under the Agency  Agreement,  we agreed to pay an\nagency  fee to AB for  corn  delivered,  subject  to an  annual  minimum  fee of\n$225,000,  for AB's service of procuring all grain  requirements  for our plant.\nThe  Agency  Agreement  will  commence  when we first  require  corn,  presently\nprojected  to be in the fourth  quarter of 2008,  and will then  continue for 10\nyears with  automatic  renewals for three year periods  unless a party  provides\nnotice to not renew  within six months of the  then-current  term.  After  three\nyears from the commencement of the Agency Agreement,  the annual minimum payment\nmay be adjusted.\n\n     The Company and AB entered into the Supply  Agreement on December 15, 2008.\nUnder the Supply Agreement,  AB has agreed to provide us with all of the corn we\nneed to operate our ethanol plant, and we have agreed to only purchase corn from\nAB. AB will provide grain originators who will work at the Facility for purposes\nof fulfilling its obligations under the Supply  Agreement.  The Company will pay\nAB a  per-bushel  fee for corn  procured by AB for the Company  under the Supply\nAgreement, subject to a minimum annual fee of $675,000 and adjustments according\nto specified  indexes after three years. The term of the Supply Agreement is ten\nyears,  subject  to  earlier  termination  upon  specified  events.  The  Supply\nAgreement suspends the operation of the Agency Agreement. In the event we obtain\na grain dealer's license,  subject to certain procedures specified in the Supply\nAgreement,  then the operation of the Supply  Agreement  will  terminate and the\nAgency Agreement will be reinstated.\n\n     On January 30, 2008, the Company and Bunge entered into a Support  Services\nAgreement  (the  \"<U>Services  Agreement</U>\"),  under  which  Bunge  agreed to provide\nengineering  support on the  project,  provide  reports to Lender and assist the\nCompany with requests by the Agent. The Company will pay, in addition to Bunge's\nout of pocket  expenses,  an hourly fee of $95 for such  services.  The Services\nAgreement  terminates  upon the earlier of  completion  of the ethanol  plant or\nDecember 31, 2008.  Bunge may terminate the Services  Agreement at any time, and\nthe Company may terminate under specified circumstances.\n\n     On June 25, 2007, we entered into the Railcar  Agreement with Bunge for the\nsub-lease  of 320  ethanol  cars and 300  DDGS  cars  which  will be used in the\ndelivery  and  marketing  of ethanol and DDGS.  We will be  responsible  for all\nmaintenance and mileage charges as well as the monthly lease expense and certain\nrailcar  modification  expenses.  Under the  Railcar  Agreement,  we will  lease\nrailcars for terms  lasting 120 months and  continuing on a month to month basis\nthereafter.  The Railcar  Agreement  will  terminate  upon the expiration of all\nrailcar leases.\n\n     On  December  15,  2008,  the Company  and Bunge  entered  into the Ethanol\nAgreement,  under  which the Company has agreed to sell Bunge all of the ethanol\nproduced  at the Plant,  and Bunge has agreed to  purchase  the same,  up to the\nPlant's nameplate  capacity of 110,000,000  gallons a year. The Company will pay\nBunge a  per-gallon  fee for  ethanol  sold by Bunge for the  Company  under the\nEthanol  Agreement,  subject to a minimum annual fee of $750,000 and adjustments\naccording  to  specified  indexes  after three  years.  The initial  term of the\nEthanol  Agreement,  which will  commence upon the  termination  of that Ethanol\nMerchandising  Agreement between the Company and Lansing Ethanol Services,  LLC,\nis three years and it will automatically  renew for successive  three-\n\n                                       61\n\n</pre>\n<hr>\n<pre>\n\nyear terms  unless one party  provides  the other  notice of their  election  to\nterminate 180 days prior to the end of the term.\n\n     On December 15, 2008, the Company and Bunge entered into a Risk  Management\nServices  Agreement  (\"<U>Risk  Management  Agreement</U>\").  Under the Risk Management\nAgreement,  Bunge has agreed to provide the Company with  assistance in managing\nits commodity  price risks for a quarterly fee of $75,000.  The Risk  Management\nAgreement  has an initial term of three years and will  automatically  renew for\nsuccessive three year terms, unless one party provides the other notice of their\nelection to terminate 180 days prior to the end of the term.\n\n     On November 1, 2006, in consideration of its agreement to invest $6,000,000\nin the Company,  ICM became the sole Series C Member of the Company.  As part of\nICM's  agreement  to  invest  in the  Company's  Series C Units,  the  Company's\nOperating  Agreement provides that it will not, without ICM's approval (i) issue\nadditional  Series C Units,  (ii)  create  any  additional  Series of Units with\nrights  senior to the Series C Units,  (iii) modify the  Operating  Agreement to\nadversely  impact the rights of Series C Unit  holders,  or (iv)  repurchase  or\nredeem any Series C Units.  Additionally,  ICM, as the sole Series C Unit owner,\nis afforded the right to elect one Series C Director to the Board so long as ICM\nremains a Series C Member.  Greg Krissek was elected as the Series C Director by\nICM on November 1, 2006.\n\n     Additionally, as discussed in more detail above under Item 7 - Management's\nDiscussion  and  Analysis of  Financial  Condition  and  Results of  Operation -\nStatus,  Overview  and Recent  Developments,  ICM has caused its bank to issue a\nletter of credit in an amount  equal to 24% of the maximum  principal  amount of\nthe Bridge Loan in favor of the Bridge  Lender as security  for the Bridge Loan.\nThe ICM LC will expire on March 16, 2009,  and the Bridge  Lender will only draw\nagainst the Bunge LC to the extent that we default under the Bridge Loan or have\nnot  repaid the  Bridge  Loan in full by March 1, 2009.  In the event the Bridge\nLender  draws  against the ICM LC, the amounts  drawn will be in  proportion  to\nICM's ownership of the Company's Units which are not Series A--currently 24%. As\npart of the foregoing  arrangement with ICM, the Company entered into the Series\nC Agreement on March 7, 2008, pursuant to which the Company has agreed to (i) to\npay ICM a fee for  the  issuance  of the ICM LC  equal  to 6% per  annum  of the\nundrawn  face  amount of the ICM LC and (ii) to  reimburse  ICM with  additional\nSeries C Units to the extent  that ICM makes a Bridge Loan  Payment,  as further\ndescribed below.\n\n     Under the  Series C  Agreement,  if ICM makes a Bridge  Loan  Payment,  the\nCompany will immediately  issue Series C Units to ICM based on a Unit price that\nis equal to the lesser of $3,000 or one half (1/2) of the lowest  purchase price\npaid  by any  party  for a Unit  who  acquired  (or  who has  entered  into  any\nagreement,  instrument or document to acquire) such Unit as part of any offering\nof Units after the date of the Series C  Agreement  but prior to the date of any\nBridge Loan Payment made by ICM. The Series C Agreement  further  provides  that\nICM will have the right to  purchase  its pro rata share of any Units  issued by\nthe Company at any time after the date of the Series C Agreement.\n\n     On September  25, 2006,  the Company  entered into a Design Build  Contract\nwith ICM,  under which ICM has  contracted to construct a 110 million gallon per\nyear dry mill  ethanol  plant.  The ICM  Contract  contains a lump-sum  price of\n$118,000,000.  Under the ICM  Contract,  the Company was required to make a down\npayment of 10% of the original  contract price, of which  $2,000,000 was paid at\nthe delivery of the parties' letter of intent, an additional $2,000,000 was paid\nin November 2006 when the Company broke escrow, and the remaining $7,800,000 was\npaid when the Company delivered to ICM a notice to proceed on January 23, 2007.\n\n      The Company does not presently  have any policies  finalized and adopted by\nthe Board governing the review or approval of related party transactions.\n\n     <b><u>Director Independence</u></b>\n\n     The  Company  determines  its  \"independent   director\"  according  to  the\nstandards  applicable to companies  listed on the Nasdaq  Capital Market (though\nthe Company's Units are not listed on any exchange or quotation  system).  Under\nthe  Company's  Operating  Agreement,   the  independent  Directors'  terms  are\nstaggered  such  that one  Director  will be up for  election  every  year.  The\nCompany's  independent  directors are Karol King, Ted Bauer, Herbert Houser, and\nMichael  Guttau.  The Audit  Committee  currently  consists  of  Michael  Guttau\n(Chair),  Ted Bauer and Karol King.  All of the  members of the Audit  Committee\nmeet the \"independent  director\" standards applicable to\n\n                                       62\n\n</pre>\n<hr>\n<pre>\n\ncompanies  listed on the Nasdaq Capital  Market (though the Company's  Units are\nnot listed on any  exchange or  quotation  system).  Presently,  the  Nominating\nCommittee's  membership consists of Ted Bauer, Hubert Houser and Karol King, all\nof whom meet the \"independent director\" standards applicable to companies listed\non the Nasdaq Capital  Market (though the Company's  Units are not listed on any\nexchange or  quotation  system).  The  Compensation  Committee  Charter does not\nexclude  from  the  Corporate  Governance/Compensation   Committee's  membership\nDirectors who also serve as officers or  Interested  Directors.  Presently,  the\nGovernance  Committee's membership consists of Messrs. Scharf (Chair), Bauer and\nKing.  As further  described  below,  Mr.  Scharf is  considered  an  Interested\nDirector.\n\n<b>\nItem 14. Principal Accountant Fees and Services.\n</b>\n     <b><u>Independent Public Accountant Fees and Services</u></b>\n\n     The following table presents fees paid for professional  services  rendered\nby the Company's  independent  public  accountants for the Company's fiscal year\nended September 30, 2008 (\"<U>Fiscal Year 2008</U>\") and for the Company's  fiscal year\nended September 30, 2007 (\"<U>Fiscal Year 2007</U>\"):\n<b>\n             Fee Category         Fiscal Year 2008 Fees                 Fiscal Year 2007 Fees\n----------------------------   ----------------------------          ----------------------------</b>\n\nAudit Fees                              $115,000                               $97,555\n\nAudit-Related Fees                         $0                                    $0\n\nTax Fees                                 $60,125                               $21,273\n\nAll Other Fees                               ---                                  ---\n\n                               ----------------------------          ----------------------------\nTotal Fees                              $175,125                              $118,828\n\n     <i>Audit Fees</i> are for  professional  services  rendered by McGladrey T&amp; Pullen,\nLLP (\"<U>McGladrey</U>\") for the audit of the Company's annual financial statements and\nreview of the interim  financial  statements  included in quarterly  reports and\nservices that are normally  provided by McGladrey in connection  with  statutory\nand regulatory filings or engagements. Fiscal Year 2007 included the re-audit of\nthe Company's annual financial statements.\n\n     <i>Audit-Related  Fees</i>  are  for  assurance  and  related  services  that  are\nreasonably  related to the  performance  of the audit or review of the Company's\nfinancial  statements  and are not reported  under \"Audit Fees.\" These  services\ninclude accounting consultations in connection with acquisitions,  consultations\nconcerning financial accounting and reporting standards. The Company did not pay\nany fees for such services in Fiscal Year 2008 or Fiscal Year 2007.\n\n     <i>Tax Fees</i> are for professional services rendered by RSM McGladrey,  Inc., an\naffiliate  of  McGladrey,  for tax  compliance,  tax advice and tax planning and\ninclude  preparation  of federal  and state  income tax  returns,  and other tax\nresearch, consultation, correspondence and advice.\n\n     <i>All Other Fees </i>are for services other than the services reported above. The\nCompany  did not pay any fees for such  other  services  in Fiscal  Year 2008 or\n2007.\n\n     The Audit  Committee has concluded the provision of the non-audit  services\nlisted above is compatible with maintaining the independence of McGladrey.\n<b>\nPolicy  on Audit  Committee  Pre-Approval  of Audit  and  Permissible  Non-Audit\nServices of Independent Auditors</b>\n\n     The  Audit  Committee  pre-approves  all audit  and  permissible  non-audit\nservices  provided by the Company's  independent  auditors.  These  services may\ninclude audit services, audit-related services, tax services and other\n\n                                       63\n\n\n</pre>\n<hr>\n<pre>\n\nservices.  Pre-approval  is  generally  provided  for up to  one  year  and  any\npre-approval  is detailed as to the  particular  service or category of services\nand is generally  subject to a specific  budget.  The  independent  auditors and\nmanagement are required to periodically  report to the Audit Committee regarding\nthe extent of services  provided by the independent  auditors in accordance with\nthis  pre-approval,  and the fees for the services  performed to date. The Audit\nCommittee may also pre-approve particular services on a case-by-case basis.\n<b>\n                                     PART IV\n\nItem 15. Exhibits and Financial Statement Schedules.</b>\n\n(a) Documents filed as part of this Report:\n\n     (1)  Balance Sheets at September 30, 2008 and September 30, 2007\n          Statements  of Operations  for the years ended  September 30, 2008 and\n          September 30, 2007 and\n          Date of Inception  (March 28, 2005 to September 30, 2008)\n          Statements of Members' Equity as of September 30, 2008\n          Statement  of Cash Flows for the year  ended  September  30,  2008\n          and September 30, 2007 and Date of Inception  (March 28, 2005 to\n          September 30, 2008)\n          Notes to Financial Statements\n\n(b) See (a)(1) above\n\n(c) The following  exhibits are filed herewith or  incorporated  by reference as\nset forth below:\n\nExhibit numbers 10.36 and 10.37 are management contracts.\n\n2        Omitted - Inapplicable.\n3(i)     Articles of Organization,  as filed with the Iowa Secretary of State on\n         March  28,  2005   (incorporated   by  reference  to  Exhibit  3(i)  of\n         Registration  Statement  on Form 10 filed by the Company on January 28,\n         2008).\n4(i)     Second  Amended and Restated  Operating  Agreement  dated March 7, 2008\n         (incorporated  by  reference  to  Exhibit  4(i) of  Amendment  No. 1 to\n         Registration  Statement  on Form 10 filed by the  Company  on March 21,\n         2008).\n9        Omitted - Inapplicable.\n\n10.1     Agreement  dated  October  13,  2006 with  Bunge  North  America,  Inc.\n         (incorporated by reference to Exhibit 10.1 of Registration Statement on\n         Form 10/A filed by the  Company on October 23,  2008).  Portions of the\n         Agreement  have been  omitted  pursuant to a request  for  confidential\n         treatment.\n10.2     Ethanol  Merchandising  Agreement  dated  November 1, 2006 with Lansing\n         Ethanol  Services,  LLC  (incorporated  by reference to Exhibit 10.2 of\n         Registration  Statement  on Form 10 filed by the Company on October 23,\n         2008).  Portions  of the  Agreement  have been  omitted  pursuant  to a\n         request for confidential treatment.\n10.3     Assignment of Ethanol Merchandising Agreement dated May 2, 2007 between\n         AgStar Financial Services, PCA and Southwest Iowa Renewable Energy, LLC\n         (incorporated by reference to Exhibit 10.3 of Registration Statement on\n         Form 10 filed by the Company on January 28, 2008).\n10.4     Executed Steam Service Contract dated January 22, 2007 with MidAmerican\n         Energy   Company   (incorporated   by  reference  to  Exhibit  10.4  of\n         Registration Statement on Form 10/A filed by the Company on October 23,\n         2008). Portions of the Contract have been omitted pursuant to a request\n         for confidential treatment.\n10.5     Assignment  of Steam  Service  Contract  dated  May 2, 2007 in favor of\n         AgStar Financial  Services,  PCA  (incorporated by reference to Exhibit\n         10.5 of  Registration  Statement  on Form 10  filed by the  Company  on\n         January 28, 2008).\n10.6     Electric  Service  Contract  dated  December 15, 2006 with  MidAmerican\n         Energy   Company   (incorporated   by  reference  to  Exhibit  10.6  of\n         Registration  Statement  on Form 10 filed by the Company on January 28,\n         2008).\n10.7     Assignment of Electric  Service  Contract dated May 2, 2007 in favor of\n         AgStar Financial  Services,  PCA  (incorporated by reference to Exhibit\n         10.7 of  Registration  Statement  on Form 10  filed by the  Company  on\n         January 28, 2008).\n\n                                       64\n\n</pre>\n<hr>\n<pre>\n\n10.8     Distillers  Grain Purchase  Agreement dated October 13, 2006 with Bunge\n         North  America,  Inc.  (incorporated  by  reference  to Exhibit 10.8 of\n         Registration  Statement  on Form 10 filed by the Company on January 28,\n         2008).  Portions  of the  Agreement  have been  omitted  pursuant  to a\n         request for confidential treatment.\n10.9     Assignment of Distillers Grain Purchase  Agreement dated May 2, 2007 in\n         favor of AgStar Financial  Services,  PCA (incorporated by reference to\n         Exhibit 10.9 of Registration  Statement on Form 10 filed by the Company\n         on January 28, 2008).\n10.10    Grain   Feedstock   Agency   Agreement  dated  October  13,  2006  with\n         AGRI-Bunge,   LLC  (incorporated  by  reference  to  Exhibit  10.10  of\n         Registration  Statement  on Form 10 filed by the Company on October 23,\n         2008).  Portions  of the  Agreement  have been  omitted  pursuant  to a\n         request for confidential treatment.\n10.11    Assignment of Grain Feedstock  Agency  Agreement dated May 2, 2007 with\n         AgStar Financial  Services,  PCA  (incorporated by reference to Exhibit\n         10.11 of  Registration  Statement  on Form 10 filed by the  Company  on\n         January 28, 2008).\n10.12    Agreement  between  Owner  and  Design/Builder  Based on The Basis of a\n         Stipulated Price dated September 25, 2006 with ICM, Inc.  (incorporated\n         by reference to Exhibit  10.12 of  Registration  Statement on Form 10/A\n         filed by the Company on October 23,  2008).  Portions of the  Agreement\n         have been omitted pursuant to a request for confidential treatment.\n10.13    Railcar  Sublease  Agreement  dated  June 25,  2007  with  Bunge  North\n         America,   Inc.   (incorporated   by  reference  to  Exhibit  10.13  of\n         Registration  Statement  on Form 10 filed by the Company on January 28,\n         2008).  Portions  of the  Agreement  have been  omitted  pursuant  to a\n         request for confidential treatment.\n10.14    Credit Agreement dated May 2, 2007 with AgStar Financial Services, PCA\n         (incorporated by reference to Exhibit 10.14 of Registration  Statement\n         on Form 10 filed by the Company on January 28, 2008).\n10.15    Security  Agreement dated May 2, 2007 with AgStar Financial  Services,\n         PCA  (incorporated  by  reference  to  Exhibit  10.15 of  Registration\n         Statement on Form 10 filed by the Company on January 28, 2008).\n10.16    Mortgage, Security Agreement Assignment of Rents and Leases and Fixture\n         Filing  dated May 2, 2007 in favor of AgStar  Financial  Services,  PCA\n         (incorporated  by reference to Exhibit 10.16 of Registration  Statement\n         on Form 10 filed by the Company on January 28, 2008).\n10.17    Environmental  Indemnity  Agreement  dated  May  2,  2007  with  AgStar\n         Financial Services,  PCA (incorporated by reference to Exhibit 10.17 of\n         Registration  Statement  on Form 10 filed by the Company on January 28,\n         2008).\n10.18    Convertible  Note  dated  May 2,  2007  in  favor  of  Monumental  Life\n         Insurance  Company  (incorporated  by  reference  to  Exhibit  10.18 of\n         Registration  Statement  on Form 10 filed by the Company on January 28,\n         2008).\n10.19    Convertible  Note  dated May 2, 2007 in favor of  Metlife  Bank,  N.A.\n         (incorporated by reference to Exhibit 10.19 of Registration  Statement\n         on Form 10 filed by the Company on January 28, 2008).\n10.20    Convertible  Note  dated May 2, 2007 in favor of  Cooperative  Centrale\n         Raiffeisen-Boerenleenbank,  B.A.  (incorporated by reference to Exhibit\n         10.20 of  Registration  Statement  on Form 10 filed by the  Company  on\n         January 28, 2008).\n10.21    Convertible  Note  dated  May 2,  2007 in  favor of  Metropolitan  Life\n         Insurance  Company  (incorporated  by  reference  to  Exhibit  10.21 of\n         Registration  Statement  on Form 10 filed by the Company on January 28,\n         2008).\n10.22    Convertible  Note dated May 2, 2007 in favor of First National Bank of\n         Omaha  (incorporated  by  reference to Exhibit  10.22 of  Registration\n         Statement on Form 10 filed by the Company on January 28, 2008).\n10.23    Revolving  Line  of  Credit  Note  in  favor  of  Cooperative  Centrale\n         Raiffeisen-Boerenleenbank,  B.A.  (incorporated by reference to Exhibit\n         10.23 of  Registration  Statement  on Form 10 filed by the  Company  on\n         January 28, 2008).\n10.24    Revolving Line of Credit Note in favor of Metropolitan  Life Insurance\n         Company  (incorporated  by reference to Exhibit 10.24 of  Registration\n         Statement on Form 10 filed by the Company on January 28, 2008).\n10.25    Revolving Line of Credit Note in favor of First National Bank of Omaha\n         (incorporated by reference to Exhibit 10.25 of Registration  Statement\n         on Form 10 filed by the Company on January 28, 2008).\n10.26    Term Revolving Note in favor of Metlife Bank,  N.A.  (incorporated  by\n         reference to Exhibit 10.26 of Registration  Statement on Form 10 filed\n         by the Company on January 28, 2008).\n10.27    Term    Revolving    Note   in   favor   of    Cooperative    Centrale\n         Raiffeisen-Boerenleenbank,  B.A. (incorporated by reference to Exhibit\n         10.27 of  Registration  Statement  on Form 10 filed by the  Company on\n         January 28, 2008).\n\n                                       65\n\n</pre>\n<hr>\n<pre>\n\n10.28    Term Revolving Note in favor of  Metropolitan  Life Insurance  Company\n         (incorporated by reference to Exhibit 10.28 of Registration  Statement\n         on Form 10 filed by the Company on January 28, 2008).\n10.29    Term  Revolving  Note  in  favor  of  First  National  Bank  of  Omaha\n         (incorporated by reference to Exhibit 10.29 of Registration  Statement\n         on Form 10 filed by the Company on January 28, 2008).\n10.30    Lien  Subordination  Agreement  dated May 2, 2007 among  Southwest Iowa\n         Renewable  Energy,  LLC,  AgStar  Financial  Services,   PCA  and  Iowa\n         Department  of  Economic  Development  (incorporated  by  reference  to\n         Exhibit 10.30 of Registration Statement on Form 10 filed by the Company\n         on January 28, 2008).\n10.31    Value Added Agricultural Product Marketing  Development Grant Agreement\n         dated November 3, 2006 with the United States of America  (incorporated\n         by  reference  to Exhibit  10.31 of  Registration  Statement on Form 10\n         filed by the Company on January 28, 2008).\n10.32    Engineering  Services  Agreement  dated  November  27,  2006  with  HGM\n         Associates,  Inc.  (incorporated  by  reference  to  Exhibit  10.32  of\n         Registration  Statement  on Form 10 filed by the Company on January 28,\n         2008). Portions of the Contract have been omitted pursuant to a request\n         for confidential treatment.\n10.33    Fee  Letter  dated May 2, 2007 with  AgStar  Financial  Services,  PCA\n         (incorporated by reference to Exhibit 10.33 of Registration  Statement\n         on Form 10 filed by the Company on January 28, 2008).\n10.34    Design-Build  Agreement  dated  December 18, 2006 with Todd T&amp; Sargent,\n         Inc.  (incorporated  by  reference  to Exhibit  10.34 of  Registration\n         Statement on Form 10 filed by the Company on January 28, 2008).\n10.35    Master  Contract  dated  November  21,  2006  with Iowa  Department  of\n         Economic  Development  (incorporated  by reference to Exhibit  10.35 of\n         Registration  Statement  on Form 10 filed by the Company on January 28,\n         2008).\n10.36    Employment   Agreement   dated   January  31,  2007  with  Mark  Drake\n         (incorporated by reference to Exhibit 10.36 of Registration  Statement\n         on Form 10 filed by the Company on January 28, 2008).\n10.37    Letter   Agreement   dated  July  23,   2007  with   Cindy   Patterson\n         (incorporated by reference to Exhibit 10.37 of Registration  Statement\n         on Form 10 filed by the Company on January 28, 2008).\n10.38    First  Amendment  to Credit  Agreement  dated March 7, 2008 with AgStar\n         Financial Services,  PCA (incorporated by reference to Exhibit 10.38 of\n         Amendment  No.  1 to  Registration  Statement  on Form 10  filed by the\n         Company on March 21, 2008).\n10.39    Amended  and  Restated  Disbursing  Agreement  dated March 7, 2008 with\n         AgStar Financial  Services,  PCA  (incorporated by reference to Exhibit\n         10.39 of Amendment No. 1 to Registration  Statement on Form 10 filed by\n         the Company on March 21, 2008).\n10.40    Promissory  Note dated  March 7, 2008 in favor of Commerce  Bank,  N.A\n         (incorporated  by  reference to Exhibit  10.40 of  Amendment  No. 1 to\n         Registration  Statement  on Form 10 filed by the  Company on March 21,\n         2008).\n10.41    Irrevocable  Standby  Letter of Credit  No.  S500381  made by UMB Bank,\n         N.A., for the account of Bunge North America, Inc. in favor of Commerce\n         Bank, N.A. dated March 10, 2008  (incorporated  by reference to Exhibit\n         10.41 of Amendment No. 1 to Registration  Statement on Form 10 filed by\n         the Company on March 21, 2008).\n10.42    Irrevocable  Standby Letter of Credit No.  08SBLC0345  made by INTRUST\n         Bank, N.A. for the account of ICM Inc. in favor of Commerce Bank, N.A.\n         dated March 7, 2008  (incorporated  by reference  to Exhibit  10.42 of\n         Amendment  No.  1 to  Registration  Statement  on Form 10 filed by the\n         Company on March 21, 2008).\n10.43    Allonge to  Revolving  Line of Credit  Note in favor of First  National\n         Bank of Omaha dated March 7, 2008 (incorporated by reference to Exhibit\n         10.43 of Amendment No. 1 to Registration  Statement on Form 10 filed by\n         the Company on March 21, 2008).\n10.44    Allonge  to  Revolving  Line of  Credit  Note in favor  of  Cooperative\n         Centrale   Raiffeisen-Boerenleenbank,   B.A.,   dated   March  7,  2008\n         (incorporated  by  reference  to Exhibit  10.44 of  Amendment  No. 1 to\n         Registration  Statement  on Form 10 filed by the  Company  on March 21,\n         2008).\n10.45    Allonge to Revolving Line of Credit Note in favor of Metropolitan  Life\n         Insurance  Company,  dated March 7, 2008  (incorporated by reference to\n         Exhibit 10.45 of Amendment No. 1 to  Registration  Statement on Form 10\n         filed by the Company on March 21, 2008).\n10.46    Allonge to  Convertible  Note in favor of First National Bank of Omaha,\n         dated March 7, 2008  (incorporated  by  reference  to Exhibit  10.46 of\n         Amendment  No.  1 to  Registration  Statement  on Form 10  filed by the\n         Company on March 21, 2008).\n\n                                       66\n\n</pre>\n<hr>\n<pre>\n\n10.47    Allonge to  Convertible  Note in favor of Metlife  Bank,  N.A.,  dated\n         March 7, 2008 (incorporated by reference to Exhibit 10.47 of Amendment\n         No. 1 to  Registration  Statement  on Form 10 filed by the  Company on\n         March 21, 2008).\n10.48    Allonge to  Convertible  Note in favor of  Metropolitan  Life Insurance\n         Company,  dated March 7, 2008  (incorporated  by  reference  to Exhibit\n         10.48 of Amendment No. 1 to Registration  Statement on Form 10 filed by\n         the Company on March 21, 2008).\n10.49    Allonge  to  Convertible   Note  in  favor  of  Cooperative   Centrale\n         Raiffeisen-Boerenleenbank,  B.A., dated March 7, 2008 (incorporated by\n         reference  to  Exhibit  10.49  of  Amendment  No.  1  to  Registration\n         Statement on Form 10 filed by the Company on March 21, 2008).\n10.50    Allonge  to Term  Revolving  Note in favor of  First  National  Bank of\n         Omaha,  dated March 7, 2008 (incorporated by reference to Exhibit 10.50\n         of Amendment  No. 1 to  Registration  Statement on Form 10 filed by the\n         Company on March 21, 2008).\n10.51    Allonge  to  Term  Revolving  Note in  favor  of  Cooperative  Centrale\n         Raiffeisen-Boerenleenbank,  B.A., dated March 7, 2008  (incorporated by\n         reference to Exhibit 10.51 of Amendment No. 1 to Registration Statement\n         on Form 10 filed by the Company on March 21, 2008).\n10.52    Allonge to Term Revolving Note in favor of Metlife Bank,  N.A.,  dated\n         March 7, 2008 (incorporated by reference to Exhibit 10.52 of Amendment\n         No. 1 to  Registration  Statement  on Form 10 filed by the  Company on\n         March 21, 2008).\n10.53    Allonge to Term Revolving Note in favor of Metropolitan  Life Insurance\n         Company,  dated March 7, 2008  (incorporated  by  reference  to Exhibit\n         10.53 of Amendment No. 1 to Registration  Statement on Form 10 filed by\n         the Company on March 21, 2008).\n10.54    Allonge  to  Convertible  Note in favor of  Monumental  Life  Insurance\n         Company,  dated March 7, 2008  (incorporated  by  reference  to Exhibit\n         10.54 of Amendment No. 1 to Registration  Statement on Form 10 filed by\n         the Company on March 21, 2008).\n10.55    Term Revolving Note in favor of Amarillo  National Bank  (incorporated\n         by  reference  to Exhibit  10.55 of  Amendment  No. 1 to  Registration\n         Statement on Form 10 filed by the Company on March 21, 2008).\n10.56    Allonge to Term  Revolving  Note in favor of  Amarillo  National  Bank,\n         dated March 7, 2008  (incorporated  by  reference  to Exhibit  10.56 of\n         Amendment  No.  1 to  Registration  Statement  on Form 10  filed by the\n         Company on March 21, 2008).\n10.57    Convertible Note dated May 2, 2007, in favor of Amarillo National Bank\n         (incorporated  by  reference to Exhibit  10.57 of  Amendment  No. 1 to\n         Registration  Statement  on Form 10 filed by the  Company on March 21,\n         2008).\n10.58    Allonge to Convertible  Note in favor of Amarillo  National Bank, dated\n         March 7, 2008  (incorporated by reference to Exhibit 10.58 of Amendment\n         No. 1 to  Registration  Statement  on Form 10 filed by the  Company  on\n         March 21, 2008).\n10.59    Revolving  Line of  Credit  Note in favor of  Amarillo  National  Bank\n         (incorporated  by  reference to Exhibit  10.59 of  Amendment  No. 1 to\n         Registration  Statement  on Form 10 filed by the  Company on March 21,\n         2008).\n10.60    Allonge to Revolving Line of Credit Note in favor of Amarillo  National\n         Bank,  dated March 7, 2008  (incorporated by reference to Exhibit 10.60\n         of Amendment  No. 1 to  Registration  Statement on Form 10 filed by the\n         Company on March 21, 2008).\n10.61    Series C Unit  Issuance  Agreement  dated March 7, 2008 with ICM, Inc.\n         (incorporated  by  reference to Exhibit  10.61 of  Amendment  No. 1 to\n         Registration  Statement  on Form 10 filed by the  Company on March 21,\n         2008).\n10.62    Series E Unit Issuance  Agreement dated March 7, 2008 with Bunge North\n         America, Inc. (incorporated by reference to Exhibit 10.62 of Amendment\n         No. 1 to  Registration  Statement  on Form 10 filed by the  Company on\n         March 21, 2008).\n10.63    Support  Services  Agreement  dated  January 30, 2008 with Bunge North\n         America, Inc. (incorporated by reference to Exhibit 10.63 of Amendment\n         No. 1 to  Registration  Statement  on Form 10 filed by the  Company on\n         March 21, 2008).\n10.64    Amendment No. 01 dated March 9, 2007 with Iowa  Department of Economic\n         Development  (incorporated  by  reference  to Exhibit 10.2 of Form 8-K\n         filed by the Company on June 10, 2006).\n10.65    Amendment  No. 02 dated May 30, 2008 with Iowa  Department of Economic\n         Development  (incorporated  by  reference  to Exhibit 10.1 of Form 8-K\n         filed by the Company on June 10, 2006).\n10.66    Industrial  Track  Agreement  dated  as of June  18,  2008  with  CBEC\n         Railway,  Inc.  (incorporated by reference to Exhibit 10.1 of Form 8-K\n         filed by the Company on June 25, 2006).\n\n                                       67\n\n</pre>\n<hr>\n<pre>\n\n\n10.67    Base Agreement  dated August 27, 2008 between  Southwest Iowa Renewable\n         Energy,  LLC and Cornerstone  Energy, LLC (incorporated by reference to\n         Exhibit 10.1 of Form 8-K filed by the Company on September 2, 2008).\n10.68    Lease Agreement dated December 15, 2008 with  Bunge North America, Inc.\n         (incorporated  by  reference  to Exhibit  10.2 of Form 8-K filed by the\n         Company on December 22, 2008).\n10.69    Ethanol  Purchase  Agreement  dated December 15, 2008  with Bunge North\n         America,  Inc. Portions of the Agreement have been  omitted pursuant to\n         a  request for  confidential  treatment  (incorporated  by reference to\n         Exhibit 10.3 of Form 8-K filed by the Company on December 22, 2008).\n10.70    Risk Management  Services Agreement dated December 15, 2008  with Bunge\n         North America, Inc. (incorporated by reference to  Exhibit 10.4 of Form\n         8-K filed by the Company on December 22, 2008).\n10.71    Base Agreement with Cornerstone Energy, LLC d/b/a Constellation Energy\n         dated  August 27, 2008  (incorporated  by reference to Exhibit 10.1 of\n         Report on Form 8-K filed by the Registrant on September 2, 2008).\n10.72    Grain  Feedstock   Supply  Agreement  dated  December  15,  2008   with\n         AGRI-Bunge,  LLC. Portions of the Agreement  have been omitted pursuant\n         to a request for confidential treatment  (incorporated by  reference to\n         Exhibit 10.1 of Form 8-K filed by the Company on December 22, 2008)..\n11       Omitted - Inapplicable.\n12       Omitted - Inapplicable.\n13       Omitted - Inapplicable.\n14       Omitted - Inapplicable.\n16       Omitted - Inapplicable.\n18       Omitted - Inapplicable.\n21       Omitted - Inapplicable.\n22       Omitted - Inapplicable.\n23       Omitted - Inapplicable.\n24       Omitted - Inapplicable.\n31.1     Certification  (pursuant to Section 302 of the  Sarbanes-Oxley  Act of\n         2002) executed by Chief Executive Officer.\n31.2     Certification  (pursuant to Section 302 of the  Sarbanes-Oxley  Act of\n         2002) executed by Chief Financial Officer.\n32.1     Certification  (pursuant to Section 906 of the  Sarbanes-Oxley  Act of\n         2002) executed by the Chief Executive Officer.\n32.2     Certification  (pursuant to Section 906 of the  Sarbanes-Oxley  Act of\n         2002) executed by the Chief Financial Officer.\n\n                                       68\n\n</pre>\n<hr>\n<pre>\n<b>\n                                   SIGNATURES</b>\n\n     In accordance with the requirements of the Exchange Act, the Registrant has\ncaused this report to be signed on its behalf by the undersigned, thereunto duly\nauthorized.\n\n                                             SOUTHWEST IOWA RENEWABLE ENERGY, LLC\n\n\n\nDate: December 29, 2008                      /s/ Mark Drake\n                                             -----------------------------------\n                                             Mark Drake, President and Chief\n                                             Executive Officer\n\n\nDate: December 29, 2008                      /s/ Cindy Patterson\n                                             -----------------------------------\n                                             Cindy Patterson, Chief Financial\n                                             Officer\n\n</pre>\n<hr>\n<pre>\n\n\n     Pursuant to the  requirements of the Securities  Exchange Act of 1934, this\nReport  has  been  signed  below  by the  following  persons  on  behalf  of the\nRegistrant in the capacities and on the dates indicated.\n<b>\n                  Signature                                                                  Date</b>\n\n/s/ Karol King\n----------------------------------                                                     December 29, 2008\nKarol King, Chairman of the Board\n\n\n/s/ Ted Bauer\n----------------------------------                                                     December 29, 2008\nTed Bauer, Director\n\n/s/ Hubert Houser\n----------------------------------                                                     December 29, 2008\nHubert Houser, Director\n\n/s/ Michael Guttau\n----------------------------------                                                     December 29, 2008\nMichael Guttau, Director\n\n/s/ Bailey Ragan\n----------------------------------                                                     December 29, 2008\nBailey Ragan, Director\n\n/s/ Michael Scharf\n----------------------------------                                                     December 29, 2008\nMichael Scharf, Director\n\n/s/ Greg Krissek\n----------------------------------                                                     December 29, 2008\nGreg Krissek, Director\n\n\n\n\n\n\n\n\n\n\n\n</PRE>\n</BODY>\n</HTML>\n</TEXT>\n</DOCUMENT>\n"), 
    date = structure(1513896524, class = c("POSIXct", "POSIXt"
    ), tzone = "GMT"), times = structure(c(0, 2.6e-05, 2.8e-05, 
    6.5e-05, 0.018144, 0.029653), .Names = c("redirect", "namelookup", 
    "connect", "pretransfer", "starttransfer", "total")), request = structure(list(
        method = "GET", url = "https://www.sec.gov/Archives/edgar/data/1424844/000092290708000774/form10k_122308.htm", 
        headers = structure("application/json, text/xml, application/xml, */*", .Names = "Accept"), 
        fields = NULL, options = structure(list(useragent = "libcurl/7.55.1 r-curl/3.1 httr/1.3.1", 
            httpget = TRUE), .Names = c("useragent", "httpget"
        )), output = structure(list(), class = c("write_memory", 
        "write_function"))), .Names = c("method", "url", "headers", 
    "fields", "options", "output"), class = "request")), .Names = c("url", 
"status_code", "headers", "all_headers", "cookies", "content", 
"date", "times", "request"), class = "response")
