% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/latest_filings.R
\name{latest_filings}
\alias{latest_filings}
\title{SEC Latest Filings}
\usage{
latest_filings(
  name = "",
  cik = "",
  type = "",
  owner = "include",
  count = 40,
  page = 1
)
}
\arguments{
\item{name}{Optional company name to limit filing results}

\item{cik}{Optional company cik to limit filing results}

\item{type}{Optional form type to limit filing results}

\item{owner}{How to include ownership filings. Options are
\itemize{
  \item include (default)
  \item exclude
  \item only
}}

\item{count}{Number of results to return}

\item{page}{Which page of results to return}
}
\value{
a dataframe list of recent results, ordered by descending accepted
       date. Includes the following columns -
 \itemize{
   \item type
   \item href
   \item company_name
   \item company_type
   \item cik
   \item filing_date
   \item accepted_date
   \item accession_number
   \item size
 }
}
\description{
Provides access to the latest SEC filings from
\href{https://www.sec.gov/cgi-bin/browse-edgar?action=getcurrent}{here}
}
\examples{
latest_filings()
}
