% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cross.R
\name{crossed_by}
\alias{crossed_by}
\title{Specify the units to cross to index a new unit}
\usage{
crossed_by(
  ...,
  prefix = NULL,
  suffix = NULL,
  leading0 = NULL,
  sep = NULL,
  attrs = NULL
)
}
\arguments{
\item{...}{a sequence of units}

\item{prefix}{Currently not implemented.The prefix of the label.}

\item{suffix}{Currently not implemented.The suffix of the label.}

\item{leading0}{Currently not implemented.Whether there should be a leading 0 if labels are made.}

\item{sep}{Currently not implemented.A separator added between prefix and the number if prefix is empty.}

\item{attrs}{Currently not implemented.}
}
\value{
An object of class "cross_lvls".
}
\description{
\code{crossed_by(A, B)} is the same as \code{~A:B} but \code{crossed_by} offers more control over the names of the new units
as well as adding new attributes.
}
\examples{
design("Strip-Plot Design | Strip-Unit Design") \%>\%
  set_units(block = 3,
            row = nested_in(block, 7),
            col = nested_in(block, 6),
            unit = nested_in(block, crossed_by(row, col)))
}
