% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/provenance.R
\name{Provenance}
\alias{Provenance}
\title{An object to query, record and modify an edibble graph}
\description{
An object to query, record and modify an edibble graph

An object to query, record and modify an edibble graph
}
\details{
The Provenance contains a set of operations to manipulate the nodes and edges of
the edibble graph object.
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{fct_nodes}}{Get the factor nodes}

\item{\code{lvl_nodes}}{Get the level nodes}

\item{\code{fct_edges}}{Get the factor edges}

\item{\code{lvl_edges}}{Get the level edges}

\item{\code{fct_n}}{Get the number of nodes in factor graph}

\item{\code{lvl_n}}{Get the number of nodes in level graph}

\item{\code{rcrd_ids}}{Get the ids for all edbl_rcrd factors.}

\item{\code{unit_ids}}{Get the ids for all edbl_unit factors.}

\item{\code{trt_ids}}{Get the ids for all edbl_trt factors.}

\item{\code{is_connected}}{Check if nodes are connected.
Get a new factor id.
Get a new level id.
Given a particular DAG, return a topological order
Remember that there could be more than one order.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Provenance-new}{\code{Provenance$new()}}
\item \href{#method-Provenance-set_title}{\code{Provenance$set_title()}}
\item \href{#method-Provenance-set_name}{\code{Provenance$set_name()}}
\item \href{#method-Provenance-set_validation}{\code{Provenance$set_validation()}}
\item \href{#method-Provenance-reactivate}{\code{Provenance$reactivate()}}
\item \href{#method-Provenance-deactivate}{\code{Provenance$deactivate()}}
\item \href{#method-Provenance-fct_id}{\code{Provenance$fct_id()}}
\item \href{#method-Provenance-fct_id_parent}{\code{Provenance$fct_id_parent()}}
\item \href{#method-Provenance-fct_id_child}{\code{Provenance$fct_id_child()}}
\item \href{#method-Provenance-fct_id_ancestor}{\code{Provenance$fct_id_ancestor()}}
\item \href{#method-Provenance-fct_id_leaves}{\code{Provenance$fct_id_leaves()}}
\item \href{#method-Provenance-lvl_id}{\code{Provenance$lvl_id()}}
\item \href{#method-Provenance-lvl_id_parent}{\code{Provenance$lvl_id_parent()}}
\item \href{#method-Provenance-lvl_id_child}{\code{Provenance$lvl_id_child()}}
\item \href{#method-Provenance-lvl_id_ancestor}{\code{Provenance$lvl_id_ancestor()}}
\item \href{#method-Provenance-fct_id_from_lvl_id}{\code{Provenance$fct_id_from_lvl_id()}}
\item \href{#method-Provenance-fct_id_from_lvl_values}{\code{Provenance$fct_id_from_lvl_values()}}
\item \href{#method-Provenance-lvl_id_from_fct_id}{\code{Provenance$lvl_id_from_fct_id()}}
\item \href{#method-Provenance-fct_names}{\code{Provenance$fct_names()}}
\item \href{#method-Provenance-unit_names}{\code{Provenance$unit_names()}}
\item \href{#method-Provenance-trt_names}{\code{Provenance$trt_names()}}
\item \href{#method-Provenance-rcrd_names}{\code{Provenance$rcrd_names()}}
\item \href{#method-Provenance-lvl_values}{\code{Provenance$lvl_values()}}
\item \href{#method-Provenance-unit_values}{\code{Provenance$unit_values()}}
\item \href{#method-Provenance-trt_values}{\code{Provenance$trt_values()}}
\item \href{#method-Provenance-rcrd_values}{\code{Provenance$rcrd_values()}}
\item \href{#method-Provenance-fct_role}{\code{Provenance$fct_role()}}
\item \href{#method-Provenance-fct_levels}{\code{Provenance$fct_levels()}}
\item \href{#method-Provenance-fct_levels_id_to_edbl_fct}{\code{Provenance$fct_levels_id_to_edbl_fct()}}
\item \href{#method-Provenance-fct_levels_id_to_value}{\code{Provenance$fct_levels_id_to_value()}}
\item \href{#method-Provenance-fct_levels_value_to_id}{\code{Provenance$fct_levels_value_to_id()}}
\item \href{#method-Provenance-fct_exists}{\code{Provenance$fct_exists()}}
\item \href{#method-Provenance-trt_exists}{\code{Provenance$trt_exists()}}
\item \href{#method-Provenance-unit_exists}{\code{Provenance$unit_exists()}}
\item \href{#method-Provenance-rcrd_exists}{\code{Provenance$rcrd_exists()}}
\item \href{#method-Provenance-append_fct_nodes}{\code{Provenance$append_fct_nodes()}}
\item \href{#method-Provenance-append_lvl_nodes}{\code{Provenance$append_lvl_nodes()}}
\item \href{#method-Provenance-append_fct_edges}{\code{Provenance$append_fct_edges()}}
\item \href{#method-Provenance-append_lvl_edges}{\code{Provenance$append_lvl_edges()}}
\item \href{#method-Provenance-serve_units}{\code{Provenance$serve_units()}}
\item \href{#method-Provenance-serve_trts}{\code{Provenance$serve_trts()}}
\item \href{#method-Provenance-serve_rcrds}{\code{Provenance$serve_rcrds()}}
\item \href{#method-Provenance-graph_subset}{\code{Provenance$graph_subset()}}
\item \href{#method-Provenance-save_seed}{\code{Provenance$save_seed()}}
\item \href{#method-Provenance-get_title}{\code{Provenance$get_title()}}
\item \href{#method-Provenance-get_validation}{\code{Provenance$get_validation()}}
\item \href{#method-Provenance-get_trail}{\code{Provenance$get_trail()}}
\item \href{#method-Provenance-get_graph}{\code{Provenance$get_graph()}}
\item \href{#method-Provenance-get_seed}{\code{Provenance$get_seed()}}
\item \href{#method-Provenance-get_session_info}{\code{Provenance$get_session_info()}}
\item \href{#method-Provenance-get_edibble_version}{\code{Provenance$get_edibble_version()}}
\item \href{#method-Provenance-mapping}{\code{Provenance$mapping()}}
\item \href{#method-Provenance-mapping_to_unit}{\code{Provenance$mapping_to_unit()}}
\item \href{#method-Provenance-record_step}{\code{Provenance$record_step()}}
\item \href{#method-Provenance-record_track_external}{\code{Provenance$record_track_external()}}
\item \href{#method-Provenance-clone}{\code{Provenance$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Provenance-new"></a>}}
\if{latex}{\out{\hypertarget{method-Provenance-new}{}}}
\subsection{Method \code{new()}}{
Initialise function
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Provenance$new(graph = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{graph}}{An edibble graph.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Provenance-set_title"></a>}}
\if{latex}{\out{\hypertarget{method-Provenance-set_title}{}}}
\subsection{Method \code{set_title()}}{
Set the title.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Provenance$set_title(title)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{title}}{The title of the experiment}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Provenance-set_name"></a>}}
\if{latex}{\out{\hypertarget{method-Provenance-set_name}{}}}
\subsection{Method \code{set_name()}}{
Set the name.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Provenance$set_name(name)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{The name of the edibble graph object.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Provenance-set_validation"></a>}}
\if{latex}{\out{\hypertarget{method-Provenance-set_validation}{}}}
\subsection{Method \code{set_validation()}}{
Set the validation.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Provenance$set_validation(validation, type = "rcrds")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{validation}}{The validation statement.}

\item{\code{type}}{The type of validation.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Provenance-reactivate"></a>}}
\if{latex}{\out{\hypertarget{method-Provenance-reactivate}{}}}
\subsection{Method \code{reactivate()}}{
Reactivate the graph in the provenance object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Provenance$reactivate(
  design,
  overwrite = c("graph", "anatomy", "recipe", "validation")
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{design}}{An edibble design}

\item{\code{overwrite}}{A vector of character to overwrite from the
supplied design object.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Provenance-deactivate"></a>}}
\if{latex}{\out{\hypertarget{method-Provenance-deactivate}{}}}
\subsection{Method \code{deactivate()}}{
Deactivate the provenance object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Provenance$deactivate(delete = c("graph", "anatomy", "recipe", "validation"))}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{delete}}{A vector of character to delete.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Provenance-fct_id"></a>}}
\if{latex}{\out{\hypertarget{method-Provenance-fct_id}{}}}
\subsection{Method \code{fct_id()}}{
Get the id based on either the name of the factor node.
If none supplied then it will give all.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Provenance$fct_id(name = NULL, role = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{The name of the node.}

\item{\code{role}}{The role for the node.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Provenance-fct_id_parent"></a>}}
\if{latex}{\out{\hypertarget{method-Provenance-fct_id_parent}{}}}
\subsection{Method \code{fct_id_parent()}}{
Get the factor parent ids
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Provenance$fct_id_parent(id = NULL, role = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{The id of the corresponding node.}

\item{\code{role}}{The role for the node.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Provenance-fct_id_child"></a>}}
\if{latex}{\out{\hypertarget{method-Provenance-fct_id_child}{}}}
\subsection{Method \code{fct_id_child()}}{
Get the factor child ids. If \code{role} is
supplied then the child has to fit \code{role}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Provenance$fct_id_child(id = NULL, role = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{The id of the corresponding node.}

\item{\code{role}}{The role for the node.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Provenance-fct_id_ancestor"></a>}}
\if{latex}{\out{\hypertarget{method-Provenance-fct_id_ancestor}{}}}
\subsection{Method \code{fct_id_ancestor()}}{
Get the factor ancestor ids
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Provenance$fct_id_ancestor(id = NULL, role = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{The id of the corresponding node.}

\item{\code{role}}{The role for the node.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Provenance-fct_id_leaves"></a>}}
\if{latex}{\out{\hypertarget{method-Provenance-fct_id_leaves}{}}}
\subsection{Method \code{fct_id_leaves()}}{
Get the leave factor ids.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Provenance$fct_id_leaves(role = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{role}}{The role for the node.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Provenance-lvl_id"></a>}}
\if{latex}{\out{\hypertarget{method-Provenance-lvl_id}{}}}
\subsection{Method \code{lvl_id()}}{
Get the id based on name of level node.
Assumes that level ids obtained are all from the same fid
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Provenance$lvl_id(value = NULL, role = NULL, fid = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{value}}{The value of the node.}

\item{\code{role}}{The role for the node.}

\item{\code{fid}}{The factor id.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Provenance-lvl_id_parent"></a>}}
\if{latex}{\out{\hypertarget{method-Provenance-lvl_id_parent}{}}}
\subsection{Method \code{lvl_id_parent()}}{
Get the level parent ids
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Provenance$lvl_id_parent(id = NULL, role = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{The id of the corresponding node.}

\item{\code{role}}{The role for the node.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Provenance-lvl_id_child"></a>}}
\if{latex}{\out{\hypertarget{method-Provenance-lvl_id_child}{}}}
\subsection{Method \code{lvl_id_child()}}{
Get the level child ids
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Provenance$lvl_id_child(id = NULL, role = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{The id of the corresponding node.}

\item{\code{role}}{The role for the node.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Provenance-lvl_id_ancestor"></a>}}
\if{latex}{\out{\hypertarget{method-Provenance-lvl_id_ancestor}{}}}
\subsection{Method \code{lvl_id_ancestor()}}{
Get the level ancestor ids
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Provenance$lvl_id_ancestor(id = NULL, role = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{The id of the corresponding node.}

\item{\code{role}}{The role for the node.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Provenance-fct_id_from_lvl_id"></a>}}
\if{latex}{\out{\hypertarget{method-Provenance-fct_id_from_lvl_id}{}}}
\subsection{Method \code{fct_id_from_lvl_id()}}{
Find the factor id from level ids.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Provenance$fct_id_from_lvl_id(id = NULL, fid_search = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{The id of the corresponding node.}

\item{\code{fid_search}}{A vector of fids to search from.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Provenance-fct_id_from_lvl_values"></a>}}
\if{latex}{\out{\hypertarget{method-Provenance-fct_id_from_lvl_values}{}}}
\subsection{Method \code{fct_id_from_lvl_values()}}{
Find the factor id from level values.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Provenance$fct_id_from_lvl_values(value = NULL, fid_search = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{value}}{The value of the node.}

\item{\code{fid_search}}{A vector of fids to search from.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Provenance-lvl_id_from_fct_id"></a>}}
\if{latex}{\out{\hypertarget{method-Provenance-lvl_id_from_fct_id}{}}}
\subsection{Method \code{lvl_id_from_fct_id()}}{
Find the level id from the given fid
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Provenance$lvl_id_from_fct_id(fid = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{fid}}{The factor id.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Provenance-fct_names"></a>}}
\if{latex}{\out{\hypertarget{method-Provenance-fct_names}{}}}
\subsection{Method \code{fct_names()}}{
Get the factor names based on id or role
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Provenance$fct_names(id = NULL, role = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{The id of the corresponding node.}

\item{\code{role}}{The role for the node.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Provenance-unit_names"></a>}}
\if{latex}{\out{\hypertarget{method-Provenance-unit_names}{}}}
\subsection{Method \code{unit_names()}}{
Get the unit names
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Provenance$unit_names(id = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{The id of the corresponding node.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Provenance-trt_names"></a>}}
\if{latex}{\out{\hypertarget{method-Provenance-trt_names}{}}}
\subsection{Method \code{trt_names()}}{
Get the treatment names
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Provenance$trt_names(id = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{The id of the corresponding node.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Provenance-rcrd_names"></a>}}
\if{latex}{\out{\hypertarget{method-Provenance-rcrd_names}{}}}
\subsection{Method \code{rcrd_names()}}{
Get the record names.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Provenance$rcrd_names(id = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{The id of the corresponding node.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Provenance-lvl_values"></a>}}
\if{latex}{\out{\hypertarget{method-Provenance-lvl_values}{}}}
\subsection{Method \code{lvl_values()}}{
Get the level values based on id or role
cannot have just role only defined.
id must be from the same fid
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Provenance$lvl_values(id = NULL, role = NULL, fid = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{The id of the corresponding node.}

\item{\code{role}}{The role for the node.}

\item{\code{fid}}{The factor id.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Provenance-unit_values"></a>}}
\if{latex}{\out{\hypertarget{method-Provenance-unit_values}{}}}
\subsection{Method \code{unit_values()}}{
Get the unit values.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Provenance$unit_values(id = NULL, fid = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{The id of the corresponding node.}

\item{\code{fid}}{The factor id.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Provenance-trt_values"></a>}}
\if{latex}{\out{\hypertarget{method-Provenance-trt_values}{}}}
\subsection{Method \code{trt_values()}}{
Get the treatment values.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Provenance$trt_values(id = NULL, fid = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{The id of the corresponding node.}

\item{\code{fid}}{The factor id.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Provenance-rcrd_values"></a>}}
\if{latex}{\out{\hypertarget{method-Provenance-rcrd_values}{}}}
\subsection{Method \code{rcrd_values()}}{
Get the record values.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Provenance$rcrd_values(uid = NULL, fid = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{uid}}{The unit level id}

\item{\code{fid}}{The factor id.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Provenance-fct_role"></a>}}
\if{latex}{\out{\hypertarget{method-Provenance-fct_role}{}}}
\subsection{Method \code{fct_role()}}{
Get the role of the vertex given the factor id
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Provenance$fct_role(id = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{The id of the corresponding node.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Provenance-fct_levels"></a>}}
\if{latex}{\out{\hypertarget{method-Provenance-fct_levels}{}}}
\subsection{Method \code{fct_levels()}}{
Get the levels for each factor
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Provenance$fct_levels(id = NULL, name = NULL, return = c("id", "value"))}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{The id of the corresponding node.}

\item{\code{name}}{The name of the node.}

\item{\code{return}}{To return in "id" or "value" format.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Provenance-fct_levels_id_to_edbl_fct"></a>}}
\if{latex}{\out{\hypertarget{method-Provenance-fct_levels_id_to_edbl_fct}{}}}
\subsection{Method \code{fct_levels_id_to_edbl_fct()}}{
Factor levels to edble factor
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Provenance$fct_levels_id_to_edbl_fct(fct_levels, role)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{fct_levels}}{The factor levels in id.}

\item{\code{role}}{The role for the node.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Provenance-fct_levels_id_to_value"></a>}}
\if{latex}{\out{\hypertarget{method-Provenance-fct_levels_id_to_value}{}}}
\subsection{Method \code{fct_levels_id_to_value()}}{
Get the factor levels in value given id format
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Provenance$fct_levels_id_to_value(fct_levels)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{fct_levels}}{A list of factor levels in id format.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Provenance-fct_levels_value_to_id"></a>}}
\if{latex}{\out{\hypertarget{method-Provenance-fct_levels_value_to_id}{}}}
\subsection{Method \code{fct_levels_value_to_id()}}{
Get the factor levels in id given value format.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Provenance$fct_levels_value_to_id(fct_levels)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{fct_levels}}{A list of factor levels in id format.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Provenance-fct_exists"></a>}}
\if{latex}{\out{\hypertarget{method-Provenance-fct_exists}{}}}
\subsection{Method \code{fct_exists()}}{
One of \code{name}, \code{id} or \code{role} is defined to check if it exists.
If more than one of the arguments \code{name}, \code{id} and \code{role} are supplied, then
the intersection of it will be checked.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Provenance$fct_exists(id = NULL, name = NULL, role = NULL, abort = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{The id of the corresponding node.}

\item{\code{name}}{The name of the node.}

\item{\code{role}}{The role for the node.}

\item{\code{abort}}{Whether to abort.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Provenance-trt_exists"></a>}}
\if{latex}{\out{\hypertarget{method-Provenance-trt_exists}{}}}
\subsection{Method \code{trt_exists()}}{
Check if treatment exists.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Provenance$trt_exists(id = NULL, name = NULL, abort = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{The id of the corresponding node.}

\item{\code{name}}{The name of the node.}

\item{\code{abort}}{Whether to abort.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Provenance-unit_exists"></a>}}
\if{latex}{\out{\hypertarget{method-Provenance-unit_exists}{}}}
\subsection{Method \code{unit_exists()}}{
Check if unit exists.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Provenance$unit_exists(id = NULL, name = NULL, abort = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{The id of the corresponding node.}

\item{\code{name}}{The name of the node.}

\item{\code{abort}}{Whether to abort.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Provenance-rcrd_exists"></a>}}
\if{latex}{\out{\hypertarget{method-Provenance-rcrd_exists}{}}}
\subsection{Method \code{rcrd_exists()}}{
Check if record exists.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Provenance$rcrd_exists(id = NULL, name = NULL, abort = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{The id of the corresponding node.}

\item{\code{name}}{The name of the node.}

\item{\code{abort}}{Whether to abort.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Provenance-append_fct_nodes"></a>}}
\if{latex}{\out{\hypertarget{method-Provenance-append_fct_nodes}{}}}
\subsection{Method \code{append_fct_nodes()}}{
Given node data, append the factor nodes
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Provenance$append_fct_nodes(name, role, attrs = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{The name of the node.}

\item{\code{role}}{The role for the node.}

\item{\code{attrs}}{The attributes.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Provenance-append_lvl_nodes"></a>}}
\if{latex}{\out{\hypertarget{method-Provenance-append_lvl_nodes}{}}}
\subsection{Method \code{append_lvl_nodes()}}{
Given node data, append the level nodes
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Provenance$append_lvl_nodes(value, attrs = NULL, fid = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{value}}{The value of the node.}

\item{\code{attrs}}{The attributes.}

\item{\code{fid}}{The factor id.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Provenance-append_fct_edges"></a>}}
\if{latex}{\out{\hypertarget{method-Provenance-append_fct_edges}{}}}
\subsection{Method \code{append_fct_edges()}}{
Given edge data, append the factor edges
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Provenance$append_fct_edges(from, to, type = NULL, group = NULL, attrs = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{from}}{The node id from.}

\item{\code{to}}{The node id to.}

\item{\code{type}}{The type of edges.}

\item{\code{group}}{The group id.}

\item{\code{attrs}}{The attributes.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Provenance-append_lvl_edges"></a>}}
\if{latex}{\out{\hypertarget{method-Provenance-append_lvl_edges}{}}}
\subsection{Method \code{append_lvl_edges()}}{
Given edge data, append the level edges
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Provenance$append_lvl_edges(from, to, attrs = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{from}}{The node id from.}

\item{\code{to}}{The node id to.}

\item{\code{attrs}}{The attributes.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Provenance-serve_units"></a>}}
\if{latex}{\out{\hypertarget{method-Provenance-serve_units}{}}}
\subsection{Method \code{serve_units()}}{
Serve the units.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Provenance$serve_units(id = NULL, return = c("id", "value"))}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{The id of the corresponding node.}

\item{\code{return}}{To return in "id" or "value" format.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Provenance-serve_trts"></a>}}
\if{latex}{\out{\hypertarget{method-Provenance-serve_trts}{}}}
\subsection{Method \code{serve_trts()}}{
Serve treatments
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Provenance$serve_trts(id = NULL, return = c("id", "value"))}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{The id of the corresponding node.}

\item{\code{return}}{To return in "id" or "value" format.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Provenance-serve_rcrds"></a>}}
\if{latex}{\out{\hypertarget{method-Provenance-serve_rcrds}{}}}
\subsection{Method \code{serve_rcrds()}}{
Serve records
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Provenance$serve_rcrds(id = NULL, return = c("id", "value"))}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{The id of the corresponding node.}

\item{\code{return}}{To return in "id" or "value" format.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Provenance-graph_subset"></a>}}
\if{latex}{\out{\hypertarget{method-Provenance-graph_subset}{}}}
\subsection{Method \code{graph_subset()}}{
Subset graph
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Provenance$graph_subset(
  id = NULL,
  include = c("self", "child", "parent", "ancestors")
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{The id of the corresponding node.}

\item{\code{include}}{"self" for only input id, "child" for child also,
"parent" for parent also,
nodes immediately related, and "ancestors" for all ancestors}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
subsetted graph
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Provenance-save_seed"></a>}}
\if{latex}{\out{\hypertarget{method-Provenance-save_seed}{}}}
\subsection{Method \code{save_seed()}}{
Save the seed
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Provenance$save_seed(seed)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{seed}}{A seed.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Provenance-get_title"></a>}}
\if{latex}{\out{\hypertarget{method-Provenance-get_title}{}}}
\subsection{Method \code{get_title()}}{
Get the title
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Provenance$get_title()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Provenance-get_validation"></a>}}
\if{latex}{\out{\hypertarget{method-Provenance-get_validation}{}}}
\subsection{Method \code{get_validation()}}{
Get the validation
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Provenance$get_validation(type = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{type}}{A type.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Provenance-get_trail"></a>}}
\if{latex}{\out{\hypertarget{method-Provenance-get_trail}{}}}
\subsection{Method \code{get_trail()}}{
Get the trail.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Provenance$get_trail()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Provenance-get_graph"></a>}}
\if{latex}{\out{\hypertarget{method-Provenance-get_graph}{}}}
\subsection{Method \code{get_graph()}}{
Get the graph
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Provenance$get_graph()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Provenance-get_seed"></a>}}
\if{latex}{\out{\hypertarget{method-Provenance-get_seed}{}}}
\subsection{Method \code{get_seed()}}{
Get the seed
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Provenance$get_seed()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Provenance-get_session_info"></a>}}
\if{latex}{\out{\hypertarget{method-Provenance-get_session_info}{}}}
\subsection{Method \code{get_session_info()}}{
Get the session information
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Provenance$get_session_info()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Provenance-get_edibble_version"></a>}}
\if{latex}{\out{\hypertarget{method-Provenance-get_edibble_version}{}}}
\subsection{Method \code{get_edibble_version()}}{
Get the edibble version.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Provenance$get_edibble_version()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Provenance-mapping"></a>}}
\if{latex}{\out{\hypertarget{method-Provenance-mapping}{}}}
\subsection{Method \code{mapping()}}{
Mapping of a role to role
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Provenance$mapping(role_from, role_to)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{role_from}}{The role from.}

\item{\code{role_to}}{The role to.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Provenance-mapping_to_unit"></a>}}
\if{latex}{\out{\hypertarget{method-Provenance-mapping_to_unit}{}}}
\subsection{Method \code{mapping_to_unit()}}{
Mapping of an id to a unit
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Provenance$mapping_to_unit(id = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{The id of the corresponding node.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Provenance-record_step"></a>}}
\if{latex}{\out{\hypertarget{method-Provenance-record_step}{}}}
\subsection{Method \code{record_step()}}{
Record step.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Provenance$record_step()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Provenance-record_track_external"></a>}}
\if{latex}{\out{\hypertarget{method-Provenance-record_track_external}{}}}
\subsection{Method \code{record_track_external()}}{
Record track external.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Provenance$record_track_external(code)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{code}}{The code to record.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Provenance-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Provenance-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Provenance$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
