% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coagulate.R
\name{coagulate}
\alias{coagulate}
\alias{coagulate_base}
\title{Low-level langmuir coagulation calculations}
\usage{
coagulate(data, coefs)

coagulate_base(DOC, dose, pH, UV254, K1, K2, x1, x2, x3, b, root = -1)
}
\arguments{
\item{data}{A data frame containing columns \code{DOC}, \code{dose}, \code{pH}, and \code{UV254}.}

\item{coefs}{The output of \code{\link[=edwards_coefs]{edwards_coefs()}} or a similar named vector
containing elements \code{K1}, \code{K2}, \code{x1}, \code{x2}, \code{x3}, \code{b} and \code{root}.}

\item{DOC}{The initial DOC concentration (mg/L).}

\item{dose}{The coagulant dose (mmol/L).}

\item{pH}{The pH of coagulation.}

\item{UV254}{The absorbance of UV254 (1/cm). With \code{DOC},
used to calculate SUVA.}

\item{K1, K2}{Empirical fitting coefficients relating to SUVA.}

\item{x1, x2, x3}{Empirical fitting coefficients relating to pH.}

\item{b}{The Langmuir term.}

\item{root}{The solution to the equation presented in Edwards (1997) is
a quadratic with two roots. \code{root} can be 1 or -1 to account for these roots,
however we see no evidence that anything except -1 here results in realistic
predictions.}
}
\value{
A vector of predicted organic carbon concentrations (in mg/L) following
coagulation.
}
\description{
The Edwards (1997) model is a Langmuir-based semiempirical model designed to predict
OC removal during alum coagulation. The model is on a non-linear function
derived from physical relationships, primarily the process of
Langmuir sorptive removal (Tipping 1981, Jekyl 1986).
}
\examples{
alum_jar_tests <- edwards_data("Al")
alum_jar_tests$DOC_final_model <- coagulate(alum_jar_tests, edwards_coefs("Al"))
plot(DOC_final_model ~ DOC_final, data = alum_jar_tests)

}
\references{
Edwards, M. 1997. Predicting DOC removal during enhanced coagulation.
Journal - American Water Works Association, 89: 78–89.
https://doi.org/10.1002/j.1551-8833.1997.tb08229.x

Jekel, M.R. 1986. Interactions of humic acids and aluminum salts
in the flocculation process. Water Research, 20: 1535-1542.
https://doi.org/10.1016/0043-1354(86)90118-1

Tipping, E. 1981. The adsorption of aquatic humic substances by iron oxides.
Geochimica et Cosmochimica Acta, 45: 191-199.
https://doi.org/10.1016/0016-7037(81)90162-9
}
