% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eefAnalytics_03_2017.r
\name{caceCRTBoot}
\alias{caceCRTBoot}
\title{Complier Average Causal Effect (CACE) Analysis of Cluster Randomised Education Trials using Multilevel Model.}
\usage{
caceCRTBoot(formula, random, intervention, compliance, nBoot, data)
}
\arguments{
\item{formula}{the model to be analysed. It is of the form y ~ x1+x2+.... Where y is the outcome variable and Xs are the predictors.}

\item{random}{a string variable specifying the "clustering variable" as contained in the data. See example below}

\item{intervention}{a string variable specifying the "intervention variable" as appeared in the formula. See example below}

\item{compliance}{a string variable specifying the "compliance variable" as contained in the data.  The data must be in percentages ranging from 0 - 100.}

\item{nBoot}{number of bootstraps required to generate bootstrap confidence interval. Default is NULL.}

\item{data}{data frame containing the data to be analysed.}
}
\value{
S3 object; a list consisting of
\itemize{
\item \code{CACE}. Estimates of CACE adjusted effect sizes based on pre-specified thresholds. Only produced for threshold with at least 50% compliance rate.
\item \code{Compliers}. Percentage of pupils that achieved a pre-specified threshold of compliance.
}
}
\description{
\code{caceCRTBoot} performs exploratoty CACE analysis of cluster randomised education trials.
}
\examples{
if(interactive()){

data(crtData)

######################## weighted ITT ##############################################
caceOutput<- caceCRTBoot(Posttest~ Prettest+ Intervention,
			random="School",intervention="Intervention",
			compliance = "Percentage_Attendance",nBoot=1000,data=crtData)

cace <- caceOutput$CACE
cace

Complier <- caceOutput$Compliers
Complier 

### visualising CACE effect size

plot(caceOutput)
}
}

