% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ale.R
\name{.ale}
\alias{.ale}
\title{Barebone Accumulated Local Effects (ALE)}
\usage{
.ale(
  object,
  v,
  data,
  breaks,
  right = TRUE,
  pred_fun = stats::predict,
  trafo = NULL,
  which_pred = NULL,
  bin_size = 200L,
  w = NULL,
  g = NULL,
  ...
)
}
\arguments{
\item{object}{Fitted model.}

\item{v}{Variable name in \code{data} to calculate ALE.}

\item{data}{Matrix or data.frame.}

\item{breaks}{Breaks for ALE calculation.}

\item{right}{Should bins specified via \code{breaks} be right-closed?
The default is \code{TRUE}.}

\item{pred_fun}{Prediction function, by default \code{stats::predict}.
The function takes three arguments (names irrelevant): \code{object}, \code{data}, and \code{...}.}

\item{trafo}{How should predictions be transformed?
A function or \code{NULL} (default). Examples are \code{log} (to switch to link scale)
or \code{exp} (to switch from link scale to the original scale).}

\item{which_pred}{If the predictions are multivariate: which column to pick
(integer or column name). By default \code{NULL} (picks last column).}

\item{bin_size}{Maximal number of observations used per bin. If there are more
observations in a bin, \code{bin_size} indices are randomly sampled. The default is 200.}

\item{w}{Optional vector with case weights.}

\item{g}{For internal use. The result of \code{qF(findInterval(...))}.
By default \code{NULL}.}

\item{...}{Further arguments passed to \code{pred_fun()}, e.g., \code{type = "response"} in
a \code{glm()} or (typically) \code{prob = TRUE} in classification models.}
}
\value{
Vector of ALE values in the same order as \code{breaks[-length(breaks)]}.
}
\description{
This is a barebone implementation of Apley's ALE intended for developers.
To get more information on ALE, see \code{\link[=ale]{ale()}}.
}
\examples{
fit <- lm(Sepal.Length ~ ., data = iris)
v <- "Sepal.Width"
.ale(fit, v, data = iris, breaks = seq(2, 4, length.out = 5))
}
\references{
Apley, Daniel W., and Jingyu Zhu. 2020. \emph{Visualizing the Effects of Predictor Variables in Black Box Supervised Learning Models.}
Journal of the Royal Statistical Society Series B: Statistical Methodology,
82 (4): 1059–1086. doi:10.1111/rssb.12377.
}
\seealso{
\code{\link[=partial_dependence]{partial_dependence()}}
}
