% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crunch.R
\name{fcut}
\alias{fcut}
\title{Fast cut()}
\usage{
fcut(x, breaks, labels = NULL, right = TRUE, explicit_na = FALSE)
}
\arguments{
\item{x}{A numeric vector.}

\item{breaks}{A monotonically increasing numeric vector of breaks.}

\item{labels}{A character vector of length \code{length(breaks) - 1} with bin labels.
By default (\code{NULL}), the levels \code{c("1", "2", ...)} are used. Set to \code{FALSE}
to return raw integer codes.}

\item{right}{Right closed bins (\code{TRUE}, default) or not?}

\item{explicit_na}{If \code{TRUE}, missing values are encoded by the bin value
\code{length(breaks)}, having \code{NA} as corresponding factor level. The factor will get
the additional class "na.included".}
}
\value{
Binned version of \code{x}. Either a factor, or integer codes.
}
\description{
Bins a numeric vector \code{x} into bins specified by \code{breaks}.
Values outside the range of \code{breaks} will be placed in the lowest or highest bin.
Set \code{labels = FALSE} to return integer codes only, and \code{explicit_na = TRUE} for
maximal synergy with the "collapse" package.
Uses the logic of \code{spatstat.utils::fastFindInterval()} for equi-length bins.
}
\examples{
x <- c(NA, 1:10)
fcut(x, breaks = c(3, 5, 7))
fcut(x, breaks = c(3, 5, 7), right = FALSE)
fcut(x, breaks = c(3, 5, 7), labels = FALSE)

}
