% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eta_squared_posterior.R
\name{eta_squared_posterior}
\alias{eta_squared_posterior}
\title{Simulate Eta Squared from Posterior Predictive Distribution}
\usage{
eta_squared_posterior(
  model,
  partial = TRUE,
  type = 3,
  draws = 500,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{model}{A Bayesian linear model, fit with \code{brms} or \code{rstanarm}.}

\item{partial}{Whether Partial Eta should be returned.}

\item{type}{Type of sum-of-squares to use. See \code{\link[car:Anova]{car::Anova()}}.}

\item{draws}{An integer indicating the number of draws from the posterior
predictive distribution to return. Larger numbers take longer to run, but
provide estimates that are more stable.}

\item{verbose}{Show messages / warning about centering.}

\item{...}{Currently not used.}
}
\value{
A data frame containing the ppd of the Eta squared for each fixed
effect, which can then be passed to \code{\link[bayestestR:describe_posterior]{bayestestR::describe_posterior()}} for
summary stats.
}
\description{
This function simulates data from the posterior predictive distribution (ppd)
and for each simulation the Eta Squared is computed for the model's fixed
effects. This means that the returned values are the population level effect
size as implied by the posterior model (and not the effect size in the sample
data). See \code{\link[rstantools:posterior_predict]{rstantools::posterior_predict()}} for more info.
\cr\cr
Effect sizes are computed using the sums of squares obtained from
\code{car::Anova(model, ...)} which might not always be appropriate (\strong{\emph{Yeah...
ANOVAs are hard...}}), e.g., when factors aren't 0-mean codded and
covariates aren't centered; a warning will be given in such predictors are
detected. See \emph{details} section in \code{\link[=eta_squared]{eta_squared()}}.
}
\examples{
\donttest{
if (require(rstanarm) && require(bayestestR)) {
  fit_bayes <- stan_glm(mpg ~ factor(cyl) * wt + qsec,
                        data = mtcars,
                        family = gaussian(),
                        refresh = 0)

  es <- eta_squared_posterior(fit_bayes)

  bayestestR::describe_posterior(es)
}

# compare to:
if (require(car)) {
  fit_freq <- lm(mpg ~ factor(cyl) * wt + qsec,
                 data = mtcars)
  aov_table <- car::Anova(fit_freq, type = 3)
  eta_squared(aov_table)
}
}


}
