% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read.egonet.R
\name{long.df.to.list}
\alias{long.df.to.list}
\title{Trim/listify ego-centered network data}
\usage{
long.df.to.list(long, netsize, egoID, back.to.df = FALSE)
}
\arguments{
\item{long}{A 'long' dataframe with alters/dyads in rows.}

\item{netsize}{\code{Vector} containing values of network size per ego.}

\item{egoID}{\code{Character}. Name of the variable identifying egos (default: "egoID").}

\item{back.to.df}{If \code{TRUE} a dataframe is returned, if \code{FALSE} a
list. Defaults to \code{FALSE}.}

\item{wide}{A \code{data.frame} of alter attributes in the wide format.}
}
\value{
Returns a \code{list} of \code{dataframes} where every
\code{dataframe} represents one ego/ network and the rows in the
\code{dataframe} represents one alter. If the \code{back.to.df} parameter is
called the \code{list} entries are combined to one \code{dataframe}, in the
'long' format.
}
\description{
This function generates the \code{alters.list} object. \code{alters.list} is a list where
each entry entails a \code{dataframe} of the alters of one ego. By using
the \code{netsize} variable it is ensured, that the list entries are of the
correct length and possibly present rows of NA values are deleted.
}
\keyword{internal}
