% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ltx.R
\name{ltx}
\alias{ltx}
\title{LaTeX printing of coxreg results.}
\usage{
ltx(
  x,
  caption = NULL,
  label = NULL,
  dr = NULL,
  digits = max(options()$digits - 4, 3),
  ...
)
}
\arguments{
\item{x}{The output from a call to \code{coxreg}, \code{coxreg}, or
\code{aftreg}}

\item{caption}{A suitable caption for the table.}

\item{label}{A label used in the LaTeX code.}

\item{dr}{Output from a \code{drop1} call.}

\item{digits}{Number of digits to be printed.}

\item{\dots}{Not used.}
}
\value{
LaTeX code version of the results from a run with
\code{\link{coxreg}}, \code{\link{phreg}}, or \code{\link{aftreg}}.
}
\description{
This (generic) function prints the LaTeX code of the results of a fit from
\code{\link{coxreg}}, \code{\link{phreg}}, or \code{\link{aftreg}}, similar
to what \code{xtable} does for fits from other functions.
}
\details{
The result is a printout which is (much) nicer than the standard printed
output from \code{glm} and friends,
}
\note{
There is no method in \code{xtable} for \code{coxreg}.
}
\examples{

data(oldmort)
fit <- coxreg(Surv(enter, exit, event) ~ civ + sex, data = oldmort)
dr <- drop1(fit, test = "Chisq")
ltx(fit, dr = dr, caption = "A test example.", label = "tab:test1") 

}
\seealso{
\code{xtable}, \code{\link{coxreg}}
}
\author{
Göran Broström.
}
\keyword{printing}
