% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eimpute.R
\name{eimpute}
\alias{eimpute}
\title{Efficiently impute missing values for a large scale matrix}
\usage{
eimpute(
  x,
  r,
  svd.method = c("tsvd", "rsvd"),
  noise.var = 0,
  thresh = 1e-05,
  maxit = 100,
  init = FALSE,
  init.mat = 0,
  override = FALSE,
  control = list(...),
  ...
)
}
\arguments{
\item{x}{an \eqn{m} by \eqn{n} matrix with \code{NA}s.}

\item{r}{the rank of low-rank matrix for approximating \code{x}}

\item{svd.method}{a character string indicating the truncated SVD method.
If \code{svd.method = "rsvd"}, a randomized SVD is used,
else if \code{svd.method = "tsvd"}, standard truncated SVD is used.
Any unambiguous substring can be given. Default \code{svd.method = "tsvd"}.}

\item{noise.var}{the variance of noise.}

\item{thresh}{convergence threshold, measured as the relative change in the Frobenius norm between two successive estimates.}

\item{maxit}{maximal number of iterations.}

\item{init}{if init = FALSE(the default), the missing entries will initialize with mean.}

\item{init.mat}{the initialization matrix.}

\item{override}{logical value indicating whether the observed elements in \code{x} should be overwritten by its low-rank approximation.}

\item{control}{a list of parameters that control details of standard procedure, See \link{biscale.control}.}

\item{...}{arguments to be used to form the default control argument if it is not supplied directly.}
}
\value{
A list containing the following components
\item{\code{x.imp}}{the matrix after completion.}
\item{\code{rmse}}{the relative mean square error of matrix completion, i.e., training error.}
\item{\code{iter.count}}{the number of iterations.}
}
\description{
Fit a low-rank matrix approximation to a matrix with missing values.
The algorithm iterates like EM: filling the missing values with the current guess,
and then approximating the complete matrix via truncated SVD.
}
\examples{
################# Quick Start #################
m <- 100
n <- 100
r <- 10
x_na <- incomplete.generator(m, n, r)
head(x_na[, 1:6])
x_impute <- eimpute(x_na, r)
head(x_impute[["x.imp"]][, 1:6])
x_impute[["rmse"]]
}
\references{
Rahul Mazumder, Trevor Hastie and Rob Tibshirani (2010) Spectral Regularization Algorithms for Learning Large Incomplete Matrices, Journal of Machine Learning Research 11, 2287-2322

Nathan Halko, Per-Gunnar Martinsson, Joel A. Tropp (2011) Finding Structure with Randomness: Probabilistic Algorithms for Constructing Approximate Matrix Decompositions, Siam Review Vol. 53, num. 2, pp. 217-288
}
