% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrf_grid.R
\name{wrf_grid}
\alias{wrf_grid}
\title{Creates grid from wrf file}
\usage{
wrf_grid(filewrf, type = "wrfinput", matrix = F, epsg = 4326)
}
\arguments{
\item{filewrf}{wrf file}

\item{type}{Type of wrf file: "wrfinput" or "geo". When type is "geo", lat
long comes from mass grid, XLONG_M and XLAT_M}

\item{matrix}{if the output is matrix or polygon (sf)}

\item{epsg}{epsg code number (see http://spatialreference.org/ref/epsg/)}
}
\description{
Return a Spatial Feature multipolygon or matrix
}
\examples{
{
# Do not run
wrf <- paste(system.file("extdata", package = "eixport"),
                         "/wrfinput_d02", sep="")
gwrf  <- wrf_grid(wrf)
plot(gwrf, axes = TRUE)
}
}
