% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chem_edgar.R
\name{chem_edgar}
\alias{chem_edgar}
\title{Agregate EDGAR emissions NetCDF files into a RasterStack by}
\usage{
chem_edgar(path, chem, merge = FALSE, k = rep(1, 34), verbose = TRUE)
}
\arguments{
\item{path}{Character; path to the NetCDF files from EDGAR. The directory
\strong{must} have one file for each of the following pollutants:
"voc" from 1 to 25, "co", "nox", "nmvoc","so2", "nh3",
"pm10", "pm2.5", "bc" and "oc"}

\item{chem}{Character; chemical mechanism: "edgar", "radm", "radmsorg",
"cbmz_mosaic", "cptec", "ecb05_opt1",
"neu_cb05" (thanks to Daniel Schuch) and
"ufpr_cbmz" (thanks to Leila Martins).
\itemize{
\item When chem is "edgar" units are: "g km-2 h-1"
\item Other mechanisms: gases "mol km-2 h-1" and aerosols: "ug m-2 s-1"
}}

\item{merge}{Logical; in the case that tehre are more than one NetCDF per pollutant,
merge = TRUE will merge them with sum. Default is FALSE.}

\item{k, }{Numeric; Value to factorize each pollutant.}

\item{verbose}{Logical to print more information}
}
\value{
RasterStack
}
\description{
The Emissions Database for Global Atmospheric Research (EDGAR) is a
project from the Joint Research Centre. This function reads the NetCDF and
merge/aggregate into diferent chemical mechanisms
}
\note{
Molecular weights were obtained from

Development of  Improved Chemical Speciation Database for Processing Emissions of
Volatile Organic Compounds for Air Quality Models
https://intra.engr.ucr.edu/~carter/emitdb/

Some mappings were obtained from:

Carter, W. P. (2015). Development of a database for chemical
mechanism assignments for volatile organic emissions.
Journal of the Air & Waste Management Association, 65(10), 1171-1184.

Lopez-Norena, Ana and Fernandez, Rafael & Puliafito, SALVADOR. (2019).
ESPECIACION DE INVENTARIOS DE EMISIONES DE AEROSOLES Y COMPUESTOS ORGANICOS
VOLATILES PARA EL MODELO WRF-CHEM, APLICADO A LOS ESQUEMAS RADM-2,
CBM-Z Y MOZART-4.
}
\examples{
\dontrun{
# Not run
# Downloading EDGAR data ####
get_edgar(
  dataset = "v432_VOC_spec",
  destpath = "V50_432_AP/TOT/",
  sector = c("TOTALS"),
  type = "nc",
  year = 2012
)

get_edgar(
  dataset = "v50_AP",
  destpath = "V50_432_AP/TOT",
  sector = c("TOTALS"),
  type = "nc",
  year = 2014
)

get_edgar(
  dataset = "v432_VOC_spec",
  destpath = "V50_432_AP/TRO/",
  sector = c("TRO"),
  type = "nc",
  year = 2012, ask = F
)

get_edgar(
  dataset = "v50_AP",
  destpath = "V50_432_AP/TRO",
  sector = c("TRO_RES", "TRO_noRES"),
  type = "nc",
  year = 2014
)

totals <- list.files(
  path = "V50_432_AP/TOT/",
  full.names = TRUE,
  pattern = ".zip"
)
lapply(totals, unzip, exdir = "V50_432_AP/TOT//")


tros <- list.files(
  path = "V50_432_AP/TRO",
  full.names = TRUE,
  pattern = ".zip"
)
lapply(tros, unzip, exdir = "V50_432_AP/TRO/")
edgar_chem("V50_432_AP/TOT", "radm")
}
}
