% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nodes.R
\name{nodes}
\alias{nodes}
\alias{nodes_stats}
\alias{nodes_info}
\alias{nodes_hot_threads}
\title{Elasticsearch nodes endpoints.}
\usage{
nodes_stats(conn, node = NULL, metric = NULL, raw = FALSE,
  fields = NULL, ...)

nodes_info(conn, node = NULL, metric = NULL, raw = FALSE, ...)

nodes_hot_threads(conn, node = NULL, metric = NULL, threads = 3,
  interval = "500ms", type = NULL, raw = FALSE, ...)
}
\arguments{
\item{conn}{an Elasticsearch connection object, see \code{\link[=connect]{connect()}}}

\item{node}{The node}

\item{metric}{A metric to get. See Details.}

\item{raw}{If \code{TRUE} (default), data is parsed to list. If \code{FALSE}, then
raw JSON.}

\item{fields}{You can get information about field data memory usage on
node level or on index level}

\item{...}{Curl args passed on to \link[crul:verb-GET]{crul::verb-GET}}

\item{threads}{(character) Number of hot threads to provide. Default: 3}

\item{interval}{(character) The interval to do the second sampling of
threads. Default: 500ms}

\item{type}{(character) The type to sample, defaults to cpu, but supports
wait and block to see hot threads that are in wait or block state.}
}
\description{
Elasticsearch nodes endpoints.
}
\details{
\url{https://www.elastic.co/guide/en/elasticsearch/reference/current/cluster-nodes-stats.html}

By default, all stats are returned. You can limit this by combining any of
indices, os, process, jvm, network, transport, http, fs, breaker and
thread_pool. With the metric parameter you can select zero or more of:
\itemize{
\item indices Indices stats about size, document count, indexing and
deletion times, search times, field cache size, merges and flushes
\item os retrieve information that concern the operating system
\item fs File system information, data path, free disk space,
read/write stats
\item http HTTP connection information
\item jvm JVM stats, memory pool information, garbage collection,
buffer pools
\item network TCP information
\item os Operating system stats, load average, cpu, mem, swap
\item process Process statistics, memory consumption, cpu usage, open
file descriptors
\item thread_pool Statistics about each thread pool, including current
size, queue and rejected tasks
\item transport Transport statistics about sent and received bytes in
cluster communication
\item breaker Statistics about the field data circuit breaker
}

\code{\link[=nodes_hot_threads]{nodes_hot_threads()}} returns plain text, so \code{\link[base:cat]{base::cat()}}
is used to print to the console.
}
\examples{
\dontrun{
# connection setup
(x <- connect())

(out <- nodes_stats(x))
nodes_stats(x, node = names(out$nodes))
nodes_stats(x, metric='get')
nodes_stats(x, metric='jvm')
nodes_stats(x, metric=c('os','process'))
nodes_info(x)
nodes_info(x, metric='process')
nodes_info(x, metric='jvm')
nodes_info(x, metric='http')
nodes_info(x, metric='network')
}
}
