% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reindex.R
\name{reindex}
\alias{reindex}
\title{Reindex}
\usage{
reindex(conn, body, refresh = NULL, requests_per_second = NULL,
  slices = NULL, timeout = NULL, wait_for_active_shards = NULL,
  wait_for_completion = NULL, ...)
}
\arguments{
\item{conn}{an Elasticsearch connection object, see \code{\link[=connect]{connect()}}}

\item{body}{(list/character/json) The search definition using the Query DSL
and the prototype for the index request.}

\item{refresh}{(logical) Should the effected indexes be refreshed?}

\item{requests_per_second}{(integer) The throttle to set on this request in
sub-requests per second. - 1 means no throttle. Default: 0}

\item{slices}{(integer) The number of slices this task should be divided
into. Defaults to 1 meaning the task isn't sliced into subtasks. Default: 1}

\item{timeout}{(character) Time each individual bulk request should wait
for shards that are unavailable. Default: '1m'}

\item{wait_for_active_shards}{(integer) Sets the number of shard copies that
must be active before proceeding with the reindex operation. Defaults to 1,
meaning the primary shard only. Set to all for all shard copies, otherwise
set to any non-negative value less than or equal to the total number of
copies for the shard (number of replicas + 1)}

\item{wait_for_completion}{(logical) Should the request block until the
reindex is complete? Default: \code{TRUE}}

\item{...}{Curl options, passed on to \link[crul:verb-POST]{crul::verb-POST}}
}
\description{
Reindex all documents from one index to another.
}
\examples{
\dontrun{
x <- connect()

if (!index_exists(x, "twitter")) index_create(x, "twitter")
if (!index_exists(x, "new_twitter")) index_create(x, "new_twitter")
body <- '{
  "source": {
    "index": "twitter"
  },
  "dest": {
    "index": "new_twitter"
  }
}'
reindex(x, body = body)
}
}
\references{
\url{https://www.elastic.co/guide/en/elasticsearch/reference/current/docs-reindex.html}
}
