% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_elev_raster.R
\name{get_aws_terrain}
\alias{get_aws_terrain}
\title{Get a digital elevation model from the AWS Terrain Tiles}
\source{
Attribution: Mapzen terrain tiles contain 3DEP, SRTM, and GMTED2010 
        content courtesy of the U.S. Geological Survey and ETOPO1 content 
        courtesy of U.S. National Oceanic and Atmospheric Administration. 
        \url{https://mapzen.com/documentation/terrain-tiles/}
}
\usage{
get_aws_terrain(bbx, z, prj, expand = NULL, ...)
}
\arguments{
\item{bbx}{a \code{sp::bbox} object that is used to select x,y,z tiles.}

\item{z}{The zoom level to return.  The zoom ranges from 1 to 14.  Resolution
of the resultant raster is determined by the zoom and latitude.  For 
details on zoom and resolution see the documentation from Mapzen at 
\url{https://mapzen.com/documentation/terrain-tiles/data-sources/#what-is-the-ground-resolution}}

\item{prj}{PROJ.4 string for input bbox}

\item{expand}{A numeric value of a distance, in map units, used to expand the
bounding box that is used to fetch the terrain tiles. This can 
be used for features that fall close to the edge of a tile and 
additional area around the feature is desired. Default is NULL.}

\item{...}{Extra configuration parameters to be passed to httr::GET.  Common 
usage is to adjust timeout.  This is done as 
\code{config=timeout(x)} where \code{x} is a numeric value in 
seconds.  Multiple configuration functions may be passed as a 
vector.}
}
\description{
This function uses the AWS Terrain Tile service to retrieve an elevation
raster from the geotiff service.  It accepts a \code{sp::bbox} object as 
input and returns a single raster object covering that extent.  The data is
the same as that available via the Mapzen tiles but does not require a key.  
It is best used if rate limits are causing failures on the Mapzen service or 
if you are needing to access the terrain tiles via an AWS instance.  These 
tiles are not cached so accessing them via a local/non-AWS machine will be 
slower than the Mapzen tiles.
}
\keyword{internal}
