% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_elev_raster.R
\name{get_elev_raster}
\alias{get_elev_raster}
\title{Get Raster Elevation}
\usage{
get_elev_raster(
  locations,
  z,
  prj = NULL,
  src = c("aws", "gl3", "gl1", "alos"),
  expand = NULL,
  clip = c("tile", "bbox", "locations"),
  verbose = TRUE,
  neg_to_na = FALSE,
  override_size_check = FALSE,
  ...
)
}
\arguments{
\item{locations}{Either a \code{data.frame} of x (long) and y (lat), an 
\code{sp}, or \code{raster} object as input.}

\item{z}{The zoom level to return.  The zoom ranges from 1 to 14.  Resolution
of the resultant raster is determined by the zoom and latitude.  For 
details on zoom and resolution see the documentation from Mapzen at 
\url{https://github.com/tilezen/joerd/blob/master/docs/data-sources.md#what-is-the-ground-resolution}.
The z is not required for the OpenTopography data sources.}

\item{prj}{A PROJ.4 string defining the projection of the locations argument. 
If a \code{sp} or \code{raster} object is provided, the PROJ.4 
string will be taken from that.  This argument is required for a 
\code{data.frame} of locations."}

\item{src}{A character indicating which API to use.  Currently supports "aws" 
and "gl3", "gl1", or "alos" from the OpenTopography API global 
datasets. "aws" is the default.}

\item{expand}{A numeric value of a distance, in map units, used to expand the
bounding box that is used to fetch the terrain tiles. This can 
be used for features that fall close to the edge of a tile and 
additional area around the feature is desired. Default is NULL.}

\item{clip}{A character value used to determine clipping of returned DEM.
The default value is "tile" which returns the full tiles.  Other 
options are "bbox" which returns the DEM clipped to the bounding 
box of the original locations (or expanded bounding box if used), 
or "locations" if the spatials data (e.g. polygons) in the input 
locations should be used to clip the DEM.  Locations are not used 
to clip input point datasets.  Instead the bounding box is used.}

\item{verbose}{Toggles on and off the note about units and coordinate 
reference system.}

\item{neg_to_na}{Some of the data sources return large negative numbers as 
missing data.  When the end result is a projected those 
large negative numbers can vary.  When set to TRUE, only 
zero and positive values are returned.  Default is FALSE.}

\item{override_size_check}{Boolean to override size checks.  Any download 
between 100 Mb and 500Mb report a message but
continue.  Between 500Mb and 3000Mb requires 
interaction and greater than 3000Mb fails.  These
can be overriden with this argument set to TRUE.}

\item{...}{Extra arguments to pass to \code{httr::GET} via a named vector, 
\code{config}.   See
\code{\link{get_aws_terrain}} for more details.}
}
\value{
Function returns a \code{SpatialPointsDataFrame} in the projection 
        specified by the \code{prj} argument.
}
\description{
Several web services provide access to raster elevation. Currently, this 
function provides access to the Amazon Web Services Terrian Tiles and the 
Open Topography global datasets API. The function accepts a \code{data.frame} 
of x (long) and y (lat), an \code{sp}, or \code{raster} object as input.  A 
\code{raster} object is returned.
}
\details{
Currently, the \code{get_elev_raster} function utilizes  the 
         Amazon Web Services 
         (\url{https://registry.opendata.aws/terrain-tiles/}) terrain 
         tiles and the Open Topography Global Datasets API 
         (\url{https://opentopography.org/developers}).  
         
         The AWS Terrain Tiles data is provided via x, y, and z tiles (see 
         \url{https://wiki.openstreetmap.org/wiki/Slippy_map_tilenames} for 
         details.) The x and y are determined from the bounding box of the 
         object submitted for \code{locations} argument, and the z argument 
         must be specified by the user.
}
\examples{
\dontrun{
loc_df <- data.frame(x = runif(6,min=sp::bbox(lake)[1,1], 
                               max=sp::bbox(lake)[1,2]),
                     y = runif(6,min=sp::bbox(lake)[2,1], 
                               max=sp::bbox(lake)[2,2]))
x <- get_elev_raster(locations = loc_df, prj = sp::proj4string(lake), z=10)

data(lake)
x <- get_elev_raster(lake, z = 12)
x <- get_elev_raster(lake, src = "gl3", expand = 5000)
}
}
