% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elo.R
\docType{package}
\name{elo}
\alias{elo}
\alias{elo-package}
\title{The Elo Package}
\description{
An implementation of Elo ratings for general use in 'R'.
}
\section{Functions}{


Listed below are the most useful functions available in \code{elo}:

\code{\link{elo.prob}}: Calculate the probability that team A beats team B.

\code{\link{elo.update}}: Calculate the update value for a given Elo matchup.

\code{\link{elo.calc}}: Calculate post-update Elo values.

\code{\link{elo.run}}: Calculate Elos for a series of matches.

\code{\link{score}}: Create a 1/0/0.5 win "indicator" based on two teams' scores.
}

\section{Data}{


\code{\link{tournament}}: Mock data for examples.
}

\examples{
library(elo)
}
\references{
Elo, A. E. 1978. The Rating of Chess Players, Past and Present. New York: Arco.
}
