% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elo.model.frame.R
\name{elo.model.frame}
\alias{elo.model.frame}
\title{Interpret formulas in \code{elo} functions}
\usage{
elo.model.frame(formula, data, na.action, subset, k = NULL, ...,
  required.vars = "elos")
}
\arguments{
\item{formula}{A formula. See "details", below.}

\item{data}{A \code{data.frame} in which to look for objects in \code{formula}.}

\item{na.action}{A function which indicates what should happen when the data contain NAs.}

\item{subset}{An optional vector specifying a subset of observations.}

\item{k}{A constant k-value (or a vector, where appropriate).}

\item{...}{Other arguments (not in use at this time).}

\item{required.vars}{One or more of \code{c("wins", "elos", "k", "group", "regress")},
denoting which variables are required to appear in the final model.frame.}
}
\description{
A helper function to create the \code{model.frame} for many \code{elo} functions.
}
\details{
\code{formula} is usually of the form \code{wins.A ~ elo.A + elo.B}, where \code{elo.A} and \code{elo.B}
  are vectors of Elos, and \code{wins.A} is between 0 and 1,
  denoting whether team A (Elo A) won or lost (or something between). \code{elo.prob} also allows
  \code{elo.A} and \code{elo.B} to be character or factors, denoting which team(s) played. \code{elo.run}
  requires \code{elo.A} to be a vector of teams (sometimes denoted by \code{"team.A"}),
  but \code{elo.B} can be either a vector of teams or  else a numeric column
  (denoting a fixed-Elo opponent).

\code{formula} accepts four special functions in it:

\code{k()} allows for complicated Elo updates. For
  constant Elo updates, use the \code{k = } argument instead of this special function.

\code{adjust()} allows for Elos to be adjusted for, e.g., home-field advantage. The second argument
  to this function can be a scalar or vector of appropriate length.

\code{regress()} can be used to regress Elos back to a fixed value
  after certain matches. Giving a logical vector identifies these matches after which to
  regress back to the mean. Giving any other kind of vector regresses after the appropriate
  groupings (see, e.g., \code{\link{duplicated}(..., fromLast = TRUE)}). The other two arguments determine
  what Elo to regress to (\code{to = }), and by how much to regress toward that value
  (\code{by = }).

\code{group()} is used to group matches (by, e.g., week). It is fed to \code{\link{as.matrix.elo.run}}
  to produce only certain rows of matrix output.
}
\seealso{
\code{\link{elo.run}}, \code{\link{elo.calc}}, \code{\link{elo.update}}, \code{\link{elo.prob}}
}
