% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mse.R
\name{elo.mse}
\alias{elo.mse}
\alias{brier}
\alias{mse}
\alias{mse.elo.run}
\alias{mse.elo.glm}
\alias{mse.elo.running}
\alias{mse.elo.markovchain}
\alias{mse.elo.winpct}
\title{Calculate the mean square error}
\usage{
brier(object, subset, ...)

mse(object, subset, ...)

\method{mse}{elo.run}(object, subset, ...)

\method{mse}{elo.glm}(object, subset, ...)

\method{mse}{elo.running}(object, subset, running = TRUE, ...)

\method{mse}{elo.markovchain}(object, subset, ...)

\method{mse}{elo.winpct}(object, subset, ...)
}
\arguments{
\item{object}{An object}

\item{subset}{(optional) A vector of indices on which to calculate the MSE.}

\item{...}{Other arguments (not in use at this time).}

\item{running}{logical, denoting whether to use the running predicted values.}
}
\description{
Calculate the mean square error (Brier score) for a model.
}
\details{
Even though logistic regressions don't use the MSE on the y=0/1 scale, it can still be informative.
  Note that the S3 method is \code{mse}.
}
