## -----------------------------------------------------------------------------
library(elo)

## -----------------------------------------------------------------------------
elo.A <- c(1500, 1500)
elo.B <- c(1500, 1600)
elo.prob(elo.A, elo.B)

## -----------------------------------------------------------------------------
wins.A <- c(1, 0)
elo.update(wins.A, elo.A, elo.B, k = 20)

## -----------------------------------------------------------------------------
elo.calc(wins.A, elo.A, elo.B, k = 20)

## -----------------------------------------------------------------------------
points.A <- c(4, 1)
points.B <- c(3, 3)
elo.calc(score(points.A, points.B), elo.A, elo.B, k = 20)

## -----------------------------------------------------------------------------
dat <- data.frame(elo.A = c(1500, 1500), elo.B = c(1500, 1600),
                  wins.A = c(1, 0), k = 20)
form <- wins.A ~ elo.A + elo.B + k(k)
elo.prob(form, data = dat)
elo.update(form, data = dat)
elo.calc(form, data = dat)

## -----------------------------------------------------------------------------
elo.prob(~ elo.A + elo.B, data = dat)

## -----------------------------------------------------------------------------
elo.calc(wins.A ~ adjust(elo.A, 10) + elo.B + k(k), data = dat)

