% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HeterogeneityNests.R
\name{HeterogeneityNests}
\alias{HeterogeneityNests}
\title{Model heterogeneity of temperatures.}
\usage{
HeterogeneityNests(
  nests = stop("An object of class Nests2, NestsResult, or mcmcComposite."),
  control.legend.total = list(),
  control.legend.metabolicheating = list(),
  show.full.incubation = TRUE,
  show.first.half.incubation = TRUE,
  ...
)
}
\arguments{
\item{nests}{An object of class Nests, Nests2, NestsResult, or mcmcComposite.}

\item{control.legend.total}{A list of options for legend.}

\item{control.legend.metabolicheating}{A list of options for legend.}

\item{show.full.incubation}{Show the plot with full incubation?}

\item{show.first.half.incubation}{Show the plot with first half incubation?}

\item{...}{Parameters used for plot.}
}
\value{
Nothing.
}
\description{
Generate a model of heterogeneity of temperatures.\cr
}
\details{
HeterogeneityNests models heterogeneity of temperatures.
}
\examples{
\dontrun{
library(embryogrowth)
data(nest)
Laying.Time <- matrix(c("DY.1", "15/05/2010", 
                 "DY.17", "24/05/2010", 
                 "DY.16", "24/05/2010", 
                 "DY.18", "25/05/2010", 
                 "DY.20", "25/05/2010", 
                 "DY.21", "26/05/2010", 
                 "DY.22", "26/05/2010", 
                 "DY.23", "26/05/2010", 
                 "DY.24", "27/05/2010", 
                 "DY.25", "27/05/2010", 
                 "DY.28", "28/05/2010", 
                 "DY.26", "28/05/2010", 
                 "DY.27", "28/05/2010", 
                 "DY.146", "20/06/2010", 
                 "DY.147", "20/06/2010", 
                 "DY.172", "24/06/2010", 
                 "DY.175", "24/06/2010", 
                 "DY.170", "24/06/2010", 
                 "DY.260", "06/07/2010", 
                 "DY.282", "12/07/2010", 
                 "DY.310", "18/07/2010", 
                 "DY.309", "18/07/2010", 
                 "DY.328", "25/07/2010", 
                 "DY.331", "26/07/2010"), byrow=TRUE, ncol=2)
tz <- OlsonNames()[grepl("Asia/Istanbul", OlsonNames())]
Laying.Time_f <- as.POSIXlt.character(Laying.Time[, 2], format = "\%d/\%m/\%Y", tz=tz)
names(Laying.Time_f) <- Laying.Time[, 1]
nests <- FormatNests(data=nest, previous=NULL, col.Time="Time", LayingTime=Laying.Time_f)
HeterogeneityNests(nests, ylim=c(0, 4))
}
}
\author{
Marc Girondot \email{marc.girondot@gmail.com}
}
