% Generated by roxygen2 (4.0.2): do not edit by hand
\name{plotR}
\alias{plotR}
\title{Show the fitted growth rate dependent on temperature}
\usage{
plotR(result = NULL, parameters = NULL, fixed.parameters = NULL,
  col = "black", legend = NA, SE = NULL, set.par = 1, size = NA,
  xlim = c(20, 35), scaleY = "auto", lty = 1, ltyCI = 3, lwd = 1,
  lwdCI = 1, xlimR = xlim, replicate.CI = 100, show.box = TRUE,
  local.box = "topleft", ...)
}
\arguments{
\item{result}{A result object or a list of result objects}

\item{parameters}{Indicate some parameters if the result object is not supplied}

\item{fixed.parameters}{Indicate some parameters if the result object is not supplied}

\item{col}{The color to use for a list of colors if several results}

\item{legend}{Text to show in bottom right legend or a list of text if several results}

\item{SE}{The standard error for the parameters or a list of SE if several results. Use NA to force not use SE}

\item{set.par}{1 or 2 or a list of 1 or 2 to designate with set of parameters to show}

\item{size}{If indicated, will show the growth rate for this size}

\item{xlim}{Range of values for x-axis}

\item{scaleY}{Scaling factor for y axis or "auto"}

\item{lty}{The type of line to use if several results as a list}

\item{ltyCI}{The type of line to use for confidence interval as a list}

\item{lwd}{The type of line to use if several results as a list}

\item{lwdCI}{The type of line to use for confidence interval as a list}

\item{xlimR}{Range of values to be displayed for R curve; can be a list if a list of results is used}

\item{replicate.CI}{Number of randomizations to estimate CI}

\item{show.box}{If TRUE show a box with "mean" and "confidence interval"}

\item{local.box}{Position of the box with "mean" and "confidence interval", default="topleft"}

\item{...}{Parameters for plot() such as main= or ylim=}
}
\value{
Nothing
}
\description{
To show the growth rate, the syntaxe is \cr
plotR(result=res)
}
\details{
plotR shows the fitted growth rate dependent on temperature
}
\examples{
\dontrun{
library(embryogrowth)
data(nest)
formated <- FormatNests(nest)
# The initial parameters value can be:
# "T12H", "DHA",  "DHH", "Rho25"
# Or
# "T12L", "DT", "DHA",  "DHH", "DHL", "Rho25"
x <- structure(c(118.768297442004, 475.750095909406, 306.243694918151,
116.055824800264), .Names = c("DHA", "DHH", "T12H", "Rho25"))
# pfixed <- c(K=82.33) or rK=82.33/39.33
pfixed <- c(rK=2.093313)
resultNest_4p <- searchR(parameters=x, fixed.parameters=pfixed,
	temperatures=formated, derivate=dydt.Gompertz, M0=1.7,
	test=c(Mean=39.33, SD=1.92), method = "BFGS", maxiter = 200)
data(resultNest_4p)
pMCMC <- embryogrowth_MHmcmc_p(resultNest_4p, accept=TRUE)
# Take care, it can be very long, sometimes several days
result_mcmc_4p_80 <- embryogrowth_MHmcmc(result=resultNest_4p,
	parametersMCMC=pMCMC, n.iter=10000, n.chains = 1, n.adapt = 0,
	thin=1, trace=TRUE)
data(result_mcmc_4p)
plotR(result=resultNest_4p, SE=result_mcmc_4p$TimeSeriesSE,
ylim=c(0,0.3))
x <- structure(c(115.758929130522, 428.649022170996, 503.687251738993,
12.2621455821612, 306.308841227278, 116.35048615105), .Names = c("DHA",
"DHH", "DHL", "DT", "T12L", "Rho25"))
pfixed <- c(rK=2.093313)
resultNest_6p <- searchR(parameters=x, fixed.parameters=pfixed,
	temperatures=formated, derivate=dydt.Gompertz, M0=1.7,
	test=c(Mean=39.33, SD=1.92), method = "BFGS", maxiter = 200)
data(resultNest_6p)
plotR(list(resultNest_4p, resultNest_6p),
col=c("black", "red"), legend=c("4 parameters", "6 parameters"))
##########################################
# new formulation of parameters
data(resultNest_newp)
plotR(resultNest_newp)
}
}
\author{
Marc Girondot
}

