% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.tsd.R
\name{predict.tsd}
\alias{predict.tsd}
\title{Estimate sex ratio according to constant incubation temperature}
\usage{
\method{predict}{tsd}(object, temperatures = NULL, durations = NULL,
  SE = NULL, quantiles = c(0.025, 0.5, 0.975), replicates = 1000,
  progressbar = FALSE, ...)
}
\arguments{
\item{object}{A result file generated by tsd}

\item{temperatures}{A vector of temperatures}

\item{durations}{A vector of durations}

\item{SE}{The standard error for temperatures or durations}

\item{quantiles}{The quantiles to be returned, default=c(0.025, 0.5, 0.975)}

\item{replicates}{Number of replicates to estimate CI}

\item{progressbar}{Logical. Does a progression bar must be shown?}

\item{...}{Not used}
}
\value{
A data.frame with informations about sex-ratio
}
\description{
Estimate sex ratio according to constant incubation temperature\cr
The data.frame has the following components:\cr
temperatures, SE, sexratio, CI.minus.sexratio, CI.plus.sexratio, range.CI\cr
Note that incubation duration is a very bad proxy for sex ratio. See Georges, 
A., Limpus, C. J. & Stoutjesdijk, R. 1994. Hatchling sex in the marine turtle 
Caretta caretta is determined by proportion of development at a temperature, 
not daily duration of exposure. J. Exp. Zool., 270, 432-444.
}
\details{
predict.tsd Estimate sex ratio according to constant incubation temperature
}
\examples{
\dontrun{
library(embryogrowth)
m <- c(10, 14, 7, 4, 3, 0, 0)
f <- c(0, 1, 2, 4, 15, 10, 13)
t <- c(25, 26, 27, 28, 29, 30, 31)
result <- tsd(males=m, females=f, temperatures=t)
plot(result)
predict(result, temperatures=c(25, 31))
predict(result, temperatures=c(25, 31), SE=c(1, 2))
d <- c(72, 70, 65, 63, 62, 60, 59)
result <- tsd(males=m, females=f, durations=d)
predict(result, durations=c(67, 68))
}
}
\author{
Marc Girondot
}
\seealso{
Other Functions.for.temperature.dependent.sex.determination: \code{\link{DatabaseTSD}},
  \code{\link{TSP.list}}, \code{\link{stages}},
  \code{\link{tsd_MHmcmc_p}}, \code{\link{tsd_MHmcmc}},
  \code{\link{tsd}}
}

