% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/movement.R
\name{movement}
\alias{movement}
\title{Analyze movement recorded within a nest with an accelerometer datalogger}
\usage{
movement(
  x = stop("data.frame must be provided"),
  col.time = "Time",
  col.x = "x",
  col.y = "y",
  col.z = "z",
  NumberRecordBeforeEmergence = 1900,
  k = 4,
  Windowsize = 15
)
}
\arguments{
\item{x}{A data.frame with 4 columns, one for time and three for x, y, and z position}

\item{col.time}{Name of the column with time}

\item{col.x}{Name of the column with x positions}

\item{col.y}{Name of the column with y positions}

\item{col.z}{Name of the column with z positions}

\item{NumberRecordBeforeEmergence}{Number of records in quiet period}

\item{k}{Factor to multiply SD to prevent false positive detection}

\item{Windowsize}{Number of records used for moving average}
}
\value{
The function will return a list
}
\description{
This function is used to evaluate significant movement within a nest.
}
\details{
movement is a function that permits to analyze movement datalogger
}
\examples{
\dontrun{
library(embryogrowth)
mv <- movement(x=dataf, 
               col.time="Time", 
               col.x="x", col.y="y", col.z="z")
}
}
\seealso{
Other Data loggers utilities: 
\code{\link{calibrate.datalogger}()},
\code{\link{uncertainty.datalogger}()}
}
\author{
Marc Girondot
}
\concept{Data loggers utilities}
