% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hist.NestsResult.R
\name{hist.NestsResult}
\alias{hist.NestsResult}
\title{Show the histogram of temperatures with set of nests}
\usage{
\method{hist}{NestsResult}(x, series = "all", ...)
}
\arguments{
\item{x}{Results obtained after searchR}

\item{series}{Series to be used, logical (TRUE ou FALSE), numbers or names. If "all", all series are used.}

\item{...}{Parameters used by hist function (example main="Title")}
}
\value{
A list with an histogram object with information on histogram or 
NULL if no series was selected and the complete set of temperatures used.
}
\description{
Show the histogram of temperatures with set of nests
hist(data)
}
\details{
hist.NestsResult shows the histogram of temperatures with set of nests
}
\examples{
\dontrun{
library(embryogrowth)
data(resultNest_4p_SSM)
h <- hist(resultNest_4p_SSM, series=c(1:5))
}
}
\author{
Marc Girondot \email{marc.girondot@universite-paris-saclay.fr}
}
