% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emmeans.R
\name{emmobj}
\alias{emmobj}
\title{Construct an \code{emmGrid} object from scratch}
\usage{
emmobj(bhat, V, levels, linfct, df = NA, dffun, dfargs = list(),
  post.beta = matrix(NA), ...)
}
\arguments{
\item{bhat}{Numeric. Vector of regression coefficients}

\item{V}{Square matrix. Covariance matrix of \code{bhat}}

\item{levels}{Named list or vector. Levels of factor(s) that define the
estimates defined by \code{linfct}. If not a list, we assume one factor
named \code{"level"}}

\item{linfct}{Matrix. Linear functions of \code{bhat} for each combination 
of \code{levels}.}

\item{df}{Numeric value or function with arguments \code{(x, dfargs)}. If a
number, that is used for the degrees of freedom. If a function, it should
return the degrees of freedom for \code{sum(x*bhat)}, with any additional
parameters in \code{dfargs}.}

\item{dffun}{Overrides \code{df} if specified. This is a convenience
to match the slot names of the returned object.}

\item{dfargs}{List containing arguments for \code{df}.
This is ignored if df is numeric.}

\item{post.beta}{Matrix whose columns comprise a sample from the posterior
distribution of the regression coefficients (so that typically, the column
averages will be \code{bhat}). A 1 x 1 matrix of \code{NA} indicates that
such a sample is unavailable.}

\item{...}{Arguments passed to \code{\link{update.emmGrid}}}
}
\value{
An \code{emmGrid} object
}
\description{
This allows the user to incorporate results obtained by some analysis
into an \code{emmGrid} object, enabling the use of \code{emmGrid} methods
to perform related follow-up analyses.
}
\details{
The arguments must be conformable. This includes that the length of
 \code{bhat}, the number of columns of \code{linfct}, and the number of
 columns of \code{post.beta} must all be equal. And that the product of
 lengths in \code{levels} must be equal to the number of rows of
 \code{linfct}. The \code{grid} slot of the returned object is generated 
 by \code{\link{expand.grid}} using \code{levels} as its arguments. So the
 rows of \code{linfct} should be in corresponding order.
}
\examples{
# Given summary statistics for 4 cells in a 2 x 2 layout, obtain 
# marginal means and comparisons thereof. Assume heteroscedasticity
# and use the Satterthwaite method
levels <- list(trt = c("A", "B"), dose = c("high", "low"))
ybar <- c(57.6, 43.2, 88.9, 69.8)
s <-    c(12.1, 19.5, 22.8, 43.2)
n <-    c(44,   11,   37,   24)
se2 = s^2 / n
Satt.df <- function(x, dfargs)
    sum(x * dfargs$v)^2 / sum((x * dfargs$v)^2 / (dfargs$n - 1))
    
expt.rg <- emmobj(bhat = ybar, V = diag(se2),
    levels = levels, linfct = diag(c(1, 1, 1, 1)),
    df = Satt.df, dfargs = list(v = se2, n = n), estName = "mean")
plot(expt.rg)

( trt.emmGrid <- emmeans(expt.rg, "trt") )
( dose.emmGrid <- emmeans(expt.rg, "dose") )

rbind(pairs(trt.emmGrid), pairs(dose.emmGrid), adjust = "mvt")
}
