% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glht-support.R
\name{emm}
\alias{emm}
\alias{glht-support}
\alias{as.glht}
\alias{as.glht.emmGrid}
\title{Support for \code{multcomp::glht}}
\usage{
emm(...)

as.glht(object, ...)

\method{as.glht}{emmGrid}(object, ...)
}
\arguments{
\item{...}{In \code{emm}, the \code{specs}, \code{by}, and \code{contr}
arguments you would normally supply to \code{\link{emmeans}}. Only
\code{specs} is required. Otherwise, arguments that are passed to other
methods.}

\item{object}{An object of class \code{emmGrid} or \code{emm_list}}
}
\value{
\code{emm} returns an object of an intermediate class for which
  there is a \code{\link[multcomp]{glht}} method.

\code{as.glht} returns an object of class \code{glht} or \code{glht_list}
  according to whether \code{object} is of class \code{emmGrid} or \code{emm_list}. 
  See Details below for more on \code{glht_list}s.
}
\description{
These functions and methods provide an interface between \pkg{emmeans} and
the \code{\link[multcomp]{glht}} function for simultaneous inference provided
by the \pkg{multcomp} package.
}
\details{
\code{emm} is meant to be called only \emph{from} \code{"glht"} as its second
(\code{linfct}) argument. It works similarly to \code{\link[multcomp]{mcp}},
except with \code{specs} (and optionally \code{by} and \code{contr}
arguments) provided as in a call to \code{\link{emmeans}}.
}
\note{
The multivariate-\eqn{t} routines used by \code{glht} require that all
  estimates in the family have the same integer degrees of freedom. In cases
  where that is not true, a message is displayed that shows what df is used.
  The user may override this via the \code{df} argument.
}
\section{Details}{

A \code{glht_list} object is simply a \code{list} of \code{glht} objects. 
It is created as needed -- for example, when there is a \code{by} variable. 
Appropriate convenience methods \code{coef},
\code{confint}, \code{plot}, \code{summary}, and \code{vcov} are provided,
which simply apply the corresponding \code{glht} methods to each member.
}

\examples{
require(multcomp)

warp.lm <- lm(breaks ~ wool*tension, data = warpbreaks)

# Using 'emm'
summary(glht(warp.lm, emm(pairwise ~ tension | wool)))

# Same, but using an existing 'emmeans' result
warp.emm <- emmeans(warp.lm, ~ tension | wool)
summary(as.glht(pairs(warp.emm)))

# Same contrasts, but treat as one family
summary(as.glht(pairs(warp.emm), by = NULL))

}
