% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emmeans.R
\name{emmeans}
\alias{emmeans}
\title{Estimated marginal means (Least-squares means)}
\usage{
emmeans(object, specs, by = NULL, fac.reduce = function(coefs) apply(coefs,
  2, mean), contr, options = get_emm_option("emmeans"), weights, offset,
  trend, ..., tran)
}
\arguments{
\item{object}{An object of class \code{emmGrid}; or a fitted model object
that is supported, such as the result of a call to \code{lm} or
\code{lmer}. Many fitted-model objects are supported; see
\href{../doc/models.html}{\code{vignette("models", "emmeans")}} for details.}

\item{specs}{A \code{character} vector specifying the names of the predictors
over which EMMs are desired. \code{specs} may also be a \code{formula}
or a \code{list} (optionally named) of valid \code{spec}s. Use of formulas
is described in the Overview section below.}

\item{by}{A character vector specifying the names of predictors to condition on.}

\item{fac.reduce}{A function that combines the rows of a matrix into a single
vector. This implements the ``marginal averaging'' aspect of EMMs. 
The default is the mean of the rows. Typically if it is overridden,
it would be some kind of weighted mean of the rows. If \code{fac.reduce} is
nonlinear, bizarre results are likely, and EMMs will not be
interpretable. NOTE: If the \code{weights} argument is non-missing,
\code{fac.reduce} is ignored.}

\item{contr}{A character value or \code{list} specifying contrasts to be
added. See \code{\link{contrast}}. NOTE: \code{contr} is ignored when
\code{specs} is a formula.}

\item{options}{If non-\code{NULL}, a named \code{list} of arguments to pass
to \code{\link{update.emmGrid}}, just after the object is constructed.
(Options may also be included in \code{...}.)}

\item{weights}{Character value, numeric vector, or numeric matrix specifying
weights to use in averaging predictions. See \dQuote{Weights} section below.}

\item{offset}{Numeric vector or scalar. If specified, this adds an offset to
the predictions, or overrides any offset in the model or its
reference grid. If a vector of length differing from the number of rows in 
the result, it is subsetted or cyclically recycled.}

\item{trend}{This is now deprecated. Use \code{\link{emtrends}} instead.}

\item{...}{When \code{object} is not already a \code{"emmGrid"}
object, these arguments are passed to \code{\link{ref_grid}}. Common
examples are \code{at}, \code{cov.reduce}, \code{data}, code{type}, 
\code{transform}, \code{df}, \code{nesting}, and \code{vcov.}.
Model-type-specific options (see
\href{../doc/models.html}{\code{vignette("models", "emmeans")}}), commonly
\code{mode}, may be used here as well. In addition, if the model formula
contains references to variables that are not predictors, you must provide
a \code{params} argument with a list of their names.

Arguments that could go in \code{options} may instead be included in \code{...},
typically, arguments such as \code{type}, \code{infer}, etc. that in essence
are passed to \code{\link{summary.emmGrid}}. Arguments in both places are 
overridden by the ones in \code{...}.

There is a danger that \code{...} arguments could partially match those used
by both \code{ref_grid} and \code{update.emmGrid}, creating a conflict.
If these occur, usually they can be resolved by providing complete (or at least 
longer) argument names; or by isolating non-\code{ref_grid} arguments in
\code{options}; or by calling \code{ref_grid} separately and passing the
result as \code{object}. See a not-run example below.}

\item{tran}{Placeholder to prevent it from being included in \code{...}.
If non-missing, it is added to `options`}
}
\value{
When \code{specs} is a \code{character} vector or one-sided formula,
  an object of class \code{"emmGrid"}. A number of methods
  are provided for further analysis, including
  \code{\link{summary.emmGrid}}, \code{\link{confint.emmGrid}},
  \code{\link{test.emmGrid}}, \code{\link{contrast.emmGrid}},
  \code{\link{pairs.emmGrid}}, and \code{\link{CLD.emmGrid}}.
When \code{specs} is a \code{list} or a \code{formula} having a left-hand
side, the return value is an \code{\link{emm_list}} object, which is simply a
\code{list} of \code{emmGrid} objects.
}
\description{
Compute estimated marginal means (EMMs) for specified factors
or factor combinations in a linear model; and optionally, comparisons or
contrasts among them. EMMs are also known as least-squares means.
}
\details{
Users should also consult the documentation for \code{\link{ref_grid}}, 
because many important options for EMMs are implemented there, via the 
\code{...} argument.
}
\section{Overview}{

Estimated marginal means or EMMs (sometimes called least-squares means) are
predictions from a linear model over a \emph{reference grid}; or marginal
averages thereof. The \code{\link{ref_grid}} function identifies/creates the
reference grid upon which \code{emmeans} is based.

For those who prefer the terms \dQuote{least-squares means} or
\dQuote{predicted marginal means}, functions \code{lsmeans} and
\code{pmmeans} are provided as wrappers. See \code{\link{wrappers}}.

If \code{specs} is a \code{formula}, it should be of the form \code{~ specs},
\code{~ specs | by}, \code{contr ~ specs}, or \code{contr ~ specs | by}. The
formula is parsed and the variables therein are used as the arguments
\code{specs}, \code{by}, and \code{contr} as indicated. The left-hand side is
optional, but if specified it should be the name of a contrast family (e.g.,
\code{pairwise}). Operators like
\code{*} or \code{:} are needed in the formula to delineate names, but
otherwise are ignored.

In the special case where the mean (or weighted mean) of all the predictions
is desired, specify \code{specs} as \code{~ 1} or \code{"1"}.

A number of standard contrast families are provided. They can be identified 
as functions having names ending in \code{.emmc} -- see the documentation
for \code{\link{emmc-functions}} for details -- including how to write your
own \code{.emmc} function for custom contrasts.
}

\section{Weights}{

If \code{weights} is a vector, its length must equal
  the number of predictions to be averaged to obtain each EMM.
  If a matrix, each row of the matrix is used in turn, wrapping back to the
  first row as needed.  When in doubt about what is being averaged (or how
  many), first call \code{emmeans} with \code{weights = "show.levels"}.
  
If \code{weights} is a string, it should partially match one of the following:
\describe{
\item{\code{"equal"}}{Use an equally weighted average.}
\item{\code{"proportional"}}{Weight in proportion to the frequencies (in the
  original data) of the factor combinations that are averaged over.}
\item{\code{"outer"}}{Weight in proportion to each individual factor's
  marginal frequencies. Thus, the weights for a combination of factors are the
  outer product of the one-factor margins}
\item{\code{"cells"}}{Weight according to the frequencies of the cells being
  averaged.}
\item{\code{"flat"}}{Give equal weight to all cells with data, and ignore
  empty cells.}
\item{\code{"show.levels"}}{This is a convenience feature for understanding
  what is being averaged over. Instead of a table of EMMs, this causes the
  function to return a table showing the levels that are averaged over, in the
  order that they appear.}
}
Outer weights are like the 'expected' counts in a chi-square test of
independence, and will yield the same results as those obtained by
proportional averaging with one factor at a time. All except \code{"cells"}
uses the same set of weights for each mean. In a model where the predicted
values are the cell means, cell weights will yield the raw averages of the
data for the factors involved. Using \code{"flat"} is similar to
\code{"cells"}, except nonempty cells are weighted equally and empty cells
are ignored.
}

\section{Offsets}{

Unlike in \code{ref_grid}, an offset need not be scalar. If not enough values
are supplied, they are cyclically recycled. For a vector of offsets, it is 
important to understand that the ordering of results goes with the first 
name in \code{specs} varying fastest. If there are any \code{by} factors,
those vary slower than all the primary ones, but the first \code{by} variable
varies the fastest within that hierarchy. See the examples.
}

\examples{
warp.lm <- lm(breaks ~ wool * tension, data = warpbreaks)
emmeans (warp.lm,  ~ wool | tension)
# or equivalently emmeans(warp.lm, "wool", by = "tension")

emmeans (warp.lm, poly ~ tension | wool)

\dontrun{
  ### Offsets: Consider a silly example:
  emmeans(warp.lm, ~ tension | wool, offset = c(17, 23, 47)) @ grid
  # note that offsets are recycled so that each level of tension receives
  # the same offset for each wool.
  # But using the same offsets with ~ wool | tension will probably not
  # be what you want because the ordering of combinations is different.
  
  ### Conflicting arguments...
  # This will error because 'tran' is passed to both ref_grid and update
  emmeans(some.model, "treatment", tran = "log", type = "response")
  
  # Use this if the response was a variable that is the log of some other variable
  # (Keep 'tran' from being passed to ref_grid)
  emmeans(some.model, "treatment", options = list(tran = "log"), type = "response")
  
  # This will re-grid the result as if the response had been log-transformed
  # ('transform' is passed only to ref_grid, not to update)
  emmeans(some.model, "treatment", transform = "log", type = "response")
}
}
\seealso{
\code{\link{ref_grid}}, \code{\link{contrast}}, 
\href{../doc/models.html}{vignette("models", "emmeans")}
}
