% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rbind.R, R/nested.R, R/emm-list.R
\name{rbind.emmGrid}
\alias{rbind.emmGrid}
\alias{+.emmGrid}
\alias{[.emmGrid}
\alias{subset.emmGrid}
\alias{force_regular}
\alias{rbind.emm_list}
\title{Combine or subset \code{emmGrid} objects}
\usage{
\method{rbind}{emmGrid}(..., deparse.level = 1, adjust = "bonferroni")

\method{+}{emmGrid}(e1, e2)

\method{[}{emmGrid}(x, i, adjust, drop.levels = TRUE, ...)

\method{subset}{emmGrid}(x, subset, ...)

force_regular(object)

\method{rbind}{emm_list}(..., which, adjust = "bonferroni")
}
\arguments{
\item{...}{Additional arguments:
In \code{rbind}, object(s) of class \code{emmGrid}. 
In \code{"["}, it is ignored. 
In \code{subset}, it is passed to \code{[.emmGrid]}}

\item{deparse.level}{(required but not used)}

\item{adjust}{Character value passed to \code{\link{update.emmGrid}}}

\item{e1}{An \code{emmGrid} object}

\item{e2}{Another \code{emmGrid} object}

\item{x}{An \code{emmGrid} object to be subsetted}

\item{i}{Integer vector of indexes}

\item{drop.levels}{Logical value. If \code{TRUE}, the \code{"levels"} slot in
the returned object is updated to hold only the predictor levels that actually occur}

\item{subset}{logical expression indicating which rows of the grid to keep}

\item{object}{an object of class \code{emmGrid}}

\item{which}{Integer vector of subset of elements to use; if missing, all are combined}
}
\value{
A revised object of class \code{emmGrid}

The result of \code{e1 + e2} is the same as \code{rbind(e1, e2)}

\code{force_regular} adds extra (invisible) rows to an \code{emmGrid} object
  to make it a regular grid (all combinations of factors). This regular structure is 
  needed by \code{emmeans}. An object can become irregular by, for example,
  subsetting rows, or by obtaining contrasts of a nested structure.

The \code{rbind} method for \code{emm_list} objects simply combines 
the \code{emmGrid} objects comprising the first element of \code{...}.
}
\description{
These functions provide methods for \code{\link[base:cbind]{rbind}} and
\code{\link[base:Extract]{[}} that may be used to combine \code{emmGrid} objects
together, or to extract a subset of cases. The primary reason for 
doing this would be to obtain multiplicity-adjusted results for smaller
or larger families of tests or confidence intervals.
}
\note{
\code{rbind} throws an error if there are incompatibilities in
  the objects' coefficients, covariance structures, etc. But they 
  are allowed to have different factors; a missing level \code{'.'}
  is added to factors as needed.
}
\examples{
warp.lm <- lm(breaks ~ wool * tension, data = warpbreaks)
warp.rg <- ref_grid(warp.lm)

# Do all pairwise comparisons within rows or within columns, 
# all considered as one faily of tests:
w.t <- pairs(emmeans(warp.rg, ~ wool | tension))
t.w <- pairs(emmeans(warp.rg, ~ tension | wool))
rbind(w.t, t.w, adjust = "mvt")
update(w.t + t.w, adjust = "fdr")  ## same as above except for adjustment

# Show only 3 of the 6 cases
summary(warp.rg[c(2, 4, 5)])

# After-the-fact 'at' specification
subset(warp.rg, wool == "A")  ## or warp.rg |> subset(wool == "A")


### Irregular object
tmp <- warp.rg[-1]
## emmeans(tmp, "tension")   # will fail because tmp is irregular
emmeans(force_regular(tmp), "tension")   # will show some results

### Working with 'emm_list' objects
mod <- lm(conc ~ source + factor(percent), data = pigs)
all <- emmeans(mod, list(src = pairwise ~ source, pct = consec ~ percent))
rbind(all, which = c(2, 4), adjust = "mvt")
}
