% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emm-list.R
\name{emm_list}
\alias{emm_list}
\alias{contrast.emm_list}
\alias{pairs.emm_list}
\alias{test.emm_list}
\alias{confint.emm_list}
\alias{plot.emm_list}
\alias{coef.emm_list}
\alias{str.emm_list}
\alias{summary.emm_list}
\alias{print.emm_list}
\alias{as.data.frame.emm_list}
\title{The \code{emm_list} class}
\usage{
\method{contrast}{emm_list}(object, ..., which = 1)

\method{pairs}{emm_list}(x, ..., which = 1)

\method{test}{emm_list}(object, ..., which = seq_along(object))

\method{confint}{emm_list}(object, ..., which = seq_along(object))

\method{plot}{emm_list}(x, ..., which = 1)

\method{coef}{emm_list}(object, ..., which = 1)

\method{str}{emm_list}(object, ...)

\method{summary}{emm_list}(object, ..., which = seq_along(object))

\method{print}{emm_list}(x, ...)

\method{as.data.frame}{emm_list}(x, ...)
}
\arguments{
\item{object, x}{an object of class \code{emm_list}}

\item{...}{additional arguments passed to corresponding \code{emmGrid} method}

\item{which}{integer vector specifying which elements to select.}
}
\value{
a \code{list} of objects returned by the corresponding \code{emmGrid}
  method (thus, often, another \code{emm_list} object). However, if
  \code{which} has length 1, the one result is not wrapped in a list.

The \code{as.data.frame} method returns a single data frame via
\code{as.data.frame(rbind(x))}.
See also \code{\link{rbind.emm_list}} and \code{\link{as.data.frame.emmGrid}}
}
\description{
An \code{emm_list} object is simply a list of
\code{\link[=emmGrid-class]{emmGrid}} objects. Such a list is returned,
for example, by \code{\link{emmeans}} with a two-sided formula or a list as its
\code{specs} argument. Several methods for this class are provided, as detailed below.
Typically, these methods just quietly do the same thing as their \code{EmmGrid}
methods, using the first element of the list. You can specify \code{which}
to select a different element, or just run the corresponding \code{emmGrid}
method on \code{object[[k]]}.
}
\note{
The \code{plot} method uses only the first element of \code{which}; the others are ignored.

No \code{export} option is provided for printing an \code{emm_list}
(see \code{\link{print.emmGrid}}). If you wish to export these objects, you 
must do so separately for each element in the list.
}
