% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calcurve.R
\name{calcurve}
\alias{calcurve}
\alias{print.calcurve}
\alias{plot.calcurve}
\title{Calibration Curve}
\usage{
calcurve(deaths, pred, score = NULL, name_score = "Saps3",
  other_score = NULL, name_other_score = NULL,
  categories_option = c("predicted", "score"), table = FALSE, plot = TRUE,
  title_label = "Calibration Curve", y1axis_label = "Patients (n)",
  y2axis_label = "Mortality Rate (\%)", score_color = c("#cac7cc",
  "#ffc341", "#33cca3"), bar_color = "#1f77b4", points = c(19, 18, 17))

\method{print}{calcurve}(x, ...)

\method{plot}{calcurve}(x, ..., main = x$title_label, text = x$y2axis_label,
  ylab = x$y1axis_label, col = c(x$bar_color, x$score_color),
  pch = x$points)
}
\arguments{
\item{deaths}{a numerical vector that only contains 0 and 1, indicating whether the patient was alive or dead, respectively.}

\item{pred}{a numerical vector that contains the mortality rate predicted by the main score, in percentage, for each patient.}

\item{score}{a numerical vector that contains the main score punctuation for each patient, or NULL.}

\item{name_score}{a character string which determines the name of the main score.}

\item{other_score}{a list of numerical vectors, where each vector contains the mortality rate predicted by other score, in percentage, for each patient, or NULL (the default).}

\item{name_other_score}{if other_score variable is different from NULL, this argument must be a vector with the name(s) of the score(s) given.}

\item{categories_option}{a character string which determines if the categories will refer to the main score or to the predicted mortality rate. Accepted values are 'predicted' (the default) or 'score'.}

\item{table}{logical; if \code{TRUE} prints the \code{data.frame}.}

\item{plot}{logical; if \code{TRUE} (the default) plots the categories chosen versus the mortality rates in the secondary vertical axis. The main vertical axis refers to the number of patients in each category, represented by the bars.}

\item{title_label}{main title for \code{calcurve}.}

\item{y1axis_label, y2axis_label}{labels of the main vertical axis and the secondary axis, respectively, for \code{calcurve}.}

\item{score_color}{a vector with the colors to be used in the score traces for \code{calcurve}.}

\item{bar_color}{color of the bars for \code{calcurve}.}

\item{points}{a vector with markers types of the scores for \code{calcurve}.}

\item{x}{an object of class 'calcurve'.}

\item{...}{further arguments passed to \code{\link[graphics]{plot}}.}

\item{main}{main title for \code{plot.calcurve}.}

\item{text}{label of the secondary vertical axis for \code{plot.calcurve}.}

\item{ylab}{label of the main vertical axis for \code{plot.calcurve}.}

\item{col}{character vector with the colors of the bars and score traces, in this order, for \code{plot.calcurve}.}

\item{pch}{a vector with markers types of the scores for \code{plot.curve}.}
}
\description{
\code{calcurve} function returns a data.frame containing the number of patients, the observed mortality rate and the predicted mortality rate for each category of the predicted mortality rate. If any other acute physiology score is given, the function will also return the mortality rate predicted by this score for each category.
}
\details{
\itemize{
\item If \code{categories_option = 'score'}, the categories will refer to the deciles of the main score punctuation. If \code{categories_option = 'predicted'}, the categories will refer to fixed intervals of the predicted mortality rate.
}
}
\examples{


# Loading the dataset
data(icu)

# Calibration Curve Plot
a <- calcurve(deaths = icu$UnitDischargeName,
pred = icu$Saps3DeathProbabilityStandardEquation,
score = icu$Saps3Points, name_score = 'Saps3',
categories_option = 'score', table = FALSE, plot = TRUE)


}
\author{
Camila Cardoso
}
