% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emuR-legacy.R
\name{convert_legacyEmuDB}
\alias{convert_legacyEmuDB}
\title{Convert legacy EMU database to the emuDB format}
\usage{
convert_legacyEmuDB(emuTplPath, targetDir, dbUUID = UUIDgenerate(),
  verbose = TRUE, ...)
}
\arguments{
\item{emuTplPath}{EMU template file path}

\item{targetDir}{target directory}

\item{dbUUID}{optional UUID of emuDB, will be generated by default}

\item{verbose}{be verbose, default: \code{TRUE}}

\item{...}{currently available additional options:
\itemize{
\item{\code{rewriteSSFFTracks}: if \code{TRUE}, rewrite SSFF tracks instead of copying the file to get rid of big endian encoded SSFF files (SPARC), default: \code{TRUE}}
\item{\code{ignoreMissingSSFFTrackFiles}: if \code{TRUE}, missing SSFF track files are ignored, if \code{FALSE} an error will be generated, default: \code{TRUE}}
\item{\code{sourceFileTextEncoding}: encoding of legacy database text files (template, label and hlb files), possible values: NULL, "latin1", "UTF-8" "bytes" or "unknown" :default \code{NULL} (uses encoding of operating system platform)}
\item{\code{symbolicLinkSignalFiles}: if \code{TRUE}, signal files are symbolic linked instead of copied. Implies: \code{rewriteSSFFTracks=FALSE}, Default: \code{FALSE}}
}}
}
\description{
Converts an existing legacy EMU database to emuDB database structure. 
Copies or rewrites signal files and converts the database configuration and annotation data.
The legacy database must be addressed by its template file.
}
\details{
The database will be converted if the legacy database template file \code{emuTplPath} could 
be found and successfully loaded and parsed. The legacy template file usually has the extension '.tpl'. 
The UUID of the new emuDB will be randomly generated by default. If \code{targetDir} does not exist, 
the directory and its parents will be created. A new directory with the name of the database and the 
suffix '_emuDB' will be created in the \code{targetDir}. If the new database directory exists 
already, the function stops with an error. The template file is converted to a JSON file.

Some of the flags of the legacy EMU template files are ignored (lines with this syntax: "set [flagName] [flagValue]", 
known ignored flag names are: 'LabelTracks', 'SpectrogramWhiteLevel', 'HierarchyViewLevels', 'SignalViewLevels'). 
Legacy EMU utterances are reorganized to sessions and bundles. The naming of the sessions depends on the wildcard 
path pattern of the primary track: If the path contains no wildcard, only one session with the name '0000' will be created. 
If the path contains one wildcard path element, the names of the directories matching the pattern will be used as session names. 
If the path contains more than one wildcard path element, the session name is the concatenation of directory names 
separated by an underscore character.

Media files (usually WAV files) are copied, SSFF track files are rewritten using the ASSP library of package
\code{wrassp} by default (see option \code{rewriteSSFFTracks} below, see also \link[wrassp]{read.AsspDataObj} 
\link[wrassp]{write.AsspDataObj}). Annotations in EMU hierarchy (.hlb) files and ESPS label files are 
converted to one JSON file per bundle (utterance). Only those files get copied, which match the scheme 
of the template file. Additional files in the legacy database directories are ignored. The legacy EMU 
database will not be modified. For more information on the structural elements of an emuDB see \code{vignette{emuDB}}.


\code{options} is a list of key value pairs:
}
\examples{
\dontrun{
## Convert legacy EMU database specified by EMU 
## template file /mydata/EMU_legacy/ae/ae.tpl to directory /mydata/EMU/
## and load it afterwards

convert_legacyEmuDB("/mydata/EMU_legacy/ae/ae.tpl","/mydata/EMU/")
ae=load_emuDB("/mydata/EMU/ae_emuDB")

## Convert database "ae" and do not rewrite SSFF tracks 

convert_legacyEmuDB("/mydata/EMU_legacy/ae/ae.tpl",
"/mydata/EMU/",
options=list(rewriteSSFFTracks=FALSE))

## Convert legacy database "ae" from emuR demo data and load converted emuDB

create_emuRdemoData()
demoTplPath=file.path(tempdir(),"emuR_demoData/legacy_ae/ae.tpl")
targetDir=file.path(tempdir(),"converted_to_emuR")
convert_legacyEmuDB(demoTplPath,targetDir)
dbHandle=load_emuDB(file.path(targetDir,"ae_emuDB"))

}

}
\seealso{
\code{\link{load_emuDB}}
}
\keyword{Emu}
\keyword{database}
\keyword{emuDB}
\keyword{schema}

