% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emuR-database.files.R
\name{list_files}
\alias{list_files}
\title{List files of emuDB}
\usage{
list_files(emuDBhandle, fileExtension = ".*", sessionPattern = ".*",
  bundlePattern = ".*")
}
\arguments{
\item{emuDBhandle}{emuDB handle as returned by \code{\link{load_emuDB}}}

\item{fileExtension}{file extention of files}

\item{sessionPattern}{A (RegEx) pattern matching sessions to be searched from the database}

\item{bundlePattern}{A (RegEx) pattern matching bundles to be searched from the database}
}
\value{
file paths as character vector
}
\description{
List files belonging to emuDB. For 
more information on the structural elements of an emuDB 
see \code{vignette{emuDB}}.
}
\examples{
\dontrun{

##################################
# prerequisite: loaded ae emuDB
# (see ?load_emuDB for more information)

# list all files of ae emuDB
list_files(emuDBhandle = ae)

# list all files of ae emuDB in bundles ending with '3'
list_files(emuDBhandle = ae, bundlePattern=".*3$") 

}

}
\keyword{Emu}
\keyword{database}
\keyword{emuDB}
\keyword{schema}
