% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enerscape.R
\name{enerscape}
\alias{enerscape}
\title{Compute the energy landscape}
\usage{
enerscape(dem, m, unit = "joule", neigh = 16, method = "ARC", v = NULL)
}
\arguments{
\item{dem}{raster file of the digital elevation model, either a raster or a
full path location of the file.}

\item{m}{species body mass (kg).}

\item{unit}{if joules ('joule') or kilocalories ('kcal').}

\item{neigh}{number of neighbor cells that are connected together.}

\item{method}{method to use to compute the energy costs. 'ARC' refers to the
model from Pontzer (2016) and 'cycling' to the model for cyclist from di
Prampero et al. (1979).}

\item{v}{speed of cyclist (km / h), only for \code{method = 'cycling'}.}
}
\value{
A list with elements a rasterStack of the digital elevation model,
  slope, energy landscape, and conductance and the conductance as a transitionLayer for
  path analysis.
}
\description{
This is the main function to compute energy landscapes from a digital
elevation model and body mass of animals based on the model from Pontzer
(2016). The core of the computations are done using the \emph{gdistance}
(Etten, 2017) package.
}
\details{
From the digital elevation model, transition slopes, energy costs
  and conductances (1 / work) are computed based on the model described in
  Pontzer (2016).
}
\examples{
library(raster)
data("volcano")
dem <- raster(volcano)
en <- enerscape(dem, 10, unit = "kcal", neigh = 16)
}
\references{
Etten, J. van. (2017). R Package gdistance: Distances and Routes
  on Geographical Grids. Journal of Statistical Software, 76(1), 1–21.
  \doi{https://doi.org/10.18637/jss.v076.i13}.

  Pontzer, H. (2016). A unified theory for the energy cost of legged
  locomotion. Biology Letters, 12(2), 20150935. \doi{
  https://doi.org/10.1098/rsbl.2015.0935}.

  di Prampero, P. E., Cortili, G., Mognoni, P., & Saibene, F. (1979).
  Equation of motion of a cyclist. Journal of Applied Physiology, 47(1),
  201–206. \doi{https://doi.org/10.1152/jappl.1979.47.1.201}
}
