% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bayestax2df.R
\name{bayestax2df}
\alias{bayestax2df}
\title{Converts the output of DADA2's assignTaxonomy, which implements a naive
bayesian classifier, into a dataframe compatible with the algorithms used in
ensembleTax}
\usage{
bayestax2df(
  tt,
  db = "pr2",
  ranks = NULL,
  boot = 0,
  rubric = NULL,
  return.conf = FALSE
)
}
\arguments{
\item{tt}{The taxonomy table output by DADA2's assignTaxonomy function.}

\item{db}{The database you ran assignTaxonomy against. Either "pr2", "silva",
"rdp", or "gg" are supported. You may set to NULL and include a character
vector of rank (column) names for other databases.}

\item{ranks}{NULL, or a character vector of column names if db is set to NULL}

\item{boot}{The bootstrap threshold below which taxonomic assignments should
be set to NA. This can also be done with DADA2's assignTaxonomy but is
included here for convenience.}

\item{rubric}{NULL, or a DNAStringSet (see Biostrings package) with ASV
sequences named by your preferred ASV identifier. Both the ASV sequence and
identifier will be merged with the output dataframe. If NULL, ASV-identifying
data are excluded in the output dataframe.}

\item{return.conf}{If TRUE, returns a list where the first element is your
formatted taxonomy table and the second element is a dataframe of bootstrap
confidence values. If FALSE, your formatted taxonomy table is returned as a
dataframe.}
}
\value{
a dataframe formatted for use with taxmapper and/or ensembleTax
}
\description{
Converts the output of DADA2's assignTaxonomy, which implements a naive
bayesian classifier, into a dataframe compatible with the algorithms used in
ensembleTax
}
\details{
For consistency with dada2's assignTaxonomy function, when used with
Silva, RDP, or GreenGenes it subsamples the ranks c("domain", "phylum",
"class", "order", "family", "genus"). Set db = NULL and supply ranks for
databases that aren't directly supported. If a rubric is supplied with
ASV-identifying meta-data (this is highly recommended), the output taxonomy
table is sorted by the (first returned column of) ASV-identifying data.
}
\examples{
data("bayes.sample")
data("rubric.sample")
head(bayes.sample)
head(rubric.sample)
df <- bayestax2df(tt = bayes.sample, db = "pr2", boot = 0, rubric = NULL,
return.conf = FALSE)
head(df)
df <- bayestax2df(tt = bayes.sample, db = "pr2", boot = 0,
rubric = rubric.sample, return.conf = FALSE)
head(df)
df <- bayestax2df(tt = bayes.sample, db = "pr2", boot = 60,
rubric = rubric.sample, return.conf = FALSE)
head(df)
df <- bayestax2df(tt = bayes.sample, db = "pr2", boot = 60,
rubric = rubric.sample, return.conf = TRUE)
head(df)

}
\seealso{
idtax2df, ensembleTax, taxmapper
}
\author{
Dylan Catlett

Connie Liang
}
